/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/goal-status")
public class GoalLifecycleStatus
extends Code {
    public static final GoalLifecycleStatus PROPOSED = GoalLifecycleStatus.builder().value(ValueSet.PROPOSED).build();
    public static final GoalLifecycleStatus PLANNED = GoalLifecycleStatus.builder().value(ValueSet.PLANNED).build();
    public static final GoalLifecycleStatus ACCEPTED = GoalLifecycleStatus.builder().value(ValueSet.ACCEPTED).build();
    public static final GoalLifecycleStatus ACTIVE = GoalLifecycleStatus.builder().value(ValueSet.ACTIVE).build();
    public static final GoalLifecycleStatus ON_HOLD = GoalLifecycleStatus.builder().value(ValueSet.ON_HOLD).build();
    public static final GoalLifecycleStatus COMPLETED = GoalLifecycleStatus.builder().value(ValueSet.COMPLETED).build();
    public static final GoalLifecycleStatus CANCELLED = GoalLifecycleStatus.builder().value(ValueSet.CANCELLED).build();
    public static final GoalLifecycleStatus ENTERED_IN_ERROR = GoalLifecycleStatus.builder().value(ValueSet.ENTERED_IN_ERROR).build();
    public static final GoalLifecycleStatus REJECTED = GoalLifecycleStatus.builder().value(ValueSet.REJECTED).build();
    private volatile int hashCode;

    private GoalLifecycleStatus(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static GoalLifecycleStatus of(ValueSet value) {
        switch (value) {
            case PROPOSED: {
                return PROPOSED;
            }
            case PLANNED: {
                return PLANNED;
            }
            case ACCEPTED: {
                return ACCEPTED;
            }
            case ACTIVE: {
                return ACTIVE;
            }
            case ON_HOLD: {
                return ON_HOLD;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case REJECTED: {
                return REJECTED;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static GoalLifecycleStatus of(java.lang.String value) {
        return GoalLifecycleStatus.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return GoalLifecycleStatus.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return GoalLifecycleStatus.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GoalLifecycleStatus other = (GoalLifecycleStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        PROPOSED("proposed"),
        PLANNED("planned"),
        ACCEPTED("accepted"),
        ACTIVE("active"),
        ON_HOLD("on-hold"),
        COMPLETED("completed"),
        CANCELLED("cancelled"),
        ENTERED_IN_ERROR("entered-in-error"),
        REJECTED("rejected");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public GoalLifecycleStatus build() {
            return new GoalLifecycleStatus(this);
        }
    }
}

