/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/guide-parameter-code")
public class GuideParameterCode
extends Code {
    public static final GuideParameterCode APPLY = GuideParameterCode.builder().value(ValueSet.APPLY).build();
    public static final GuideParameterCode PATH_RESOURCE = GuideParameterCode.builder().value(ValueSet.PATH_RESOURCE).build();
    public static final GuideParameterCode PATH_PAGES = GuideParameterCode.builder().value(ValueSet.PATH_PAGES).build();
    public static final GuideParameterCode PATH_TX_CACHE = GuideParameterCode.builder().value(ValueSet.PATH_TX_CACHE).build();
    public static final GuideParameterCode EXPANSION_PARAMETER = GuideParameterCode.builder().value(ValueSet.EXPANSION_PARAMETER).build();
    public static final GuideParameterCode RULE_BROKEN_LINKS = GuideParameterCode.builder().value(ValueSet.RULE_BROKEN_LINKS).build();
    public static final GuideParameterCode GENERATE_XML = GuideParameterCode.builder().value(ValueSet.GENERATE_XML).build();
    public static final GuideParameterCode GENERATE_JSON = GuideParameterCode.builder().value(ValueSet.GENERATE_JSON).build();
    public static final GuideParameterCode GENERATE_TURTLE = GuideParameterCode.builder().value(ValueSet.GENERATE_TURTLE).build();
    public static final GuideParameterCode HTML_TEMPLATE = GuideParameterCode.builder().value(ValueSet.HTML_TEMPLATE).build();
    private volatile int hashCode;

    private GuideParameterCode(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static GuideParameterCode of(ValueSet value) {
        switch (value) {
            case APPLY: {
                return APPLY;
            }
            case PATH_RESOURCE: {
                return PATH_RESOURCE;
            }
            case PATH_PAGES: {
                return PATH_PAGES;
            }
            case PATH_TX_CACHE: {
                return PATH_TX_CACHE;
            }
            case EXPANSION_PARAMETER: {
                return EXPANSION_PARAMETER;
            }
            case RULE_BROKEN_LINKS: {
                return RULE_BROKEN_LINKS;
            }
            case GENERATE_XML: {
                return GENERATE_XML;
            }
            case GENERATE_JSON: {
                return GENERATE_JSON;
            }
            case GENERATE_TURTLE: {
                return GENERATE_TURTLE;
            }
            case HTML_TEMPLATE: {
                return HTML_TEMPLATE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static GuideParameterCode of(java.lang.String value) {
        return GuideParameterCode.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return GuideParameterCode.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return GuideParameterCode.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GuideParameterCode other = (GuideParameterCode)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        APPLY("apply"),
        PATH_RESOURCE("path-resource"),
        PATH_PAGES("path-pages"),
        PATH_TX_CACHE("path-tx-cache"),
        EXPANSION_PARAMETER("expansion-parameter"),
        RULE_BROKEN_LINKS("rule-broken-links"),
        GENERATE_XML("generate-xml"),
        GENERATE_JSON("generate-json"),
        GENERATE_TURTLE("generate-turtle"),
        HTML_TEMPLATE("html-template");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public GuideParameterCode build() {
            return new GuideParameterCode(this);
        }
    }
}

