/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/identity-assuranceLevel")
public class IdentityAssuranceLevel
extends Code {
    public static final IdentityAssuranceLevel LEVEL1 = IdentityAssuranceLevel.builder().value(ValueSet.LEVEL1).build();
    public static final IdentityAssuranceLevel LEVEL2 = IdentityAssuranceLevel.builder().value(ValueSet.LEVEL2).build();
    public static final IdentityAssuranceLevel LEVEL3 = IdentityAssuranceLevel.builder().value(ValueSet.LEVEL3).build();
    public static final IdentityAssuranceLevel LEVEL4 = IdentityAssuranceLevel.builder().value(ValueSet.LEVEL4).build();
    private volatile int hashCode;

    private IdentityAssuranceLevel(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static IdentityAssuranceLevel of(ValueSet value) {
        switch (value) {
            case LEVEL1: {
                return LEVEL1;
            }
            case LEVEL2: {
                return LEVEL2;
            }
            case LEVEL3: {
                return LEVEL3;
            }
            case LEVEL4: {
                return LEVEL4;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static IdentityAssuranceLevel of(java.lang.String value) {
        return IdentityAssuranceLevel.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return IdentityAssuranceLevel.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return IdentityAssuranceLevel.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentityAssuranceLevel other = (IdentityAssuranceLevel)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        LEVEL1("level1"),
        LEVEL2("level2"),
        LEVEL3("level3"),
        LEVEL4("level4");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public IdentityAssuranceLevel build() {
            return new IdentityAssuranceLevel(this);
        }
    }
}

