/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/imagingstudy-status")
public class ImagingStudyStatus
extends Code {
    public static final ImagingStudyStatus REGISTERED = ImagingStudyStatus.builder().value(ValueSet.REGISTERED).build();
    public static final ImagingStudyStatus AVAILABLE = ImagingStudyStatus.builder().value(ValueSet.AVAILABLE).build();
    public static final ImagingStudyStatus CANCELLED = ImagingStudyStatus.builder().value(ValueSet.CANCELLED).build();
    public static final ImagingStudyStatus ENTERED_IN_ERROR = ImagingStudyStatus.builder().value(ValueSet.ENTERED_IN_ERROR).build();
    public static final ImagingStudyStatus UNKNOWN = ImagingStudyStatus.builder().value(ValueSet.UNKNOWN).build();
    private volatile int hashCode;

    private ImagingStudyStatus(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static ImagingStudyStatus of(ValueSet value) {
        switch (value) {
            case REGISTERED: {
                return REGISTERED;
            }
            case AVAILABLE: {
                return AVAILABLE;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ImagingStudyStatus of(java.lang.String value) {
        return ImagingStudyStatus.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return ImagingStudyStatus.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return ImagingStudyStatus.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImagingStudyStatus other = (ImagingStudyStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        REGISTERED("registered"),
        AVAILABLE("available"),
        CANCELLED("cancelled"),
        ENTERED_IN_ERROR("entered-in-error"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ImagingStudyStatus build() {
            return new ImagingStudyStatus(this);
        }
    }
}

