/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://terminology.hl7.org/CodeSystem/medicationdispense-status")
public class MedicationDispenseStatus
extends Code {
    public static final MedicationDispenseStatus PREPARATION = MedicationDispenseStatus.builder().value(ValueSet.PREPARATION).build();
    public static final MedicationDispenseStatus IN_PROGRESS = MedicationDispenseStatus.builder().value(ValueSet.IN_PROGRESS).build();
    public static final MedicationDispenseStatus CANCELLED = MedicationDispenseStatus.builder().value(ValueSet.CANCELLED).build();
    public static final MedicationDispenseStatus ON_HOLD = MedicationDispenseStatus.builder().value(ValueSet.ON_HOLD).build();
    public static final MedicationDispenseStatus COMPLETED = MedicationDispenseStatus.builder().value(ValueSet.COMPLETED).build();
    public static final MedicationDispenseStatus ENTERED_IN_ERROR = MedicationDispenseStatus.builder().value(ValueSet.ENTERED_IN_ERROR).build();
    public static final MedicationDispenseStatus STOPPED = MedicationDispenseStatus.builder().value(ValueSet.STOPPED).build();
    public static final MedicationDispenseStatus DECLINED = MedicationDispenseStatus.builder().value(ValueSet.DECLINED).build();
    public static final MedicationDispenseStatus UNKNOWN = MedicationDispenseStatus.builder().value(ValueSet.UNKNOWN).build();
    private volatile int hashCode;

    private MedicationDispenseStatus(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static MedicationDispenseStatus of(ValueSet value) {
        switch (value) {
            case PREPARATION: {
                return PREPARATION;
            }
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case ON_HOLD: {
                return ON_HOLD;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case STOPPED: {
                return STOPPED;
            }
            case DECLINED: {
                return DECLINED;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static MedicationDispenseStatus of(java.lang.String value) {
        return MedicationDispenseStatus.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return MedicationDispenseStatus.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return MedicationDispenseStatus.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicationDispenseStatus other = (MedicationDispenseStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        PREPARATION("preparation"),
        IN_PROGRESS("in-progress"),
        CANCELLED("cancelled"),
        ON_HOLD("on-hold"),
        COMPLETED("completed"),
        ENTERED_IN_ERROR("entered-in-error"),
        STOPPED("stopped"),
        DECLINED("declined"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public MedicationDispenseStatus build() {
            return new MedicationDispenseStatus(this);
        }
    }
}

