/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/CodeSystem/medication-statement-status")
public class MedicationStatementStatus
extends Code {
    public static final MedicationStatementStatus ACTIVE = MedicationStatementStatus.builder().value(ValueSet.ACTIVE).build();
    public static final MedicationStatementStatus COMPLETED = MedicationStatementStatus.builder().value(ValueSet.COMPLETED).build();
    public static final MedicationStatementStatus ENTERED_IN_ERROR = MedicationStatementStatus.builder().value(ValueSet.ENTERED_IN_ERROR).build();
    public static final MedicationStatementStatus INTENDED = MedicationStatementStatus.builder().value(ValueSet.INTENDED).build();
    public static final MedicationStatementStatus STOPPED = MedicationStatementStatus.builder().value(ValueSet.STOPPED).build();
    public static final MedicationStatementStatus ON_HOLD = MedicationStatementStatus.builder().value(ValueSet.ON_HOLD).build();
    public static final MedicationStatementStatus UNKNOWN = MedicationStatementStatus.builder().value(ValueSet.UNKNOWN).build();
    public static final MedicationStatementStatus NOT_TAKEN = MedicationStatementStatus.builder().value(ValueSet.NOT_TAKEN).build();
    private volatile int hashCode;

    private MedicationStatementStatus(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static MedicationStatementStatus of(ValueSet value) {
        switch (value) {
            case ACTIVE: {
                return ACTIVE;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case INTENDED: {
                return INTENDED;
            }
            case STOPPED: {
                return STOPPED;
            }
            case ON_HOLD: {
                return ON_HOLD;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
            case NOT_TAKEN: {
                return NOT_TAKEN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static MedicationStatementStatus of(java.lang.String value) {
        return MedicationStatementStatus.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return MedicationStatementStatus.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return MedicationStatementStatus.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicationStatementStatus other = (MedicationStatementStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        ACTIVE("active"),
        COMPLETED("completed"),
        ENTERED_IN_ERROR("entered-in-error"),
        INTENDED("intended"),
        STOPPED("stopped"),
        ON_HOLD("on-hold"),
        UNKNOWN("unknown"),
        NOT_TAKEN("not-taken");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public MedicationStatementStatus build() {
            return new MedicationStatementStatus(this);
        }
    }
}

