/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/request-intent")
public class NutritionOrderIntent
extends Code {
    public static final NutritionOrderIntent PROPOSAL = NutritionOrderIntent.builder().value(ValueSet.PROPOSAL).build();
    public static final NutritionOrderIntent PLAN = NutritionOrderIntent.builder().value(ValueSet.PLAN).build();
    public static final NutritionOrderIntent DIRECTIVE = NutritionOrderIntent.builder().value(ValueSet.DIRECTIVE).build();
    public static final NutritionOrderIntent ORDER = NutritionOrderIntent.builder().value(ValueSet.ORDER).build();
    public static final NutritionOrderIntent ORIGINAL_ORDER = NutritionOrderIntent.builder().value(ValueSet.ORIGINAL_ORDER).build();
    public static final NutritionOrderIntent REFLEX_ORDER = NutritionOrderIntent.builder().value(ValueSet.REFLEX_ORDER).build();
    public static final NutritionOrderIntent FILLER_ORDER = NutritionOrderIntent.builder().value(ValueSet.FILLER_ORDER).build();
    public static final NutritionOrderIntent INSTANCE_ORDER = NutritionOrderIntent.builder().value(ValueSet.INSTANCE_ORDER).build();
    public static final NutritionOrderIntent OPTION = NutritionOrderIntent.builder().value(ValueSet.OPTION).build();
    private volatile int hashCode;

    private NutritionOrderIntent(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static NutritionOrderIntent of(ValueSet value) {
        switch (value) {
            case PROPOSAL: {
                return PROPOSAL;
            }
            case PLAN: {
                return PLAN;
            }
            case DIRECTIVE: {
                return DIRECTIVE;
            }
            case ORDER: {
                return ORDER;
            }
            case ORIGINAL_ORDER: {
                return ORIGINAL_ORDER;
            }
            case REFLEX_ORDER: {
                return REFLEX_ORDER;
            }
            case FILLER_ORDER: {
                return FILLER_ORDER;
            }
            case INSTANCE_ORDER: {
                return INSTANCE_ORDER;
            }
            case OPTION: {
                return OPTION;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static NutritionOrderIntent of(java.lang.String value) {
        return NutritionOrderIntent.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return NutritionOrderIntent.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return NutritionOrderIntent.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutritionOrderIntent other = (NutritionOrderIntent)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        PROPOSAL("proposal"),
        PLAN("plan"),
        DIRECTIVE("directive"),
        ORDER("order"),
        ORIGINAL_ORDER("original-order"),
        REFLEX_ORDER("reflex-order"),
        FILLER_ORDER("filler-order"),
        INSTANCE_ORDER("instance-order"),
        OPTION("option");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public NutritionOrderIntent build() {
            return new NutritionOrderIntent(this);
        }
    }
}

