/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/permitted-data-type")
public class ObservationDataType
extends Code {
    public static final ObservationDataType QUANTITY = ObservationDataType.builder().value(ValueSet.QUANTITY).build();
    public static final ObservationDataType CODEABLE_CONCEPT = ObservationDataType.builder().value(ValueSet.CODEABLE_CONCEPT).build();
    public static final ObservationDataType STRING = ObservationDataType.builder().value(ValueSet.STRING).build();
    public static final ObservationDataType BOOLEAN = ObservationDataType.builder().value(ValueSet.BOOLEAN).build();
    public static final ObservationDataType INTEGER = ObservationDataType.builder().value(ValueSet.INTEGER).build();
    public static final ObservationDataType RANGE = ObservationDataType.builder().value(ValueSet.RANGE).build();
    public static final ObservationDataType RATIO = ObservationDataType.builder().value(ValueSet.RATIO).build();
    public static final ObservationDataType SAMPLED_DATA = ObservationDataType.builder().value(ValueSet.SAMPLED_DATA).build();
    public static final ObservationDataType TIME = ObservationDataType.builder().value(ValueSet.TIME).build();
    public static final ObservationDataType DATE_TIME = ObservationDataType.builder().value(ValueSet.DATE_TIME).build();
    public static final ObservationDataType PERIOD = ObservationDataType.builder().value(ValueSet.PERIOD).build();
    private volatile int hashCode;

    private ObservationDataType(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static ObservationDataType of(ValueSet value) {
        switch (value) {
            case QUANTITY: {
                return QUANTITY;
            }
            case CODEABLE_CONCEPT: {
                return CODEABLE_CONCEPT;
            }
            case STRING: {
                return STRING;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case INTEGER: {
                return INTEGER;
            }
            case RANGE: {
                return RANGE;
            }
            case RATIO: {
                return RATIO;
            }
            case SAMPLED_DATA: {
                return SAMPLED_DATA;
            }
            case TIME: {
                return TIME;
            }
            case DATE_TIME: {
                return DATE_TIME;
            }
            case PERIOD: {
                return PERIOD;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ObservationDataType of(java.lang.String value) {
        return ObservationDataType.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return ObservationDataType.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return ObservationDataType.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObservationDataType other = (ObservationDataType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        QUANTITY("Quantity"),
        CODEABLE_CONCEPT("CodeableConcept"),
        STRING("string"),
        BOOLEAN("boolean"),
        INTEGER("integer"),
        RANGE("Range"),
        RATIO("Ratio"),
        SAMPLED_DATA("SampledData"),
        TIME("time"),
        DATE_TIME("dateTime"),
        PERIOD("Period");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ObservationDataType build() {
            return new ObservationDataType(this);
        }
    }
}

