/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/quantity-comparator")
public class QuantityComparator
extends Code {
    public static final QuantityComparator LESS_THAN = QuantityComparator.builder().value(ValueSet.LESS_THAN).build();
    public static final QuantityComparator LESS_OR_EQUALS = QuantityComparator.builder().value(ValueSet.LESS_OR_EQUALS).build();
    public static final QuantityComparator GREATER_OR_EQUALS = QuantityComparator.builder().value(ValueSet.GREATER_OR_EQUALS).build();
    public static final QuantityComparator GREATER_THAN = QuantityComparator.builder().value(ValueSet.GREATER_THAN).build();
    private volatile int hashCode;

    private QuantityComparator(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static QuantityComparator of(ValueSet value) {
        switch (value) {
            case LESS_THAN: {
                return LESS_THAN;
            }
            case LESS_OR_EQUALS: {
                return LESS_OR_EQUALS;
            }
            case GREATER_OR_EQUALS: {
                return GREATER_OR_EQUALS;
            }
            case GREATER_THAN: {
                return GREATER_THAN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static QuantityComparator of(java.lang.String value) {
        return QuantityComparator.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return QuantityComparator.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return QuantityComparator.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuantityComparator other = (QuantityComparator)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        LESS_THAN("<"),
        LESS_OR_EQUALS("<="),
        GREATER_OR_EQUALS(">="),
        GREATER_THAN(">");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public QuantityComparator build() {
            return new QuantityComparator(this);
        }
    }
}

