/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/questionnaire-answers-status")
public class QuestionnaireResponseStatus
extends Code {
    public static final QuestionnaireResponseStatus IN_PROGRESS = QuestionnaireResponseStatus.builder().value(ValueSet.IN_PROGRESS).build();
    public static final QuestionnaireResponseStatus COMPLETED = QuestionnaireResponseStatus.builder().value(ValueSet.COMPLETED).build();
    public static final QuestionnaireResponseStatus AMENDED = QuestionnaireResponseStatus.builder().value(ValueSet.AMENDED).build();
    public static final QuestionnaireResponseStatus ENTERED_IN_ERROR = QuestionnaireResponseStatus.builder().value(ValueSet.ENTERED_IN_ERROR).build();
    public static final QuestionnaireResponseStatus STOPPED = QuestionnaireResponseStatus.builder().value(ValueSet.STOPPED).build();
    private volatile int hashCode;

    private QuestionnaireResponseStatus(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static QuestionnaireResponseStatus of(ValueSet value) {
        switch (value) {
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case AMENDED: {
                return AMENDED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case STOPPED: {
                return STOPPED;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static QuestionnaireResponseStatus of(java.lang.String value) {
        return QuestionnaireResponseStatus.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return QuestionnaireResponseStatus.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return QuestionnaireResponseStatus.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuestionnaireResponseStatus other = (QuestionnaireResponseStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        AMENDED("amended"),
        ENTERED_IN_ERROR("entered-in-error"),
        STOPPED("stopped");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public QuestionnaireResponseStatus build() {
            return new QuestionnaireResponseStatus(this);
        }
    }
}

