/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/research-study-status")
public class ResearchStudyStatus
extends Code {
    public static final ResearchStudyStatus ACTIVE = ResearchStudyStatus.builder().value(ValueSet.ACTIVE).build();
    public static final ResearchStudyStatus ADMINISTRATIVELY_COMPLETED = ResearchStudyStatus.builder().value(ValueSet.ADMINISTRATIVELY_COMPLETED).build();
    public static final ResearchStudyStatus APPROVED = ResearchStudyStatus.builder().value(ValueSet.APPROVED).build();
    public static final ResearchStudyStatus CLOSED_TO_ACCRUAL = ResearchStudyStatus.builder().value(ValueSet.CLOSED_TO_ACCRUAL).build();
    public static final ResearchStudyStatus CLOSED_TO_ACCRUAL_AND_INTERVENTION = ResearchStudyStatus.builder().value(ValueSet.CLOSED_TO_ACCRUAL_AND_INTERVENTION).build();
    public static final ResearchStudyStatus COMPLETED = ResearchStudyStatus.builder().value(ValueSet.COMPLETED).build();
    public static final ResearchStudyStatus DISAPPROVED = ResearchStudyStatus.builder().value(ValueSet.DISAPPROVED).build();
    public static final ResearchStudyStatus IN_REVIEW = ResearchStudyStatus.builder().value(ValueSet.IN_REVIEW).build();
    public static final ResearchStudyStatus TEMPORARILY_CLOSED_TO_ACCRUAL = ResearchStudyStatus.builder().value(ValueSet.TEMPORARILY_CLOSED_TO_ACCRUAL).build();
    public static final ResearchStudyStatus TEMPORARILY_CLOSED_TO_ACCRUAL_AND_INTERVENTION = ResearchStudyStatus.builder().value(ValueSet.TEMPORARILY_CLOSED_TO_ACCRUAL_AND_INTERVENTION).build();
    public static final ResearchStudyStatus WITHDRAWN = ResearchStudyStatus.builder().value(ValueSet.WITHDRAWN).build();
    private volatile int hashCode;

    private ResearchStudyStatus(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static ResearchStudyStatus of(ValueSet value) {
        switch (value) {
            case ACTIVE: {
                return ACTIVE;
            }
            case ADMINISTRATIVELY_COMPLETED: {
                return ADMINISTRATIVELY_COMPLETED;
            }
            case APPROVED: {
                return APPROVED;
            }
            case CLOSED_TO_ACCRUAL: {
                return CLOSED_TO_ACCRUAL;
            }
            case CLOSED_TO_ACCRUAL_AND_INTERVENTION: {
                return CLOSED_TO_ACCRUAL_AND_INTERVENTION;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case DISAPPROVED: {
                return DISAPPROVED;
            }
            case IN_REVIEW: {
                return IN_REVIEW;
            }
            case TEMPORARILY_CLOSED_TO_ACCRUAL: {
                return TEMPORARILY_CLOSED_TO_ACCRUAL;
            }
            case TEMPORARILY_CLOSED_TO_ACCRUAL_AND_INTERVENTION: {
                return TEMPORARILY_CLOSED_TO_ACCRUAL_AND_INTERVENTION;
            }
            case WITHDRAWN: {
                return WITHDRAWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ResearchStudyStatus of(java.lang.String value) {
        return ResearchStudyStatus.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return ResearchStudyStatus.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return ResearchStudyStatus.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResearchStudyStatus other = (ResearchStudyStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        ACTIVE("active"),
        ADMINISTRATIVELY_COMPLETED("administratively-completed"),
        APPROVED("approved"),
        CLOSED_TO_ACCRUAL("closed-to-accrual"),
        CLOSED_TO_ACCRUAL_AND_INTERVENTION("closed-to-accrual-and-intervention"),
        COMPLETED("completed"),
        DISAPPROVED("disapproved"),
        IN_REVIEW("in-review"),
        TEMPORARILY_CLOSED_TO_ACCRUAL("temporarily-closed-to-accrual"),
        TEMPORARILY_CLOSED_TO_ACCRUAL_AND_INTERVENTION("temporarily-closed-to-accrual-and-intervention"),
        WITHDRAWN("withdrawn");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ResearchStudyStatus build() {
            return new ResearchStudyStatus(this);
        }
    }
}

