/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/research-subject-status")
public class ResearchSubjectStatus
extends Code {
    public static final ResearchSubjectStatus CANDIDATE = ResearchSubjectStatus.builder().value(ValueSet.CANDIDATE).build();
    public static final ResearchSubjectStatus ELIGIBLE = ResearchSubjectStatus.builder().value(ValueSet.ELIGIBLE).build();
    public static final ResearchSubjectStatus FOLLOW_UP = ResearchSubjectStatus.builder().value(ValueSet.FOLLOW_UP).build();
    public static final ResearchSubjectStatus INELIGIBLE = ResearchSubjectStatus.builder().value(ValueSet.INELIGIBLE).build();
    public static final ResearchSubjectStatus NOT_REGISTERED = ResearchSubjectStatus.builder().value(ValueSet.NOT_REGISTERED).build();
    public static final ResearchSubjectStatus OFF_STUDY = ResearchSubjectStatus.builder().value(ValueSet.OFF_STUDY).build();
    public static final ResearchSubjectStatus ON_STUDY = ResearchSubjectStatus.builder().value(ValueSet.ON_STUDY).build();
    public static final ResearchSubjectStatus ON_STUDY_INTERVENTION = ResearchSubjectStatus.builder().value(ValueSet.ON_STUDY_INTERVENTION).build();
    public static final ResearchSubjectStatus ON_STUDY_OBSERVATION = ResearchSubjectStatus.builder().value(ValueSet.ON_STUDY_OBSERVATION).build();
    public static final ResearchSubjectStatus PENDING_ON_STUDY = ResearchSubjectStatus.builder().value(ValueSet.PENDING_ON_STUDY).build();
    public static final ResearchSubjectStatus POTENTIAL_CANDIDATE = ResearchSubjectStatus.builder().value(ValueSet.POTENTIAL_CANDIDATE).build();
    public static final ResearchSubjectStatus SCREENING = ResearchSubjectStatus.builder().value(ValueSet.SCREENING).build();
    public static final ResearchSubjectStatus WITHDRAWN = ResearchSubjectStatus.builder().value(ValueSet.WITHDRAWN).build();
    private volatile int hashCode;

    private ResearchSubjectStatus(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static ResearchSubjectStatus of(ValueSet value) {
        switch (value) {
            case CANDIDATE: {
                return CANDIDATE;
            }
            case ELIGIBLE: {
                return ELIGIBLE;
            }
            case FOLLOW_UP: {
                return FOLLOW_UP;
            }
            case INELIGIBLE: {
                return INELIGIBLE;
            }
            case NOT_REGISTERED: {
                return NOT_REGISTERED;
            }
            case OFF_STUDY: {
                return OFF_STUDY;
            }
            case ON_STUDY: {
                return ON_STUDY;
            }
            case ON_STUDY_INTERVENTION: {
                return ON_STUDY_INTERVENTION;
            }
            case ON_STUDY_OBSERVATION: {
                return ON_STUDY_OBSERVATION;
            }
            case PENDING_ON_STUDY: {
                return PENDING_ON_STUDY;
            }
            case POTENTIAL_CANDIDATE: {
                return POTENTIAL_CANDIDATE;
            }
            case SCREENING: {
                return SCREENING;
            }
            case WITHDRAWN: {
                return WITHDRAWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ResearchSubjectStatus of(java.lang.String value) {
        return ResearchSubjectStatus.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return ResearchSubjectStatus.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return ResearchSubjectStatus.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResearchSubjectStatus other = (ResearchSubjectStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        CANDIDATE("candidate"),
        ELIGIBLE("eligible"),
        FOLLOW_UP("follow-up"),
        INELIGIBLE("ineligible"),
        NOT_REGISTERED("not-registered"),
        OFF_STUDY("off-study"),
        ON_STUDY("on-study"),
        ON_STUDY_INTERVENTION("on-study-intervention"),
        ON_STUDY_OBSERVATION("on-study-observation"),
        PENDING_ON_STUDY("pending-on-study"),
        POTENTIAL_CANDIDATE("potential-candidate"),
        SCREENING("screening"),
        WITHDRAWN("withdrawn");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ResearchSubjectStatus build() {
            return new ResearchSubjectStatus(this);
        }
    }
}

