/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/search-param-type")
public class SearchParamType
extends Code {
    public static final SearchParamType NUMBER = SearchParamType.builder().value(ValueSet.NUMBER).build();
    public static final SearchParamType DATE = SearchParamType.builder().value(ValueSet.DATE).build();
    public static final SearchParamType STRING = SearchParamType.builder().value(ValueSet.STRING).build();
    public static final SearchParamType TOKEN = SearchParamType.builder().value(ValueSet.TOKEN).build();
    public static final SearchParamType REFERENCE = SearchParamType.builder().value(ValueSet.REFERENCE).build();
    public static final SearchParamType COMPOSITE = SearchParamType.builder().value(ValueSet.COMPOSITE).build();
    public static final SearchParamType QUANTITY = SearchParamType.builder().value(ValueSet.QUANTITY).build();
    public static final SearchParamType URI = SearchParamType.builder().value(ValueSet.URI).build();
    public static final SearchParamType SPECIAL = SearchParamType.builder().value(ValueSet.SPECIAL).build();
    private volatile int hashCode;

    private SearchParamType(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static SearchParamType of(ValueSet value) {
        switch (value) {
            case NUMBER: {
                return NUMBER;
            }
            case DATE: {
                return DATE;
            }
            case STRING: {
                return STRING;
            }
            case TOKEN: {
                return TOKEN;
            }
            case REFERENCE: {
                return REFERENCE;
            }
            case COMPOSITE: {
                return COMPOSITE;
            }
            case QUANTITY: {
                return QUANTITY;
            }
            case URI: {
                return URI;
            }
            case SPECIAL: {
                return SPECIAL;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static SearchParamType of(java.lang.String value) {
        return SearchParamType.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return SearchParamType.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return SearchParamType.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchParamType other = (SearchParamType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        NUMBER("number"),
        DATE("date"),
        STRING("string"),
        TOKEN("token"),
        REFERENCE("reference"),
        COMPOSITE("composite"),
        QUANTITY("quantity"),
        URI("uri"),
        SPECIAL("special");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public SearchParamType build() {
            return new SearchParamType(this);
        }
    }
}

