/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/map-transform")
public class StructureMapTransform
extends Code {
    public static final StructureMapTransform CREATE = StructureMapTransform.builder().value(ValueSet.CREATE).build();
    public static final StructureMapTransform COPY = StructureMapTransform.builder().value(ValueSet.COPY).build();
    public static final StructureMapTransform TRUNCATE = StructureMapTransform.builder().value(ValueSet.TRUNCATE).build();
    public static final StructureMapTransform ESCAPE = StructureMapTransform.builder().value(ValueSet.ESCAPE).build();
    public static final StructureMapTransform CAST = StructureMapTransform.builder().value(ValueSet.CAST).build();
    public static final StructureMapTransform APPEND = StructureMapTransform.builder().value(ValueSet.APPEND).build();
    public static final StructureMapTransform TRANSLATE = StructureMapTransform.builder().value(ValueSet.TRANSLATE).build();
    public static final StructureMapTransform REFERENCE = StructureMapTransform.builder().value(ValueSet.REFERENCE).build();
    public static final StructureMapTransform DATE_OP = StructureMapTransform.builder().value(ValueSet.DATE_OP).build();
    public static final StructureMapTransform UUID = StructureMapTransform.builder().value(ValueSet.UUID).build();
    public static final StructureMapTransform POINTER = StructureMapTransform.builder().value(ValueSet.POINTER).build();
    public static final StructureMapTransform EVALUATE = StructureMapTransform.builder().value(ValueSet.EVALUATE).build();
    public static final StructureMapTransform CC = StructureMapTransform.builder().value(ValueSet.CC).build();
    public static final StructureMapTransform C = StructureMapTransform.builder().value(ValueSet.C).build();
    public static final StructureMapTransform QTY = StructureMapTransform.builder().value(ValueSet.QTY).build();
    public static final StructureMapTransform ID = StructureMapTransform.builder().value(ValueSet.ID).build();
    public static final StructureMapTransform CP = StructureMapTransform.builder().value(ValueSet.CP).build();
    private volatile int hashCode;

    private StructureMapTransform(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static StructureMapTransform of(ValueSet value) {
        switch (value) {
            case CREATE: {
                return CREATE;
            }
            case COPY: {
                return COPY;
            }
            case TRUNCATE: {
                return TRUNCATE;
            }
            case ESCAPE: {
                return ESCAPE;
            }
            case CAST: {
                return CAST;
            }
            case APPEND: {
                return APPEND;
            }
            case TRANSLATE: {
                return TRANSLATE;
            }
            case REFERENCE: {
                return REFERENCE;
            }
            case DATE_OP: {
                return DATE_OP;
            }
            case UUID: {
                return UUID;
            }
            case POINTER: {
                return POINTER;
            }
            case EVALUATE: {
                return EVALUATE;
            }
            case CC: {
                return CC;
            }
            case C: {
                return C;
            }
            case QTY: {
                return QTY;
            }
            case ID: {
                return ID;
            }
            case CP: {
                return CP;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static StructureMapTransform of(java.lang.String value) {
        return StructureMapTransform.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return StructureMapTransform.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return StructureMapTransform.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureMapTransform other = (StructureMapTransform)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        CREATE("create"),
        COPY("copy"),
        TRUNCATE("truncate"),
        ESCAPE("escape"),
        CAST("cast"),
        APPEND("append"),
        TRANSLATE("translate"),
        REFERENCE("reference"),
        DATE_OP("dateOp"),
        UUID("uuid"),
        POINTER("pointer"),
        EVALUATE("evaluate"),
        CC("cc"),
        C("c"),
        QTY("qty"),
        ID("id"),
        CP("cp");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public StructureMapTransform build() {
            return new StructureMapTransform(this);
        }
    }
}

