/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/task-status")
public class TaskStatus
extends Code {
    public static final TaskStatus DRAFT = TaskStatus.builder().value(ValueSet.DRAFT).build();
    public static final TaskStatus REQUESTED = TaskStatus.builder().value(ValueSet.REQUESTED).build();
    public static final TaskStatus RECEIVED = TaskStatus.builder().value(ValueSet.RECEIVED).build();
    public static final TaskStatus ACCEPTED = TaskStatus.builder().value(ValueSet.ACCEPTED).build();
    public static final TaskStatus REJECTED = TaskStatus.builder().value(ValueSet.REJECTED).build();
    public static final TaskStatus READY = TaskStatus.builder().value(ValueSet.READY).build();
    public static final TaskStatus CANCELLED = TaskStatus.builder().value(ValueSet.CANCELLED).build();
    public static final TaskStatus IN_PROGRESS = TaskStatus.builder().value(ValueSet.IN_PROGRESS).build();
    public static final TaskStatus ON_HOLD = TaskStatus.builder().value(ValueSet.ON_HOLD).build();
    public static final TaskStatus FAILED = TaskStatus.builder().value(ValueSet.FAILED).build();
    public static final TaskStatus COMPLETED = TaskStatus.builder().value(ValueSet.COMPLETED).build();
    public static final TaskStatus ENTERED_IN_ERROR = TaskStatus.builder().value(ValueSet.ENTERED_IN_ERROR).build();
    private volatile int hashCode;

    private TaskStatus(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static TaskStatus of(ValueSet value) {
        switch (value) {
            case DRAFT: {
                return DRAFT;
            }
            case REQUESTED: {
                return REQUESTED;
            }
            case RECEIVED: {
                return RECEIVED;
            }
            case ACCEPTED: {
                return ACCEPTED;
            }
            case REJECTED: {
                return REJECTED;
            }
            case READY: {
                return READY;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case ON_HOLD: {
                return ON_HOLD;
            }
            case FAILED: {
                return FAILED;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static TaskStatus of(java.lang.String value) {
        return TaskStatus.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return TaskStatus.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return TaskStatus.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskStatus other = (TaskStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        DRAFT("draft"),
        REQUESTED("requested"),
        RECEIVED("received"),
        ACCEPTED("accepted"),
        REJECTED("rejected"),
        READY("ready"),
        CANCELLED("cancelled"),
        IN_PROGRESS("in-progress"),
        ON_HOLD("on-hold"),
        FAILED("failed"),
        COMPLETED("completed"),
        ENTERED_IN_ERROR("entered-in-error");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public TaskStatus build() {
            return new TaskStatus(this);
        }
    }
}

