/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://unitsofmeasure.org")
public class UnitsOfTime
extends Code {
    public static final UnitsOfTime S = UnitsOfTime.builder().value(ValueSet.S).build();
    public static final UnitsOfTime MIN = UnitsOfTime.builder().value(ValueSet.MIN).build();
    public static final UnitsOfTime H = UnitsOfTime.builder().value(ValueSet.H).build();
    public static final UnitsOfTime D = UnitsOfTime.builder().value(ValueSet.D).build();
    public static final UnitsOfTime WK = UnitsOfTime.builder().value(ValueSet.WK).build();
    public static final UnitsOfTime MO = UnitsOfTime.builder().value(ValueSet.MO).build();
    public static final UnitsOfTime A = UnitsOfTime.builder().value(ValueSet.A).build();
    private volatile int hashCode;

    private UnitsOfTime(Builder builder) {
        super(builder);
    }

    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public static UnitsOfTime of(ValueSet value) {
        switch (value) {
            case S: {
                return S;
            }
            case MIN: {
                return MIN;
            }
            case H: {
                return H;
            }
            case D: {
                return D;
            }
            case WK: {
                return WK;
            }
            case MO: {
                return MO;
            }
            case A: {
                return A;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static UnitsOfTime of(java.lang.String value) {
        return UnitsOfTime.of(ValueSet.from(value));
    }

    public static String string(java.lang.String value) {
        return UnitsOfTime.of(ValueSet.from(value));
    }

    public static Code code(java.lang.String value) {
        return UnitsOfTime.of(ValueSet.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnitsOfTime other = (UnitsOfTime)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.id(this.id);
        builder.extension((Collection)this.extension);
        builder.value(this.value);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ValueSet {
        S("s"),
        MIN("min"),
        H("h"),
        D("d"),
        WK("wk"),
        MO("mo"),
        A("a");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(ValueSet.from(value).value()) : this;
        }

        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public UnitsOfTime build() {
            return new UnitsOfTime(this);
        }
    }
}

