/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.util;

import com.ibm.fhir.model.config.FHIRModelConfig;
import com.ibm.fhir.model.lang.util.LanguageRegistryUtil;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.ucum.util.UCUMUtil;
import com.ibm.fhir.model.util.FHIRUtil;
import com.ibm.fhir.model.util.ModelSupport;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

public final class ValidationSupport {
    public static final java.lang.String ALL_LANG_VALUE_SET_URL = "http://hl7.org/fhir/ValueSet/all-languages";
    public static final java.lang.String UCUM_UNITS_VALUE_SET_URL = "http://hl7.org/fhir/ValueSet/ucum-units";
    public static final java.lang.String BCP_47_URN = "urn:ietf:bcp:47";
    public static final java.lang.String UCUM_CODE_SYSTEM_URL = "http://unitsofmeasure.org";
    public static final java.lang.String DATA_ABSENT_REASON_EXTENSION_URL = "http://hl7.org/fhir/StructureDefinition/data-absent-reason";
    private static final int RESOURCE_TYPE_GROUP = 4;
    private static final int MIN_STRING_LENGTH = 1;
    private static final int MAX_STRING_LENGTH = 0x100000;
    private static final java.lang.String LOCAL_REF_PREFIX = "urn:";
    private static final java.lang.String HTTP_PREFIX = "http:";
    private static final java.lang.String HTTPS_PREFIX = "https:";
    private static final java.lang.String FHIR_XHTML_XSD = "fhir-xhtml.xsd";
    private static final java.lang.String FHIR_XML_XSD = "xml.xsd";
    private static final java.lang.String FHIR_XMLDSIG_CORE_SCHEMA_XSD = "xmldsig-core-schema.xsd";
    private static final SchemaFactory SCHEMA_FACTORY = ValidationSupport.createSchemaFactory();
    private static final Schema SCHEMA = ValidationSupport.createSchema();
    private static final ThreadLocal<Validator> THREAD_LOCAL_VALIDATOR = new ThreadLocal<Validator>(){

        @Override
        public Validator initialValue() {
            return SCHEMA.newValidator();
        }
    };
    private static final Set<Character> WHITESPACE = new HashSet<Character>(Arrays.asList(Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\n')));
    private static final char[] BASE64_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final Map<Character, Integer> BASE64_INDEX_MAP = ValidationSupport.buildBase64IndexMap();

    private ValidationSupport() {
    }

    private static Map<Character, Integer> buildBase64IndexMap() {
        LinkedHashMap<Character, Integer> base64IndexMap = new LinkedHashMap<Character, Integer>();
        for (int i = 0; i < BASE64_CHARS.length; ++i) {
            base64IndexMap.put(Character.valueOf(BASE64_CHARS[i]), i);
        }
        return base64IndexMap;
    }

    public static void checkString(java.lang.String s) {
        if (s == null) {
            return;
        }
        if (s.length() > 0x100000) {
            throw new IllegalStateException(java.lang.String.format("String value length: %d is greater than maximum allowed length: %d", s.length(), 0x100000));
        }
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!Character.isWhitespace(ch)) {
                ++count;
                continue;
            }
            if (WHITESPACE.contains(Character.valueOf(ch))) continue;
            throw new IllegalStateException(java.lang.String.format("String value: '%s' is not valid with respect to pattern: [ \\r\\n\\t\\S]+", s));
        }
        if (count < 1) {
            throw new IllegalStateException(java.lang.String.format("Trimmed String value length: %d is less than minimum required length: %d", count, 1));
        }
    }

    public static void checkCode(java.lang.String s) {
        if (s == null) {
            return;
        }
        if (s.length() == 0 || Character.isWhitespace(s.charAt(0))) {
            throw new IllegalStateException(java.lang.String.format("Code value: '%s' must begin with a non-whitespace character", s));
        }
        if (Character.isWhitespace(s.charAt(s.length() - 1))) {
            throw new IllegalStateException(java.lang.String.format("Code value: '%s' must end with a non-whitespace character", s));
        }
        boolean previousIsSpace = false;
        for (int i = 0; i < s.length(); ++i) {
            char current = s.charAt(i);
            if (Character.isWhitespace(current)) {
                if (current != ' ') {
                    throw new IllegalStateException(java.lang.String.format("Code value: '%s' must not contain whitespace other than a single space", s));
                }
                if (previousIsSpace) {
                    throw new IllegalStateException(java.lang.String.format("Code value: '%s' must not contain consecutive spaces", s));
                }
                previousIsSpace = true;
                continue;
            }
            if (!previousIsSpace) continue;
            previousIsSpace = false;
        }
    }

    public static void checkId(java.lang.String s) {
        if (s == null) {
            return;
        }
        if (s.isEmpty()) {
            throw new IllegalStateException(java.lang.String.format("Id value must not be empty", new Object[0]));
        }
        if (s.length() > 64) {
            throw new IllegalStateException(java.lang.String.format("Id value length: %d is greater than maximum allowed length: %d", s.length(), 64));
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(c < '-' || c == '/' || c > '9' && c < 'A' || c > 'Z' && c < 'a') && c <= 'z') continue;
            throw new IllegalStateException(java.lang.String.format("Id value: '%s' contain invalid character '%s'", s, Character.valueOf(c)));
        }
    }

    public static void checkUri(java.lang.String s) {
        if (s == null) {
            return;
        }
        if (s.length() > 0x100000) {
            throw new IllegalStateException(java.lang.String.format("Uri value length: %d is greater than maximum allowed length: %d", s.length(), 0x100000));
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            throw new IllegalStateException(java.lang.String.format("Uri value: '%s' must not contain whitespace", s));
        }
    }

    public static void checkMaxLength(java.lang.String value) {
        if (value != null && value.length() > 0x100000) {
            throw new IllegalStateException(java.lang.String.format("String value length: %d is greater than maximum allowed length: %d", value.length(), 0x100000));
        }
    }

    public static void checkMinLength(java.lang.String value) {
        if (value != null && value.trim().length() < 1) {
            throw new IllegalStateException(java.lang.String.format("Trimmed String value length: %d is less than minimum required length: %d", value.trim().length(), 1));
        }
    }

    public static void checkValue(Integer value, int minValue) {
        if (value != null && value < minValue) {
            throw new IllegalStateException(java.lang.String.format("Integer value: %d is less than minimum required value: %d", value, minValue));
        }
    }

    public static void checkValue(java.lang.String value, Pattern pattern) {
        if (value != null && !pattern.matcher(value).matches()) {
            throw new IllegalStateException(java.lang.String.format("String value: '%s' is not valid with respect to pattern: %s", value, pattern.pattern()));
        }
    }

    public static <T> T checkValueType(T value, Class<?> ... types) {
        Class<?> valueType;
        List<Class<?>> typeList;
        if (value != null && !(typeList = Arrays.asList(types)).contains(valueType = value.getClass())) {
            List typeNameList = typeList.stream().map(Class::getSimpleName).collect(Collectors.toList());
            throw new IllegalStateException(java.lang.String.format("Invalid value type: %s must be one of: %s", valueType.getSimpleName(), typeNameList.toString()));
        }
        return value;
    }

    public static <T extends Element> T choiceElement(T element, java.lang.String elementName, Class<?> ... types) {
        if (element != null) {
            Class<?> elementType = element.getClass();
            boolean noneMatch = true;
            for (Class<?> type : types) {
                if (!type.isAssignableFrom(elementType)) continue;
                noneMatch = false;
                break;
            }
            if (noneMatch) {
                List typeNameList = Arrays.stream(types).map(Class::getSimpleName).collect(Collectors.toList());
                throw new IllegalStateException(java.lang.String.format("Invalid type: %s for choice element: '%s' must be one of: %s", elementType.getSimpleName(), elementName, typeNameList.toString()));
            }
        }
        return element;
    }

    public static void checkXHTMLContent(java.lang.String value) {
        try {
            Validator validator = THREAD_LOCAL_VALIDATOR.get();
            validator.reset();
            validator.validate(new StreamSource(new StringReader(value)));
        }
        catch (Exception e) {
            throw new IllegalStateException(java.lang.String.format("Invalid XHTML content: %s", e.getMessage()), e);
        }
    }

    private static Schema createSchema() {
        try {
            Source[] sources = new StreamSource[]{new StreamSource(ValidationSupport.class.getClassLoader().getResourceAsStream(FHIR_XML_XSD)), new StreamSource(ValidationSupport.class.getClassLoader().getResourceAsStream(FHIR_XMLDSIG_CORE_SCHEMA_XSD)), new StreamSource(ValidationSupport.class.getClassLoader().getResourceAsStream(FHIR_XHTML_XSD))};
            return SCHEMA_FACTORY.newSchema(sources);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static SchemaFactory createSchemaFactory() {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return schemaFactory;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static <T extends Element> T requireChoiceElement(T element, java.lang.String elementName, Class<?> ... types) {
        ValidationSupport.requireNonNull(element, elementName);
        return ValidationSupport.choiceElement(element, elementName, types);
    }

    public static <T> T requireNonNull(T element, java.lang.String elementName) {
        if (element == null) {
            throw new IllegalStateException(java.lang.String.format("Missing required element: '%s'", elementName));
        }
        return element;
    }

    @Deprecated
    public static <T> List<T> requireNonEmpty(List<T> elements, java.lang.String elementName) {
        ValidationSupport.requireNonNull(elements, elementName);
        if (elements.isEmpty()) {
            throw new IllegalStateException(java.lang.String.format("Missing required element: '%s'", elementName));
        }
        return elements;
    }

    @Deprecated
    public static <T> List<T> requireNonNull(List<T> elements, java.lang.String elementName) {
        boolean anyMatch = false;
        for (T element : elements) {
            if (!Objects.isNull(element)) continue;
            anyMatch = true;
            break;
        }
        if (anyMatch) {
            throw new IllegalStateException(java.lang.String.format("Repeating element: '%s' does not permit null elements", elementName));
        }
        return elements;
    }

    public static <T> List<T> checkNonEmptyList(List<T> elements, java.lang.String elementName, Class<T> type) {
        if (elements.isEmpty()) {
            throw new IllegalStateException(java.lang.String.format("Missing required element: '%s'", elementName));
        }
        return ValidationSupport.checkList(elements, elementName, type);
    }

    public static <T> List<T> checkList(List<T> elements, java.lang.String elementName, Class<T> type) {
        for (T element : elements) {
            if (Objects.isNull(element)) {
                throw new IllegalStateException(java.lang.String.format("Repeating element: '%s' does not permit null elements", elementName));
            }
            if (type.isInstance(element)) continue;
            throw new IllegalStateException(java.lang.String.format("Invalid type: %s for repeating element: '%s' must be: %s", element.getClass().getSimpleName(), elementName, type.getSimpleName()));
        }
        return elements;
    }

    public static void requireValueOrChildren(Element element) {
        if (!element.hasValue() && !element.hasChildren()) {
            throw new IllegalStateException("ele-1: All FHIR elements must have a @value or children");
        }
    }

    @Deprecated
    public static void requireChildren(Resource resource) {
        if (!resource.hasChildren()) {
            throw new IllegalStateException("global-1: All FHIR elements must have a @value or children");
        }
    }

    public static void prohibited(Element element, java.lang.String elementName) {
        if (element != null) {
            throw new IllegalStateException(java.lang.String.format("Element: '%s' is prohibited.", elementName));
        }
    }

    public static <T extends Element> void prohibited(List<T> elements, java.lang.String elementName) {
        if (!elements.isEmpty()) {
            throw new IllegalStateException(java.lang.String.format("Element: '%s' is prohibited.", elementName));
        }
    }

    @Deprecated
    public static void checkCodeableConcept(CodeableConcept codeableConcept, java.lang.String elementName, java.lang.String valueSet, java.lang.String system, java.lang.String ... codes) {
        if (codeableConcept != null && !codeableConcept.getCoding().isEmpty() && ValidationSupport.hasCodingWithSystemAndCodeValues(codeableConcept)) {
            List<java.lang.String> codeList = Arrays.asList(codes);
            for (Coding coding : codeableConcept.getCoding()) {
                if (!ValidationSupport.hasSystemAndCodeValues(coding) || !system.equals(coding.getSystem().getValue()) || !codeList.contains(coding.getCode().getValue())) continue;
                return;
            }
            throw new IllegalStateException(java.lang.String.format("Element: '%s' must contain a valid code from value set: '%s'", elementName, valueSet));
        }
    }

    public static void checkValueSetBinding(List<? extends Element> elements, java.lang.String elementName, java.lang.String valueSet, java.lang.String system, java.lang.String ... valueSetCodes) {
        if (elements != null) {
            for (Element element : elements) {
                ValidationSupport.checkValueSetBinding(element, elementName, valueSet, system, valueSetCodes);
            }
        }
    }

    public static void checkValueSetBinding(Element element, java.lang.String elementName, java.lang.String valueSet, java.lang.String system, java.lang.String ... codes) {
        if (element != null) {
            boolean advancedCodeableConceptValidation = FHIRModelConfig.getExtendedCodeableConceptValidation();
            List<java.lang.String> codeList = Arrays.asList(codes);
            if (element instanceof CodeableConcept) {
                ValidationSupport.checkCodeableConcept((CodeableConcept)element, elementName, valueSet, system, codeList, advancedCodeableConceptValidation);
            } else if (element instanceof Coding || element instanceof Quantity) {
                ValidationSupport.checkCoding(element, elementName, valueSet, system, codeList, advancedCodeableConceptValidation);
            } else if (element instanceof Code || element instanceof Uri || element instanceof String) {
                ValidationSupport.checkCode(element, elementName, valueSet, codeList, advancedCodeableConceptValidation);
            }
        }
    }

    private static void checkCodeableConcept(CodeableConcept codeableConcept, java.lang.String elementName, java.lang.String valueSet, java.lang.String system, List<java.lang.String> codes, boolean advancedCodeableConceptValidation) {
        if (advancedCodeableConceptValidation) {
            if (codeableConcept.getCoding() != null) {
                for (Coding coding : codeableConcept.getCoding()) {
                    try {
                        ValidationSupport.checkCoding(coding, elementName, valueSet, system, codes, advancedCodeableConceptValidation);
                        return;
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                }
            }
            throw new IllegalStateException(java.lang.String.format("Element '%s': does not contain a Coding element with a valid system and code combination for value set: '%s'", elementName, valueSet));
        }
        if (!codes.isEmpty() && !codeableConcept.getCoding().isEmpty() && ValidationSupport.hasCodingWithSystemAndCodeValues(codeableConcept)) {
            for (Coding coding : codeableConcept.getCoding()) {
                if (!ValidationSupport.hasSystemAndCodeValues(coding) || !system.equals(coding.getSystem().getValue()) || !codes.contains(coding.getCode().getValue())) continue;
                return;
            }
            throw new IllegalStateException(java.lang.String.format("Element '%s': does not contain a Coding element with a valid system and code combination for value set: '%s'", elementName, valueSet));
        }
    }

    private static void checkCoding(Element element, java.lang.String elementName, java.lang.String valueSet, java.lang.String system, List<java.lang.String> codes, boolean advancedCodeableConceptValidation) {
        if (advancedCodeableConceptValidation && !ValidationSupport.hasOnlyDataAbsentReasonExtension(element)) {
            if (ValidationSupport.hasSystemAndCodeValues(element)) {
                java.lang.String codingSystem = null;
                String codingCode = null;
                if (element instanceof Coding) {
                    codingSystem = element.as(Coding.class).getSystem().getValue();
                    codingCode = element.as(Coding.class).getCode();
                } else if (element instanceof Quantity) {
                    codingSystem = element.as(Quantity.class).getSystem().getValue();
                    codingCode = element.as(Quantity.class).getCode();
                }
                if (ValidationSupport.isSyntaxValidatedValueSet(valueSet)) {
                    ValidationSupport.checkSyntaxValidatedCode(codingCode.getValue(), codingSystem, elementName, valueSet, advancedCodeableConceptValidation);
                } else {
                    if (!codingSystem.equals(system)) {
                        throw new IllegalStateException(java.lang.String.format("Element '%s': '%s' is not a valid system for value set '%s'", elementName, codingSystem, valueSet));
                    }
                    ValidationSupport.checkCode(codingCode, elementName, valueSet, codes, advancedCodeableConceptValidation);
                }
            } else {
                throw new IllegalStateException(java.lang.String.format("Element '%s': does not contain a valid system and code combination for value set: '%s'", elementName, valueSet));
            }
        }
    }

    private static void checkCode(Element element, java.lang.String elementName, java.lang.String valueSet, List<java.lang.String> codes, boolean advancedCodeableConceptValidation) {
        if (advancedCodeableConceptValidation && !ValidationSupport.hasOnlyDataAbsentReasonExtension(element)) {
            java.lang.String codeValue = null;
            if (element instanceof Code) {
                codeValue = ((Code)element).getValue();
            } else if (element instanceof Uri) {
                codeValue = ((Uri)element).getValue();
            } else if (element instanceof String) {
                codeValue = ((String)element).getValue();
            }
            if (codeValue != null) {
                if (ValidationSupport.isSyntaxValidatedValueSet(valueSet)) {
                    ValidationSupport.checkSyntaxValidatedCode(codeValue, null, elementName, valueSet, advancedCodeableConceptValidation);
                } else if (!codes.contains(codeValue)) {
                    throw new IllegalStateException(java.lang.String.format("Element '%s': '%s' is not a valid code for value set '%s'", elementName, codeValue, valueSet));
                }
            } else {
                throw new IllegalStateException(java.lang.String.format("Element '%s': does not contan a valid code for value set '%s'", elementName, valueSet));
            }
        }
    }

    private static void checkSyntaxValidatedCode(java.lang.String code, java.lang.String system, java.lang.String elementName, java.lang.String valueSet, boolean advancedCodeableConceptValidation) {
        if (advancedCodeableConceptValidation) {
            if (ALL_LANG_VALUE_SET_URL.contentEquals(valueSet)) {
                if (system != null && !BCP_47_URN.equals(system)) {
                    throw new IllegalStateException(java.lang.String.format("Element '%s': '%s' is not a valid system for value set '%s'", elementName, system, valueSet));
                }
                if (!LanguageRegistryUtil.isValidLanguageTag(code)) {
                    throw new IllegalStateException(java.lang.String.format("Element '%s': '%s' is not a valid code for value set '%s'", elementName, code, valueSet));
                }
            } else if (UCUM_UNITS_VALUE_SET_URL.equals(valueSet)) {
                if (system != null && !UCUM_CODE_SYSTEM_URL.equals(system)) {
                    throw new IllegalStateException(java.lang.String.format("Element '%s': '%s' is not a valid system for value set '%s'", elementName, system, valueSet));
                }
                if (!UCUMUtil.isValidUcum(code)) {
                    throw new IllegalStateException(java.lang.String.format("Element '%s': '%s' is not a valid code for value set '%s'", elementName, code, valueSet));
                }
            }
        }
    }

    private static boolean hasCodingWithSystemAndCodeValues(CodeableConcept codeableConcept) {
        for (Coding coding : codeableConcept.getCoding()) {
            if (!ValidationSupport.hasSystemAndCodeValues(coding)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSystemAndCodeValues(Element element) {
        if (element instanceof Coding) {
            Coding coding = (Coding)element;
            return coding.getSystem() != null && coding.getSystem().getValue() != null && coding.getCode() != null && coding.getCode().getValue() != null;
        }
        if (element instanceof Quantity) {
            Quantity quantity = (Quantity)element;
            return quantity.getSystem() != null && quantity.getSystem().getValue() != null && quantity.getCode() != null && quantity.getCode().getValue() != null;
        }
        return false;
    }

    private static boolean isSyntaxValidatedValueSet(java.lang.String valueSet) {
        return ALL_LANG_VALUE_SET_URL.equals(valueSet) || UCUM_UNITS_VALUE_SET_URL.equals(valueSet);
    }

    public static void checkReferenceType(List<Reference> reference, java.lang.String elementName, java.lang.String ... referenceTypes) {
        for (Reference r : reference) {
            ValidationSupport.checkReferenceType(r, elementName, referenceTypes);
        }
    }

    public static void checkReferenceType(Element choiceElement, java.lang.String elementName, java.lang.String ... referenceTypes) {
        if (choiceElement instanceof Reference) {
            ValidationSupport.checkReferenceType((Reference)choiceElement, elementName, referenceTypes);
        }
    }

    public static void checkReferenceType(Reference reference, java.lang.String elementName, java.lang.String ... referenceTypes) {
        java.lang.String referenceType;
        if (reference == null || !FHIRModelConfig.getCheckReferenceTypes()) {
            return;
        }
        java.lang.String resourceType = null;
        java.lang.String referenceReference = ValidationSupport.getReferenceReference(reference);
        List<java.lang.String> referenceTypeList = Arrays.asList(referenceTypes);
        if (!(referenceReference == null || referenceReference.startsWith("#") || referenceReference.startsWith(LOCAL_REF_PREFIX) || referenceReference.startsWith(HTTP_PREFIX) || referenceReference.startsWith(HTTPS_PREFIX))) {
            Matcher matcher = FHIRUtil.REFERENCE_PATTERN.matcher(referenceReference);
            if (matcher.matches()) {
                resourceType = matcher.group(4);
            }
            if (resourceType == null) {
                throw new IllegalStateException(java.lang.String.format("Invalid reference value or resource type not found in reference value: '%s' for element: '%s'", referenceReference, elementName));
            }
            if (!ModelSupport.isResourceType(resourceType)) {
                throw new IllegalStateException(java.lang.String.format("Resource type found in reference value: '%s' for element: '%s' must be a valid resource type name", referenceReference, elementName));
            }
            if (!referenceTypeList.contains(resourceType)) {
                throw new IllegalStateException(java.lang.String.format("Resource type found in reference value: '%s' for element: '%s' must be one of: %s", referenceReference, elementName, referenceTypeList.toString()));
            }
        }
        if ((referenceType = ValidationSupport.getReferenceType(reference)) != null) {
            if (!ModelSupport.isResourceType(referenceType)) {
                throw new IllegalStateException(java.lang.String.format("Resource type found in Reference.type: '%s' for element: '%s' must be a valid resource type name", referenceType, elementName));
            }
            if (!referenceTypeList.contains(referenceType)) {
                throw new IllegalStateException(java.lang.String.format("Resource type found in Reference.type: '%s' for element: '%s' must be one of: %s", referenceType, elementName, referenceTypeList.toString()));
            }
            if (resourceType != null && !resourceType.equals(referenceType)) {
                throw new IllegalStateException(java.lang.String.format("Resource type found in reference value: '%s' for element: '%s' does not match Reference.type: %s", referenceReference, elementName, referenceType));
            }
        }
    }

    private static java.lang.String getReferenceReference(Reference reference) {
        if (reference.getReference() != null) {
            return reference.getReference().getValue();
        }
        return null;
    }

    private static java.lang.String getReferenceType(Reference reference) {
        if (reference.getType() != null) {
            return reference.getType().getValue();
        }
        return null;
    }

    public static void validateBase64EncodedString(java.lang.String value) {
        int length = value.length();
        if (length % 4 != 0) {
            throw new IllegalArgumentException("Invalid base64 string length: " + value.length());
        }
        if (value.endsWith("==") || value.endsWith("=")) {
            int mask;
            int charIndex = value.endsWith("==") ? length - 3 : length - 2;
            char ch = value.charAt(charIndex);
            if (ch == '=') {
                throw new IllegalArgumentException("Unexpected base64 padding character: '=' found at index: " + charIndex);
            }
            int base64Index = BASE64_INDEX_MAP.getOrDefault(Character.valueOf(ch), -1);
            if (base64Index == -1) {
                throw new IllegalArgumentException("Illegal base64 character: '" + ch + "' found at index: " + charIndex);
            }
            int n = mask = value.endsWith("==") ? 15 : 3;
            if ((base64Index & mask) != 0) {
                throw new IllegalArgumentException("Invalid base64 string: non-zero padding bits; character: '" + ch + "' found at index: " + charIndex + " should be: '" + BASE64_CHARS[base64Index & ~mask] + "'");
            }
        }
    }

    public static boolean hasOnlyDataAbsentReasonExtension(Element element) {
        if (ValidationSupport.hasDataAbsentReasonExtension(element) && (element.is(Code.class) && element.as(Code.class).getValue() == null || element.is(ModelSupport.FHIR_STRING) && element.as(ModelSupport.FHIR_STRING).getValue() == null || element.is(Uri.class) && element.as(Uri.class).getValue() == null || element.is(Coding.class) && element.as(Coding.class).getSystem() == null && element.as(Coding.class).getCode() == null || element.is(Quantity.class) && element.as(Quantity.class).getSystem() == null && element.as(Quantity.class).getCode() == null)) {
            return true;
        }
        if (element.is(CodeableConcept.class) && element.as(CodeableConcept.class).getCoding() != null) {
            for (Coding coding : element.as(CodeableConcept.class).getCoding()) {
                if (!ValidationSupport.hasOnlyDataAbsentReasonExtension(coding)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasDataAbsentReasonExtension(Element element) {
        for (Extension extension : element.getExtension()) {
            if (!DATA_ABSENT_REASON_EXTENSION_URL.equals(extension.getUrl())) continue;
            return true;
        }
        return false;
    }
}

