/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.visitor;

import com.ibm.fhir.model.builder.Builder;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.util.ModelSupport;
import com.ibm.fhir.model.visitor.DefaultVisitor;
import com.ibm.fhir.model.visitor.Visitable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class CopyingVisitor<T extends Visitable>
extends DefaultVisitor {
    private final Stack<String> pathStack = new Stack();
    private final Stack<BuilderWrapper> builderStack = new Stack();
    private final Stack<ListWrapper> listStack = new Stack();
    private Object result;

    protected void doVisitEnd(String elementName, int elementIndex, Element element) {
    }

    protected void doVisitEnd(String elementName, int elementIndex, Resource resource) {
    }

    protected void doVisitStart(String elementName, int elementIndex, Element element) {
    }

    protected void doVisitStart(String elementName, int elementIndex, Resource resource) {
    }

    protected void doVisitListStart(String elementName, List<? extends Visitable> visitables, Class<?> type) {
    }

    protected void doVisitListEnd(String elementName, List<? extends Visitable> visitables, Class<?> type) {
    }

    public T getResult() {
        return (T)((Visitable)this.result);
    }

    public final String getPath() {
        if (!this.pathStack.isEmpty()) {
            return this.pathStack.stream().collect(Collectors.joining("."));
        }
        return null;
    }

    public CopyingVisitor() {
        super(true);
    }

    public final void reset() {
        if (!this.pathStack.isEmpty()) {
            this.pathStack.clear();
        }
        if (!this.builderStack.isEmpty()) {
            this.builderStack.clear();
        }
        if (!this.listStack.isEmpty()) {
            this.listStack.clear();
        }
    }

    @Override
    public final void visitStart(String elementName, int index, Element element) {
        this.builderStack.push(new ElementWrapper(element.toBuilder()));
        this.pathStackPush(elementName, index);
        this.doVisitStart(elementName, index, element);
    }

    @Override
    public final void visitStart(String elementName, int index, Resource resource) {
        this.builderStack.push(new ResourceWrapper(resource.toBuilder()));
        this.pathStackPush(elementName, index);
        this.doVisitStart(elementName, index, resource);
    }

    @Override
    public final void visitEnd(String elementName, int index, Element element) {
        this.doVisitEnd(elementName, index, element);
        this._visitEnd(elementName, index, element, Element.class);
    }

    @Override
    public final void visitEnd(String elementName, int index, Resource resource) {
        this.doVisitEnd(elementName, index, resource);
        this._visitEnd(elementName, index, resource, Resource.class);
    }

    private void _visitEnd(String elementName, int index, Visitable visited, Class<? extends Visitable> elementOrResource) {
        this.pathStackPop();
        BuilderWrapper wrapper = this.builderStack.pop();
        if (index != -1) {
            Visitable item;
            ListWrapper listWrapper = this.listStack.peek();
            if (wrapper.isDirty()) {
                listWrapper.dirty(true);
            }
            if ((item = wrapper.getBuilder().build()) != null) {
                listWrapper.getList().add(wrapper.getBuilder().build());
            }
        } else if (this.builderStack.isEmpty()) {
            this.result = wrapper.isDirty() ? wrapper.getBuilder().build() : visited;
        } else {
            BuilderWrapper parent = this.builderStack.peek();
            if (wrapper.isDirty()) {
                parent.dirty(true);
                Builder<? extends Visitable> parentBuilder = parent.getBuilder();
                Visitable obj = wrapper.getBuilder().build();
                Class<?> expectedType = ModelSupport.getElementType(parentBuilder.getClass().getEnclosingClass(), elementName);
                if (obj != null && !expectedType.isInstance(obj)) {
                    throw new IllegalStateException("Expected argument of type " + expectedType + " but found " + obj.getClass());
                }
                try {
                    MethodType mt = MethodType.methodType(parentBuilder.getClass(), expectedType);
                    MethodHandle methodHandle = MethodHandles.publicLookup().findVirtual(parentBuilder.getClass(), this.setterName(elementName), mt);
                    methodHandle.invoke(parentBuilder, obj);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Unexpected error while visiting " + parentBuilder.getClass() + "." + elementName, t);
                }
            }
            wrapper = parent;
        }
    }

    @Override
    public void visitStart(String elementName, List<? extends Visitable> visitables, Class<?> type) {
        this.doVisitListStart(elementName, visitables, type);
        this.listStack.push(new ListWrapper(new ArrayList<Visitable>()));
    }

    @Override
    public void visitEnd(String elementName, List<? extends Visitable> visitables, Class<?> type) {
        this.doVisitListEnd(elementName, visitables, type);
        ListWrapper listWrapper = this.listStack.pop();
        if (listWrapper.isDirty()) {
            for (Visitable obj : listWrapper.getList()) {
                if (type.isInstance(obj)) continue;
                throw new IllegalStateException("Expected argument of type " + type + " but found " + obj.getClass());
            }
            BuilderWrapper parent = this.builderStack.peek();
            parent.dirty(true);
            Builder<? extends Visitable> parentBuilder = parent.getBuilder();
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodType mt = MethodType.methodType(parentBuilder.getClass(), Collection.class);
            try {
                MethodHandle methodHandle = lookup.findVirtual(parentBuilder.getClass(), this.setterName(elementName), mt);
                methodHandle.invoke(parentBuilder, listWrapper.getList());
            }
            catch (Throwable t) {
                throw new RuntimeException("Unexpected error while visiting " + parentBuilder.getClass() + "." + elementName, t);
            }
        }
    }

    private String setterName(String elementName) {
        if ("class".equals(elementName)) {
            return "clazz";
        }
        if (SourceVersion.isKeyword(elementName)) {
            return "_" + elementName;
        }
        return elementName;
    }

    @Override
    public void postVisit(Element element) {
    }

    @Override
    public void postVisit(Resource resource) {
    }

    private void pathStackPop() {
        this.pathStack.pop();
    }

    private void pathStackPush(String elementName, int index) {
        if (ModelSupport.isKeyword(elementName)) {
            elementName = ModelSupport.delimit(elementName);
        }
        if (index != -1) {
            this.pathStack.push(elementName + "[" + index + "]");
        } else {
            this.pathStack.push(elementName);
        }
    }

    protected Builder<?> getBuilder() {
        return this.builderStack.peek().getBuilder();
    }

    protected List<Visitable> getList() {
        return this.listStack.peek().getList();
    }

    protected void replace(Resource.Builder builder) {
        this.builderStack.pop();
        this.builderStack.push(new ResourceWrapper(builder));
        this.markDirty();
    }

    protected void replace(Element.Builder builder) {
        this.builderStack.pop();
        this.builderStack.push(new ElementWrapper(builder));
        this.markDirty();
    }

    protected void delete() {
        this.builderStack.pop();
        this.builderStack.push(new BuilderWrapper(){

            @Override
            public Builder<? extends Visitable> getBuilder() {
                return new Builder<Visitable>(){

                    @Override
                    public Visitable build() {
                        return null;
                    }
                };
            }
        });
        this.markDirty();
    }

    protected void markDirty() {
        this.builderStack.peek().dirty(true);
    }

    protected void markListDirty() {
        this.listStack.peek().dirty(true);
    }

    protected Code convertToCodeSubtype(Visitable parent, String elementName, Code value) {
        Class<?> targetType = ModelSupport.getElementType(parent.getClass(), elementName);
        if (value.getClass() != targetType) {
            MethodType mt = MethodType.methodType(targetType, String.class);
            try {
                MethodHandle methodHandle = MethodHandles.publicLookup().findStatic(targetType, "of", mt);
                value = methodHandle.invoke(value.getValue());
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Value of type '" + value.getClass() + "' cannot be used to populate target of type '" + targetType + "'");
            }
        }
        return value;
    }

    private class ResourceWrapper
    extends BuilderWrapper {
        private final Resource.Builder builder;

        public ResourceWrapper(Resource.Builder builder) {
            this.builder = builder;
        }

        public Resource.Builder getBuilder() {
            return this.builder;
        }
    }

    private class ElementWrapper
    extends BuilderWrapper {
        private final Element.Builder builder;

        public ElementWrapper(Element.Builder builder) {
            this.builder = builder;
        }

        public Element.Builder getBuilder() {
            return this.builder;
        }
    }

    private abstract class BuilderWrapper
    extends Markable {
        private BuilderWrapper() {
        }

        public abstract Builder<? extends Visitable> getBuilder();
    }

    private class ListWrapper
    extends Markable {
        private final List<Visitable> list;

        public ListWrapper(List<Visitable> list) {
            this.list = list;
        }

        public List<Visitable> getList() {
            return this.list;
        }
    }

    private abstract class Markable {
        private boolean dirty = false;

        private Markable() {
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void dirty(boolean dirty) {
            this.dirty = dirty;
        }
    }
}

