/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.visitor;

import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.util.ModelSupport;
import com.ibm.fhir.model.visitor.DefaultVisitor;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class PathAwareVisitor
extends DefaultVisitor {
    private static final Logger log = Logger.getLogger(PathAwareVisitor.class.getName());
    private final Stack<String> pathStack = new Stack();

    public final String getPath() {
        if (!this.pathStack.isEmpty()) {
            return this.pathStack.stream().collect(Collectors.joining("."));
        }
        return null;
    }

    public final void reset() {
        if (!this.pathStack.isEmpty()) {
            this.pathStack.clear();
        }
    }

    protected void doVisitStart(String elementName, int elementIndex, Element element) {
    }

    protected void doVisitStart(String elementName, int elementIndex, Resource resource) {
    }

    protected void doVisitEnd(String elementName, int elementIndex, Element element) {
    }

    protected void doVisitEnd(String elementName, int elementIndex, Resource resource) {
    }

    private void pathStackPop() {
        this.pathStack.pop();
    }

    private void pathStackPush(String elementName, int index) {
        if (ModelSupport.isKeyword(elementName)) {
            elementName = ModelSupport.delimit(elementName);
        }
        if (index != -1) {
            this.pathStack.push(elementName + "[" + index + "]");
        } else {
            this.pathStack.push(elementName);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.getPath());
        }
    }

    public PathAwareVisitor() {
        super(true);
    }

    @Override
    public final void visitEnd(String elementName, int elementIndex, Element element) {
        this.doVisitEnd(elementName, elementIndex, element);
        this.pathStackPop();
    }

    @Override
    public final void visitEnd(String elementName, int elementIndex, Resource resource) {
        this.doVisitEnd(elementName, elementIndex, resource);
        this.pathStackPop();
    }

    @Override
    public final void visitStart(String elementName, int elementIndex, Element element) {
        this.pathStackPush(elementName, elementIndex);
        this.doVisitStart(elementName, elementIndex, element);
    }

    @Override
    public final void visitStart(String elementName, int elementIndex, Resource resource) {
        this.pathStackPush(elementName, elementIndex);
        this.doVisitStart(elementName, elementIndex, resource);
    }

    @Override
    public final void visit(String elementName, String value) {
        if (!"value".equals(elementName)) {
            this.pathStackPush(elementName, -1);
        }
        this.doVisit(elementName, value);
        if (!"value".equals(elementName)) {
            this.pathStackPop();
        }
    }

    protected void doVisit(String elementName, String value) {
    }
}

