/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.visitor;

import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.util.SaltHash;
import com.ibm.fhir.model.visitor.PathAwareVisitor;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;

public class ResourceFingerprintVisitor
extends PathAwareVisitor {
    private static final int BYTES_FOR_256_BITS = 32;
    private static final SecureRandom RANDOM = new SecureRandom();
    private final byte[] salt;
    private String currentResourceName;
    private final MessageDigest digest;
    int index;

    public ResourceFingerprintVisitor(byte[] salt) {
        this.salt = salt;
        try {
            this.digest = MessageDigest.getInstance("SHA-256");
            this.digest.update(salt);
        }
        catch (NoSuchAlgorithmException x) {
            throw new IllegalStateException(x);
        }
    }

    public ResourceFingerprintVisitor(SaltHash baseline) {
        this(baseline.getSalt());
    }

    public ResourceFingerprintVisitor() {
        this.salt = new byte[32];
        RANDOM.nextBytes(this.salt);
        try {
            this.digest = MessageDigest.getInstance("SHA-256");
            this.digest.update(this.salt);
        }
        catch (NoSuchAlgorithmException x) {
            throw new IllegalStateException(x);
        }
    }

    public SaltHash getSaltAndHash() {
        return new SaltHash(this.salt, this.digest.digest());
    }

    @Override
    protected void doVisitStart(String elementName, int elementIndex, Resource resource) {
        if (this.currentResourceName == null) {
            this.currentResourceName = resource.getClass().getSimpleName();
        }
    }

    @Override
    public void visit(String elementName, byte[] value) {
        if (this.includePath()) {
            this.digest.update(this.getPath().getBytes(StandardCharsets.UTF_8));
            this.digest.update(value);
        }
    }

    @Override
    public void visit(String elementName, BigDecimal value) {
        if (this.includePath()) {
            this.updateDigest(this.getPath(), value.toString());
        }
    }

    @Override
    public void visit(String elementName, Boolean value) {
        if (this.includePath()) {
            this.updateDigest(this.getPath(), value.toString());
        }
    }

    @Override
    public void visit(String elementName, Integer value) {
        if (this.includePath()) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(value);
            this.digest.update(bb);
        }
    }

    @Override
    public void visit(String elementName, LocalDate value) {
        if (this.includePath()) {
            this.updateDigest(this.getPath(), value.toString());
        }
    }

    @Override
    public void visit(String elementName, LocalTime value) {
        if (this.includePath()) {
            this.updateDigest(this.getPath(), value.toString());
        }
    }

    @Override
    public void doVisit(String elementName, String value) {
        if (this.includePath()) {
            this.updateDigest(this.getPath(), value);
        }
    }

    @Override
    public void visit(String elementName, Year value) {
        if (this.includePath()) {
            this.updateDigest(this.getPath(), value.toString());
        }
    }

    @Override
    public void visit(String elementName, YearMonth value) {
        if (this.includePath()) {
            this.updateDigest(this.getPath(), value.toString());
        }
    }

    @Override
    public void visit(String elementName, ZonedDateTime value) {
        if (this.includePath()) {
            this.updateDigest(this.getPath(), value.toString());
        }
    }

    protected void updateDigest(String name, String value) {
        this.digest.update(name.getBytes(StandardCharsets.UTF_8));
        this.digest.update(value.getBytes(StandardCharsets.UTF_8));
    }

    protected boolean includePath() {
        String idName = this.currentResourceName + ".id";
        String versionIdName = this.currentResourceName + ".meta.versionId";
        String lastUpdatedName = this.currentResourceName + ".meta.lastUpdated";
        String path = this.getPath();
        return !path.startsWith(idName) && !path.startsWith(versionIdName) && !path.startsWith(lastUpdatedName);
    }
}

