/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.AccountStatus;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
public class Account
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="AccountStatus", strength=BindingStrength.Value.REQUIRED, description="Indicates whether the account is available to be used.", valueSet="http://hl7.org/fhir/ValueSet/account-status|4.0.1")
    @Required
    private final AccountStatus status;
    @Summary
    @Binding(bindingName="AccountType", strength=BindingStrength.Value.EXAMPLE, description="The usage type of this account, permits categorization of accounts.", valueSet="http://hl7.org/fhir/ValueSet/account-type")
    private final CodeableConcept type;
    @Summary
    private final String name;
    @Summary
    @ReferenceTarget(value={"Patient", "Device", "Practitioner", "PractitionerRole", "Location", "HealthcareService", "Organization"})
    private final List<Reference> subject;
    @Summary
    private final Period servicePeriod;
    @Summary
    private final List<Coverage> coverage;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference owner;
    @Summary
    private final String description;
    private final List<Guarantor> guarantor;
    @ReferenceTarget(value={"Account"})
    private final Reference partOf;

    private Account(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.type = builder.type;
        this.name = builder.name;
        this.subject = Collections.unmodifiableList(builder.subject);
        this.servicePeriod = builder.servicePeriod;
        this.coverage = Collections.unmodifiableList(builder.coverage);
        this.owner = builder.owner;
        this.description = builder.description;
        this.guarantor = Collections.unmodifiableList(builder.guarantor);
        this.partOf = builder.partOf;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public AccountStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<Reference> getSubject() {
        return this.subject;
    }

    public Period getServicePeriod() {
        return this.servicePeriod;
    }

    public List<Coverage> getCoverage() {
        return this.coverage;
    }

    public Reference getOwner() {
        return this.owner;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Guarantor> getGuarantor() {
        return this.guarantor;
    }

    public Reference getPartOf() {
        return this.partOf;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.type != null || this.name != null || !this.subject.isEmpty() || this.servicePeriod != null || !this.coverage.isEmpty() || this.owner != null || this.description != null || !this.guarantor.isEmpty() || this.partOf != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.subject, "subject", visitor, Reference.class);
                this.accept(this.servicePeriod, "servicePeriod", visitor);
                this.accept(this.coverage, "coverage", visitor, Coverage.class);
                this.accept(this.owner, "owner", visitor);
                this.accept(this.description, "description", visitor);
                this.accept(this.guarantor, "guarantor", visitor, Guarantor.class);
                this.accept(this.partOf, "partOf", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Account other = (Account)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name) && Objects.equals(this.subject, other.subject) && Objects.equals(this.servicePeriod, other.servicePeriod) && Objects.equals(this.coverage, other.coverage) && Objects.equals(this.owner, other.owner) && Objects.equals(this.description, other.description) && Objects.equals(this.guarantor, other.guarantor) && Objects.equals(this.partOf, other.partOf);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.type, this.name, this.subject, this.servicePeriod, this.coverage, this.owner, this.description, this.guarantor, this.partOf);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Guarantor
    extends BackboneElement {
        @ReferenceTarget(value={"Patient", "RelatedPerson", "Organization"})
        @Required
        private final Reference party;
        private final Boolean onHold;
        private final Period period;

        private Guarantor(Builder builder) {
            super(builder);
            this.party = builder.party;
            this.onHold = builder.onHold;
            this.period = builder.period;
        }

        public Reference getParty() {
            return this.party;
        }

        public Boolean getOnHold() {
            return this.onHold;
        }

        public Period getPeriod() {
            return this.period;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.party != null || this.onHold != null || this.period != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.party, "party", visitor);
                    this.accept(this.onHold, "onHold", visitor);
                    this.accept(this.period, "period", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Guarantor other = (Guarantor)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.party, other.party) && Objects.equals(this.onHold, other.onHold) && Objects.equals(this.period, other.period);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.party, this.onHold, this.period);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference party;
            private Boolean onHold;
            private Period period;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder party(Reference party) {
                this.party = party;
                return this;
            }

            public Builder onHold(Boolean onHold) {
                this.onHold = onHold;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            @Override
            public Guarantor build() {
                Guarantor guarantor = new Guarantor(this);
                if (this.validating) {
                    this.validate(guarantor);
                }
                return guarantor;
            }

            protected void validate(Guarantor guarantor) {
                super.validate(guarantor);
                ValidationSupport.requireNonNull(guarantor.party, "party");
                ValidationSupport.checkReferenceType(guarantor.party, "party", "Patient", "RelatedPerson", "Organization");
                ValidationSupport.requireValueOrChildren(guarantor);
            }

            protected Builder from(Guarantor guarantor) {
                super.from(guarantor);
                this.party = guarantor.party;
                this.onHold = guarantor.onHold;
                this.period = guarantor.period;
                return this;
            }
        }
    }

    public static class Coverage
    extends BackboneElement {
        @Summary
        @ReferenceTarget(value={"Coverage"})
        @Required
        private final Reference coverage;
        @Summary
        private final PositiveInt priority;

        private Coverage(Builder builder) {
            super(builder);
            this.coverage = builder.coverage;
            this.priority = builder.priority;
        }

        public Reference getCoverage() {
            return this.coverage;
        }

        public PositiveInt getPriority() {
            return this.priority;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.coverage != null || this.priority != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.coverage, "coverage", visitor);
                    this.accept(this.priority, "priority", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Coverage other = (Coverage)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.coverage, other.coverage) && Objects.equals(this.priority, other.priority);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.coverage, this.priority);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference coverage;
            private PositiveInt priority;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder coverage(Reference coverage) {
                this.coverage = coverage;
                return this;
            }

            public Builder priority(PositiveInt priority) {
                this.priority = priority;
                return this;
            }

            @Override
            public Coverage build() {
                Coverage coverage = new Coverage(this);
                if (this.validating) {
                    this.validate(coverage);
                }
                return coverage;
            }

            protected void validate(Coverage coverage) {
                super.validate(coverage);
                ValidationSupport.requireNonNull(coverage.coverage, "coverage");
                ValidationSupport.checkReferenceType(coverage.coverage, "coverage", "Coverage");
                ValidationSupport.requireValueOrChildren(coverage);
            }

            protected Builder from(Coverage coverage) {
                super.from(coverage);
                this.coverage = coverage.coverage;
                this.priority = coverage.priority;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private AccountStatus status;
        private CodeableConcept type;
        private String name;
        private List<Reference> subject = new ArrayList<Reference>();
        private Period servicePeriod;
        private List<Coverage> coverage = new ArrayList<Coverage>();
        private Reference owner;
        private String description;
        private List<Guarantor> guarantor = new ArrayList<Guarantor>();
        private Reference partOf;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(AccountStatus status) {
            this.status = status;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder subject(Reference ... subject) {
            for (Reference value : subject) {
                this.subject.add(value);
            }
            return this;
        }

        public Builder subject(Collection<Reference> subject) {
            this.subject = new ArrayList<Reference>(subject);
            return this;
        }

        public Builder servicePeriod(Period servicePeriod) {
            this.servicePeriod = servicePeriod;
            return this;
        }

        public Builder coverage(Coverage ... coverage) {
            for (Coverage value : coverage) {
                this.coverage.add(value);
            }
            return this;
        }

        public Builder coverage(Collection<Coverage> coverage) {
            this.coverage = new ArrayList<Coverage>(coverage);
            return this;
        }

        public Builder owner(Reference owner) {
            this.owner = owner;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder guarantor(Guarantor ... guarantor) {
            for (Guarantor value : guarantor) {
                this.guarantor.add(value);
            }
            return this;
        }

        public Builder guarantor(Collection<Guarantor> guarantor) {
            this.guarantor = new ArrayList<Guarantor>(guarantor);
            return this;
        }

        public Builder partOf(Reference partOf) {
            this.partOf = partOf;
            return this;
        }

        @Override
        public Account build() {
            Account account = new Account(this);
            if (this.validating) {
                this.validate(account);
            }
            return account;
        }

        protected void validate(Account account) {
            super.validate(account);
            ValidationSupport.checkList(account.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(account.status, "status");
            ValidationSupport.checkList(account.subject, "subject", Reference.class);
            ValidationSupport.checkList(account.coverage, "coverage", Coverage.class);
            ValidationSupport.checkList(account.guarantor, "guarantor", Guarantor.class);
            ValidationSupport.checkReferenceType(account.subject, "subject", "Patient", "Device", "Practitioner", "PractitionerRole", "Location", "HealthcareService", "Organization");
            ValidationSupport.checkReferenceType(account.owner, "owner", "Organization");
            ValidationSupport.checkReferenceType(account.partOf, "partOf", "Account");
        }

        protected Builder from(Account account) {
            super.from(account);
            this.identifier.addAll(account.identifier);
            this.status = account.status;
            this.type = account.type;
            this.name = account.name;
            this.subject.addAll(account.subject);
            this.servicePeriod = account.servicePeriod;
            this.coverage.addAll(account.coverage);
            this.owner = account.owner;
            this.description = account.description;
            this.guarantor.addAll(account.guarantor);
            this.partOf = account.partOf;
            return this;
        }
    }
}

