/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Signature;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.BundleType;
import com.ibm.fhir.model.type.code.HTTPVerb;
import com.ibm.fhir.model.type.code.SearchEntryMode;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=5, status=StandardsStatus.Value.NORMATIVE)
@Constraints(value={@Constraint(id="bdl-1", level="Rule", location="(base)", description="total only when a search or history", expression="total.empty() or (type = 'searchset') or (type = 'history')", source="http://hl7.org/fhir/StructureDefinition/Bundle"), @Constraint(id="bdl-2", level="Rule", location="(base)", description="entry.search only when a search", expression="entry.search.empty() or (type = 'searchset')", source="http://hl7.org/fhir/StructureDefinition/Bundle"), @Constraint(id="bdl-3", level="Rule", location="(base)", description="entry.request mandatory for batch/transaction/history, otherwise prohibited", expression="entry.all(request.exists() = (%resource.type = 'batch' or %resource.type = 'transaction' or %resource.type = 'history'))", source="http://hl7.org/fhir/StructureDefinition/Bundle"), @Constraint(id="bdl-4", level="Rule", location="(base)", description="entry.response mandatory for batch-response/transaction-response/history, otherwise prohibited", expression="entry.all(response.exists() = (%resource.type = 'batch-response' or %resource.type = 'transaction-response' or %resource.type = 'history'))", source="http://hl7.org/fhir/StructureDefinition/Bundle"), @Constraint(id="bdl-5", level="Rule", location="Bundle.entry", description="must be a resource unless there's a request or response", expression="resource.exists() or request.exists() or response.exists()", source="http://hl7.org/fhir/StructureDefinition/Bundle"), @Constraint(id="bdl-7", level="Rule", location="(base)", description="FullUrl must be unique in a bundle, or else entries with the same fullUrl must have different meta.versionId (except in history bundles)", expression="(type = 'history') or entry.where(fullUrl.exists()).select(fullUrl&resource.meta.versionId).isDistinct()", source="http://hl7.org/fhir/StructureDefinition/Bundle"), @Constraint(id="bdl-8", level="Rule", location="Bundle.entry", description="fullUrl cannot be a version specific reference", expression="fullUrl.contains('/_history/').not()", source="http://hl7.org/fhir/StructureDefinition/Bundle"), @Constraint(id="bdl-9", level="Rule", location="(base)", description="A document must have an identifier with a system and a value", expression="type = 'document' implies (identifier.system.exists() and identifier.value.exists())", source="http://hl7.org/fhir/StructureDefinition/Bundle"), @Constraint(id="bdl-10", level="Rule", location="(base)", description="A document must have a date", expression="type = 'document' implies (timestamp.hasValue())", source="http://hl7.org/fhir/StructureDefinition/Bundle"), @Constraint(id="bdl-11", level="Rule", location="(base)", description="A document must have a Composition as the first resource", expression="type = 'document' implies entry.first().resource.is(Composition)", source="http://hl7.org/fhir/StructureDefinition/Bundle"), @Constraint(id="bdl-12", level="Rule", location="(base)", description="A message must have a MessageHeader as the first resource", expression="type = 'message' implies entry.first().resource.is(MessageHeader)", source="http://hl7.org/fhir/StructureDefinition/Bundle")})
public class Bundle
extends Resource {
    @Summary
    private final Identifier identifier;
    @Summary
    @Binding(bindingName="BundleType", strength=BindingStrength.Value.REQUIRED, description="Indicates the purpose of a bundle - how it is intended to be used.", valueSet="http://hl7.org/fhir/ValueSet/bundle-type|4.0.1")
    @Required
    private final BundleType type;
    @Summary
    private final Instant timestamp;
    @Summary
    private final UnsignedInt total;
    @Summary
    private final List<Link> link;
    @Summary
    private final List<Entry> entry;
    @Summary
    private final Signature signature;

    private Bundle(Builder builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.type = builder.type;
        this.timestamp = builder.timestamp;
        this.total = builder.total;
        this.link = Collections.unmodifiableList(builder.link);
        this.entry = Collections.unmodifiableList(builder.entry);
        this.signature = builder.signature;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public BundleType getType() {
        return this.type;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public UnsignedInt getTotal() {
        return this.total;
    }

    public List<Link> getLink() {
        return this.link;
    }

    public List<Entry> getEntry() {
        return this.entry;
    }

    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.identifier != null || this.type != null || this.timestamp != null || this.total != null || !this.link.isEmpty() || !this.entry.isEmpty() || this.signature != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.identifier, "identifier", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.timestamp, "timestamp", visitor);
                this.accept(this.total, "total", visitor);
                this.accept(this.link, "link", visitor, Link.class);
                this.accept(this.entry, "entry", visitor, Entry.class);
                this.accept(this.signature, "signature", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bundle other = (Bundle)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.total, other.total) && Objects.equals(this.link, other.link) && Objects.equals(this.entry, other.entry) && Objects.equals(this.signature, other.signature);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.identifier, this.type, this.timestamp, this.total, this.link, this.entry, this.signature);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Entry
    extends BackboneElement {
        @Summary
        private final List<Link> link;
        @Summary
        private final Uri fullUrl;
        @Summary
        private final Resource resource;
        @Summary
        private final Search search;
        @Summary
        private final Request request;
        @Summary
        private final Response response;

        private Entry(Builder builder) {
            super(builder);
            this.link = Collections.unmodifiableList(builder.link);
            this.fullUrl = builder.fullUrl;
            this.resource = builder.resource;
            this.search = builder.search;
            this.request = builder.request;
            this.response = builder.response;
        }

        public List<Link> getLink() {
            return this.link;
        }

        public Uri getFullUrl() {
            return this.fullUrl;
        }

        public Resource getResource() {
            return this.resource;
        }

        public Search getSearch() {
            return this.search;
        }

        public Request getRequest() {
            return this.request;
        }

        public Response getResponse() {
            return this.response;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.link.isEmpty() || this.fullUrl != null || this.resource != null || this.search != null || this.request != null || this.response != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.link, "link", visitor, Link.class);
                    this.accept(this.fullUrl, "fullUrl", visitor);
                    this.accept(this.resource, "resource", visitor);
                    this.accept(this.search, "search", visitor);
                    this.accept(this.request, "request", visitor);
                    this.accept(this.response, "response", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.link, other.link) && Objects.equals(this.fullUrl, other.fullUrl) && Objects.equals(this.resource, other.resource) && Objects.equals(this.search, other.search) && Objects.equals(this.request, other.request) && Objects.equals(this.response, other.response);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.link, this.fullUrl, this.resource, this.search, this.request, this.response);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Response
        extends BackboneElement {
            @Summary
            @Required
            private final String status;
            @Summary
            private final Uri location;
            @Summary
            private final String etag;
            @Summary
            private final Instant lastModified;
            @Summary
            private final Resource outcome;

            private Response(Builder builder) {
                super(builder);
                this.status = builder.status;
                this.location = builder.location;
                this.etag = builder.etag;
                this.lastModified = builder.lastModified;
                this.outcome = builder.outcome;
            }

            public String getStatus() {
                return this.status;
            }

            public Uri getLocation() {
                return this.location;
            }

            public String getEtag() {
                return this.etag;
            }

            public Instant getLastModified() {
                return this.lastModified;
            }

            public Resource getOutcome() {
                return this.outcome;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.status != null || this.location != null || this.etag != null || this.lastModified != null || this.outcome != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.status, "status", visitor);
                        this.accept(this.location, "location", visitor);
                        this.accept(this.etag, "etag", visitor);
                        this.accept(this.lastModified, "lastModified", visitor);
                        this.accept(this.outcome, "outcome", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Response other = (Response)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.status, other.status) && Objects.equals(this.location, other.location) && Objects.equals(this.etag, other.etag) && Objects.equals(this.lastModified, other.lastModified) && Objects.equals(this.outcome, other.outcome);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.status, this.location, this.etag, this.lastModified, this.outcome);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private String status;
                private Uri location;
                private String etag;
                private Instant lastModified;
                private Resource outcome;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder status(String status) {
                    this.status = status;
                    return this;
                }

                public Builder location(Uri location) {
                    this.location = location;
                    return this;
                }

                public Builder etag(String etag) {
                    this.etag = etag;
                    return this;
                }

                public Builder lastModified(Instant lastModified) {
                    this.lastModified = lastModified;
                    return this;
                }

                public Builder outcome(Resource outcome) {
                    this.outcome = outcome;
                    return this;
                }

                @Override
                public Response build() {
                    Response response = new Response(this);
                    if (this.validating) {
                        this.validate(response);
                    }
                    return response;
                }

                protected void validate(Response response) {
                    super.validate(response);
                    ValidationSupport.requireNonNull(response.status, "status");
                    ValidationSupport.requireValueOrChildren(response);
                }

                protected Builder from(Response response) {
                    super.from(response);
                    this.status = response.status;
                    this.location = response.location;
                    this.etag = response.etag;
                    this.lastModified = response.lastModified;
                    this.outcome = response.outcome;
                    return this;
                }
            }
        }

        public static class Request
        extends BackboneElement {
            @Summary
            @Binding(bindingName="HTTPVerb", strength=BindingStrength.Value.REQUIRED, description="HTTP verbs (in the HTTP command line). See [HTTP rfc](https://tools.ietf.org/html/rfc7231) for details.", valueSet="http://hl7.org/fhir/ValueSet/http-verb|4.0.1")
            @Required
            private final HTTPVerb method;
            @Summary
            @Required
            private final Uri url;
            @Summary
            private final String ifNoneMatch;
            @Summary
            private final Instant ifModifiedSince;
            @Summary
            private final String ifMatch;
            @Summary
            private final String ifNoneExist;

            private Request(Builder builder) {
                super(builder);
                this.method = builder.method;
                this.url = builder.url;
                this.ifNoneMatch = builder.ifNoneMatch;
                this.ifModifiedSince = builder.ifModifiedSince;
                this.ifMatch = builder.ifMatch;
                this.ifNoneExist = builder.ifNoneExist;
            }

            public HTTPVerb getMethod() {
                return this.method;
            }

            public Uri getUrl() {
                return this.url;
            }

            public String getIfNoneMatch() {
                return this.ifNoneMatch;
            }

            public Instant getIfModifiedSince() {
                return this.ifModifiedSince;
            }

            public String getIfMatch() {
                return this.ifMatch;
            }

            public String getIfNoneExist() {
                return this.ifNoneExist;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.method != null || this.url != null || this.ifNoneMatch != null || this.ifModifiedSince != null || this.ifMatch != null || this.ifNoneExist != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.method, "method", visitor);
                        this.accept(this.url, "url", visitor);
                        this.accept(this.ifNoneMatch, "ifNoneMatch", visitor);
                        this.accept(this.ifModifiedSince, "ifModifiedSince", visitor);
                        this.accept(this.ifMatch, "ifMatch", visitor);
                        this.accept(this.ifNoneExist, "ifNoneExist", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Request other = (Request)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.method, other.method) && Objects.equals(this.url, other.url) && Objects.equals(this.ifNoneMatch, other.ifNoneMatch) && Objects.equals(this.ifModifiedSince, other.ifModifiedSince) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.ifNoneExist, other.ifNoneExist);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.method, this.url, this.ifNoneMatch, this.ifModifiedSince, this.ifMatch, this.ifNoneExist);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private HTTPVerb method;
                private Uri url;
                private String ifNoneMatch;
                private Instant ifModifiedSince;
                private String ifMatch;
                private String ifNoneExist;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder method(HTTPVerb method) {
                    this.method = method;
                    return this;
                }

                public Builder url(Uri url) {
                    this.url = url;
                    return this;
                }

                public Builder ifNoneMatch(String ifNoneMatch) {
                    this.ifNoneMatch = ifNoneMatch;
                    return this;
                }

                public Builder ifModifiedSince(Instant ifModifiedSince) {
                    this.ifModifiedSince = ifModifiedSince;
                    return this;
                }

                public Builder ifMatch(String ifMatch) {
                    this.ifMatch = ifMatch;
                    return this;
                }

                public Builder ifNoneExist(String ifNoneExist) {
                    this.ifNoneExist = ifNoneExist;
                    return this;
                }

                @Override
                public Request build() {
                    Request request = new Request(this);
                    if (this.validating) {
                        this.validate(request);
                    }
                    return request;
                }

                protected void validate(Request request) {
                    super.validate(request);
                    ValidationSupport.requireNonNull(request.method, "method");
                    ValidationSupport.requireNonNull(request.url, "url");
                    ValidationSupport.requireValueOrChildren(request);
                }

                protected Builder from(Request request) {
                    super.from(request);
                    this.method = request.method;
                    this.url = request.url;
                    this.ifNoneMatch = request.ifNoneMatch;
                    this.ifModifiedSince = request.ifModifiedSince;
                    this.ifMatch = request.ifMatch;
                    this.ifNoneExist = request.ifNoneExist;
                    return this;
                }
            }
        }

        public static class Search
        extends BackboneElement {
            @Summary
            @Binding(bindingName="SearchEntryMode", strength=BindingStrength.Value.REQUIRED, description="Why an entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.", valueSet="http://hl7.org/fhir/ValueSet/search-entry-mode|4.0.1")
            private final SearchEntryMode mode;
            @Summary
            private final Decimal score;

            private Search(Builder builder) {
                super(builder);
                this.mode = builder.mode;
                this.score = builder.score;
            }

            public SearchEntryMode getMode() {
                return this.mode;
            }

            public Decimal getScore() {
                return this.score;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.mode != null || this.score != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.mode, "mode", visitor);
                        this.accept(this.score, "score", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Search other = (Search)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.mode, other.mode) && Objects.equals(this.score, other.score);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.mode, this.score);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private SearchEntryMode mode;
                private Decimal score;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder mode(SearchEntryMode mode) {
                    this.mode = mode;
                    return this;
                }

                public Builder score(Decimal score) {
                    this.score = score;
                    return this;
                }

                @Override
                public Search build() {
                    Search search = new Search(this);
                    if (this.validating) {
                        this.validate(search);
                    }
                    return search;
                }

                protected void validate(Search search) {
                    super.validate(search);
                    ValidationSupport.requireValueOrChildren(search);
                }

                protected Builder from(Search search) {
                    super.from(search);
                    this.mode = search.mode;
                    this.score = search.score;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Link> link = new ArrayList<Link>();
            private Uri fullUrl;
            private Resource resource;
            private Search search;
            private Request request;
            private Response response;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder link(Link ... link) {
                for (Link value : link) {
                    this.link.add(value);
                }
                return this;
            }

            public Builder link(Collection<Link> link) {
                this.link = new ArrayList<Link>(link);
                return this;
            }

            public Builder fullUrl(Uri fullUrl) {
                this.fullUrl = fullUrl;
                return this;
            }

            public Builder resource(Resource resource) {
                this.resource = resource;
                return this;
            }

            public Builder search(Search search) {
                this.search = search;
                return this;
            }

            public Builder request(Request request) {
                this.request = request;
                return this;
            }

            public Builder response(Response response) {
                this.response = response;
                return this;
            }

            @Override
            public Entry build() {
                Entry entry = new Entry(this);
                if (this.validating) {
                    this.validate(entry);
                }
                return entry;
            }

            protected void validate(Entry entry) {
                super.validate(entry);
                ValidationSupport.checkList(entry.link, "link", Link.class);
                ValidationSupport.requireValueOrChildren(entry);
            }

            protected Builder from(Entry entry) {
                super.from(entry);
                this.link.addAll(entry.link);
                this.fullUrl = entry.fullUrl;
                this.resource = entry.resource;
                this.search = entry.search;
                this.request = entry.request;
                this.response = entry.response;
                return this;
            }
        }
    }

    public static class Link
    extends BackboneElement {
        @Summary
        @Required
        private final String relation;
        @Summary
        @Required
        private final Uri url;

        private Link(Builder builder) {
            super(builder);
            this.relation = builder.relation;
            this.url = builder.url;
        }

        public String getRelation() {
            return this.relation;
        }

        public Uri getUrl() {
            return this.url;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.relation != null || this.url != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.relation, "relation", visitor);
                    this.accept(this.url, "url", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Link other = (Link)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.relation, other.relation) && Objects.equals(this.url, other.url);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.relation, this.url);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String relation;
            private Uri url;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder relation(String relation) {
                this.relation = relation;
                return this;
            }

            public Builder url(Uri url) {
                this.url = url;
                return this;
            }

            @Override
            public Link build() {
                Link link = new Link(this);
                if (this.validating) {
                    this.validate(link);
                }
                return link;
            }

            protected void validate(Link link) {
                super.validate(link);
                ValidationSupport.requireNonNull(link.relation, "relation");
                ValidationSupport.requireNonNull(link.url, "url");
                ValidationSupport.requireValueOrChildren(link);
            }

            protected Builder from(Link link) {
                super.from(link);
                this.relation = link.relation;
                this.url = link.url;
                return this;
            }
        }
    }

    public static class Builder
    extends Resource.Builder {
        private Identifier identifier;
        private BundleType type;
        private Instant timestamp;
        private UnsignedInt total;
        private List<Link> link = new ArrayList<Link>();
        private List<Entry> entry = new ArrayList<Entry>();
        private Signature signature;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder type(BundleType type) {
            this.type = type;
            return this;
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder total(UnsignedInt total) {
            this.total = total;
            return this;
        }

        public Builder link(Link ... link) {
            for (Link value : link) {
                this.link.add(value);
            }
            return this;
        }

        public Builder link(Collection<Link> link) {
            this.link = new ArrayList<Link>(link);
            return this;
        }

        public Builder entry(Entry ... entry) {
            for (Entry value : entry) {
                this.entry.add(value);
            }
            return this;
        }

        public Builder entry(Collection<Entry> entry) {
            this.entry = new ArrayList<Entry>(entry);
            return this;
        }

        public Builder signature(Signature signature) {
            this.signature = signature;
            return this;
        }

        @Override
        public Bundle build() {
            Bundle bundle = new Bundle(this);
            if (this.validating) {
                this.validate(bundle);
            }
            return bundle;
        }

        protected void validate(Bundle bundle) {
            super.validate(bundle);
            ValidationSupport.requireNonNull(bundle.type, "type");
            ValidationSupport.checkList(bundle.link, "link", Link.class);
            ValidationSupport.checkList(bundle.entry, "entry", Entry.class);
        }

        protected Builder from(Bundle bundle) {
            super.from(bundle);
            this.identifier = bundle.identifier;
            this.type = bundle.type;
            this.timestamp = bundle.timestamp;
            this.total = bundle.total;
            this.link.addAll(bundle.link);
            this.entry.addAll(bundle.entry);
            this.signature = bundle.signature;
            return this;
        }
    }
}

