/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ChargeItemStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class ChargeItem
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    private final List<Uri> definitionUri;
    private final List<Canonical> definitionCanonical;
    @Summary
    @Binding(bindingName="ChargeItemStatus", strength=BindingStrength.Value.REQUIRED, description="Codes identifying the lifecycle stage of a ChargeItem.", valueSet="http://hl7.org/fhir/ValueSet/chargeitem-status|4.0.1")
    @Required
    private final ChargeItemStatus status;
    @ReferenceTarget(value={"ChargeItem"})
    private final List<Reference> partOf;
    @Summary
    @Binding(bindingName="ChargeItemCode", strength=BindingStrength.Value.EXAMPLE, description="Example set of codes that can be used for billing purposes.", valueSet="http://hl7.org/fhir/ValueSet/chargeitem-billingcodes")
    @Required
    private final CodeableConcept code;
    @Summary
    @ReferenceTarget(value={"Patient", "Group"})
    @Required
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter", "EpisodeOfCare"})
    private final Reference context;
    @Summary
    @Choice(value={DateTime.class, Period.class, Timing.class})
    private final Element occurrence;
    private final List<Performer> performer;
    @ReferenceTarget(value={"Organization"})
    private final Reference performingOrganization;
    @ReferenceTarget(value={"Organization"})
    private final Reference requestingOrganization;
    @ReferenceTarget(value={"Organization"})
    private final Reference costCenter;
    @Summary
    private final Quantity quantity;
    @Summary
    @Binding(bindingName="BodySite", strength=BindingStrength.Value.EXAMPLE, description="Codes describing anatomical locations. May include laterality.", valueSet="http://hl7.org/fhir/ValueSet/body-site")
    private final List<CodeableConcept> bodysite;
    private final Decimal factorOverride;
    private final Money priceOverride;
    private final String overrideReason;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "Patient", "Device", "RelatedPerson"})
    private final Reference enterer;
    @Summary
    private final DateTime enteredDate;
    @Binding(bindingName="ChargeItemReason", strength=BindingStrength.Value.EXAMPLE, description="Example binding for reason.", valueSet="http://hl7.org/fhir/ValueSet/icd-10")
    private final List<CodeableConcept> reason;
    @ReferenceTarget(value={"DiagnosticReport", "ImagingStudy", "Immunization", "MedicationAdministration", "MedicationDispense", "Observation", "Procedure", "SupplyDelivery"})
    private final List<Reference> service;
    @ReferenceTarget(value={"Device", "Medication", "Substance"})
    @Choice(value={Reference.class, CodeableConcept.class})
    @Binding(bindingName="ChargeItemProduct", strength=BindingStrength.Value.EXAMPLE, description="Example binding for product type.", valueSet="http://hl7.org/fhir/ValueSet/device-kind")
    private final Element product;
    @Summary
    @ReferenceTarget(value={"Account"})
    private final List<Reference> account;
    private final List<Annotation> note;
    private final List<Reference> supportingInformation;

    private ChargeItem(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.definitionUri = Collections.unmodifiableList(builder.definitionUri);
        this.definitionCanonical = Collections.unmodifiableList(builder.definitionCanonical);
        this.status = builder.status;
        this.partOf = Collections.unmodifiableList(builder.partOf);
        this.code = builder.code;
        this.subject = builder.subject;
        this.context = builder.context;
        this.occurrence = builder.occurrence;
        this.performer = Collections.unmodifiableList(builder.performer);
        this.performingOrganization = builder.performingOrganization;
        this.requestingOrganization = builder.requestingOrganization;
        this.costCenter = builder.costCenter;
        this.quantity = builder.quantity;
        this.bodysite = Collections.unmodifiableList(builder.bodysite);
        this.factorOverride = builder.factorOverride;
        this.priceOverride = builder.priceOverride;
        this.overrideReason = builder.overrideReason;
        this.enterer = builder.enterer;
        this.enteredDate = builder.enteredDate;
        this.reason = Collections.unmodifiableList(builder.reason);
        this.service = Collections.unmodifiableList(builder.service);
        this.product = builder.product;
        this.account = Collections.unmodifiableList(builder.account);
        this.note = Collections.unmodifiableList(builder.note);
        this.supportingInformation = Collections.unmodifiableList(builder.supportingInformation);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Uri> getDefinitionUri() {
        return this.definitionUri;
    }

    public List<Canonical> getDefinitionCanonical() {
        return this.definitionCanonical;
    }

    public ChargeItemStatus getStatus() {
        return this.status;
    }

    public List<Reference> getPartOf() {
        return this.partOf;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getContext() {
        return this.context;
    }

    public Element getOccurrence() {
        return this.occurrence;
    }

    public List<Performer> getPerformer() {
        return this.performer;
    }

    public Reference getPerformingOrganization() {
        return this.performingOrganization;
    }

    public Reference getRequestingOrganization() {
        return this.requestingOrganization;
    }

    public Reference getCostCenter() {
        return this.costCenter;
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public List<CodeableConcept> getBodysite() {
        return this.bodysite;
    }

    public Decimal getFactorOverride() {
        return this.factorOverride;
    }

    public Money getPriceOverride() {
        return this.priceOverride;
    }

    public String getOverrideReason() {
        return this.overrideReason;
    }

    public Reference getEnterer() {
        return this.enterer;
    }

    public DateTime getEnteredDate() {
        return this.enteredDate;
    }

    public List<CodeableConcept> getReason() {
        return this.reason;
    }

    public List<Reference> getService() {
        return this.service;
    }

    public Element getProduct() {
        return this.product;
    }

    public List<Reference> getAccount() {
        return this.account;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<Reference> getSupportingInformation() {
        return this.supportingInformation;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.definitionUri.isEmpty() || !this.definitionCanonical.isEmpty() || this.status != null || !this.partOf.isEmpty() || this.code != null || this.subject != null || this.context != null || this.occurrence != null || !this.performer.isEmpty() || this.performingOrganization != null || this.requestingOrganization != null || this.costCenter != null || this.quantity != null || !this.bodysite.isEmpty() || this.factorOverride != null || this.priceOverride != null || this.overrideReason != null || this.enterer != null || this.enteredDate != null || !this.reason.isEmpty() || !this.service.isEmpty() || this.product != null || !this.account.isEmpty() || !this.note.isEmpty() || !this.supportingInformation.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.definitionUri, "definitionUri", visitor, Uri.class);
                this.accept(this.definitionCanonical, "definitionCanonical", visitor, Canonical.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.partOf, "partOf", visitor, Reference.class);
                this.accept(this.code, "code", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.context, "context", visitor);
                this.accept(this.occurrence, "occurrence", visitor);
                this.accept(this.performer, "performer", visitor, Performer.class);
                this.accept(this.performingOrganization, "performingOrganization", visitor);
                this.accept(this.requestingOrganization, "requestingOrganization", visitor);
                this.accept(this.costCenter, "costCenter", visitor);
                this.accept(this.quantity, "quantity", visitor);
                this.accept(this.bodysite, "bodysite", visitor, CodeableConcept.class);
                this.accept(this.factorOverride, "factorOverride", visitor);
                this.accept(this.priceOverride, "priceOverride", visitor);
                this.accept(this.overrideReason, "overrideReason", visitor);
                this.accept(this.enterer, "enterer", visitor);
                this.accept(this.enteredDate, "enteredDate", visitor);
                this.accept(this.reason, "reason", visitor, CodeableConcept.class);
                this.accept(this.service, "service", visitor, Reference.class);
                this.accept(this.product, "product", visitor);
                this.accept(this.account, "account", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.supportingInformation, "supportingInformation", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChargeItem other = (ChargeItem)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.definitionUri, other.definitionUri) && Objects.equals(this.definitionCanonical, other.definitionCanonical) && Objects.equals(this.status, other.status) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.code, other.code) && Objects.equals(this.subject, other.subject) && Objects.equals(this.context, other.context) && Objects.equals(this.occurrence, other.occurrence) && Objects.equals(this.performer, other.performer) && Objects.equals(this.performingOrganization, other.performingOrganization) && Objects.equals(this.requestingOrganization, other.requestingOrganization) && Objects.equals(this.costCenter, other.costCenter) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.bodysite, other.bodysite) && Objects.equals(this.factorOverride, other.factorOverride) && Objects.equals(this.priceOverride, other.priceOverride) && Objects.equals(this.overrideReason, other.overrideReason) && Objects.equals(this.enterer, other.enterer) && Objects.equals(this.enteredDate, other.enteredDate) && Objects.equals(this.reason, other.reason) && Objects.equals(this.service, other.service) && Objects.equals(this.product, other.product) && Objects.equals(this.account, other.account) && Objects.equals(this.note, other.note) && Objects.equals(this.supportingInformation, other.supportingInformation);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.definitionUri, this.definitionCanonical, this.status, this.partOf, this.code, this.subject, this.context, this.occurrence, this.performer, this.performingOrganization, this.requestingOrganization, this.costCenter, this.quantity, this.bodysite, this.factorOverride, this.priceOverride, this.overrideReason, this.enterer, this.enteredDate, this.reason, this.service, this.product, this.account, this.note, this.supportingInformation);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Performer
    extends BackboneElement {
        @Binding(bindingName="ChargeItemPerformerFunction", strength=BindingStrength.Value.EXAMPLE, description="Codes describing the types of functional roles performers can take on when performing events.", valueSet="http://hl7.org/fhir/ValueSet/performer-role")
        private final CodeableConcept function;
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "CareTeam", "Patient", "Device", "RelatedPerson"})
        @Required
        private final Reference actor;

        private Performer(Builder builder) {
            super(builder);
            this.function = builder.function;
            this.actor = builder.actor;
        }

        public CodeableConcept getFunction() {
            return this.function;
        }

        public Reference getActor() {
            return this.actor;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.function != null || this.actor != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.function, "function", visitor);
                    this.accept(this.actor, "actor", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Performer other = (Performer)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.function, other.function) && Objects.equals(this.actor, other.actor);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.function, this.actor);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept function;
            private Reference actor;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder function(CodeableConcept function) {
                this.function = function;
                return this;
            }

            public Builder actor(Reference actor) {
                this.actor = actor;
                return this;
            }

            @Override
            public Performer build() {
                Performer performer = new Performer(this);
                if (this.validating) {
                    this.validate(performer);
                }
                return performer;
            }

            protected void validate(Performer performer) {
                super.validate(performer);
                ValidationSupport.requireNonNull(performer.actor, "actor");
                ValidationSupport.checkReferenceType(performer.actor, "actor", "Practitioner", "PractitionerRole", "Organization", "CareTeam", "Patient", "Device", "RelatedPerson");
                ValidationSupport.requireValueOrChildren(performer);
            }

            protected Builder from(Performer performer) {
                super.from(performer);
                this.function = performer.function;
                this.actor = performer.actor;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Uri> definitionUri = new ArrayList<Uri>();
        private List<Canonical> definitionCanonical = new ArrayList<Canonical>();
        private ChargeItemStatus status;
        private List<Reference> partOf = new ArrayList<Reference>();
        private CodeableConcept code;
        private Reference subject;
        private Reference context;
        private Element occurrence;
        private List<Performer> performer = new ArrayList<Performer>();
        private Reference performingOrganization;
        private Reference requestingOrganization;
        private Reference costCenter;
        private Quantity quantity;
        private List<CodeableConcept> bodysite = new ArrayList<CodeableConcept>();
        private Decimal factorOverride;
        private Money priceOverride;
        private String overrideReason;
        private Reference enterer;
        private DateTime enteredDate;
        private List<CodeableConcept> reason = new ArrayList<CodeableConcept>();
        private List<Reference> service = new ArrayList<Reference>();
        private Element product;
        private List<Reference> account = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<Reference> supportingInformation = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder definitionUri(Uri ... definitionUri) {
            for (Uri value : definitionUri) {
                this.definitionUri.add(value);
            }
            return this;
        }

        public Builder definitionUri(Collection<Uri> definitionUri) {
            this.definitionUri = new ArrayList<Uri>(definitionUri);
            return this;
        }

        public Builder definitionCanonical(Canonical ... definitionCanonical) {
            for (Canonical value : definitionCanonical) {
                this.definitionCanonical.add(value);
            }
            return this;
        }

        public Builder definitionCanonical(Collection<Canonical> definitionCanonical) {
            this.definitionCanonical = new ArrayList<Canonical>(definitionCanonical);
            return this;
        }

        public Builder status(ChargeItemStatus status) {
            this.status = status;
            return this;
        }

        public Builder partOf(Reference ... partOf) {
            for (Reference value : partOf) {
                this.partOf.add(value);
            }
            return this;
        }

        public Builder partOf(Collection<Reference> partOf) {
            this.partOf = new ArrayList<Reference>(partOf);
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder context(Reference context) {
            this.context = context;
            return this;
        }

        public Builder occurrence(Element occurrence) {
            this.occurrence = occurrence;
            return this;
        }

        public Builder performer(Performer ... performer) {
            for (Performer value : performer) {
                this.performer.add(value);
            }
            return this;
        }

        public Builder performer(Collection<Performer> performer) {
            this.performer = new ArrayList<Performer>(performer);
            return this;
        }

        public Builder performingOrganization(Reference performingOrganization) {
            this.performingOrganization = performingOrganization;
            return this;
        }

        public Builder requestingOrganization(Reference requestingOrganization) {
            this.requestingOrganization = requestingOrganization;
            return this;
        }

        public Builder costCenter(Reference costCenter) {
            this.costCenter = costCenter;
            return this;
        }

        public Builder quantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder bodysite(CodeableConcept ... bodysite) {
            for (CodeableConcept value : bodysite) {
                this.bodysite.add(value);
            }
            return this;
        }

        public Builder bodysite(Collection<CodeableConcept> bodysite) {
            this.bodysite = new ArrayList<CodeableConcept>(bodysite);
            return this;
        }

        public Builder factorOverride(Decimal factorOverride) {
            this.factorOverride = factorOverride;
            return this;
        }

        public Builder priceOverride(Money priceOverride) {
            this.priceOverride = priceOverride;
            return this;
        }

        public Builder overrideReason(String overrideReason) {
            this.overrideReason = overrideReason;
            return this;
        }

        public Builder enterer(Reference enterer) {
            this.enterer = enterer;
            return this;
        }

        public Builder enteredDate(DateTime enteredDate) {
            this.enteredDate = enteredDate;
            return this;
        }

        public Builder reason(CodeableConcept ... reason) {
            for (CodeableConcept value : reason) {
                this.reason.add(value);
            }
            return this;
        }

        public Builder reason(Collection<CodeableConcept> reason) {
            this.reason = new ArrayList<CodeableConcept>(reason);
            return this;
        }

        public Builder service(Reference ... service) {
            for (Reference value : service) {
                this.service.add(value);
            }
            return this;
        }

        public Builder service(Collection<Reference> service) {
            this.service = new ArrayList<Reference>(service);
            return this;
        }

        public Builder product(Element product) {
            this.product = product;
            return this;
        }

        public Builder account(Reference ... account) {
            for (Reference value : account) {
                this.account.add(value);
            }
            return this;
        }

        public Builder account(Collection<Reference> account) {
            this.account = new ArrayList<Reference>(account);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder supportingInformation(Reference ... supportingInformation) {
            for (Reference value : supportingInformation) {
                this.supportingInformation.add(value);
            }
            return this;
        }

        public Builder supportingInformation(Collection<Reference> supportingInformation) {
            this.supportingInformation = new ArrayList<Reference>(supportingInformation);
            return this;
        }

        @Override
        public ChargeItem build() {
            ChargeItem chargeItem = new ChargeItem(this);
            if (this.validating) {
                this.validate(chargeItem);
            }
            return chargeItem;
        }

        protected void validate(ChargeItem chargeItem) {
            super.validate(chargeItem);
            ValidationSupport.checkList(chargeItem.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(chargeItem.definitionUri, "definitionUri", Uri.class);
            ValidationSupport.checkList(chargeItem.definitionCanonical, "definitionCanonical", Canonical.class);
            ValidationSupport.requireNonNull(chargeItem.status, "status");
            ValidationSupport.checkList(chargeItem.partOf, "partOf", Reference.class);
            ValidationSupport.requireNonNull(chargeItem.code, "code");
            ValidationSupport.requireNonNull(chargeItem.subject, "subject");
            ValidationSupport.choiceElement(chargeItem.occurrence, "occurrence", DateTime.class, Period.class, Timing.class);
            ValidationSupport.checkList(chargeItem.performer, "performer", Performer.class);
            ValidationSupport.checkList(chargeItem.bodysite, "bodysite", CodeableConcept.class);
            ValidationSupport.checkList(chargeItem.reason, "reason", CodeableConcept.class);
            ValidationSupport.checkList(chargeItem.service, "service", Reference.class);
            ValidationSupport.choiceElement(chargeItem.product, "product", Reference.class, CodeableConcept.class);
            ValidationSupport.checkList(chargeItem.account, "account", Reference.class);
            ValidationSupport.checkList(chargeItem.note, "note", Annotation.class);
            ValidationSupport.checkList(chargeItem.supportingInformation, "supportingInformation", Reference.class);
            ValidationSupport.checkReferenceType(chargeItem.partOf, "partOf", "ChargeItem");
            ValidationSupport.checkReferenceType(chargeItem.subject, "subject", "Patient", "Group");
            ValidationSupport.checkReferenceType(chargeItem.context, "context", "Encounter", "EpisodeOfCare");
            ValidationSupport.checkReferenceType(chargeItem.performingOrganization, "performingOrganization", "Organization");
            ValidationSupport.checkReferenceType(chargeItem.requestingOrganization, "requestingOrganization", "Organization");
            ValidationSupport.checkReferenceType(chargeItem.costCenter, "costCenter", "Organization");
            ValidationSupport.checkReferenceType(chargeItem.enterer, "enterer", "Practitioner", "PractitionerRole", "Organization", "Patient", "Device", "RelatedPerson");
            ValidationSupport.checkReferenceType(chargeItem.service, "service", "DiagnosticReport", "ImagingStudy", "Immunization", "MedicationAdministration", "MedicationDispense", "Observation", "Procedure", "SupplyDelivery");
            ValidationSupport.checkReferenceType(chargeItem.product, "product", "Device", "Medication", "Substance");
            ValidationSupport.checkReferenceType(chargeItem.account, "account", "Account");
        }

        protected Builder from(ChargeItem chargeItem) {
            super.from(chargeItem);
            this.identifier.addAll(chargeItem.identifier);
            this.definitionUri.addAll(chargeItem.definitionUri);
            this.definitionCanonical.addAll(chargeItem.definitionCanonical);
            this.status = chargeItem.status;
            this.partOf.addAll(chargeItem.partOf);
            this.code = chargeItem.code;
            this.subject = chargeItem.subject;
            this.context = chargeItem.context;
            this.occurrence = chargeItem.occurrence;
            this.performer.addAll(chargeItem.performer);
            this.performingOrganization = chargeItem.performingOrganization;
            this.requestingOrganization = chargeItem.requestingOrganization;
            this.costCenter = chargeItem.costCenter;
            this.quantity = chargeItem.quantity;
            this.bodysite.addAll(chargeItem.bodysite);
            this.factorOverride = chargeItem.factorOverride;
            this.priceOverride = chargeItem.priceOverride;
            this.overrideReason = chargeItem.overrideReason;
            this.enterer = chargeItem.enterer;
            this.enteredDate = chargeItem.enteredDate;
            this.reason.addAll(chargeItem.reason);
            this.service.addAll(chargeItem.service);
            this.product = chargeItem.product;
            this.account.addAll(chargeItem.account);
            this.note.addAll(chargeItem.note);
            this.supportingInformation.addAll(chargeItem.supportingInformation);
            return this;
        }
    }
}

