/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Address;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ClaimStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.type.code.Use;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="claim-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/claim-type", expression="type.exists() and type.memberOf('http://hl7.org/fhir/ValueSet/claim-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Claim", generated=true), @Constraint(id="claim-1", level="Warning", location="accident.type", description="SHALL, if possible, contain a code from value set http://terminology.hl7.org/ValueSet/v3-ActIncidentCode", expression="$this.memberOf('http://terminology.hl7.org/ValueSet/v3-ActIncidentCode', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Claim", generated=true)})
public class Claim
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="ClaimStatus", strength=BindingStrength.Value.REQUIRED, description="A code specifying the state of the resource instance.", valueSet="http://hl7.org/fhir/ValueSet/fm-status|4.0.1")
    @Required
    private final ClaimStatus status;
    @Summary
    @Binding(bindingName="ClaimType", strength=BindingStrength.Value.EXTENSIBLE, description="The type or discipline-style of the claim.", valueSet="http://hl7.org/fhir/ValueSet/claim-type")
    @Required
    private final CodeableConcept type;
    @Binding(bindingName="ClaimSubType", strength=BindingStrength.Value.EXAMPLE, description="A more granular claim typecode.", valueSet="http://hl7.org/fhir/ValueSet/claim-subtype")
    private final CodeableConcept subType;
    @Summary
    @Binding(bindingName="Use", strength=BindingStrength.Value.REQUIRED, description="The purpose of the Claim: predetermination, preauthorization, claim.", valueSet="http://hl7.org/fhir/ValueSet/claim-use|4.0.1")
    @Required
    private final Use use;
    @Summary
    @ReferenceTarget(value={"Patient"})
    @Required
    private final Reference patient;
    @Summary
    private final Period billablePeriod;
    @Summary
    @Required
    private final DateTime created;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
    private final Reference enterer;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference insurer;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
    @Required
    private final Reference provider;
    @Summary
    @Binding(bindingName="ProcessPriority", strength=BindingStrength.Value.EXAMPLE, description="The timeliness with which processing is required: stat, normal, deferred.", valueSet="http://hl7.org/fhir/ValueSet/process-priority")
    @Required
    private final CodeableConcept priority;
    @Binding(bindingName="FundsReserve", strength=BindingStrength.Value.EXAMPLE, description="For whom funds are to be reserved: (Patient, Provider, None).", valueSet="http://hl7.org/fhir/ValueSet/fundsreserve")
    private final CodeableConcept fundsReserve;
    private final List<Related> related;
    @ReferenceTarget(value={"DeviceRequest", "MedicationRequest", "VisionPrescription"})
    private final Reference prescription;
    @ReferenceTarget(value={"DeviceRequest", "MedicationRequest", "VisionPrescription"})
    private final Reference originalPrescription;
    private final Payee payee;
    @ReferenceTarget(value={"ServiceRequest"})
    private final Reference referral;
    @ReferenceTarget(value={"Location"})
    private final Reference facility;
    private final List<CareTeam> careTeam;
    private final List<SupportingInfo> supportingInfo;
    private final List<Diagnosis> diagnosis;
    private final List<Procedure> procedure;
    @Summary
    @Required
    private final List<Insurance> insurance;
    private final Accident accident;
    private final List<Item> item;
    private final Money total;

    private Claim(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.type = builder.type;
        this.subType = builder.subType;
        this.use = builder.use;
        this.patient = builder.patient;
        this.billablePeriod = builder.billablePeriod;
        this.created = builder.created;
        this.enterer = builder.enterer;
        this.insurer = builder.insurer;
        this.provider = builder.provider;
        this.priority = builder.priority;
        this.fundsReserve = builder.fundsReserve;
        this.related = Collections.unmodifiableList(builder.related);
        this.prescription = builder.prescription;
        this.originalPrescription = builder.originalPrescription;
        this.payee = builder.payee;
        this.referral = builder.referral;
        this.facility = builder.facility;
        this.careTeam = Collections.unmodifiableList(builder.careTeam);
        this.supportingInfo = Collections.unmodifiableList(builder.supportingInfo);
        this.diagnosis = Collections.unmodifiableList(builder.diagnosis);
        this.procedure = Collections.unmodifiableList(builder.procedure);
        this.insurance = Collections.unmodifiableList(builder.insurance);
        this.accident = builder.accident;
        this.item = Collections.unmodifiableList(builder.item);
        this.total = builder.total;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public ClaimStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public CodeableConcept getSubType() {
        return this.subType;
    }

    public Use getUse() {
        return this.use;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public Period getBillablePeriod() {
        return this.billablePeriod;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public Reference getEnterer() {
        return this.enterer;
    }

    public Reference getInsurer() {
        return this.insurer;
    }

    public Reference getProvider() {
        return this.provider;
    }

    public CodeableConcept getPriority() {
        return this.priority;
    }

    public CodeableConcept getFundsReserve() {
        return this.fundsReserve;
    }

    public List<Related> getRelated() {
        return this.related;
    }

    public Reference getPrescription() {
        return this.prescription;
    }

    public Reference getOriginalPrescription() {
        return this.originalPrescription;
    }

    public Payee getPayee() {
        return this.payee;
    }

    public Reference getReferral() {
        return this.referral;
    }

    public Reference getFacility() {
        return this.facility;
    }

    public List<CareTeam> getCareTeam() {
        return this.careTeam;
    }

    public List<SupportingInfo> getSupportingInfo() {
        return this.supportingInfo;
    }

    public List<Diagnosis> getDiagnosis() {
        return this.diagnosis;
    }

    public List<Procedure> getProcedure() {
        return this.procedure;
    }

    public List<Insurance> getInsurance() {
        return this.insurance;
    }

    public Accident getAccident() {
        return this.accident;
    }

    public List<Item> getItem() {
        return this.item;
    }

    public Money getTotal() {
        return this.total;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.type != null || this.subType != null || this.use != null || this.patient != null || this.billablePeriod != null || this.created != null || this.enterer != null || this.insurer != null || this.provider != null || this.priority != null || this.fundsReserve != null || !this.related.isEmpty() || this.prescription != null || this.originalPrescription != null || this.payee != null || this.referral != null || this.facility != null || !this.careTeam.isEmpty() || !this.supportingInfo.isEmpty() || !this.diagnosis.isEmpty() || !this.procedure.isEmpty() || !this.insurance.isEmpty() || this.accident != null || !this.item.isEmpty() || this.total != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.subType, "subType", visitor);
                this.accept(this.use, "use", visitor);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.billablePeriod, "billablePeriod", visitor);
                this.accept(this.created, "created", visitor);
                this.accept(this.enterer, "enterer", visitor);
                this.accept(this.insurer, "insurer", visitor);
                this.accept(this.provider, "provider", visitor);
                this.accept(this.priority, "priority", visitor);
                this.accept(this.fundsReserve, "fundsReserve", visitor);
                this.accept(this.related, "related", visitor, Related.class);
                this.accept(this.prescription, "prescription", visitor);
                this.accept(this.originalPrescription, "originalPrescription", visitor);
                this.accept(this.payee, "payee", visitor);
                this.accept(this.referral, "referral", visitor);
                this.accept(this.facility, "facility", visitor);
                this.accept(this.careTeam, "careTeam", visitor, CareTeam.class);
                this.accept(this.supportingInfo, "supportingInfo", visitor, SupportingInfo.class);
                this.accept(this.diagnosis, "diagnosis", visitor, Diagnosis.class);
                this.accept(this.procedure, "procedure", visitor, Procedure.class);
                this.accept(this.insurance, "insurance", visitor, Insurance.class);
                this.accept(this.accident, "accident", visitor);
                this.accept(this.item, "item", visitor, Item.class);
                this.accept(this.total, "total", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Claim other = (Claim)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.type, other.type) && Objects.equals(this.subType, other.subType) && Objects.equals(this.use, other.use) && Objects.equals(this.patient, other.patient) && Objects.equals(this.billablePeriod, other.billablePeriod) && Objects.equals(this.created, other.created) && Objects.equals(this.enterer, other.enterer) && Objects.equals(this.insurer, other.insurer) && Objects.equals(this.provider, other.provider) && Objects.equals(this.priority, other.priority) && Objects.equals(this.fundsReserve, other.fundsReserve) && Objects.equals(this.related, other.related) && Objects.equals(this.prescription, other.prescription) && Objects.equals(this.originalPrescription, other.originalPrescription) && Objects.equals(this.payee, other.payee) && Objects.equals(this.referral, other.referral) && Objects.equals(this.facility, other.facility) && Objects.equals(this.careTeam, other.careTeam) && Objects.equals(this.supportingInfo, other.supportingInfo) && Objects.equals(this.diagnosis, other.diagnosis) && Objects.equals(this.procedure, other.procedure) && Objects.equals(this.insurance, other.insurance) && Objects.equals(this.accident, other.accident) && Objects.equals(this.item, other.item) && Objects.equals(this.total, other.total);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.type, this.subType, this.use, this.patient, this.billablePeriod, this.created, this.enterer, this.insurer, this.provider, this.priority, this.fundsReserve, this.related, this.prescription, this.originalPrescription, this.payee, this.referral, this.facility, this.careTeam, this.supportingInfo, this.diagnosis, this.procedure, this.insurance, this.accident, this.item, this.total);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Item
    extends BackboneElement {
        @Required
        private final PositiveInt sequence;
        private final List<PositiveInt> careTeamSequence;
        private final List<PositiveInt> diagnosisSequence;
        private final List<PositiveInt> procedureSequence;
        private final List<PositiveInt> informationSequence;
        @Binding(bindingName="RevenueCenter", strength=BindingStrength.Value.EXAMPLE, description="Codes for the revenue or cost centers supplying the service and/or products.", valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
        private final CodeableConcept revenue;
        @Binding(bindingName="BenefitCategory", strength=BindingStrength.Value.EXAMPLE, description="Benefit categories such as: oral-basic, major, glasses.", valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
        private final CodeableConcept category;
        @Binding(bindingName="ServiceProduct", strength=BindingStrength.Value.EXAMPLE, description="Allowable service and product codes.", valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        @Required
        private final CodeableConcept productOrService;
        @Binding(bindingName="Modifiers", strength=BindingStrength.Value.EXAMPLE, description="Item type or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.", valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        private final List<CodeableConcept> modifier;
        @Binding(bindingName="ProgramCode", strength=BindingStrength.Value.EXAMPLE, description="Program specific reason codes.", valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
        private final List<CodeableConcept> programCode;
        @Choice(value={Date.class, Period.class})
        private final Element serviced;
        @ReferenceTarget(value={"Location"})
        @Choice(value={CodeableConcept.class, Address.class, Reference.class})
        @Binding(bindingName="ServicePlace", strength=BindingStrength.Value.EXAMPLE, description="Place of service: pharmacy, school, prison, etc.", valueSet="http://hl7.org/fhir/ValueSet/service-place")
        private final Element location;
        private final SimpleQuantity quantity;
        private final Money unitPrice;
        private final Decimal factor;
        private final Money net;
        @ReferenceTarget(value={"Device"})
        private final List<Reference> udi;
        @Binding(bindingName="OralSites", strength=BindingStrength.Value.EXAMPLE, description="The code for the teeth, quadrant, sextant and arch.", valueSet="http://hl7.org/fhir/ValueSet/tooth")
        private final CodeableConcept bodySite;
        @Binding(bindingName="Surface", strength=BindingStrength.Value.EXAMPLE, description="The code for the tooth surface and surface combinations.", valueSet="http://hl7.org/fhir/ValueSet/surface")
        private final List<CodeableConcept> subSite;
        @ReferenceTarget(value={"Encounter"})
        private final List<Reference> encounter;
        private final List<Detail> detail;

        private Item(Builder builder) {
            super(builder);
            this.sequence = builder.sequence;
            this.careTeamSequence = Collections.unmodifiableList(builder.careTeamSequence);
            this.diagnosisSequence = Collections.unmodifiableList(builder.diagnosisSequence);
            this.procedureSequence = Collections.unmodifiableList(builder.procedureSequence);
            this.informationSequence = Collections.unmodifiableList(builder.informationSequence);
            this.revenue = builder.revenue;
            this.category = builder.category;
            this.productOrService = builder.productOrService;
            this.modifier = Collections.unmodifiableList(builder.modifier);
            this.programCode = Collections.unmodifiableList(builder.programCode);
            this.serviced = builder.serviced;
            this.location = builder.location;
            this.quantity = builder.quantity;
            this.unitPrice = builder.unitPrice;
            this.factor = builder.factor;
            this.net = builder.net;
            this.udi = Collections.unmodifiableList(builder.udi);
            this.bodySite = builder.bodySite;
            this.subSite = Collections.unmodifiableList(builder.subSite);
            this.encounter = Collections.unmodifiableList(builder.encounter);
            this.detail = Collections.unmodifiableList(builder.detail);
        }

        public PositiveInt getSequence() {
            return this.sequence;
        }

        public List<PositiveInt> getCareTeamSequence() {
            return this.careTeamSequence;
        }

        public List<PositiveInt> getDiagnosisSequence() {
            return this.diagnosisSequence;
        }

        public List<PositiveInt> getProcedureSequence() {
            return this.procedureSequence;
        }

        public List<PositiveInt> getInformationSequence() {
            return this.informationSequence;
        }

        public CodeableConcept getRevenue() {
            return this.revenue;
        }

        public CodeableConcept getCategory() {
            return this.category;
        }

        public CodeableConcept getProductOrService() {
            return this.productOrService;
        }

        public List<CodeableConcept> getModifier() {
            return this.modifier;
        }

        public List<CodeableConcept> getProgramCode() {
            return this.programCode;
        }

        public Element getServiced() {
            return this.serviced;
        }

        public Element getLocation() {
            return this.location;
        }

        public SimpleQuantity getQuantity() {
            return this.quantity;
        }

        public Money getUnitPrice() {
            return this.unitPrice;
        }

        public Decimal getFactor() {
            return this.factor;
        }

        public Money getNet() {
            return this.net;
        }

        public List<Reference> getUdi() {
            return this.udi;
        }

        public CodeableConcept getBodySite() {
            return this.bodySite;
        }

        public List<CodeableConcept> getSubSite() {
            return this.subSite;
        }

        public List<Reference> getEncounter() {
            return this.encounter;
        }

        public List<Detail> getDetail() {
            return this.detail;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.sequence != null || !this.careTeamSequence.isEmpty() || !this.diagnosisSequence.isEmpty() || !this.procedureSequence.isEmpty() || !this.informationSequence.isEmpty() || this.revenue != null || this.category != null || this.productOrService != null || !this.modifier.isEmpty() || !this.programCode.isEmpty() || this.serviced != null || this.location != null || this.quantity != null || this.unitPrice != null || this.factor != null || this.net != null || !this.udi.isEmpty() || this.bodySite != null || !this.subSite.isEmpty() || !this.encounter.isEmpty() || !this.detail.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.sequence, "sequence", visitor);
                    this.accept(this.careTeamSequence, "careTeamSequence", visitor, PositiveInt.class);
                    this.accept(this.diagnosisSequence, "diagnosisSequence", visitor, PositiveInt.class);
                    this.accept(this.procedureSequence, "procedureSequence", visitor, PositiveInt.class);
                    this.accept(this.informationSequence, "informationSequence", visitor, PositiveInt.class);
                    this.accept(this.revenue, "revenue", visitor);
                    this.accept(this.category, "category", visitor);
                    this.accept(this.productOrService, "productOrService", visitor);
                    this.accept(this.modifier, "modifier", visitor, CodeableConcept.class);
                    this.accept(this.programCode, "programCode", visitor, CodeableConcept.class);
                    this.accept(this.serviced, "serviced", visitor);
                    this.accept(this.location, "location", visitor);
                    this.accept(this.quantity, "quantity", visitor);
                    this.accept(this.unitPrice, "unitPrice", visitor);
                    this.accept(this.factor, "factor", visitor);
                    this.accept(this.net, "net", visitor);
                    this.accept(this.udi, "udi", visitor, Reference.class);
                    this.accept(this.bodySite, "bodySite", visitor);
                    this.accept(this.subSite, "subSite", visitor, CodeableConcept.class);
                    this.accept(this.encounter, "encounter", visitor, Reference.class);
                    this.accept(this.detail, "detail", visitor, Detail.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.careTeamSequence, other.careTeamSequence) && Objects.equals(this.diagnosisSequence, other.diagnosisSequence) && Objects.equals(this.procedureSequence, other.procedureSequence) && Objects.equals(this.informationSequence, other.informationSequence) && Objects.equals(this.revenue, other.revenue) && Objects.equals(this.category, other.category) && Objects.equals(this.productOrService, other.productOrService) && Objects.equals(this.modifier, other.modifier) && Objects.equals(this.programCode, other.programCode) && Objects.equals(this.serviced, other.serviced) && Objects.equals(this.location, other.location) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.unitPrice, other.unitPrice) && Objects.equals(this.factor, other.factor) && Objects.equals(this.net, other.net) && Objects.equals(this.udi, other.udi) && Objects.equals(this.bodySite, other.bodySite) && Objects.equals(this.subSite, other.subSite) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.detail, other.detail);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.sequence, this.careTeamSequence, this.diagnosisSequence, this.procedureSequence, this.informationSequence, this.revenue, this.category, this.productOrService, this.modifier, this.programCode, this.serviced, this.location, this.quantity, this.unitPrice, this.factor, this.net, this.udi, this.bodySite, this.subSite, this.encounter, this.detail);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Detail
        extends BackboneElement {
            @Required
            private final PositiveInt sequence;
            @Binding(bindingName="RevenueCenter", strength=BindingStrength.Value.EXAMPLE, description="Codes for the revenue or cost centers supplying the service and/or products.", valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
            private final CodeableConcept revenue;
            @Binding(bindingName="BenefitCategory", strength=BindingStrength.Value.EXAMPLE, description="Benefit categories such as: oral-basic, major, glasses.", valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
            private final CodeableConcept category;
            @Binding(bindingName="ServiceProduct", strength=BindingStrength.Value.EXAMPLE, description="Allowable service and product codes.", valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
            @Required
            private final CodeableConcept productOrService;
            @Binding(bindingName="Modifiers", strength=BindingStrength.Value.EXAMPLE, description="Item type or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.", valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
            private final List<CodeableConcept> modifier;
            @Binding(bindingName="ProgramCode", strength=BindingStrength.Value.EXAMPLE, description="Program specific reason codes.", valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
            private final List<CodeableConcept> programCode;
            private final SimpleQuantity quantity;
            private final Money unitPrice;
            private final Decimal factor;
            private final Money net;
            @ReferenceTarget(value={"Device"})
            private final List<Reference> udi;
            private final List<SubDetail> subDetail;

            private Detail(Builder builder) {
                super(builder);
                this.sequence = builder.sequence;
                this.revenue = builder.revenue;
                this.category = builder.category;
                this.productOrService = builder.productOrService;
                this.modifier = Collections.unmodifiableList(builder.modifier);
                this.programCode = Collections.unmodifiableList(builder.programCode);
                this.quantity = builder.quantity;
                this.unitPrice = builder.unitPrice;
                this.factor = builder.factor;
                this.net = builder.net;
                this.udi = Collections.unmodifiableList(builder.udi);
                this.subDetail = Collections.unmodifiableList(builder.subDetail);
            }

            public PositiveInt getSequence() {
                return this.sequence;
            }

            public CodeableConcept getRevenue() {
                return this.revenue;
            }

            public CodeableConcept getCategory() {
                return this.category;
            }

            public CodeableConcept getProductOrService() {
                return this.productOrService;
            }

            public List<CodeableConcept> getModifier() {
                return this.modifier;
            }

            public List<CodeableConcept> getProgramCode() {
                return this.programCode;
            }

            public SimpleQuantity getQuantity() {
                return this.quantity;
            }

            public Money getUnitPrice() {
                return this.unitPrice;
            }

            public Decimal getFactor() {
                return this.factor;
            }

            public Money getNet() {
                return this.net;
            }

            public List<Reference> getUdi() {
                return this.udi;
            }

            public List<SubDetail> getSubDetail() {
                return this.subDetail;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.sequence != null || this.revenue != null || this.category != null || this.productOrService != null || !this.modifier.isEmpty() || !this.programCode.isEmpty() || this.quantity != null || this.unitPrice != null || this.factor != null || this.net != null || !this.udi.isEmpty() || !this.subDetail.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.sequence, "sequence", visitor);
                        this.accept(this.revenue, "revenue", visitor);
                        this.accept(this.category, "category", visitor);
                        this.accept(this.productOrService, "productOrService", visitor);
                        this.accept(this.modifier, "modifier", visitor, CodeableConcept.class);
                        this.accept(this.programCode, "programCode", visitor, CodeableConcept.class);
                        this.accept(this.quantity, "quantity", visitor);
                        this.accept(this.unitPrice, "unitPrice", visitor);
                        this.accept(this.factor, "factor", visitor);
                        this.accept(this.net, "net", visitor);
                        this.accept(this.udi, "udi", visitor, Reference.class);
                        this.accept(this.subDetail, "subDetail", visitor, SubDetail.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Detail other = (Detail)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.revenue, other.revenue) && Objects.equals(this.category, other.category) && Objects.equals(this.productOrService, other.productOrService) && Objects.equals(this.modifier, other.modifier) && Objects.equals(this.programCode, other.programCode) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.unitPrice, other.unitPrice) && Objects.equals(this.factor, other.factor) && Objects.equals(this.net, other.net) && Objects.equals(this.udi, other.udi) && Objects.equals(this.subDetail, other.subDetail);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.sequence, this.revenue, this.category, this.productOrService, this.modifier, this.programCode, this.quantity, this.unitPrice, this.factor, this.net, this.udi, this.subDetail);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class SubDetail
            extends BackboneElement {
                @Required
                private final PositiveInt sequence;
                @Binding(bindingName="RevenueCenter", strength=BindingStrength.Value.EXAMPLE, description="Codes for the revenue or cost centers supplying the service and/or products.", valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
                private final CodeableConcept revenue;
                @Binding(bindingName="BenefitCategory", strength=BindingStrength.Value.EXAMPLE, description="Benefit categories such as: oral-basic, major, glasses.", valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
                private final CodeableConcept category;
                @Binding(bindingName="ServiceProduct", strength=BindingStrength.Value.EXAMPLE, description="Allowable service and product codes.", valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
                @Required
                private final CodeableConcept productOrService;
                @Binding(bindingName="Modifiers", strength=BindingStrength.Value.EXAMPLE, description="Item type or modifiers codes, eg for Oral whether the treatment is cosmetic or associated with TMJ, or an appliance was lost or stolen.", valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
                private final List<CodeableConcept> modifier;
                @Binding(bindingName="ProgramCode", strength=BindingStrength.Value.EXAMPLE, description="Program specific reason codes.", valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
                private final List<CodeableConcept> programCode;
                private final SimpleQuantity quantity;
                private final Money unitPrice;
                private final Decimal factor;
                private final Money net;
                @ReferenceTarget(value={"Device"})
                private final List<Reference> udi;

                private SubDetail(Builder builder) {
                    super(builder);
                    this.sequence = builder.sequence;
                    this.revenue = builder.revenue;
                    this.category = builder.category;
                    this.productOrService = builder.productOrService;
                    this.modifier = Collections.unmodifiableList(builder.modifier);
                    this.programCode = Collections.unmodifiableList(builder.programCode);
                    this.quantity = builder.quantity;
                    this.unitPrice = builder.unitPrice;
                    this.factor = builder.factor;
                    this.net = builder.net;
                    this.udi = Collections.unmodifiableList(builder.udi);
                }

                public PositiveInt getSequence() {
                    return this.sequence;
                }

                public CodeableConcept getRevenue() {
                    return this.revenue;
                }

                public CodeableConcept getCategory() {
                    return this.category;
                }

                public CodeableConcept getProductOrService() {
                    return this.productOrService;
                }

                public List<CodeableConcept> getModifier() {
                    return this.modifier;
                }

                public List<CodeableConcept> getProgramCode() {
                    return this.programCode;
                }

                public SimpleQuantity getQuantity() {
                    return this.quantity;
                }

                public Money getUnitPrice() {
                    return this.unitPrice;
                }

                public Decimal getFactor() {
                    return this.factor;
                }

                public Money getNet() {
                    return this.net;
                }

                public List<Reference> getUdi() {
                    return this.udi;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.sequence != null || this.revenue != null || this.category != null || this.productOrService != null || !this.modifier.isEmpty() || !this.programCode.isEmpty() || this.quantity != null || this.unitPrice != null || this.factor != null || this.net != null || !this.udi.isEmpty();
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.sequence, "sequence", visitor);
                            this.accept(this.revenue, "revenue", visitor);
                            this.accept(this.category, "category", visitor);
                            this.accept(this.productOrService, "productOrService", visitor);
                            this.accept(this.modifier, "modifier", visitor, CodeableConcept.class);
                            this.accept(this.programCode, "programCode", visitor, CodeableConcept.class);
                            this.accept(this.quantity, "quantity", visitor);
                            this.accept(this.unitPrice, "unitPrice", visitor);
                            this.accept(this.factor, "factor", visitor);
                            this.accept(this.net, "net", visitor);
                            this.accept(this.udi, "udi", visitor, Reference.class);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    SubDetail other = (SubDetail)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.revenue, other.revenue) && Objects.equals(this.category, other.category) && Objects.equals(this.productOrService, other.productOrService) && Objects.equals(this.modifier, other.modifier) && Objects.equals(this.programCode, other.programCode) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.unitPrice, other.unitPrice) && Objects.equals(this.factor, other.factor) && Objects.equals(this.net, other.net) && Objects.equals(this.udi, other.udi);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.sequence, this.revenue, this.category, this.productOrService, this.modifier, this.programCode, this.quantity, this.unitPrice, this.factor, this.net, this.udi);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private PositiveInt sequence;
                    private CodeableConcept revenue;
                    private CodeableConcept category;
                    private CodeableConcept productOrService;
                    private List<CodeableConcept> modifier = new ArrayList<CodeableConcept>();
                    private List<CodeableConcept> programCode = new ArrayList<CodeableConcept>();
                    private SimpleQuantity quantity;
                    private Money unitPrice;
                    private Decimal factor;
                    private Money net;
                    private List<Reference> udi = new ArrayList<Reference>();

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder sequence(PositiveInt sequence) {
                        this.sequence = sequence;
                        return this;
                    }

                    public Builder revenue(CodeableConcept revenue) {
                        this.revenue = revenue;
                        return this;
                    }

                    public Builder category(CodeableConcept category) {
                        this.category = category;
                        return this;
                    }

                    public Builder productOrService(CodeableConcept productOrService) {
                        this.productOrService = productOrService;
                        return this;
                    }

                    public Builder modifier(CodeableConcept ... modifier) {
                        for (CodeableConcept value : modifier) {
                            this.modifier.add(value);
                        }
                        return this;
                    }

                    public Builder modifier(Collection<CodeableConcept> modifier) {
                        this.modifier = new ArrayList<CodeableConcept>(modifier);
                        return this;
                    }

                    public Builder programCode(CodeableConcept ... programCode) {
                        for (CodeableConcept value : programCode) {
                            this.programCode.add(value);
                        }
                        return this;
                    }

                    public Builder programCode(Collection<CodeableConcept> programCode) {
                        this.programCode = new ArrayList<CodeableConcept>(programCode);
                        return this;
                    }

                    public Builder quantity(SimpleQuantity quantity) {
                        this.quantity = quantity;
                        return this;
                    }

                    public Builder unitPrice(Money unitPrice) {
                        this.unitPrice = unitPrice;
                        return this;
                    }

                    public Builder factor(Decimal factor) {
                        this.factor = factor;
                        return this;
                    }

                    public Builder net(Money net) {
                        this.net = net;
                        return this;
                    }

                    public Builder udi(Reference ... udi) {
                        for (Reference value : udi) {
                            this.udi.add(value);
                        }
                        return this;
                    }

                    public Builder udi(Collection<Reference> udi) {
                        this.udi = new ArrayList<Reference>(udi);
                        return this;
                    }

                    @Override
                    public SubDetail build() {
                        SubDetail subDetail = new SubDetail(this);
                        if (this.validating) {
                            this.validate(subDetail);
                        }
                        return subDetail;
                    }

                    protected void validate(SubDetail subDetail) {
                        super.validate(subDetail);
                        ValidationSupport.requireNonNull(subDetail.sequence, "sequence");
                        ValidationSupport.requireNonNull(subDetail.productOrService, "productOrService");
                        ValidationSupport.checkList(subDetail.modifier, "modifier", CodeableConcept.class);
                        ValidationSupport.checkList(subDetail.programCode, "programCode", CodeableConcept.class);
                        ValidationSupport.checkList(subDetail.udi, "udi", Reference.class);
                        ValidationSupport.checkReferenceType(subDetail.udi, "udi", "Device");
                        ValidationSupport.requireValueOrChildren(subDetail);
                    }

                    protected Builder from(SubDetail subDetail) {
                        super.from(subDetail);
                        this.sequence = subDetail.sequence;
                        this.revenue = subDetail.revenue;
                        this.category = subDetail.category;
                        this.productOrService = subDetail.productOrService;
                        this.modifier.addAll(subDetail.modifier);
                        this.programCode.addAll(subDetail.programCode);
                        this.quantity = subDetail.quantity;
                        this.unitPrice = subDetail.unitPrice;
                        this.factor = subDetail.factor;
                        this.net = subDetail.net;
                        this.udi.addAll(subDetail.udi);
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private PositiveInt sequence;
                private CodeableConcept revenue;
                private CodeableConcept category;
                private CodeableConcept productOrService;
                private List<CodeableConcept> modifier = new ArrayList<CodeableConcept>();
                private List<CodeableConcept> programCode = new ArrayList<CodeableConcept>();
                private SimpleQuantity quantity;
                private Money unitPrice;
                private Decimal factor;
                private Money net;
                private List<Reference> udi = new ArrayList<Reference>();
                private List<SubDetail> subDetail = new ArrayList<SubDetail>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder sequence(PositiveInt sequence) {
                    this.sequence = sequence;
                    return this;
                }

                public Builder revenue(CodeableConcept revenue) {
                    this.revenue = revenue;
                    return this;
                }

                public Builder category(CodeableConcept category) {
                    this.category = category;
                    return this;
                }

                public Builder productOrService(CodeableConcept productOrService) {
                    this.productOrService = productOrService;
                    return this;
                }

                public Builder modifier(CodeableConcept ... modifier) {
                    for (CodeableConcept value : modifier) {
                        this.modifier.add(value);
                    }
                    return this;
                }

                public Builder modifier(Collection<CodeableConcept> modifier) {
                    this.modifier = new ArrayList<CodeableConcept>(modifier);
                    return this;
                }

                public Builder programCode(CodeableConcept ... programCode) {
                    for (CodeableConcept value : programCode) {
                        this.programCode.add(value);
                    }
                    return this;
                }

                public Builder programCode(Collection<CodeableConcept> programCode) {
                    this.programCode = new ArrayList<CodeableConcept>(programCode);
                    return this;
                }

                public Builder quantity(SimpleQuantity quantity) {
                    this.quantity = quantity;
                    return this;
                }

                public Builder unitPrice(Money unitPrice) {
                    this.unitPrice = unitPrice;
                    return this;
                }

                public Builder factor(Decimal factor) {
                    this.factor = factor;
                    return this;
                }

                public Builder net(Money net) {
                    this.net = net;
                    return this;
                }

                public Builder udi(Reference ... udi) {
                    for (Reference value : udi) {
                        this.udi.add(value);
                    }
                    return this;
                }

                public Builder udi(Collection<Reference> udi) {
                    this.udi = new ArrayList<Reference>(udi);
                    return this;
                }

                public Builder subDetail(SubDetail ... subDetail) {
                    for (SubDetail value : subDetail) {
                        this.subDetail.add(value);
                    }
                    return this;
                }

                public Builder subDetail(Collection<SubDetail> subDetail) {
                    this.subDetail = new ArrayList<SubDetail>(subDetail);
                    return this;
                }

                @Override
                public Detail build() {
                    Detail detail = new Detail(this);
                    if (this.validating) {
                        this.validate(detail);
                    }
                    return detail;
                }

                protected void validate(Detail detail) {
                    super.validate(detail);
                    ValidationSupport.requireNonNull(detail.sequence, "sequence");
                    ValidationSupport.requireNonNull(detail.productOrService, "productOrService");
                    ValidationSupport.checkList(detail.modifier, "modifier", CodeableConcept.class);
                    ValidationSupport.checkList(detail.programCode, "programCode", CodeableConcept.class);
                    ValidationSupport.checkList(detail.udi, "udi", Reference.class);
                    ValidationSupport.checkList(detail.subDetail, "subDetail", SubDetail.class);
                    ValidationSupport.checkReferenceType(detail.udi, "udi", "Device");
                    ValidationSupport.requireValueOrChildren(detail);
                }

                protected Builder from(Detail detail) {
                    super.from(detail);
                    this.sequence = detail.sequence;
                    this.revenue = detail.revenue;
                    this.category = detail.category;
                    this.productOrService = detail.productOrService;
                    this.modifier.addAll(detail.modifier);
                    this.programCode.addAll(detail.programCode);
                    this.quantity = detail.quantity;
                    this.unitPrice = detail.unitPrice;
                    this.factor = detail.factor;
                    this.net = detail.net;
                    this.udi.addAll(detail.udi);
                    this.subDetail.addAll(detail.subDetail);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private PositiveInt sequence;
            private List<PositiveInt> careTeamSequence = new ArrayList<PositiveInt>();
            private List<PositiveInt> diagnosisSequence = new ArrayList<PositiveInt>();
            private List<PositiveInt> procedureSequence = new ArrayList<PositiveInt>();
            private List<PositiveInt> informationSequence = new ArrayList<PositiveInt>();
            private CodeableConcept revenue;
            private CodeableConcept category;
            private CodeableConcept productOrService;
            private List<CodeableConcept> modifier = new ArrayList<CodeableConcept>();
            private List<CodeableConcept> programCode = new ArrayList<CodeableConcept>();
            private Element serviced;
            private Element location;
            private SimpleQuantity quantity;
            private Money unitPrice;
            private Decimal factor;
            private Money net;
            private List<Reference> udi = new ArrayList<Reference>();
            private CodeableConcept bodySite;
            private List<CodeableConcept> subSite = new ArrayList<CodeableConcept>();
            private List<Reference> encounter = new ArrayList<Reference>();
            private List<Detail> detail = new ArrayList<Detail>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder sequence(PositiveInt sequence) {
                this.sequence = sequence;
                return this;
            }

            public Builder careTeamSequence(PositiveInt ... careTeamSequence) {
                for (PositiveInt value : careTeamSequence) {
                    this.careTeamSequence.add(value);
                }
                return this;
            }

            public Builder careTeamSequence(Collection<PositiveInt> careTeamSequence) {
                this.careTeamSequence = new ArrayList<PositiveInt>(careTeamSequence);
                return this;
            }

            public Builder diagnosisSequence(PositiveInt ... diagnosisSequence) {
                for (PositiveInt value : diagnosisSequence) {
                    this.diagnosisSequence.add(value);
                }
                return this;
            }

            public Builder diagnosisSequence(Collection<PositiveInt> diagnosisSequence) {
                this.diagnosisSequence = new ArrayList<PositiveInt>(diagnosisSequence);
                return this;
            }

            public Builder procedureSequence(PositiveInt ... procedureSequence) {
                for (PositiveInt value : procedureSequence) {
                    this.procedureSequence.add(value);
                }
                return this;
            }

            public Builder procedureSequence(Collection<PositiveInt> procedureSequence) {
                this.procedureSequence = new ArrayList<PositiveInt>(procedureSequence);
                return this;
            }

            public Builder informationSequence(PositiveInt ... informationSequence) {
                for (PositiveInt value : informationSequence) {
                    this.informationSequence.add(value);
                }
                return this;
            }

            public Builder informationSequence(Collection<PositiveInt> informationSequence) {
                this.informationSequence = new ArrayList<PositiveInt>(informationSequence);
                return this;
            }

            public Builder revenue(CodeableConcept revenue) {
                this.revenue = revenue;
                return this;
            }

            public Builder category(CodeableConcept category) {
                this.category = category;
                return this;
            }

            public Builder productOrService(CodeableConcept productOrService) {
                this.productOrService = productOrService;
                return this;
            }

            public Builder modifier(CodeableConcept ... modifier) {
                for (CodeableConcept value : modifier) {
                    this.modifier.add(value);
                }
                return this;
            }

            public Builder modifier(Collection<CodeableConcept> modifier) {
                this.modifier = new ArrayList<CodeableConcept>(modifier);
                return this;
            }

            public Builder programCode(CodeableConcept ... programCode) {
                for (CodeableConcept value : programCode) {
                    this.programCode.add(value);
                }
                return this;
            }

            public Builder programCode(Collection<CodeableConcept> programCode) {
                this.programCode = new ArrayList<CodeableConcept>(programCode);
                return this;
            }

            public Builder serviced(Element serviced) {
                this.serviced = serviced;
                return this;
            }

            public Builder location(Element location) {
                this.location = location;
                return this;
            }

            public Builder quantity(SimpleQuantity quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder unitPrice(Money unitPrice) {
                this.unitPrice = unitPrice;
                return this;
            }

            public Builder factor(Decimal factor) {
                this.factor = factor;
                return this;
            }

            public Builder net(Money net) {
                this.net = net;
                return this;
            }

            public Builder udi(Reference ... udi) {
                for (Reference value : udi) {
                    this.udi.add(value);
                }
                return this;
            }

            public Builder udi(Collection<Reference> udi) {
                this.udi = new ArrayList<Reference>(udi);
                return this;
            }

            public Builder bodySite(CodeableConcept bodySite) {
                this.bodySite = bodySite;
                return this;
            }

            public Builder subSite(CodeableConcept ... subSite) {
                for (CodeableConcept value : subSite) {
                    this.subSite.add(value);
                }
                return this;
            }

            public Builder subSite(Collection<CodeableConcept> subSite) {
                this.subSite = new ArrayList<CodeableConcept>(subSite);
                return this;
            }

            public Builder encounter(Reference ... encounter) {
                for (Reference value : encounter) {
                    this.encounter.add(value);
                }
                return this;
            }

            public Builder encounter(Collection<Reference> encounter) {
                this.encounter = new ArrayList<Reference>(encounter);
                return this;
            }

            public Builder detail(Detail ... detail) {
                for (Detail value : detail) {
                    this.detail.add(value);
                }
                return this;
            }

            public Builder detail(Collection<Detail> detail) {
                this.detail = new ArrayList<Detail>(detail);
                return this;
            }

            @Override
            public Item build() {
                Item item = new Item(this);
                if (this.validating) {
                    this.validate(item);
                }
                return item;
            }

            protected void validate(Item item) {
                super.validate(item);
                ValidationSupport.requireNonNull(item.sequence, "sequence");
                ValidationSupport.checkList(item.careTeamSequence, "careTeamSequence", PositiveInt.class);
                ValidationSupport.checkList(item.diagnosisSequence, "diagnosisSequence", PositiveInt.class);
                ValidationSupport.checkList(item.procedureSequence, "procedureSequence", PositiveInt.class);
                ValidationSupport.checkList(item.informationSequence, "informationSequence", PositiveInt.class);
                ValidationSupport.requireNonNull(item.productOrService, "productOrService");
                ValidationSupport.checkList(item.modifier, "modifier", CodeableConcept.class);
                ValidationSupport.checkList(item.programCode, "programCode", CodeableConcept.class);
                ValidationSupport.choiceElement(item.serviced, "serviced", Date.class, Period.class);
                ValidationSupport.choiceElement(item.location, "location", CodeableConcept.class, Address.class, Reference.class);
                ValidationSupport.checkList(item.udi, "udi", Reference.class);
                ValidationSupport.checkList(item.subSite, "subSite", CodeableConcept.class);
                ValidationSupport.checkList(item.encounter, "encounter", Reference.class);
                ValidationSupport.checkList(item.detail, "detail", Detail.class);
                ValidationSupport.checkReferenceType(item.location, "location", "Location");
                ValidationSupport.checkReferenceType(item.udi, "udi", "Device");
                ValidationSupport.checkReferenceType(item.encounter, "encounter", "Encounter");
                ValidationSupport.requireValueOrChildren(item);
            }

            protected Builder from(Item item) {
                super.from(item);
                this.sequence = item.sequence;
                this.careTeamSequence.addAll(item.careTeamSequence);
                this.diagnosisSequence.addAll(item.diagnosisSequence);
                this.procedureSequence.addAll(item.procedureSequence);
                this.informationSequence.addAll(item.informationSequence);
                this.revenue = item.revenue;
                this.category = item.category;
                this.productOrService = item.productOrService;
                this.modifier.addAll(item.modifier);
                this.programCode.addAll(item.programCode);
                this.serviced = item.serviced;
                this.location = item.location;
                this.quantity = item.quantity;
                this.unitPrice = item.unitPrice;
                this.factor = item.factor;
                this.net = item.net;
                this.udi.addAll(item.udi);
                this.bodySite = item.bodySite;
                this.subSite.addAll(item.subSite);
                this.encounter.addAll(item.encounter);
                this.detail.addAll(item.detail);
                return this;
            }
        }
    }

    public static class Accident
    extends BackboneElement {
        @Required
        private final Date date;
        @Binding(bindingName="AccidentType", strength=BindingStrength.Value.EXTENSIBLE, description="Type of accident: work place, auto, etc.", valueSet="http://terminology.hl7.org/ValueSet/v3-ActIncidentCode")
        private final CodeableConcept type;
        @ReferenceTarget(value={"Location"})
        @Choice(value={Address.class, Reference.class})
        private final Element location;

        private Accident(Builder builder) {
            super(builder);
            this.date = builder.date;
            this.type = builder.type;
            this.location = builder.location;
        }

        public Date getDate() {
            return this.date;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Element getLocation() {
            return this.location;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.date != null || this.type != null || this.location != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.date, "date", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.location, "location", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Accident other = (Accident)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.date, other.date) && Objects.equals(this.type, other.type) && Objects.equals(this.location, other.location);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.date, this.type, this.location);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Date date;
            private CodeableConcept type;
            private Element location;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder date(Date date) {
                this.date = date;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder location(Element location) {
                this.location = location;
                return this;
            }

            @Override
            public Accident build() {
                Accident accident = new Accident(this);
                if (this.validating) {
                    this.validate(accident);
                }
                return accident;
            }

            protected void validate(Accident accident) {
                super.validate(accident);
                ValidationSupport.requireNonNull(accident.date, "date");
                ValidationSupport.choiceElement(accident.location, "location", Address.class, Reference.class);
                ValidationSupport.checkReferenceType(accident.location, "location", "Location");
                ValidationSupport.requireValueOrChildren(accident);
            }

            protected Builder from(Accident accident) {
                super.from(accident);
                this.date = accident.date;
                this.type = accident.type;
                this.location = accident.location;
                return this;
            }
        }
    }

    public static class Insurance
    extends BackboneElement {
        @Summary
        @Required
        private final PositiveInt sequence;
        @Summary
        @Required
        private final Boolean focal;
        private final Identifier identifier;
        @Summary
        @ReferenceTarget(value={"Coverage"})
        @Required
        private final Reference coverage;
        private final String businessArrangement;
        private final List<String> preAuthRef;
        @ReferenceTarget(value={"ClaimResponse"})
        private final Reference claimResponse;

        private Insurance(Builder builder) {
            super(builder);
            this.sequence = builder.sequence;
            this.focal = builder.focal;
            this.identifier = builder.identifier;
            this.coverage = builder.coverage;
            this.businessArrangement = builder.businessArrangement;
            this.preAuthRef = Collections.unmodifiableList(builder.preAuthRef);
            this.claimResponse = builder.claimResponse;
        }

        public PositiveInt getSequence() {
            return this.sequence;
        }

        public Boolean getFocal() {
            return this.focal;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public Reference getCoverage() {
            return this.coverage;
        }

        public String getBusinessArrangement() {
            return this.businessArrangement;
        }

        public List<String> getPreAuthRef() {
            return this.preAuthRef;
        }

        public Reference getClaimResponse() {
            return this.claimResponse;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.sequence != null || this.focal != null || this.identifier != null || this.coverage != null || this.businessArrangement != null || !this.preAuthRef.isEmpty() || this.claimResponse != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.sequence, "sequence", visitor);
                    this.accept(this.focal, "focal", visitor);
                    this.accept(this.identifier, "identifier", visitor);
                    this.accept(this.coverage, "coverage", visitor);
                    this.accept(this.businessArrangement, "businessArrangement", visitor);
                    this.accept(this.preAuthRef, "preAuthRef", visitor, String.class);
                    this.accept(this.claimResponse, "claimResponse", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Insurance other = (Insurance)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.focal, other.focal) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.coverage, other.coverage) && Objects.equals(this.businessArrangement, other.businessArrangement) && Objects.equals(this.preAuthRef, other.preAuthRef) && Objects.equals(this.claimResponse, other.claimResponse);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.sequence, this.focal, this.identifier, this.coverage, this.businessArrangement, this.preAuthRef, this.claimResponse);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private PositiveInt sequence;
            private Boolean focal;
            private Identifier identifier;
            private Reference coverage;
            private String businessArrangement;
            private List<String> preAuthRef = new ArrayList<String>();
            private Reference claimResponse;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder sequence(PositiveInt sequence) {
                this.sequence = sequence;
                return this;
            }

            public Builder focal(Boolean focal) {
                this.focal = focal;
                return this;
            }

            public Builder identifier(Identifier identifier) {
                this.identifier = identifier;
                return this;
            }

            public Builder coverage(Reference coverage) {
                this.coverage = coverage;
                return this;
            }

            public Builder businessArrangement(String businessArrangement) {
                this.businessArrangement = businessArrangement;
                return this;
            }

            public Builder preAuthRef(String ... preAuthRef) {
                for (String value : preAuthRef) {
                    this.preAuthRef.add(value);
                }
                return this;
            }

            public Builder preAuthRef(Collection<String> preAuthRef) {
                this.preAuthRef = new ArrayList<String>(preAuthRef);
                return this;
            }

            public Builder claimResponse(Reference claimResponse) {
                this.claimResponse = claimResponse;
                return this;
            }

            @Override
            public Insurance build() {
                Insurance insurance = new Insurance(this);
                if (this.validating) {
                    this.validate(insurance);
                }
                return insurance;
            }

            protected void validate(Insurance insurance) {
                super.validate(insurance);
                ValidationSupport.requireNonNull(insurance.sequence, "sequence");
                ValidationSupport.requireNonNull(insurance.focal, "focal");
                ValidationSupport.requireNonNull(insurance.coverage, "coverage");
                ValidationSupport.checkList(insurance.preAuthRef, "preAuthRef", String.class);
                ValidationSupport.checkReferenceType(insurance.coverage, "coverage", "Coverage");
                ValidationSupport.checkReferenceType(insurance.claimResponse, "claimResponse", "ClaimResponse");
                ValidationSupport.requireValueOrChildren(insurance);
            }

            protected Builder from(Insurance insurance) {
                super.from(insurance);
                this.sequence = insurance.sequence;
                this.focal = insurance.focal;
                this.identifier = insurance.identifier;
                this.coverage = insurance.coverage;
                this.businessArrangement = insurance.businessArrangement;
                this.preAuthRef.addAll(insurance.preAuthRef);
                this.claimResponse = insurance.claimResponse;
                return this;
            }
        }
    }

    public static class Procedure
    extends BackboneElement {
        @Required
        private final PositiveInt sequence;
        @Binding(bindingName="ProcedureType", strength=BindingStrength.Value.EXAMPLE, description="Example procedure type codes.", valueSet="http://hl7.org/fhir/ValueSet/ex-procedure-type")
        private final List<CodeableConcept> type;
        private final DateTime date;
        @ReferenceTarget(value={"Procedure"})
        @Choice(value={CodeableConcept.class, Reference.class})
        @Binding(bindingName="ICD10_Procedures", strength=BindingStrength.Value.EXAMPLE, description="Example ICD10 Procedure codes.", valueSet="http://hl7.org/fhir/ValueSet/icd-10-procedures")
        @Required
        private final Element procedure;
        @ReferenceTarget(value={"Device"})
        private final List<Reference> udi;

        private Procedure(Builder builder) {
            super(builder);
            this.sequence = builder.sequence;
            this.type = Collections.unmodifiableList(builder.type);
            this.date = builder.date;
            this.procedure = builder.procedure;
            this.udi = Collections.unmodifiableList(builder.udi);
        }

        public PositiveInt getSequence() {
            return this.sequence;
        }

        public List<CodeableConcept> getType() {
            return this.type;
        }

        public DateTime getDate() {
            return this.date;
        }

        public Element getProcedure() {
            return this.procedure;
        }

        public List<Reference> getUdi() {
            return this.udi;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.sequence != null || !this.type.isEmpty() || this.date != null || this.procedure != null || !this.udi.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.sequence, "sequence", visitor);
                    this.accept(this.type, "type", visitor, CodeableConcept.class);
                    this.accept(this.date, "date", visitor);
                    this.accept(this.procedure, "procedure", visitor);
                    this.accept(this.udi, "udi", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Procedure other = (Procedure)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.type, other.type) && Objects.equals(this.date, other.date) && Objects.equals(this.procedure, other.procedure) && Objects.equals(this.udi, other.udi);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.sequence, this.type, this.date, this.procedure, this.udi);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private PositiveInt sequence;
            private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
            private DateTime date;
            private Element procedure;
            private List<Reference> udi = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder sequence(PositiveInt sequence) {
                this.sequence = sequence;
                return this;
            }

            public Builder type(CodeableConcept ... type) {
                for (CodeableConcept value : type) {
                    this.type.add(value);
                }
                return this;
            }

            public Builder type(Collection<CodeableConcept> type) {
                this.type = new ArrayList<CodeableConcept>(type);
                return this;
            }

            public Builder date(DateTime date) {
                this.date = date;
                return this;
            }

            public Builder procedure(Element procedure) {
                this.procedure = procedure;
                return this;
            }

            public Builder udi(Reference ... udi) {
                for (Reference value : udi) {
                    this.udi.add(value);
                }
                return this;
            }

            public Builder udi(Collection<Reference> udi) {
                this.udi = new ArrayList<Reference>(udi);
                return this;
            }

            @Override
            public Procedure build() {
                Procedure procedure = new Procedure(this);
                if (this.validating) {
                    this.validate(procedure);
                }
                return procedure;
            }

            protected void validate(Procedure procedure) {
                super.validate(procedure);
                ValidationSupport.requireNonNull(procedure.sequence, "sequence");
                ValidationSupport.checkList(procedure.type, "type", CodeableConcept.class);
                ValidationSupport.requireChoiceElement(procedure.procedure, "procedure", CodeableConcept.class, Reference.class);
                ValidationSupport.checkList(procedure.udi, "udi", Reference.class);
                ValidationSupport.checkReferenceType(procedure.procedure, "procedure", "Procedure");
                ValidationSupport.checkReferenceType(procedure.udi, "udi", "Device");
                ValidationSupport.requireValueOrChildren(procedure);
            }

            protected Builder from(Procedure procedure) {
                super.from(procedure);
                this.sequence = procedure.sequence;
                this.type.addAll(procedure.type);
                this.date = procedure.date;
                this.procedure = procedure.procedure;
                this.udi.addAll(procedure.udi);
                return this;
            }
        }
    }

    public static class Diagnosis
    extends BackboneElement {
        @Required
        private final PositiveInt sequence;
        @ReferenceTarget(value={"Condition"})
        @Choice(value={CodeableConcept.class, Reference.class})
        @Binding(bindingName="ICD10", strength=BindingStrength.Value.EXAMPLE, description="Example ICD10 Diagnostic codes.", valueSet="http://hl7.org/fhir/ValueSet/icd-10")
        @Required
        private final Element diagnosis;
        @Binding(bindingName="DiagnosisType", strength=BindingStrength.Value.EXAMPLE, description="The type of the diagnosis: admitting, principal, discharge.", valueSet="http://hl7.org/fhir/ValueSet/ex-diagnosistype")
        private final List<CodeableConcept> type;
        @Binding(bindingName="DiagnosisOnAdmission", strength=BindingStrength.Value.EXAMPLE, description="Present on admission.", valueSet="http://hl7.org/fhir/ValueSet/ex-diagnosis-on-admission")
        private final CodeableConcept onAdmission;
        @Binding(bindingName="DiagnosisRelatedGroup", strength=BindingStrength.Value.EXAMPLE, description="The DRG codes associated with the diagnosis.", valueSet="http://hl7.org/fhir/ValueSet/ex-diagnosisrelatedgroup")
        private final CodeableConcept packageCode;

        private Diagnosis(Builder builder) {
            super(builder);
            this.sequence = builder.sequence;
            this.diagnosis = builder.diagnosis;
            this.type = Collections.unmodifiableList(builder.type);
            this.onAdmission = builder.onAdmission;
            this.packageCode = builder.packageCode;
        }

        public PositiveInt getSequence() {
            return this.sequence;
        }

        public Element getDiagnosis() {
            return this.diagnosis;
        }

        public List<CodeableConcept> getType() {
            return this.type;
        }

        public CodeableConcept getOnAdmission() {
            return this.onAdmission;
        }

        public CodeableConcept getPackageCode() {
            return this.packageCode;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.sequence != null || this.diagnosis != null || !this.type.isEmpty() || this.onAdmission != null || this.packageCode != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.sequence, "sequence", visitor);
                    this.accept(this.diagnosis, "diagnosis", visitor);
                    this.accept(this.type, "type", visitor, CodeableConcept.class);
                    this.accept(this.onAdmission, "onAdmission", visitor);
                    this.accept(this.packageCode, "packageCode", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Diagnosis other = (Diagnosis)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.diagnosis, other.diagnosis) && Objects.equals(this.type, other.type) && Objects.equals(this.onAdmission, other.onAdmission) && Objects.equals(this.packageCode, other.packageCode);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.sequence, this.diagnosis, this.type, this.onAdmission, this.packageCode);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private PositiveInt sequence;
            private Element diagnosis;
            private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
            private CodeableConcept onAdmission;
            private CodeableConcept packageCode;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder sequence(PositiveInt sequence) {
                this.sequence = sequence;
                return this;
            }

            public Builder diagnosis(Element diagnosis) {
                this.diagnosis = diagnosis;
                return this;
            }

            public Builder type(CodeableConcept ... type) {
                for (CodeableConcept value : type) {
                    this.type.add(value);
                }
                return this;
            }

            public Builder type(Collection<CodeableConcept> type) {
                this.type = new ArrayList<CodeableConcept>(type);
                return this;
            }

            public Builder onAdmission(CodeableConcept onAdmission) {
                this.onAdmission = onAdmission;
                return this;
            }

            public Builder packageCode(CodeableConcept packageCode) {
                this.packageCode = packageCode;
                return this;
            }

            @Override
            public Diagnosis build() {
                Diagnosis diagnosis = new Diagnosis(this);
                if (this.validating) {
                    this.validate(diagnosis);
                }
                return diagnosis;
            }

            protected void validate(Diagnosis diagnosis) {
                super.validate(diagnosis);
                ValidationSupport.requireNonNull(diagnosis.sequence, "sequence");
                ValidationSupport.requireChoiceElement(diagnosis.diagnosis, "diagnosis", CodeableConcept.class, Reference.class);
                ValidationSupport.checkList(diagnosis.type, "type", CodeableConcept.class);
                ValidationSupport.checkReferenceType(diagnosis.diagnosis, "diagnosis", "Condition");
                ValidationSupport.requireValueOrChildren(diagnosis);
            }

            protected Builder from(Diagnosis diagnosis) {
                super.from(diagnosis);
                this.sequence = diagnosis.sequence;
                this.diagnosis = diagnosis.diagnosis;
                this.type.addAll(diagnosis.type);
                this.onAdmission = diagnosis.onAdmission;
                this.packageCode = diagnosis.packageCode;
                return this;
            }
        }
    }

    public static class SupportingInfo
    extends BackboneElement {
        @Required
        private final PositiveInt sequence;
        @Binding(bindingName="InformationCategory", strength=BindingStrength.Value.EXAMPLE, description="The valuset used for additional information category codes.", valueSet="http://hl7.org/fhir/ValueSet/claim-informationcategory")
        @Required
        private final CodeableConcept category;
        @Binding(bindingName="InformationCode", strength=BindingStrength.Value.EXAMPLE, description="The valuset used for additional information codes.", valueSet="http://hl7.org/fhir/ValueSet/claim-exception")
        private final CodeableConcept code;
        @Choice(value={Date.class, Period.class})
        private final Element timing;
        @Choice(value={Boolean.class, String.class, Quantity.class, Attachment.class, Reference.class})
        private final Element value;
        @Binding(bindingName="MissingReason", strength=BindingStrength.Value.EXAMPLE, description="Reason codes for the missing teeth.", valueSet="http://hl7.org/fhir/ValueSet/missing-tooth-reason")
        private final CodeableConcept reason;

        private SupportingInfo(Builder builder) {
            super(builder);
            this.sequence = builder.sequence;
            this.category = builder.category;
            this.code = builder.code;
            this.timing = builder.timing;
            this.value = builder.value;
            this.reason = builder.reason;
        }

        public PositiveInt getSequence() {
            return this.sequence;
        }

        public CodeableConcept getCategory() {
            return this.category;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public Element getTiming() {
            return this.timing;
        }

        public Element getValue() {
            return this.value;
        }

        public CodeableConcept getReason() {
            return this.reason;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.sequence != null || this.category != null || this.code != null || this.timing != null || this.value != null || this.reason != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.sequence, "sequence", visitor);
                    this.accept(this.category, "category", visitor);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.timing, "timing", visitor);
                    this.accept(this.value, "value", visitor);
                    this.accept(this.reason, "reason", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SupportingInfo other = (SupportingInfo)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.category, other.category) && Objects.equals(this.code, other.code) && Objects.equals(this.timing, other.timing) && Objects.equals(this.value, other.value) && Objects.equals(this.reason, other.reason);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.sequence, this.category, this.code, this.timing, this.value, this.reason);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private PositiveInt sequence;
            private CodeableConcept category;
            private CodeableConcept code;
            private Element timing;
            private Element value;
            private CodeableConcept reason;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder sequence(PositiveInt sequence) {
                this.sequence = sequence;
                return this;
            }

            public Builder category(CodeableConcept category) {
                this.category = category;
                return this;
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder timing(Element timing) {
                this.timing = timing;
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            public Builder reason(CodeableConcept reason) {
                this.reason = reason;
                return this;
            }

            @Override
            public SupportingInfo build() {
                SupportingInfo supportingInfo = new SupportingInfo(this);
                if (this.validating) {
                    this.validate(supportingInfo);
                }
                return supportingInfo;
            }

            protected void validate(SupportingInfo supportingInfo) {
                super.validate(supportingInfo);
                ValidationSupport.requireNonNull(supportingInfo.sequence, "sequence");
                ValidationSupport.requireNonNull(supportingInfo.category, "category");
                ValidationSupport.choiceElement(supportingInfo.timing, "timing", Date.class, Period.class);
                ValidationSupport.choiceElement(supportingInfo.value, "value", Boolean.class, String.class, Quantity.class, Attachment.class, Reference.class);
                ValidationSupport.requireValueOrChildren(supportingInfo);
            }

            protected Builder from(SupportingInfo supportingInfo) {
                super.from(supportingInfo);
                this.sequence = supportingInfo.sequence;
                this.category = supportingInfo.category;
                this.code = supportingInfo.code;
                this.timing = supportingInfo.timing;
                this.value = supportingInfo.value;
                this.reason = supportingInfo.reason;
                return this;
            }
        }
    }

    public static class CareTeam
    extends BackboneElement {
        @Required
        private final PositiveInt sequence;
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
        @Required
        private final Reference provider;
        private final Boolean responsible;
        @Binding(bindingName="CareTeamRole", strength=BindingStrength.Value.EXAMPLE, description="The role codes for the care team members.", valueSet="http://hl7.org/fhir/ValueSet/claim-careteamrole")
        private final CodeableConcept role;
        @Binding(bindingName="ProviderQualification", strength=BindingStrength.Value.EXAMPLE, description="Provider professional qualifications.", valueSet="http://hl7.org/fhir/ValueSet/provider-qualification")
        private final CodeableConcept qualification;

        private CareTeam(Builder builder) {
            super(builder);
            this.sequence = builder.sequence;
            this.provider = builder.provider;
            this.responsible = builder.responsible;
            this.role = builder.role;
            this.qualification = builder.qualification;
        }

        public PositiveInt getSequence() {
            return this.sequence;
        }

        public Reference getProvider() {
            return this.provider;
        }

        public Boolean getResponsible() {
            return this.responsible;
        }

        public CodeableConcept getRole() {
            return this.role;
        }

        public CodeableConcept getQualification() {
            return this.qualification;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.sequence != null || this.provider != null || this.responsible != null || this.role != null || this.qualification != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.sequence, "sequence", visitor);
                    this.accept(this.provider, "provider", visitor);
                    this.accept(this.responsible, "responsible", visitor);
                    this.accept(this.role, "role", visitor);
                    this.accept(this.qualification, "qualification", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CareTeam other = (CareTeam)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sequence, other.sequence) && Objects.equals(this.provider, other.provider) && Objects.equals(this.responsible, other.responsible) && Objects.equals(this.role, other.role) && Objects.equals(this.qualification, other.qualification);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.sequence, this.provider, this.responsible, this.role, this.qualification);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private PositiveInt sequence;
            private Reference provider;
            private Boolean responsible;
            private CodeableConcept role;
            private CodeableConcept qualification;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder sequence(PositiveInt sequence) {
                this.sequence = sequence;
                return this;
            }

            public Builder provider(Reference provider) {
                this.provider = provider;
                return this;
            }

            public Builder responsible(Boolean responsible) {
                this.responsible = responsible;
                return this;
            }

            public Builder role(CodeableConcept role) {
                this.role = role;
                return this;
            }

            public Builder qualification(CodeableConcept qualification) {
                this.qualification = qualification;
                return this;
            }

            @Override
            public CareTeam build() {
                CareTeam careTeam = new CareTeam(this);
                if (this.validating) {
                    this.validate(careTeam);
                }
                return careTeam;
            }

            protected void validate(CareTeam careTeam) {
                super.validate(careTeam);
                ValidationSupport.requireNonNull(careTeam.sequence, "sequence");
                ValidationSupport.requireNonNull(careTeam.provider, "provider");
                ValidationSupport.checkReferenceType(careTeam.provider, "provider", "Practitioner", "PractitionerRole", "Organization");
                ValidationSupport.requireValueOrChildren(careTeam);
            }

            protected Builder from(CareTeam careTeam) {
                super.from(careTeam);
                this.sequence = careTeam.sequence;
                this.provider = careTeam.provider;
                this.responsible = careTeam.responsible;
                this.role = careTeam.role;
                this.qualification = careTeam.qualification;
                return this;
            }
        }
    }

    public static class Payee
    extends BackboneElement {
        @Binding(bindingName="PayeeType", strength=BindingStrength.Value.EXAMPLE, description="A code for the party to be reimbursed.", valueSet="http://hl7.org/fhir/ValueSet/payeetype")
        @Required
        private final CodeableConcept type;
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "Patient", "RelatedPerson"})
        private final Reference party;

        private Payee(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.party = builder.party;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Reference getParty() {
            return this.party;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.party != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.party, "party", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Payee other = (Payee)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.party, other.party);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.party);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Reference party;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder party(Reference party) {
                this.party = party;
                return this;
            }

            @Override
            public Payee build() {
                Payee payee = new Payee(this);
                if (this.validating) {
                    this.validate(payee);
                }
                return payee;
            }

            protected void validate(Payee payee) {
                super.validate(payee);
                ValidationSupport.requireNonNull(payee.type, "type");
                ValidationSupport.checkReferenceType(payee.party, "party", "Practitioner", "PractitionerRole", "Organization", "Patient", "RelatedPerson");
                ValidationSupport.requireValueOrChildren(payee);
            }

            protected Builder from(Payee payee) {
                super.from(payee);
                this.type = payee.type;
                this.party = payee.party;
                return this;
            }
        }
    }

    public static class Related
    extends BackboneElement {
        @ReferenceTarget(value={"Claim"})
        private final Reference claim;
        @Binding(bindingName="RelatedClaimRelationship", strength=BindingStrength.Value.EXAMPLE, description="Relationship of this claim to a related Claim.", valueSet="http://hl7.org/fhir/ValueSet/related-claim-relationship")
        private final CodeableConcept relationship;
        private final Identifier reference;

        private Related(Builder builder) {
            super(builder);
            this.claim = builder.claim;
            this.relationship = builder.relationship;
            this.reference = builder.reference;
        }

        public Reference getClaim() {
            return this.claim;
        }

        public CodeableConcept getRelationship() {
            return this.relationship;
        }

        public Identifier getReference() {
            return this.reference;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.claim != null || this.relationship != null || this.reference != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.claim, "claim", visitor);
                    this.accept(this.relationship, "relationship", visitor);
                    this.accept(this.reference, "reference", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Related other = (Related)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.claim, other.claim) && Objects.equals(this.relationship, other.relationship) && Objects.equals(this.reference, other.reference);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.claim, this.relationship, this.reference);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference claim;
            private CodeableConcept relationship;
            private Identifier reference;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder claim(Reference claim) {
                this.claim = claim;
                return this;
            }

            public Builder relationship(CodeableConcept relationship) {
                this.relationship = relationship;
                return this;
            }

            public Builder reference(Identifier reference) {
                this.reference = reference;
                return this;
            }

            @Override
            public Related build() {
                Related related = new Related(this);
                if (this.validating) {
                    this.validate(related);
                }
                return related;
            }

            protected void validate(Related related) {
                super.validate(related);
                ValidationSupport.checkReferenceType(related.claim, "claim", "Claim");
                ValidationSupport.requireValueOrChildren(related);
            }

            protected Builder from(Related related) {
                super.from(related);
                this.claim = related.claim;
                this.relationship = related.relationship;
                this.reference = related.reference;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private ClaimStatus status;
        private CodeableConcept type;
        private CodeableConcept subType;
        private Use use;
        private Reference patient;
        private Period billablePeriod;
        private DateTime created;
        private Reference enterer;
        private Reference insurer;
        private Reference provider;
        private CodeableConcept priority;
        private CodeableConcept fundsReserve;
        private List<Related> related = new ArrayList<Related>();
        private Reference prescription;
        private Reference originalPrescription;
        private Payee payee;
        private Reference referral;
        private Reference facility;
        private List<CareTeam> careTeam = new ArrayList<CareTeam>();
        private List<SupportingInfo> supportingInfo = new ArrayList<SupportingInfo>();
        private List<Diagnosis> diagnosis = new ArrayList<Diagnosis>();
        private List<Procedure> procedure = new ArrayList<Procedure>();
        private List<Insurance> insurance = new ArrayList<Insurance>();
        private Accident accident;
        private List<Item> item = new ArrayList<Item>();
        private Money total;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(ClaimStatus status) {
            this.status = status;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder subType(CodeableConcept subType) {
            this.subType = subType;
            return this;
        }

        public Builder use(Use use) {
            this.use = use;
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder billablePeriod(Period billablePeriod) {
            this.billablePeriod = billablePeriod;
            return this;
        }

        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder enterer(Reference enterer) {
            this.enterer = enterer;
            return this;
        }

        public Builder insurer(Reference insurer) {
            this.insurer = insurer;
            return this;
        }

        public Builder provider(Reference provider) {
            this.provider = provider;
            return this;
        }

        public Builder priority(CodeableConcept priority) {
            this.priority = priority;
            return this;
        }

        public Builder fundsReserve(CodeableConcept fundsReserve) {
            this.fundsReserve = fundsReserve;
            return this;
        }

        public Builder related(Related ... related) {
            for (Related value : related) {
                this.related.add(value);
            }
            return this;
        }

        public Builder related(Collection<Related> related) {
            this.related = new ArrayList<Related>(related);
            return this;
        }

        public Builder prescription(Reference prescription) {
            this.prescription = prescription;
            return this;
        }

        public Builder originalPrescription(Reference originalPrescription) {
            this.originalPrescription = originalPrescription;
            return this;
        }

        public Builder payee(Payee payee) {
            this.payee = payee;
            return this;
        }

        public Builder referral(Reference referral) {
            this.referral = referral;
            return this;
        }

        public Builder facility(Reference facility) {
            this.facility = facility;
            return this;
        }

        public Builder careTeam(CareTeam ... careTeam) {
            for (CareTeam value : careTeam) {
                this.careTeam.add(value);
            }
            return this;
        }

        public Builder careTeam(Collection<CareTeam> careTeam) {
            this.careTeam = new ArrayList<CareTeam>(careTeam);
            return this;
        }

        public Builder supportingInfo(SupportingInfo ... supportingInfo) {
            for (SupportingInfo value : supportingInfo) {
                this.supportingInfo.add(value);
            }
            return this;
        }

        public Builder supportingInfo(Collection<SupportingInfo> supportingInfo) {
            this.supportingInfo = new ArrayList<SupportingInfo>(supportingInfo);
            return this;
        }

        public Builder diagnosis(Diagnosis ... diagnosis) {
            for (Diagnosis value : diagnosis) {
                this.diagnosis.add(value);
            }
            return this;
        }

        public Builder diagnosis(Collection<Diagnosis> diagnosis) {
            this.diagnosis = new ArrayList<Diagnosis>(diagnosis);
            return this;
        }

        public Builder procedure(Procedure ... procedure) {
            for (Procedure value : procedure) {
                this.procedure.add(value);
            }
            return this;
        }

        public Builder procedure(Collection<Procedure> procedure) {
            this.procedure = new ArrayList<Procedure>(procedure);
            return this;
        }

        public Builder insurance(Insurance ... insurance) {
            for (Insurance value : insurance) {
                this.insurance.add(value);
            }
            return this;
        }

        public Builder insurance(Collection<Insurance> insurance) {
            this.insurance = new ArrayList<Insurance>(insurance);
            return this;
        }

        public Builder accident(Accident accident) {
            this.accident = accident;
            return this;
        }

        public Builder item(Item ... item) {
            for (Item value : item) {
                this.item.add(value);
            }
            return this;
        }

        public Builder item(Collection<Item> item) {
            this.item = new ArrayList<Item>(item);
            return this;
        }

        public Builder total(Money total) {
            this.total = total;
            return this;
        }

        @Override
        public Claim build() {
            Claim claim = new Claim(this);
            if (this.validating) {
                this.validate(claim);
            }
            return claim;
        }

        protected void validate(Claim claim) {
            super.validate(claim);
            ValidationSupport.checkList(claim.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(claim.status, "status");
            ValidationSupport.requireNonNull(claim.type, "type");
            ValidationSupport.requireNonNull(claim.use, "use");
            ValidationSupport.requireNonNull(claim.patient, "patient");
            ValidationSupport.requireNonNull(claim.created, "created");
            ValidationSupport.requireNonNull(claim.provider, "provider");
            ValidationSupport.requireNonNull(claim.priority, "priority");
            ValidationSupport.checkList(claim.related, "related", Related.class);
            ValidationSupport.checkList(claim.careTeam, "careTeam", CareTeam.class);
            ValidationSupport.checkList(claim.supportingInfo, "supportingInfo", SupportingInfo.class);
            ValidationSupport.checkList(claim.diagnosis, "diagnosis", Diagnosis.class);
            ValidationSupport.checkList(claim.procedure, "procedure", Procedure.class);
            ValidationSupport.checkNonEmptyList(claim.insurance, "insurance", Insurance.class);
            ValidationSupport.checkList(claim.item, "item", Item.class);
            ValidationSupport.checkReferenceType(claim.patient, "patient", "Patient");
            ValidationSupport.checkReferenceType(claim.enterer, "enterer", "Practitioner", "PractitionerRole");
            ValidationSupport.checkReferenceType(claim.insurer, "insurer", "Organization");
            ValidationSupport.checkReferenceType(claim.provider, "provider", "Practitioner", "PractitionerRole", "Organization");
            ValidationSupport.checkReferenceType(claim.prescription, "prescription", "DeviceRequest", "MedicationRequest", "VisionPrescription");
            ValidationSupport.checkReferenceType(claim.originalPrescription, "originalPrescription", "DeviceRequest", "MedicationRequest", "VisionPrescription");
            ValidationSupport.checkReferenceType(claim.referral, "referral", "ServiceRequest");
            ValidationSupport.checkReferenceType(claim.facility, "facility", "Location");
        }

        protected Builder from(Claim claim) {
            super.from(claim);
            this.identifier.addAll(claim.identifier);
            this.status = claim.status;
            this.type = claim.type;
            this.subType = claim.subType;
            this.use = claim.use;
            this.patient = claim.patient;
            this.billablePeriod = claim.billablePeriod;
            this.created = claim.created;
            this.enterer = claim.enterer;
            this.insurer = claim.insurer;
            this.provider = claim.provider;
            this.priority = claim.priority;
            this.fundsReserve = claim.fundsReserve;
            this.related.addAll(claim.related);
            this.prescription = claim.prescription;
            this.originalPrescription = claim.originalPrescription;
            this.payee = claim.payee;
            this.referral = claim.referral;
            this.facility = claim.facility;
            this.careTeam.addAll(claim.careTeam);
            this.supportingInfo.addAll(claim.supportingInfo);
            this.diagnosis.addAll(claim.diagnosis);
            this.procedure.addAll(claim.procedure);
            this.insurance.addAll(claim.insurance);
            this.accident = claim.accident;
            this.item.addAll(claim.item);
            this.total = claim.total;
            return this;
        }
    }
}

