/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.CompositionAttestationMode;
import com.ibm.fhir.model.type.code.CompositionStatus;
import com.ibm.fhir.model.type.code.DocumentConfidentiality;
import com.ibm.fhir.model.type.code.DocumentRelationshipType;
import com.ibm.fhir.model.type.code.SectionMode;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="cmp-1", level="Rule", location="Composition.section", description="A section must contain at least one of text, entries, or sub-sections", expression="text.exists() or entry.exists() or section.exists()", source="http://hl7.org/fhir/StructureDefinition/Composition"), @Constraint(id="cmp-2", level="Rule", location="Composition.section", description="A section can only have an emptyReason if it is empty", expression="emptyReason.empty() or entry.empty()", source="http://hl7.org/fhir/StructureDefinition/Composition"), @Constraint(id="composition-3", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/doc-typecodes", expression="type.exists() and type.memberOf('http://hl7.org/fhir/ValueSet/doc-typecodes', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/Composition", generated=true), @Constraint(id="composition-4", level="Warning", location="section.orderedBy", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/list-order", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/list-order', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/Composition", generated=true), @Constraint(id="composition-5", level="Warning", location="section.emptyReason", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/list-empty-reason", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/list-empty-reason', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/Composition", generated=true)})
public class Composition
extends DomainResource {
    @Summary
    private final Identifier identifier;
    @Summary
    @Binding(bindingName="CompositionStatus", strength=BindingStrength.Value.REQUIRED, description="The workflow/clinical status of the composition.", valueSet="http://hl7.org/fhir/ValueSet/composition-status|4.0.1")
    @Required
    private final CompositionStatus status;
    @Summary
    @Binding(bindingName="DocumentType", strength=BindingStrength.Value.PREFERRED, description="Type of a composition.", valueSet="http://hl7.org/fhir/ValueSet/doc-typecodes")
    @Required
    private final CodeableConcept type;
    @Summary
    @Binding(bindingName="DocumentCategory", strength=BindingStrength.Value.EXAMPLE, description="High-level kind of a clinical document at a macro level.", valueSet="http://hl7.org/fhir/ValueSet/document-classcodes")
    private final List<CodeableConcept> category;
    @Summary
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    @Required
    private final DateTime date;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Device", "Patient", "RelatedPerson", "Organization"})
    @Required
    private final List<Reference> author;
    @Summary
    @Required
    private final String title;
    @Summary
    @Binding(bindingName="DocumentConfidentiality", strength=BindingStrength.Value.REQUIRED, description="Codes specifying the level of confidentiality of the composition.", valueSet="http://terminology.hl7.org/ValueSet/v3-ConfidentialityClassification|2014-03-26")
    private final DocumentConfidentiality confidentiality;
    private final List<Attester> attester;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference custodian;
    private final List<RelatesTo> relatesTo;
    @Summary
    private final List<Event> event;
    private final List<Section> section;

    private Composition(Builder builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.status = builder.status;
        this.type = builder.type;
        this.category = Collections.unmodifiableList(builder.category);
        this.subject = builder.subject;
        this.encounter = builder.encounter;
        this.date = builder.date;
        this.author = Collections.unmodifiableList(builder.author);
        this.title = builder.title;
        this.confidentiality = builder.confidentiality;
        this.attester = Collections.unmodifiableList(builder.attester);
        this.custodian = builder.custodian;
        this.relatesTo = Collections.unmodifiableList(builder.relatesTo);
        this.event = Collections.unmodifiableList(builder.event);
        this.section = Collections.unmodifiableList(builder.section);
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public CompositionStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public DateTime getDate() {
        return this.date;
    }

    public List<Reference> getAuthor() {
        return this.author;
    }

    public String getTitle() {
        return this.title;
    }

    public DocumentConfidentiality getConfidentiality() {
        return this.confidentiality;
    }

    public List<Attester> getAttester() {
        return this.attester;
    }

    public Reference getCustodian() {
        return this.custodian;
    }

    public List<RelatesTo> getRelatesTo() {
        return this.relatesTo;
    }

    public List<Event> getEvent() {
        return this.event;
    }

    public List<Section> getSection() {
        return this.section;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.identifier != null || this.status != null || this.type != null || !this.category.isEmpty() || this.subject != null || this.encounter != null || this.date != null || !this.author.isEmpty() || this.title != null || this.confidentiality != null || !this.attester.isEmpty() || this.custodian != null || !this.relatesTo.isEmpty() || !this.event.isEmpty() || !this.section.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.author, "author", visitor, Reference.class);
                this.accept(this.title, "title", visitor);
                this.accept(this.confidentiality, "confidentiality", visitor);
                this.accept(this.attester, "attester", visitor, Attester.class);
                this.accept(this.custodian, "custodian", visitor);
                this.accept(this.relatesTo, "relatesTo", visitor, RelatesTo.class);
                this.accept(this.event, "event", visitor, Event.class);
                this.accept(this.section, "section", visitor, Section.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Composition other = (Composition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.type, other.type) && Objects.equals(this.category, other.category) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.date, other.date) && Objects.equals(this.author, other.author) && Objects.equals(this.title, other.title) && Objects.equals(this.confidentiality, other.confidentiality) && Objects.equals(this.attester, other.attester) && Objects.equals(this.custodian, other.custodian) && Objects.equals(this.relatesTo, other.relatesTo) && Objects.equals(this.event, other.event) && Objects.equals(this.section, other.section);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.type, this.category, this.subject, this.encounter, this.date, this.author, this.title, this.confidentiality, this.attester, this.custodian, this.relatesTo, this.event, this.section);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Section
    extends BackboneElement {
        private final String title;
        @Binding(bindingName="CompositionSectionType", strength=BindingStrength.Value.EXAMPLE, description="Classification of a section of a composition/document.", valueSet="http://hl7.org/fhir/ValueSet/doc-section-codes")
        private final CodeableConcept code;
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Device", "Patient", "RelatedPerson", "Organization"})
        private final List<Reference> author;
        private final Reference focus;
        private final Narrative text;
        @Binding(bindingName="SectionMode", strength=BindingStrength.Value.REQUIRED, description="The processing mode that applies to this section.", valueSet="http://hl7.org/fhir/ValueSet/list-mode|4.0.1")
        private final SectionMode mode;
        @Binding(bindingName="SectionEntryOrder", strength=BindingStrength.Value.PREFERRED, description="What order applies to the items in the entry.", valueSet="http://hl7.org/fhir/ValueSet/list-order")
        private final CodeableConcept orderedBy;
        private final List<Reference> entry;
        @Binding(bindingName="SectionEmptyReason", strength=BindingStrength.Value.PREFERRED, description="If a section is empty, why it is empty.", valueSet="http://hl7.org/fhir/ValueSet/list-empty-reason")
        private final CodeableConcept emptyReason;
        private final List<Section> section;

        private Section(Builder builder) {
            super(builder);
            this.title = builder.title;
            this.code = builder.code;
            this.author = Collections.unmodifiableList(builder.author);
            this.focus = builder.focus;
            this.text = builder.text;
            this.mode = builder.mode;
            this.orderedBy = builder.orderedBy;
            this.entry = Collections.unmodifiableList(builder.entry);
            this.emptyReason = builder.emptyReason;
            this.section = Collections.unmodifiableList(builder.section);
        }

        public String getTitle() {
            return this.title;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public List<Reference> getAuthor() {
            return this.author;
        }

        public Reference getFocus() {
            return this.focus;
        }

        public Narrative getText() {
            return this.text;
        }

        public SectionMode getMode() {
            return this.mode;
        }

        public CodeableConcept getOrderedBy() {
            return this.orderedBy;
        }

        public List<Reference> getEntry() {
            return this.entry;
        }

        public CodeableConcept getEmptyReason() {
            return this.emptyReason;
        }

        public List<Section> getSection() {
            return this.section;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.title != null || this.code != null || !this.author.isEmpty() || this.focus != null || this.text != null || this.mode != null || this.orderedBy != null || !this.entry.isEmpty() || this.emptyReason != null || !this.section.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.title, "title", visitor);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.author, "author", visitor, Reference.class);
                    this.accept(this.focus, "focus", visitor);
                    this.accept(this.text, "text", visitor);
                    this.accept(this.mode, "mode", visitor);
                    this.accept(this.orderedBy, "orderedBy", visitor);
                    this.accept(this.entry, "entry", visitor, Reference.class);
                    this.accept(this.emptyReason, "emptyReason", visitor);
                    this.accept(this.section, "section", visitor, Section.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Section other = (Section)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.title, other.title) && Objects.equals(this.code, other.code) && Objects.equals(this.author, other.author) && Objects.equals(this.focus, other.focus) && Objects.equals(this.text, other.text) && Objects.equals(this.mode, other.mode) && Objects.equals(this.orderedBy, other.orderedBy) && Objects.equals(this.entry, other.entry) && Objects.equals(this.emptyReason, other.emptyReason) && Objects.equals(this.section, other.section);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.title, this.code, this.author, this.focus, this.text, this.mode, this.orderedBy, this.entry, this.emptyReason, this.section);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String title;
            private CodeableConcept code;
            private List<Reference> author = new ArrayList<Reference>();
            private Reference focus;
            private Narrative text;
            private SectionMode mode;
            private CodeableConcept orderedBy;
            private List<Reference> entry = new ArrayList<Reference>();
            private CodeableConcept emptyReason;
            private List<Section> section = new ArrayList<Section>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder author(Reference ... author) {
                for (Reference value : author) {
                    this.author.add(value);
                }
                return this;
            }

            public Builder author(Collection<Reference> author) {
                this.author = new ArrayList<Reference>(author);
                return this;
            }

            public Builder focus(Reference focus) {
                this.focus = focus;
                return this;
            }

            public Builder text(Narrative text) {
                this.text = text;
                return this;
            }

            public Builder mode(SectionMode mode) {
                this.mode = mode;
                return this;
            }

            public Builder orderedBy(CodeableConcept orderedBy) {
                this.orderedBy = orderedBy;
                return this;
            }

            public Builder entry(Reference ... entry) {
                for (Reference value : entry) {
                    this.entry.add(value);
                }
                return this;
            }

            public Builder entry(Collection<Reference> entry) {
                this.entry = new ArrayList<Reference>(entry);
                return this;
            }

            public Builder emptyReason(CodeableConcept emptyReason) {
                this.emptyReason = emptyReason;
                return this;
            }

            public Builder section(Section ... section) {
                for (Section value : section) {
                    this.section.add(value);
                }
                return this;
            }

            public Builder section(Collection<Section> section) {
                this.section = new ArrayList<Section>(section);
                return this;
            }

            @Override
            public Section build() {
                Section section = new Section(this);
                if (this.validating) {
                    this.validate(section);
                }
                return section;
            }

            protected void validate(Section section) {
                super.validate(section);
                ValidationSupport.checkList(section.author, "author", Reference.class);
                ValidationSupport.checkList(section.entry, "entry", Reference.class);
                ValidationSupport.checkList(section.section, "section", Section.class);
                ValidationSupport.checkReferenceType(section.author, "author", "Practitioner", "PractitionerRole", "Device", "Patient", "RelatedPerson", "Organization");
                ValidationSupport.requireValueOrChildren(section);
            }

            protected Builder from(Section section) {
                super.from(section);
                this.title = section.title;
                this.code = section.code;
                this.author.addAll(section.author);
                this.focus = section.focus;
                this.text = section.text;
                this.mode = section.mode;
                this.orderedBy = section.orderedBy;
                this.entry.addAll(section.entry);
                this.emptyReason = section.emptyReason;
                this.section.addAll(section.section);
                return this;
            }
        }
    }

    public static class Event
    extends BackboneElement {
        @Summary
        @Binding(bindingName="DocumentEventType", strength=BindingStrength.Value.EXAMPLE, description="This list of codes represents the main clinical acts being documented.", valueSet="http://terminology.hl7.org/ValueSet/v3-ActCode")
        private final List<CodeableConcept> code;
        @Summary
        private final Period period;
        @Summary
        private final List<Reference> detail;

        private Event(Builder builder) {
            super(builder);
            this.code = Collections.unmodifiableList(builder.code);
            this.period = builder.period;
            this.detail = Collections.unmodifiableList(builder.detail);
        }

        public List<CodeableConcept> getCode() {
            return this.code;
        }

        public Period getPeriod() {
            return this.period;
        }

        public List<Reference> getDetail() {
            return this.detail;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.code.isEmpty() || this.period != null || !this.detail.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor, CodeableConcept.class);
                    this.accept(this.period, "period", visitor);
                    this.accept(this.detail, "detail", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Event other = (Event)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.period, other.period) && Objects.equals(this.detail, other.detail);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.period, this.detail);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<CodeableConcept> code = new ArrayList<CodeableConcept>();
            private Period period;
            private List<Reference> detail = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept ... code) {
                for (CodeableConcept value : code) {
                    this.code.add(value);
                }
                return this;
            }

            public Builder code(Collection<CodeableConcept> code) {
                this.code = new ArrayList<CodeableConcept>(code);
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            public Builder detail(Reference ... detail) {
                for (Reference value : detail) {
                    this.detail.add(value);
                }
                return this;
            }

            public Builder detail(Collection<Reference> detail) {
                this.detail = new ArrayList<Reference>(detail);
                return this;
            }

            @Override
            public Event build() {
                Event event = new Event(this);
                if (this.validating) {
                    this.validate(event);
                }
                return event;
            }

            protected void validate(Event event) {
                super.validate(event);
                ValidationSupport.checkList(event.code, "code", CodeableConcept.class);
                ValidationSupport.checkList(event.detail, "detail", Reference.class);
                ValidationSupport.requireValueOrChildren(event);
            }

            protected Builder from(Event event) {
                super.from(event);
                this.code.addAll(event.code);
                this.period = event.period;
                this.detail.addAll(event.detail);
                return this;
            }
        }
    }

    public static class RelatesTo
    extends BackboneElement {
        @Binding(bindingName="DocumentRelationshipType", strength=BindingStrength.Value.REQUIRED, description="The type of relationship between documents.", valueSet="http://hl7.org/fhir/ValueSet/document-relationship-type|4.0.1")
        @Required
        private final DocumentRelationshipType code;
        @ReferenceTarget(value={"Composition"})
        @Choice(value={Identifier.class, Reference.class})
        @Required
        private final Element target;

        private RelatesTo(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.target = builder.target;
        }

        public DocumentRelationshipType getCode() {
            return this.code;
        }

        public Element getTarget() {
            return this.target;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.target != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.target, "target", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RelatesTo other = (RelatesTo)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.target, other.target);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.target);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private DocumentRelationshipType code;
            private Element target;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(DocumentRelationshipType code) {
                this.code = code;
                return this;
            }

            public Builder target(Element target) {
                this.target = target;
                return this;
            }

            @Override
            public RelatesTo build() {
                RelatesTo relatesTo = new RelatesTo(this);
                if (this.validating) {
                    this.validate(relatesTo);
                }
                return relatesTo;
            }

            protected void validate(RelatesTo relatesTo) {
                super.validate(relatesTo);
                ValidationSupport.requireNonNull(relatesTo.code, "code");
                ValidationSupport.requireChoiceElement(relatesTo.target, "target", Identifier.class, Reference.class);
                ValidationSupport.checkReferenceType(relatesTo.target, "target", "Composition");
                ValidationSupport.requireValueOrChildren(relatesTo);
            }

            protected Builder from(RelatesTo relatesTo) {
                super.from(relatesTo);
                this.code = relatesTo.code;
                this.target = relatesTo.target;
                return this;
            }
        }
    }

    public static class Attester
    extends BackboneElement {
        @Binding(bindingName="CompositionAttestationMode", strength=BindingStrength.Value.REQUIRED, description="The way in which a person authenticated a composition.", valueSet="http://hl7.org/fhir/ValueSet/composition-attestation-mode|4.0.1")
        @Required
        private final CompositionAttestationMode mode;
        private final DateTime time;
        @ReferenceTarget(value={"Patient", "RelatedPerson", "Practitioner", "PractitionerRole", "Organization"})
        private final Reference party;

        private Attester(Builder builder) {
            super(builder);
            this.mode = builder.mode;
            this.time = builder.time;
            this.party = builder.party;
        }

        public CompositionAttestationMode getMode() {
            return this.mode;
        }

        public DateTime getTime() {
            return this.time;
        }

        public Reference getParty() {
            return this.party;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.mode != null || this.time != null || this.party != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.mode, "mode", visitor);
                    this.accept(this.time, "time", visitor);
                    this.accept(this.party, "party", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Attester other = (Attester)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.mode, other.mode) && Objects.equals(this.time, other.time) && Objects.equals(this.party, other.party);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.mode, this.time, this.party);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CompositionAttestationMode mode;
            private DateTime time;
            private Reference party;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder mode(CompositionAttestationMode mode) {
                this.mode = mode;
                return this;
            }

            public Builder time(DateTime time) {
                this.time = time;
                return this;
            }

            public Builder party(Reference party) {
                this.party = party;
                return this;
            }

            @Override
            public Attester build() {
                Attester attester = new Attester(this);
                if (this.validating) {
                    this.validate(attester);
                }
                return attester;
            }

            protected void validate(Attester attester) {
                super.validate(attester);
                ValidationSupport.requireNonNull(attester.mode, "mode");
                ValidationSupport.checkReferenceType(attester.party, "party", "Patient", "RelatedPerson", "Practitioner", "PractitionerRole", "Organization");
                ValidationSupport.requireValueOrChildren(attester);
            }

            protected Builder from(Attester attester) {
                super.from(attester);
                this.mode = attester.mode;
                this.time = attester.time;
                this.party = attester.party;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Identifier identifier;
        private CompositionStatus status;
        private CodeableConcept type;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private Reference subject;
        private Reference encounter;
        private DateTime date;
        private List<Reference> author = new ArrayList<Reference>();
        private String title;
        private DocumentConfidentiality confidentiality;
        private List<Attester> attester = new ArrayList<Attester>();
        private Reference custodian;
        private List<RelatesTo> relatesTo = new ArrayList<RelatesTo>();
        private List<Event> event = new ArrayList<Event>();
        private List<Section> section = new ArrayList<Section>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder status(CompositionStatus status) {
            this.status = status;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder author(Reference ... author) {
            for (Reference value : author) {
                this.author.add(value);
            }
            return this;
        }

        public Builder author(Collection<Reference> author) {
            this.author = new ArrayList<Reference>(author);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder confidentiality(DocumentConfidentiality confidentiality) {
            this.confidentiality = confidentiality;
            return this;
        }

        public Builder attester(Attester ... attester) {
            for (Attester value : attester) {
                this.attester.add(value);
            }
            return this;
        }

        public Builder attester(Collection<Attester> attester) {
            this.attester = new ArrayList<Attester>(attester);
            return this;
        }

        public Builder custodian(Reference custodian) {
            this.custodian = custodian;
            return this;
        }

        public Builder relatesTo(RelatesTo ... relatesTo) {
            for (RelatesTo value : relatesTo) {
                this.relatesTo.add(value);
            }
            return this;
        }

        public Builder relatesTo(Collection<RelatesTo> relatesTo) {
            this.relatesTo = new ArrayList<RelatesTo>(relatesTo);
            return this;
        }

        public Builder event(Event ... event) {
            for (Event value : event) {
                this.event.add(value);
            }
            return this;
        }

        public Builder event(Collection<Event> event) {
            this.event = new ArrayList<Event>(event);
            return this;
        }

        public Builder section(Section ... section) {
            for (Section value : section) {
                this.section.add(value);
            }
            return this;
        }

        public Builder section(Collection<Section> section) {
            this.section = new ArrayList<Section>(section);
            return this;
        }

        @Override
        public Composition build() {
            Composition composition = new Composition(this);
            if (this.validating) {
                this.validate(composition);
            }
            return composition;
        }

        protected void validate(Composition composition) {
            super.validate(composition);
            ValidationSupport.requireNonNull(composition.status, "status");
            ValidationSupport.requireNonNull(composition.type, "type");
            ValidationSupport.checkList(composition.category, "category", CodeableConcept.class);
            ValidationSupport.requireNonNull(composition.date, "date");
            ValidationSupport.checkNonEmptyList(composition.author, "author", Reference.class);
            ValidationSupport.requireNonNull(composition.title, "title");
            ValidationSupport.checkList(composition.attester, "attester", Attester.class);
            ValidationSupport.checkList(composition.relatesTo, "relatesTo", RelatesTo.class);
            ValidationSupport.checkList(composition.event, "event", Event.class);
            ValidationSupport.checkList(composition.section, "section", Section.class);
            ValidationSupport.checkReferenceType(composition.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(composition.author, "author", "Practitioner", "PractitionerRole", "Device", "Patient", "RelatedPerson", "Organization");
            ValidationSupport.checkReferenceType(composition.custodian, "custodian", "Organization");
        }

        protected Builder from(Composition composition) {
            super.from(composition);
            this.identifier = composition.identifier;
            this.status = composition.status;
            this.type = composition.type;
            this.category.addAll(composition.category);
            this.subject = composition.subject;
            this.encounter = composition.encounter;
            this.date = composition.date;
            this.author.addAll(composition.author);
            this.title = composition.title;
            this.confidentiality = composition.confidentiality;
            this.attester.addAll(composition.attester);
            this.custodian = composition.custodian;
            this.relatesTo.addAll(composition.relatesTo);
            this.event.addAll(composition.event);
            this.section.addAll(composition.section);
            return this;
        }
    }
}

