/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Age;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="con-1", level="Rule", location="Condition.stage", description="Stage SHALL have summary or assessment", expression="summary.exists() or assessment.exists()", source="http://hl7.org/fhir/StructureDefinition/Condition"), @Constraint(id="con-2", level="Rule", location="Condition.evidence", description="evidence SHALL have code or details", expression="code.exists() or detail.exists()", source="http://hl7.org/fhir/StructureDefinition/Condition"), @Constraint(id="con-3", level="Warning", location="(base)", description="Condition.clinicalStatus SHALL be present if verificationStatus is not entered-in-error and category is problem-list-item", expression="clinicalStatus.exists() or verificationStatus.coding.where(system='http://terminology.hl7.org/CodeSystem/condition-ver-status' and code = 'entered-in-error').exists() or category.select($this='problem-list-item').empty()", source="http://hl7.org/fhir/StructureDefinition/Condition"), @Constraint(id="con-4", level="Rule", location="(base)", description="If condition is abated, then clinicalStatus must be either inactive, resolved, or remission", expression="abatement.empty() or clinicalStatus.coding.where(system='http://terminology.hl7.org/CodeSystem/condition-clinical' and (code='resolved' or code='remission' or code='inactive')).exists()", source="http://hl7.org/fhir/StructureDefinition/Condition"), @Constraint(id="con-5", level="Rule", location="(base)", description="Condition.clinicalStatus SHALL NOT be present if verification Status is entered-in-error", expression="verificationStatus.coding.where(system='http://terminology.hl7.org/CodeSystem/condition-ver-status' and code='entered-in-error').empty() or clinicalStatus.empty()", source="http://hl7.org/fhir/StructureDefinition/Condition"), @Constraint(id="condition-6", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/condition-category", expression="category.exists() implies (category.all(memberOf('http://hl7.org/fhir/ValueSet/condition-category', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/Condition", generated=true), @Constraint(id="condition-7", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/condition-severity", expression="severity.exists() implies (severity.memberOf('http://hl7.org/fhir/ValueSet/condition-severity', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/Condition", generated=true)})
public class Condition
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="ConditionClinicalStatus", strength=BindingStrength.Value.REQUIRED, description="The clinical status of the condition or diagnosis.", valueSet="http://hl7.org/fhir/ValueSet/condition-clinical|4.0.1")
    private final CodeableConcept clinicalStatus;
    @Summary
    @Binding(bindingName="ConditionVerificationStatus", strength=BindingStrength.Value.REQUIRED, description="The verification status to support or decline the clinical status of the condition or diagnosis.", valueSet="http://hl7.org/fhir/ValueSet/condition-ver-status|4.0.1")
    private final CodeableConcept verificationStatus;
    @Binding(bindingName="ConditionCategory", strength=BindingStrength.Value.EXTENSIBLE, description="A category assigned to the condition.", valueSet="http://hl7.org/fhir/ValueSet/condition-category")
    private final List<CodeableConcept> category;
    @Binding(bindingName="ConditionSeverity", strength=BindingStrength.Value.PREFERRED, description="A subjective assessment of the severity of the condition as evaluated by the clinician.", valueSet="http://hl7.org/fhir/ValueSet/condition-severity")
    private final CodeableConcept severity;
    @Summary
    @Binding(bindingName="ConditionKind", strength=BindingStrength.Value.EXAMPLE, description="Identification of the condition or diagnosis.", valueSet="http://hl7.org/fhir/ValueSet/condition-code")
    private final CodeableConcept code;
    @Summary
    @Binding(bindingName="BodySite", strength=BindingStrength.Value.EXAMPLE, description="Codes describing anatomical locations. May include laterality.", valueSet="http://hl7.org/fhir/ValueSet/body-site")
    private final List<CodeableConcept> bodySite;
    @Summary
    @ReferenceTarget(value={"Patient", "Group"})
    @Required
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    @Choice(value={DateTime.class, Age.class, Period.class, Range.class, String.class})
    private final Element onset;
    @Choice(value={DateTime.class, Age.class, Period.class, Range.class, String.class})
    private final Element abatement;
    @Summary
    private final DateTime recordedDate;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Patient", "RelatedPerson"})
    private final Reference recorder;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Patient", "RelatedPerson"})
    private final Reference asserter;
    private final List<Stage> stage;
    private final List<Evidence> evidence;
    private final List<Annotation> note;

    private Condition(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.clinicalStatus = builder.clinicalStatus;
        this.verificationStatus = builder.verificationStatus;
        this.category = Collections.unmodifiableList(builder.category);
        this.severity = builder.severity;
        this.code = builder.code;
        this.bodySite = Collections.unmodifiableList(builder.bodySite);
        this.subject = builder.subject;
        this.encounter = builder.encounter;
        this.onset = builder.onset;
        this.abatement = builder.abatement;
        this.recordedDate = builder.recordedDate;
        this.recorder = builder.recorder;
        this.asserter = builder.asserter;
        this.stage = Collections.unmodifiableList(builder.stage);
        this.evidence = Collections.unmodifiableList(builder.evidence);
        this.note = Collections.unmodifiableList(builder.note);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public CodeableConcept getClinicalStatus() {
        return this.clinicalStatus;
    }

    public CodeableConcept getVerificationStatus() {
        return this.verificationStatus;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public CodeableConcept getSeverity() {
        return this.severity;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public List<CodeableConcept> getBodySite() {
        return this.bodySite;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Element getOnset() {
        return this.onset;
    }

    public Element getAbatement() {
        return this.abatement;
    }

    public DateTime getRecordedDate() {
        return this.recordedDate;
    }

    public Reference getRecorder() {
        return this.recorder;
    }

    public Reference getAsserter() {
        return this.asserter;
    }

    public List<Stage> getStage() {
        return this.stage;
    }

    public List<Evidence> getEvidence() {
        return this.evidence;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.clinicalStatus != null || this.verificationStatus != null || !this.category.isEmpty() || this.severity != null || this.code != null || !this.bodySite.isEmpty() || this.subject != null || this.encounter != null || this.onset != null || this.abatement != null || this.recordedDate != null || this.recorder != null || this.asserter != null || !this.stage.isEmpty() || !this.evidence.isEmpty() || !this.note.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.clinicalStatus, "clinicalStatus", visitor);
                this.accept(this.verificationStatus, "verificationStatus", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.severity, "severity", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.bodySite, "bodySite", visitor, CodeableConcept.class);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.onset, "onset", visitor);
                this.accept(this.abatement, "abatement", visitor);
                this.accept(this.recordedDate, "recordedDate", visitor);
                this.accept(this.recorder, "recorder", visitor);
                this.accept(this.asserter, "asserter", visitor);
                this.accept(this.stage, "stage", visitor, Stage.class);
                this.accept(this.evidence, "evidence", visitor, Evidence.class);
                this.accept(this.note, "note", visitor, Annotation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Condition other = (Condition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.clinicalStatus, other.clinicalStatus) && Objects.equals(this.verificationStatus, other.verificationStatus) && Objects.equals(this.category, other.category) && Objects.equals(this.severity, other.severity) && Objects.equals(this.code, other.code) && Objects.equals(this.bodySite, other.bodySite) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.onset, other.onset) && Objects.equals(this.abatement, other.abatement) && Objects.equals(this.recordedDate, other.recordedDate) && Objects.equals(this.recorder, other.recorder) && Objects.equals(this.asserter, other.asserter) && Objects.equals(this.stage, other.stage) && Objects.equals(this.evidence, other.evidence) && Objects.equals(this.note, other.note);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.clinicalStatus, this.verificationStatus, this.category, this.severity, this.code, this.bodySite, this.subject, this.encounter, this.onset, this.abatement, this.recordedDate, this.recorder, this.asserter, this.stage, this.evidence, this.note);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Evidence
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ManifestationOrSymptom", strength=BindingStrength.Value.EXAMPLE, description="Codes that describe the manifestation or symptoms of a condition.", valueSet="http://hl7.org/fhir/ValueSet/manifestation-or-symptom")
        private final List<CodeableConcept> code;
        @Summary
        private final List<Reference> detail;

        private Evidence(Builder builder) {
            super(builder);
            this.code = Collections.unmodifiableList(builder.code);
            this.detail = Collections.unmodifiableList(builder.detail);
        }

        public List<CodeableConcept> getCode() {
            return this.code;
        }

        public List<Reference> getDetail() {
            return this.detail;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.code.isEmpty() || !this.detail.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor, CodeableConcept.class);
                    this.accept(this.detail, "detail", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Evidence other = (Evidence)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.detail, other.detail);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.detail);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<CodeableConcept> code = new ArrayList<CodeableConcept>();
            private List<Reference> detail = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept ... code) {
                for (CodeableConcept value : code) {
                    this.code.add(value);
                }
                return this;
            }

            public Builder code(Collection<CodeableConcept> code) {
                this.code = new ArrayList<CodeableConcept>(code);
                return this;
            }

            public Builder detail(Reference ... detail) {
                for (Reference value : detail) {
                    this.detail.add(value);
                }
                return this;
            }

            public Builder detail(Collection<Reference> detail) {
                this.detail = new ArrayList<Reference>(detail);
                return this;
            }

            @Override
            public Evidence build() {
                Evidence evidence = new Evidence(this);
                if (this.validating) {
                    this.validate(evidence);
                }
                return evidence;
            }

            protected void validate(Evidence evidence) {
                super.validate(evidence);
                ValidationSupport.checkList(evidence.code, "code", CodeableConcept.class);
                ValidationSupport.checkList(evidence.detail, "detail", Reference.class);
                ValidationSupport.requireValueOrChildren(evidence);
            }

            protected Builder from(Evidence evidence) {
                super.from(evidence);
                this.code.addAll(evidence.code);
                this.detail.addAll(evidence.detail);
                return this;
            }
        }
    }

    public static class Stage
    extends BackboneElement {
        @Binding(bindingName="ConditionStage", strength=BindingStrength.Value.EXAMPLE, description="Codes describing condition stages (e.g. Cancer stages).", valueSet="http://hl7.org/fhir/ValueSet/condition-stage")
        private final CodeableConcept summary;
        @ReferenceTarget(value={"ClinicalImpression", "DiagnosticReport", "Observation"})
        private final List<Reference> assessment;
        @Binding(bindingName="ConditionStageType", strength=BindingStrength.Value.EXAMPLE, description="Codes describing the kind of condition staging (e.g. clinical or pathological).", valueSet="http://hl7.org/fhir/ValueSet/condition-stage-type")
        private final CodeableConcept type;

        private Stage(Builder builder) {
            super(builder);
            this.summary = builder.summary;
            this.assessment = Collections.unmodifiableList(builder.assessment);
            this.type = builder.type;
        }

        public CodeableConcept getSummary() {
            return this.summary;
        }

        public List<Reference> getAssessment() {
            return this.assessment;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.summary != null || !this.assessment.isEmpty() || this.type != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.summary, "summary", visitor);
                    this.accept(this.assessment, "assessment", visitor, Reference.class);
                    this.accept(this.type, "type", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Stage other = (Stage)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.summary, other.summary) && Objects.equals(this.assessment, other.assessment) && Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.summary, this.assessment, this.type);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept summary;
            private List<Reference> assessment = new ArrayList<Reference>();
            private CodeableConcept type;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder summary(CodeableConcept summary) {
                this.summary = summary;
                return this;
            }

            public Builder assessment(Reference ... assessment) {
                for (Reference value : assessment) {
                    this.assessment.add(value);
                }
                return this;
            }

            public Builder assessment(Collection<Reference> assessment) {
                this.assessment = new ArrayList<Reference>(assessment);
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            @Override
            public Stage build() {
                Stage stage = new Stage(this);
                if (this.validating) {
                    this.validate(stage);
                }
                return stage;
            }

            protected void validate(Stage stage) {
                super.validate(stage);
                ValidationSupport.checkList(stage.assessment, "assessment", Reference.class);
                ValidationSupport.checkReferenceType(stage.assessment, "assessment", "ClinicalImpression", "DiagnosticReport", "Observation");
                ValidationSupport.requireValueOrChildren(stage);
            }

            protected Builder from(Stage stage) {
                super.from(stage);
                this.summary = stage.summary;
                this.assessment.addAll(stage.assessment);
                this.type = stage.type;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private CodeableConcept clinicalStatus;
        private CodeableConcept verificationStatus;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private CodeableConcept severity;
        private CodeableConcept code;
        private List<CodeableConcept> bodySite = new ArrayList<CodeableConcept>();
        private Reference subject;
        private Reference encounter;
        private Element onset;
        private Element abatement;
        private DateTime recordedDate;
        private Reference recorder;
        private Reference asserter;
        private List<Stage> stage = new ArrayList<Stage>();
        private List<Evidence> evidence = new ArrayList<Evidence>();
        private List<Annotation> note = new ArrayList<Annotation>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder clinicalStatus(CodeableConcept clinicalStatus) {
            this.clinicalStatus = clinicalStatus;
            return this;
        }

        public Builder verificationStatus(CodeableConcept verificationStatus) {
            this.verificationStatus = verificationStatus;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder severity(CodeableConcept severity) {
            this.severity = severity;
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder bodySite(CodeableConcept ... bodySite) {
            for (CodeableConcept value : bodySite) {
                this.bodySite.add(value);
            }
            return this;
        }

        public Builder bodySite(Collection<CodeableConcept> bodySite) {
            this.bodySite = new ArrayList<CodeableConcept>(bodySite);
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder onset(Element onset) {
            this.onset = onset;
            return this;
        }

        public Builder abatement(Element abatement) {
            this.abatement = abatement;
            return this;
        }

        public Builder recordedDate(DateTime recordedDate) {
            this.recordedDate = recordedDate;
            return this;
        }

        public Builder recorder(Reference recorder) {
            this.recorder = recorder;
            return this;
        }

        public Builder asserter(Reference asserter) {
            this.asserter = asserter;
            return this;
        }

        public Builder stage(Stage ... stage) {
            for (Stage value : stage) {
                this.stage.add(value);
            }
            return this;
        }

        public Builder stage(Collection<Stage> stage) {
            this.stage = new ArrayList<Stage>(stage);
            return this;
        }

        public Builder evidence(Evidence ... evidence) {
            for (Evidence value : evidence) {
                this.evidence.add(value);
            }
            return this;
        }

        public Builder evidence(Collection<Evidence> evidence) {
            this.evidence = new ArrayList<Evidence>(evidence);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        @Override
        public Condition build() {
            Condition condition = new Condition(this);
            if (this.validating) {
                this.validate(condition);
            }
            return condition;
        }

        protected void validate(Condition condition) {
            super.validate(condition);
            ValidationSupport.checkList(condition.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(condition.category, "category", CodeableConcept.class);
            ValidationSupport.checkList(condition.bodySite, "bodySite", CodeableConcept.class);
            ValidationSupport.requireNonNull(condition.subject, "subject");
            ValidationSupport.choiceElement(condition.onset, "onset", DateTime.class, Age.class, Period.class, Range.class, String.class);
            ValidationSupport.choiceElement(condition.abatement, "abatement", DateTime.class, Age.class, Period.class, Range.class, String.class);
            ValidationSupport.checkList(condition.stage, "stage", Stage.class);
            ValidationSupport.checkList(condition.evidence, "evidence", Evidence.class);
            ValidationSupport.checkList(condition.note, "note", Annotation.class);
            ValidationSupport.checkValueSetBinding(condition.clinicalStatus, "clinicalStatus", "http://hl7.org/fhir/ValueSet/condition-clinical", "http://terminology.hl7.org/CodeSystem/condition-clinical", "active", "recurrence", "relapse", "inactive", "remission", "resolved");
            ValidationSupport.checkValueSetBinding(condition.verificationStatus, "verificationStatus", "http://hl7.org/fhir/ValueSet/condition-ver-status", "http://terminology.hl7.org/CodeSystem/condition-ver-status", "unconfirmed", "provisional", "differential", "confirmed", "refuted", "entered-in-error");
            ValidationSupport.checkReferenceType(condition.subject, "subject", "Patient", "Group");
            ValidationSupport.checkReferenceType(condition.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(condition.recorder, "recorder", "Practitioner", "PractitionerRole", "Patient", "RelatedPerson");
            ValidationSupport.checkReferenceType(condition.asserter, "asserter", "Practitioner", "PractitionerRole", "Patient", "RelatedPerson");
        }

        protected Builder from(Condition condition) {
            super.from(condition);
            this.identifier.addAll(condition.identifier);
            this.clinicalStatus = condition.clinicalStatus;
            this.verificationStatus = condition.verificationStatus;
            this.category.addAll(condition.category);
            this.severity = condition.severity;
            this.code = condition.code;
            this.bodySite.addAll(condition.bodySite);
            this.subject = condition.subject;
            this.encounter = condition.encounter;
            this.onset = condition.onset;
            this.abatement = condition.abatement;
            this.recordedDate = condition.recordedDate;
            this.recorder = condition.recorder;
            this.asserter = condition.asserter;
            this.stage.addAll(condition.stage);
            this.evidence.addAll(condition.evidence);
            this.note.addAll(condition.note);
            return this;
        }
    }
}

