/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ConsentDataMeaning;
import com.ibm.fhir.model.type.code.ConsentProvisionType;
import com.ibm.fhir.model.type.code.ConsentState;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="ppc-1", level="Rule", location="(base)", description="Either a Policy or PolicyRule", expression="policy.exists() or policyRule.exists()", source="http://hl7.org/fhir/StructureDefinition/Consent"), @Constraint(id="ppc-2", level="Rule", location="(base)", description="IF Scope=privacy, there must be a patient", expression="patient.exists() or scope.coding.where(system='something' and code='patient-privacy').exists().not()", source="http://hl7.org/fhir/StructureDefinition/Consent"), @Constraint(id="ppc-3", level="Rule", location="(base)", description="IF Scope=research, there must be a patient", expression="patient.exists() or scope.coding.where(system='something' and code='research').exists().not()", source="http://hl7.org/fhir/StructureDefinition/Consent"), @Constraint(id="ppc-4", level="Rule", location="(base)", description="IF Scope=adr, there must be a patient", expression="patient.exists() or scope.coding.where(system='something' and code='adr').exists().not()", source="http://hl7.org/fhir/StructureDefinition/Consent"), @Constraint(id="ppc-5", level="Rule", location="(base)", description="IF Scope=treatment, there must be a patient", expression="patient.exists() or scope.coding.where(system='something' and code='treatment').exists().not()", source="http://hl7.org/fhir/StructureDefinition/Consent"), @Constraint(id="consent-6", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/consent-scope", expression="scope.exists() and scope.memberOf('http://hl7.org/fhir/ValueSet/consent-scope', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Consent", generated=true), @Constraint(id="consent-7", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/consent-category", expression="category.exists() and category.all(memberOf('http://hl7.org/fhir/ValueSet/consent-category', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/Consent", generated=true), @Constraint(id="consent-8", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/consent-policy", expression="policyRule.exists() implies (policyRule.memberOf('http://hl7.org/fhir/ValueSet/consent-policy', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/Consent", generated=true), @Constraint(id="consent-9", level="Warning", location="provision.actor.role", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/security-role-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/security-role-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Consent", generated=true), @Constraint(id="consent-10", level="Warning", location="provision.securityLabel", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/security-labels", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/security-labels', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Consent", generated=true), @Constraint(id="consent-11", level="Warning", location="provision.purpose", description="SHALL, if possible, contain a code from value set http://terminology.hl7.org/ValueSet/v3-PurposeOfUse", expression="$this.memberOf('http://terminology.hl7.org/ValueSet/v3-PurposeOfUse', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Consent", generated=true), @Constraint(id="consent-12", level="Warning", location="provision.class", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/consent-content-class", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/consent-content-class', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Consent", generated=true)})
public class Consent
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="ConsentState", strength=BindingStrength.Value.REQUIRED, description="Indicates the state of the consent.", valueSet="http://hl7.org/fhir/ValueSet/consent-state-codes|4.0.1")
    @Required
    private final ConsentState status;
    @Summary
    @Binding(bindingName="ConsentScope", strength=BindingStrength.Value.EXTENSIBLE, description="The four anticipated uses for the Consent Resource.", valueSet="http://hl7.org/fhir/ValueSet/consent-scope")
    @Required
    private final CodeableConcept scope;
    @Summary
    @Binding(bindingName="ConsentCategory", strength=BindingStrength.Value.EXTENSIBLE, description="A classification of the type of consents found in a consent statement.", valueSet="http://hl7.org/fhir/ValueSet/consent-category")
    @Required
    private final List<CodeableConcept> category;
    @Summary
    @ReferenceTarget(value={"Patient"})
    private final Reference patient;
    @Summary
    private final DateTime dateTime;
    @Summary
    @ReferenceTarget(value={"Organization", "Patient", "Practitioner", "RelatedPerson", "PractitionerRole"})
    private final List<Reference> performer;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final List<Reference> organization;
    @Summary
    @ReferenceTarget(value={"Consent", "DocumentReference", "Contract", "QuestionnaireResponse"})
    @Choice(value={Attachment.class, Reference.class})
    private final Element source;
    private final List<Policy> policy;
    @Summary
    @Binding(bindingName="ConsentPolicyRule", strength=BindingStrength.Value.EXTENSIBLE, description="Regulatory policy examples.", valueSet="http://hl7.org/fhir/ValueSet/consent-policy")
    private final CodeableConcept policyRule;
    @Summary
    private final List<Verification> verification;
    @Summary
    private final Provision provision;

    private Consent(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.scope = builder.scope;
        this.category = Collections.unmodifiableList(builder.category);
        this.patient = builder.patient;
        this.dateTime = builder.dateTime;
        this.performer = Collections.unmodifiableList(builder.performer);
        this.organization = Collections.unmodifiableList(builder.organization);
        this.source = builder.source;
        this.policy = Collections.unmodifiableList(builder.policy);
        this.policyRule = builder.policyRule;
        this.verification = Collections.unmodifiableList(builder.verification);
        this.provision = builder.provision;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public ConsentState getStatus() {
        return this.status;
    }

    public CodeableConcept getScope() {
        return this.scope;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    public List<Reference> getPerformer() {
        return this.performer;
    }

    public List<Reference> getOrganization() {
        return this.organization;
    }

    public Element getSource() {
        return this.source;
    }

    public List<Policy> getPolicy() {
        return this.policy;
    }

    public CodeableConcept getPolicyRule() {
        return this.policyRule;
    }

    public List<Verification> getVerification() {
        return this.verification;
    }

    public Provision getProvision() {
        return this.provision;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.scope != null || !this.category.isEmpty() || this.patient != null || this.dateTime != null || !this.performer.isEmpty() || !this.organization.isEmpty() || this.source != null || !this.policy.isEmpty() || this.policyRule != null || !this.verification.isEmpty() || this.provision != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.scope, "scope", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.dateTime, "dateTime", visitor);
                this.accept(this.performer, "performer", visitor, Reference.class);
                this.accept(this.organization, "organization", visitor, Reference.class);
                this.accept(this.source, "source", visitor);
                this.accept(this.policy, "policy", visitor, Policy.class);
                this.accept(this.policyRule, "policyRule", visitor);
                this.accept(this.verification, "verification", visitor, Verification.class);
                this.accept(this.provision, "provision", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Consent other = (Consent)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.scope, other.scope) && Objects.equals(this.category, other.category) && Objects.equals(this.patient, other.patient) && Objects.equals(this.dateTime, other.dateTime) && Objects.equals(this.performer, other.performer) && Objects.equals(this.organization, other.organization) && Objects.equals(this.source, other.source) && Objects.equals(this.policy, other.policy) && Objects.equals(this.policyRule, other.policyRule) && Objects.equals(this.verification, other.verification) && Objects.equals(this.provision, other.provision);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.scope, this.category, this.patient, this.dateTime, this.performer, this.organization, this.source, this.policy, this.policyRule, this.verification, this.provision);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Provision
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ConsentProvisionType", strength=BindingStrength.Value.REQUIRED, description="How a rule statement is applied, such as adding additional consent or removing consent.", valueSet="http://hl7.org/fhir/ValueSet/consent-provision-type|4.0.1")
        private final ConsentProvisionType type;
        @Summary
        private final Period period;
        private final List<Actor> actor;
        @Summary
        @Binding(bindingName="ConsentAction", strength=BindingStrength.Value.EXAMPLE, description="Detailed codes for the consent action.", valueSet="http://hl7.org/fhir/ValueSet/consent-action")
        private final List<CodeableConcept> action;
        @Summary
        @Binding(bindingName="SecurityLabels", strength=BindingStrength.Value.EXTENSIBLE, description="Security Labels from the Healthcare Privacy and Security Classification System.", valueSet="http://hl7.org/fhir/ValueSet/security-labels")
        private final List<Coding> securityLabel;
        @Summary
        @Binding(bindingName="PurposeOfUse", strength=BindingStrength.Value.EXTENSIBLE, description="What purposes of use are controlled by this exception. If more than one label is specified, operations must have all the specified labels.", valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
        private final List<Coding> purpose;
        @Summary
        @Binding(bindingName="ConsentContentClass", strength=BindingStrength.Value.EXTENSIBLE, description="The class (type) of information a consent rule covers.", valueSet="http://hl7.org/fhir/ValueSet/consent-content-class")
        private final List<Coding> clazz;
        @Summary
        @Binding(bindingName="ConsentContentCode", strength=BindingStrength.Value.EXAMPLE, description="If this code is found in an instance, then the exception applies.", valueSet="http://hl7.org/fhir/ValueSet/consent-content-code")
        private final List<CodeableConcept> code;
        @Summary
        private final Period dataPeriod;
        @Summary
        private final List<Data> data;
        private final List<Provision> provision;

        private Provision(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.period = builder.period;
            this.actor = Collections.unmodifiableList(builder.actor);
            this.action = Collections.unmodifiableList(builder.action);
            this.securityLabel = Collections.unmodifiableList(builder.securityLabel);
            this.purpose = Collections.unmodifiableList(builder.purpose);
            this.clazz = Collections.unmodifiableList(builder.clazz);
            this.code = Collections.unmodifiableList(builder.code);
            this.dataPeriod = builder.dataPeriod;
            this.data = Collections.unmodifiableList(builder.data);
            this.provision = Collections.unmodifiableList(builder.provision);
        }

        public ConsentProvisionType getType() {
            return this.type;
        }

        public Period getPeriod() {
            return this.period;
        }

        public List<Actor> getActor() {
            return this.actor;
        }

        public List<CodeableConcept> getAction() {
            return this.action;
        }

        public List<Coding> getSecurityLabel() {
            return this.securityLabel;
        }

        public List<Coding> getPurpose() {
            return this.purpose;
        }

        public List<Coding> getClazz() {
            return this.clazz;
        }

        public List<CodeableConcept> getCode() {
            return this.code;
        }

        public Period getDataPeriod() {
            return this.dataPeriod;
        }

        public List<Data> getData() {
            return this.data;
        }

        public List<Provision> getProvision() {
            return this.provision;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.period != null || !this.actor.isEmpty() || !this.action.isEmpty() || !this.securityLabel.isEmpty() || !this.purpose.isEmpty() || !this.clazz.isEmpty() || !this.code.isEmpty() || this.dataPeriod != null || !this.data.isEmpty() || !this.provision.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.period, "period", visitor);
                    this.accept(this.actor, "actor", visitor, Actor.class);
                    this.accept(this.action, "action", visitor, CodeableConcept.class);
                    this.accept(this.securityLabel, "securityLabel", visitor, Coding.class);
                    this.accept(this.purpose, "purpose", visitor, Coding.class);
                    this.accept(this.clazz, "class", visitor, Coding.class);
                    this.accept(this.code, "code", visitor, CodeableConcept.class);
                    this.accept(this.dataPeriod, "dataPeriod", visitor);
                    this.accept(this.data, "data", visitor, Data.class);
                    this.accept(this.provision, "provision", visitor, Provision.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Provision other = (Provision)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.period, other.period) && Objects.equals(this.actor, other.actor) && Objects.equals(this.action, other.action) && Objects.equals(this.securityLabel, other.securityLabel) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.clazz, other.clazz) && Objects.equals(this.code, other.code) && Objects.equals(this.dataPeriod, other.dataPeriod) && Objects.equals(this.data, other.data) && Objects.equals(this.provision, other.provision);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.period, this.actor, this.action, this.securityLabel, this.purpose, this.clazz, this.code, this.dataPeriod, this.data, this.provision);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Data
        extends BackboneElement {
            @Summary
            @Binding(bindingName="ConsentDataMeaning", strength=BindingStrength.Value.REQUIRED, description="How a resource reference is interpreted when testing consent restrictions.", valueSet="http://hl7.org/fhir/ValueSet/consent-data-meaning|4.0.1")
            @Required
            private final ConsentDataMeaning meaning;
            @Summary
            @Required
            private final Reference reference;

            private Data(Builder builder) {
                super(builder);
                this.meaning = builder.meaning;
                this.reference = builder.reference;
            }

            public ConsentDataMeaning getMeaning() {
                return this.meaning;
            }

            public Reference getReference() {
                return this.reference;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.meaning != null || this.reference != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.meaning, "meaning", visitor);
                        this.accept(this.reference, "reference", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Data other = (Data)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.meaning, other.meaning) && Objects.equals(this.reference, other.reference);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.meaning, this.reference);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private ConsentDataMeaning meaning;
                private Reference reference;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder meaning(ConsentDataMeaning meaning) {
                    this.meaning = meaning;
                    return this;
                }

                public Builder reference(Reference reference) {
                    this.reference = reference;
                    return this;
                }

                @Override
                public Data build() {
                    Data data = new Data(this);
                    if (this.validating) {
                        this.validate(data);
                    }
                    return data;
                }

                protected void validate(Data data) {
                    super.validate(data);
                    ValidationSupport.requireNonNull(data.meaning, "meaning");
                    ValidationSupport.requireNonNull(data.reference, "reference");
                    ValidationSupport.requireValueOrChildren(data);
                }

                protected Builder from(Data data) {
                    super.from(data);
                    this.meaning = data.meaning;
                    this.reference = data.reference;
                    return this;
                }
            }
        }

        public static class Actor
        extends BackboneElement {
            @Binding(bindingName="ConsentActorRole", strength=BindingStrength.Value.EXTENSIBLE, description="How an actor is involved in the consent considerations.", valueSet="http://hl7.org/fhir/ValueSet/security-role-type")
            @Required
            private final CodeableConcept role;
            @ReferenceTarget(value={"Device", "Group", "CareTeam", "Organization", "Patient", "Practitioner", "RelatedPerson", "PractitionerRole"})
            @Required
            private final Reference reference;

            private Actor(Builder builder) {
                super(builder);
                this.role = builder.role;
                this.reference = builder.reference;
            }

            public CodeableConcept getRole() {
                return this.role;
            }

            public Reference getReference() {
                return this.reference;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.role != null || this.reference != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.role, "role", visitor);
                        this.accept(this.reference, "reference", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Actor other = (Actor)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.role, other.role) && Objects.equals(this.reference, other.reference);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.role, this.reference);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept role;
                private Reference reference;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder role(CodeableConcept role) {
                    this.role = role;
                    return this;
                }

                public Builder reference(Reference reference) {
                    this.reference = reference;
                    return this;
                }

                @Override
                public Actor build() {
                    Actor actor = new Actor(this);
                    if (this.validating) {
                        this.validate(actor);
                    }
                    return actor;
                }

                protected void validate(Actor actor) {
                    super.validate(actor);
                    ValidationSupport.requireNonNull(actor.role, "role");
                    ValidationSupport.requireNonNull(actor.reference, "reference");
                    ValidationSupport.checkReferenceType(actor.reference, "reference", "Device", "Group", "CareTeam", "Organization", "Patient", "Practitioner", "RelatedPerson", "PractitionerRole");
                    ValidationSupport.requireValueOrChildren(actor);
                }

                protected Builder from(Actor actor) {
                    super.from(actor);
                    this.role = actor.role;
                    this.reference = actor.reference;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private ConsentProvisionType type;
            private Period period;
            private List<Actor> actor = new ArrayList<Actor>();
            private List<CodeableConcept> action = new ArrayList<CodeableConcept>();
            private List<Coding> securityLabel = new ArrayList<Coding>();
            private List<Coding> purpose = new ArrayList<Coding>();
            private List<Coding> clazz = new ArrayList<Coding>();
            private List<CodeableConcept> code = new ArrayList<CodeableConcept>();
            private Period dataPeriod;
            private List<Data> data = new ArrayList<Data>();
            private List<Provision> provision = new ArrayList<Provision>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(ConsentProvisionType type) {
                this.type = type;
                return this;
            }

            public Builder period(Period period) {
                this.period = period;
                return this;
            }

            public Builder actor(Actor ... actor) {
                for (Actor value : actor) {
                    this.actor.add(value);
                }
                return this;
            }

            public Builder actor(Collection<Actor> actor) {
                this.actor = new ArrayList<Actor>(actor);
                return this;
            }

            public Builder action(CodeableConcept ... action) {
                for (CodeableConcept value : action) {
                    this.action.add(value);
                }
                return this;
            }

            public Builder action(Collection<CodeableConcept> action) {
                this.action = new ArrayList<CodeableConcept>(action);
                return this;
            }

            public Builder securityLabel(Coding ... securityLabel) {
                for (Coding value : securityLabel) {
                    this.securityLabel.add(value);
                }
                return this;
            }

            public Builder securityLabel(Collection<Coding> securityLabel) {
                this.securityLabel = new ArrayList<Coding>(securityLabel);
                return this;
            }

            public Builder purpose(Coding ... purpose) {
                for (Coding value : purpose) {
                    this.purpose.add(value);
                }
                return this;
            }

            public Builder purpose(Collection<Coding> purpose) {
                this.purpose = new ArrayList<Coding>(purpose);
                return this;
            }

            public Builder clazz(Coding ... clazz) {
                for (Coding value : clazz) {
                    this.clazz.add(value);
                }
                return this;
            }

            public Builder clazz(Collection<Coding> clazz) {
                this.clazz = new ArrayList<Coding>(clazz);
                return this;
            }

            public Builder code(CodeableConcept ... code) {
                for (CodeableConcept value : code) {
                    this.code.add(value);
                }
                return this;
            }

            public Builder code(Collection<CodeableConcept> code) {
                this.code = new ArrayList<CodeableConcept>(code);
                return this;
            }

            public Builder dataPeriod(Period dataPeriod) {
                this.dataPeriod = dataPeriod;
                return this;
            }

            public Builder data(Data ... data) {
                for (Data value : data) {
                    this.data.add(value);
                }
                return this;
            }

            public Builder data(Collection<Data> data) {
                this.data = new ArrayList<Data>(data);
                return this;
            }

            public Builder provision(Provision ... provision) {
                for (Provision value : provision) {
                    this.provision.add(value);
                }
                return this;
            }

            public Builder provision(Collection<Provision> provision) {
                this.provision = new ArrayList<Provision>(provision);
                return this;
            }

            @Override
            public Provision build() {
                Provision provision = new Provision(this);
                if (this.validating) {
                    this.validate(provision);
                }
                return provision;
            }

            protected void validate(Provision provision) {
                super.validate(provision);
                ValidationSupport.checkList(provision.actor, "actor", Actor.class);
                ValidationSupport.checkList(provision.action, "action", CodeableConcept.class);
                ValidationSupport.checkList(provision.securityLabel, "securityLabel", Coding.class);
                ValidationSupport.checkList(provision.purpose, "purpose", Coding.class);
                ValidationSupport.checkList(provision.clazz, "class", Coding.class);
                ValidationSupport.checkList(provision.code, "code", CodeableConcept.class);
                ValidationSupport.checkList(provision.data, "data", Data.class);
                ValidationSupport.checkList(provision.provision, "provision", Provision.class);
                ValidationSupport.requireValueOrChildren(provision);
            }

            protected Builder from(Provision provision) {
                super.from(provision);
                this.type = provision.type;
                this.period = provision.period;
                this.actor.addAll(provision.actor);
                this.action.addAll(provision.action);
                this.securityLabel.addAll(provision.securityLabel);
                this.purpose.addAll(provision.purpose);
                this.clazz.addAll(provision.clazz);
                this.code.addAll(provision.code);
                this.dataPeriod = provision.dataPeriod;
                this.data.addAll(provision.data);
                this.provision.addAll(provision.provision);
                return this;
            }
        }
    }

    public static class Verification
    extends BackboneElement {
        @Summary
        @Required
        private final Boolean verified;
        @ReferenceTarget(value={"Patient", "RelatedPerson"})
        private final Reference verifiedWith;
        private final DateTime verificationDate;

        private Verification(Builder builder) {
            super(builder);
            this.verified = builder.verified;
            this.verifiedWith = builder.verifiedWith;
            this.verificationDate = builder.verificationDate;
        }

        public Boolean getVerified() {
            return this.verified;
        }

        public Reference getVerifiedWith() {
            return this.verifiedWith;
        }

        public DateTime getVerificationDate() {
            return this.verificationDate;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.verified != null || this.verifiedWith != null || this.verificationDate != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.verified, "verified", visitor);
                    this.accept(this.verifiedWith, "verifiedWith", visitor);
                    this.accept(this.verificationDate, "verificationDate", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Verification other = (Verification)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.verified, other.verified) && Objects.equals(this.verifiedWith, other.verifiedWith) && Objects.equals(this.verificationDate, other.verificationDate);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.verified, this.verifiedWith, this.verificationDate);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Boolean verified;
            private Reference verifiedWith;
            private DateTime verificationDate;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder verified(Boolean verified) {
                this.verified = verified;
                return this;
            }

            public Builder verifiedWith(Reference verifiedWith) {
                this.verifiedWith = verifiedWith;
                return this;
            }

            public Builder verificationDate(DateTime verificationDate) {
                this.verificationDate = verificationDate;
                return this;
            }

            @Override
            public Verification build() {
                Verification verification = new Verification(this);
                if (this.validating) {
                    this.validate(verification);
                }
                return verification;
            }

            protected void validate(Verification verification) {
                super.validate(verification);
                ValidationSupport.requireNonNull(verification.verified, "verified");
                ValidationSupport.checkReferenceType(verification.verifiedWith, "verifiedWith", "Patient", "RelatedPerson");
                ValidationSupport.requireValueOrChildren(verification);
            }

            protected Builder from(Verification verification) {
                super.from(verification);
                this.verified = verification.verified;
                this.verifiedWith = verification.verifiedWith;
                this.verificationDate = verification.verificationDate;
                return this;
            }
        }
    }

    public static class Policy
    extends BackboneElement {
        private final Uri authority;
        private final Uri uri;

        private Policy(Builder builder) {
            super(builder);
            this.authority = builder.authority;
            this.uri = builder.uri;
        }

        public Uri getAuthority() {
            return this.authority;
        }

        public Uri getUri() {
            return this.uri;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.authority != null || this.uri != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.authority, "authority", visitor);
                    this.accept(this.uri, "uri", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Policy other = (Policy)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.authority, other.authority) && Objects.equals(this.uri, other.uri);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.authority, this.uri);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Uri authority;
            private Uri uri;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder authority(Uri authority) {
                this.authority = authority;
                return this;
            }

            public Builder uri(Uri uri) {
                this.uri = uri;
                return this;
            }

            @Override
            public Policy build() {
                Policy policy = new Policy(this);
                if (this.validating) {
                    this.validate(policy);
                }
                return policy;
            }

            protected void validate(Policy policy) {
                super.validate(policy);
                ValidationSupport.requireValueOrChildren(policy);
            }

            protected Builder from(Policy policy) {
                super.from(policy);
                this.authority = policy.authority;
                this.uri = policy.uri;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private ConsentState status;
        private CodeableConcept scope;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private Reference patient;
        private DateTime dateTime;
        private List<Reference> performer = new ArrayList<Reference>();
        private List<Reference> organization = new ArrayList<Reference>();
        private Element source;
        private List<Policy> policy = new ArrayList<Policy>();
        private CodeableConcept policyRule;
        private List<Verification> verification = new ArrayList<Verification>();
        private Provision provision;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(ConsentState status) {
            this.status = status;
            return this;
        }

        public Builder scope(CodeableConcept scope) {
            this.scope = scope;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder dateTime(DateTime dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public Builder performer(Reference ... performer) {
            for (Reference value : performer) {
                this.performer.add(value);
            }
            return this;
        }

        public Builder performer(Collection<Reference> performer) {
            this.performer = new ArrayList<Reference>(performer);
            return this;
        }

        public Builder organization(Reference ... organization) {
            for (Reference value : organization) {
                this.organization.add(value);
            }
            return this;
        }

        public Builder organization(Collection<Reference> organization) {
            this.organization = new ArrayList<Reference>(organization);
            return this;
        }

        public Builder source(Element source) {
            this.source = source;
            return this;
        }

        public Builder policy(Policy ... policy) {
            for (Policy value : policy) {
                this.policy.add(value);
            }
            return this;
        }

        public Builder policy(Collection<Policy> policy) {
            this.policy = new ArrayList<Policy>(policy);
            return this;
        }

        public Builder policyRule(CodeableConcept policyRule) {
            this.policyRule = policyRule;
            return this;
        }

        public Builder verification(Verification ... verification) {
            for (Verification value : verification) {
                this.verification.add(value);
            }
            return this;
        }

        public Builder verification(Collection<Verification> verification) {
            this.verification = new ArrayList<Verification>(verification);
            return this;
        }

        public Builder provision(Provision provision) {
            this.provision = provision;
            return this;
        }

        @Override
        public Consent build() {
            Consent consent = new Consent(this);
            if (this.validating) {
                this.validate(consent);
            }
            return consent;
        }

        protected void validate(Consent consent) {
            super.validate(consent);
            ValidationSupport.checkList(consent.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(consent.status, "status");
            ValidationSupport.requireNonNull(consent.scope, "scope");
            ValidationSupport.checkNonEmptyList(consent.category, "category", CodeableConcept.class);
            ValidationSupport.checkList(consent.performer, "performer", Reference.class);
            ValidationSupport.checkList(consent.organization, "organization", Reference.class);
            ValidationSupport.choiceElement(consent.source, "source", Attachment.class, Reference.class);
            ValidationSupport.checkList(consent.policy, "policy", Policy.class);
            ValidationSupport.checkList(consent.verification, "verification", Verification.class);
            ValidationSupport.checkReferenceType(consent.patient, "patient", "Patient");
            ValidationSupport.checkReferenceType(consent.performer, "performer", "Organization", "Patient", "Practitioner", "RelatedPerson", "PractitionerRole");
            ValidationSupport.checkReferenceType(consent.organization, "organization", "Organization");
            ValidationSupport.checkReferenceType(consent.source, "source", "Consent", "DocumentReference", "Contract", "QuestionnaireResponse");
        }

        protected Builder from(Consent consent) {
            super.from(consent);
            this.identifier.addAll(consent.identifier);
            this.status = consent.status;
            this.scope = consent.scope;
            this.category.addAll(consent.category);
            this.patient = consent.patient;
            this.dateTime = consent.dateTime;
            this.performer.addAll(consent.performer);
            this.organization.addAll(consent.organization);
            this.source = consent.source;
            this.policy.addAll(consent.policy);
            this.policyRule = consent.policyRule;
            this.verification.addAll(consent.verification);
            this.provision = consent.provision;
            return this;
        }
    }
}

