/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.DetectedIssueSeverity;
import com.ibm.fhir.model.type.code.DetectedIssueStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=1, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="detectedIssue-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/detectedissue-category", expression="code.exists() implies (code.memberOf('http://hl7.org/fhir/ValueSet/detectedissue-category', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/DetectedIssue", generated=true), @Constraint(id="detectedIssue-1", level="Warning", location="mitigation.action", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/detectedissue-mitigation-action", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/detectedissue-mitigation-action', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/DetectedIssue", generated=true)})
public class DetectedIssue
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="DetectedIssueStatus", strength=BindingStrength.Value.REQUIRED, description="Indicates the status of the identified issue.", valueSet="http://hl7.org/fhir/ValueSet/observation-status|4.0.1")
    @Required
    private final DetectedIssueStatus status;
    @Summary
    @Binding(bindingName="DetectedIssueCategory", strength=BindingStrength.Value.PREFERRED, description="Codes identifying the general type of detected issue; e.g. Drug-drug interaction, Timing issue, Duplicate therapy, etc.", valueSet="http://hl7.org/fhir/ValueSet/detectedissue-category")
    private final CodeableConcept code;
    @Summary
    @Binding(bindingName="DetectedIssueSeverity", strength=BindingStrength.Value.REQUIRED, description="Indicates the potential degree of impact of the identified issue on the patient.", valueSet="http://hl7.org/fhir/ValueSet/detectedissue-severity|4.0.1")
    private final DetectedIssueSeverity severity;
    @Summary
    @ReferenceTarget(value={"Patient"})
    private final Reference patient;
    @Summary
    @Choice(value={DateTime.class, Period.class})
    private final Element identified;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Device"})
    private final Reference author;
    @Summary
    private final List<Reference> implicated;
    private final List<Evidence> evidence;
    private final String detail;
    private final Uri reference;
    private final List<Mitigation> mitigation;

    private DetectedIssue(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.code = builder.code;
        this.severity = builder.severity;
        this.patient = builder.patient;
        this.identified = builder.identified;
        this.author = builder.author;
        this.implicated = Collections.unmodifiableList(builder.implicated);
        this.evidence = Collections.unmodifiableList(builder.evidence);
        this.detail = builder.detail;
        this.reference = builder.reference;
        this.mitigation = Collections.unmodifiableList(builder.mitigation);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public DetectedIssueStatus getStatus() {
        return this.status;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public DetectedIssueSeverity getSeverity() {
        return this.severity;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public Element getIdentified() {
        return this.identified;
    }

    public Reference getAuthor() {
        return this.author;
    }

    public List<Reference> getImplicated() {
        return this.implicated;
    }

    public List<Evidence> getEvidence() {
        return this.evidence;
    }

    public String getDetail() {
        return this.detail;
    }

    public Uri getReference() {
        return this.reference;
    }

    public List<Mitigation> getMitigation() {
        return this.mitigation;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.code != null || this.severity != null || this.patient != null || this.identified != null || this.author != null || !this.implicated.isEmpty() || !this.evidence.isEmpty() || this.detail != null || this.reference != null || !this.mitigation.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.code, "code", visitor);
                this.accept(this.severity, "severity", visitor);
                this.accept(this.patient, "patient", visitor);
                this.accept(this.identified, "identified", visitor);
                this.accept(this.author, "author", visitor);
                this.accept(this.implicated, "implicated", visitor, Reference.class);
                this.accept(this.evidence, "evidence", visitor, Evidence.class);
                this.accept(this.detail, "detail", visitor);
                this.accept(this.reference, "reference", visitor);
                this.accept(this.mitigation, "mitigation", visitor, Mitigation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DetectedIssue other = (DetectedIssue)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.code, other.code) && Objects.equals(this.severity, other.severity) && Objects.equals(this.patient, other.patient) && Objects.equals(this.identified, other.identified) && Objects.equals(this.author, other.author) && Objects.equals(this.implicated, other.implicated) && Objects.equals(this.evidence, other.evidence) && Objects.equals(this.detail, other.detail) && Objects.equals(this.reference, other.reference) && Objects.equals(this.mitigation, other.mitigation);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.code, this.severity, this.patient, this.identified, this.author, this.implicated, this.evidence, this.detail, this.reference, this.mitigation);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Mitigation
    extends BackboneElement {
        @Binding(bindingName="DetectedIssueMitigationAction", strength=BindingStrength.Value.PREFERRED, description="Codes describing steps taken to resolve the issue or other circumstances that mitigate the risk associated with the issue; e.g. 'added concurrent therapy', 'prior therapy documented', etc.", valueSet="http://hl7.org/fhir/ValueSet/detectedissue-mitigation-action")
        @Required
        private final CodeableConcept action;
        private final DateTime date;
        @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
        private final Reference author;

        private Mitigation(Builder builder) {
            super(builder);
            this.action = builder.action;
            this.date = builder.date;
            this.author = builder.author;
        }

        public CodeableConcept getAction() {
            return this.action;
        }

        public DateTime getDate() {
            return this.date;
        }

        public Reference getAuthor() {
            return this.author;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.action != null || this.date != null || this.author != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.action, "action", visitor);
                    this.accept(this.date, "date", visitor);
                    this.accept(this.author, "author", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mitigation other = (Mitigation)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.action, other.action) && Objects.equals(this.date, other.date) && Objects.equals(this.author, other.author);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.action, this.date, this.author);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept action;
            private DateTime date;
            private Reference author;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder action(CodeableConcept action) {
                this.action = action;
                return this;
            }

            public Builder date(DateTime date) {
                this.date = date;
                return this;
            }

            public Builder author(Reference author) {
                this.author = author;
                return this;
            }

            @Override
            public Mitigation build() {
                Mitigation mitigation = new Mitigation(this);
                if (this.validating) {
                    this.validate(mitigation);
                }
                return mitigation;
            }

            protected void validate(Mitigation mitigation) {
                super.validate(mitigation);
                ValidationSupport.requireNonNull(mitigation.action, "action");
                ValidationSupport.checkReferenceType(mitigation.author, "author", "Practitioner", "PractitionerRole");
                ValidationSupport.requireValueOrChildren(mitigation);
            }

            protected Builder from(Mitigation mitigation) {
                super.from(mitigation);
                this.action = mitigation.action;
                this.date = mitigation.date;
                this.author = mitigation.author;
                return this;
            }
        }
    }

    public static class Evidence
    extends BackboneElement {
        @Binding(bindingName="DetectedIssueEvidenceCode", strength=BindingStrength.Value.EXAMPLE, description="Codes that describes the types of evidence for a detected issue.", valueSet="http://hl7.org/fhir/ValueSet/manifestation-or-symptom")
        private final List<CodeableConcept> code;
        private final List<Reference> detail;

        private Evidence(Builder builder) {
            super(builder);
            this.code = Collections.unmodifiableList(builder.code);
            this.detail = Collections.unmodifiableList(builder.detail);
        }

        public List<CodeableConcept> getCode() {
            return this.code;
        }

        public List<Reference> getDetail() {
            return this.detail;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.code.isEmpty() || !this.detail.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor, CodeableConcept.class);
                    this.accept(this.detail, "detail", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Evidence other = (Evidence)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.detail, other.detail);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.detail);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<CodeableConcept> code = new ArrayList<CodeableConcept>();
            private List<Reference> detail = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept ... code) {
                for (CodeableConcept value : code) {
                    this.code.add(value);
                }
                return this;
            }

            public Builder code(Collection<CodeableConcept> code) {
                this.code = new ArrayList<CodeableConcept>(code);
                return this;
            }

            public Builder detail(Reference ... detail) {
                for (Reference value : detail) {
                    this.detail.add(value);
                }
                return this;
            }

            public Builder detail(Collection<Reference> detail) {
                this.detail = new ArrayList<Reference>(detail);
                return this;
            }

            @Override
            public Evidence build() {
                Evidence evidence = new Evidence(this);
                if (this.validating) {
                    this.validate(evidence);
                }
                return evidence;
            }

            protected void validate(Evidence evidence) {
                super.validate(evidence);
                ValidationSupport.checkList(evidence.code, "code", CodeableConcept.class);
                ValidationSupport.checkList(evidence.detail, "detail", Reference.class);
                ValidationSupport.requireValueOrChildren(evidence);
            }

            protected Builder from(Evidence evidence) {
                super.from(evidence);
                this.code.addAll(evidence.code);
                this.detail.addAll(evidence.detail);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private DetectedIssueStatus status;
        private CodeableConcept code;
        private DetectedIssueSeverity severity;
        private Reference patient;
        private Element identified;
        private Reference author;
        private List<Reference> implicated = new ArrayList<Reference>();
        private List<Evidence> evidence = new ArrayList<Evidence>();
        private String detail;
        private Uri reference;
        private List<Mitigation> mitigation = new ArrayList<Mitigation>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(DetectedIssueStatus status) {
            this.status = status;
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder severity(DetectedIssueSeverity severity) {
            this.severity = severity;
            return this;
        }

        public Builder patient(Reference patient) {
            this.patient = patient;
            return this;
        }

        public Builder identified(Element identified) {
            this.identified = identified;
            return this;
        }

        public Builder author(Reference author) {
            this.author = author;
            return this;
        }

        public Builder implicated(Reference ... implicated) {
            for (Reference value : implicated) {
                this.implicated.add(value);
            }
            return this;
        }

        public Builder implicated(Collection<Reference> implicated) {
            this.implicated = new ArrayList<Reference>(implicated);
            return this;
        }

        public Builder evidence(Evidence ... evidence) {
            for (Evidence value : evidence) {
                this.evidence.add(value);
            }
            return this;
        }

        public Builder evidence(Collection<Evidence> evidence) {
            this.evidence = new ArrayList<Evidence>(evidence);
            return this;
        }

        public Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public Builder reference(Uri reference) {
            this.reference = reference;
            return this;
        }

        public Builder mitigation(Mitigation ... mitigation) {
            for (Mitigation value : mitigation) {
                this.mitigation.add(value);
            }
            return this;
        }

        public Builder mitigation(Collection<Mitigation> mitigation) {
            this.mitigation = new ArrayList<Mitigation>(mitigation);
            return this;
        }

        @Override
        public DetectedIssue build() {
            DetectedIssue detectedIssue = new DetectedIssue(this);
            if (this.validating) {
                this.validate(detectedIssue);
            }
            return detectedIssue;
        }

        protected void validate(DetectedIssue detectedIssue) {
            super.validate(detectedIssue);
            ValidationSupport.checkList(detectedIssue.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(detectedIssue.status, "status");
            ValidationSupport.choiceElement(detectedIssue.identified, "identified", DateTime.class, Period.class);
            ValidationSupport.checkList(detectedIssue.implicated, "implicated", Reference.class);
            ValidationSupport.checkList(detectedIssue.evidence, "evidence", Evidence.class);
            ValidationSupport.checkList(detectedIssue.mitigation, "mitigation", Mitigation.class);
            ValidationSupport.checkReferenceType(detectedIssue.patient, "patient", "Patient");
            ValidationSupport.checkReferenceType(detectedIssue.author, "author", "Practitioner", "PractitionerRole", "Device");
        }

        protected Builder from(DetectedIssue detectedIssue) {
            super.from(detectedIssue);
            this.identifier.addAll(detectedIssue.identifier);
            this.status = detectedIssue.status;
            this.code = detectedIssue.code;
            this.severity = detectedIssue.severity;
            this.patient = detectedIssue.patient;
            this.identified = detectedIssue.identified;
            this.author = detectedIssue.author;
            this.implicated.addAll(detectedIssue.implicated);
            this.evidence.addAll(detectedIssue.evidence);
            this.detail = detectedIssue.detail;
            this.reference = detectedIssue.reference;
            this.mitigation.addAll(detectedIssue.mitigation);
            return this;
        }
    }
}

