/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.GoalLifecycleStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="gol-1", level="Rule", location="Goal.target", description="Goal.target.measure is required if Goal.target.detail is populated", expression="(detail.exists() and measure.exists()) or detail.exists().not()", source="http://hl7.org/fhir/StructureDefinition/Goal"), @Constraint(id="goal-2", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/goal-achievement", expression="achievementStatus.exists() implies (achievementStatus.memberOf('http://hl7.org/fhir/ValueSet/goal-achievement', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/Goal", generated=true), @Constraint(id="goal-3", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/goal-priority", expression="priority.exists() implies (priority.memberOf('http://hl7.org/fhir/ValueSet/goal-priority', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/Goal", generated=true)})
public class Goal
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="GoalLifecycleStatus", strength=BindingStrength.Value.REQUIRED, description="Codes that reflect the current state of a goal and whether the goal is still being targeted.", valueSet="http://hl7.org/fhir/ValueSet/goal-status|4.0.1")
    @Required
    private final GoalLifecycleStatus lifecycleStatus;
    @Summary
    @Binding(bindingName="GoalAchievementStatus", strength=BindingStrength.Value.PREFERRED, description="Indicates the progression, or lack thereof, towards the goal against the target.", valueSet="http://hl7.org/fhir/ValueSet/goal-achievement")
    private final CodeableConcept achievementStatus;
    @Summary
    @Binding(bindingName="GoalCategory", strength=BindingStrength.Value.EXAMPLE, description="Codes for grouping and sorting goals.", valueSet="http://hl7.org/fhir/ValueSet/goal-category")
    private final List<CodeableConcept> category;
    @Summary
    @Binding(bindingName="GoalPriority", strength=BindingStrength.Value.PREFERRED, description="The level of importance associated with a goal.", valueSet="http://hl7.org/fhir/ValueSet/goal-priority")
    private final CodeableConcept priority;
    @Summary
    @Binding(bindingName="GoalDescription", strength=BindingStrength.Value.EXAMPLE, description="Codes providing the details of a particular goal.  This will generally be system or implementation guide-specific.  In many systems, only the text element will be used.", valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    @Required
    private final CodeableConcept description;
    @Summary
    @ReferenceTarget(value={"Patient", "Group", "Organization"})
    @Required
    private final Reference subject;
    @Summary
    @Choice(value={Date.class, CodeableConcept.class})
    @Binding(bindingName="GoalStartEvent", strength=BindingStrength.Value.EXAMPLE, description="Codes describing events that can trigger the initiation of a goal.", valueSet="http://hl7.org/fhir/ValueSet/goal-start-event")
    private final Element start;
    private final List<Target> target;
    @Summary
    private final Date statusDate;
    private final String statusReason;
    @Summary
    @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "RelatedPerson"})
    private final Reference expressedBy;
    @ReferenceTarget(value={"Condition", "Observation", "MedicationStatement", "NutritionOrder", "ServiceRequest", "RiskAssessment"})
    private final List<Reference> addresses;
    private final List<Annotation> note;
    @Binding(bindingName="GoalOutcome", strength=BindingStrength.Value.EXAMPLE, description="The result of the goal; e.g. \"25% increase in shoulder mobility\", \"Anxiety reduced to moderate levels\".  \"15 kg weight loss sustained over 6 months\".", valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    private final List<CodeableConcept> outcomeCode;
    @ReferenceTarget(value={"Observation"})
    private final List<Reference> outcomeReference;

    private Goal(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.lifecycleStatus = builder.lifecycleStatus;
        this.achievementStatus = builder.achievementStatus;
        this.category = Collections.unmodifiableList(builder.category);
        this.priority = builder.priority;
        this.description = builder.description;
        this.subject = builder.subject;
        this.start = builder.start;
        this.target = Collections.unmodifiableList(builder.target);
        this.statusDate = builder.statusDate;
        this.statusReason = builder.statusReason;
        this.expressedBy = builder.expressedBy;
        this.addresses = Collections.unmodifiableList(builder.addresses);
        this.note = Collections.unmodifiableList(builder.note);
        this.outcomeCode = Collections.unmodifiableList(builder.outcomeCode);
        this.outcomeReference = Collections.unmodifiableList(builder.outcomeReference);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public GoalLifecycleStatus getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public CodeableConcept getAchievementStatus() {
        return this.achievementStatus;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public CodeableConcept getPriority() {
        return this.priority;
    }

    public CodeableConcept getDescription() {
        return this.description;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Element getStart() {
        return this.start;
    }

    public List<Target> getTarget() {
        return this.target;
    }

    public Date getStatusDate() {
        return this.statusDate;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public Reference getExpressedBy() {
        return this.expressedBy;
    }

    public List<Reference> getAddresses() {
        return this.addresses;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<CodeableConcept> getOutcomeCode() {
        return this.outcomeCode;
    }

    public List<Reference> getOutcomeReference() {
        return this.outcomeReference;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.lifecycleStatus != null || this.achievementStatus != null || !this.category.isEmpty() || this.priority != null || this.description != null || this.subject != null || this.start != null || !this.target.isEmpty() || this.statusDate != null || this.statusReason != null || this.expressedBy != null || !this.addresses.isEmpty() || !this.note.isEmpty() || !this.outcomeCode.isEmpty() || !this.outcomeReference.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.lifecycleStatus, "lifecycleStatus", visitor);
                this.accept(this.achievementStatus, "achievementStatus", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.priority, "priority", visitor);
                this.accept(this.description, "description", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.start, "start", visitor);
                this.accept(this.target, "target", visitor, Target.class);
                this.accept(this.statusDate, "statusDate", visitor);
                this.accept(this.statusReason, "statusReason", visitor);
                this.accept(this.expressedBy, "expressedBy", visitor);
                this.accept(this.addresses, "addresses", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.outcomeCode, "outcomeCode", visitor, CodeableConcept.class);
                this.accept(this.outcomeReference, "outcomeReference", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Goal other = (Goal)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.lifecycleStatus, other.lifecycleStatus) && Objects.equals(this.achievementStatus, other.achievementStatus) && Objects.equals(this.category, other.category) && Objects.equals(this.priority, other.priority) && Objects.equals(this.description, other.description) && Objects.equals(this.subject, other.subject) && Objects.equals(this.start, other.start) && Objects.equals(this.target, other.target) && Objects.equals(this.statusDate, other.statusDate) && Objects.equals(this.statusReason, other.statusReason) && Objects.equals(this.expressedBy, other.expressedBy) && Objects.equals(this.addresses, other.addresses) && Objects.equals(this.note, other.note) && Objects.equals(this.outcomeCode, other.outcomeCode) && Objects.equals(this.outcomeReference, other.outcomeReference);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.lifecycleStatus, this.achievementStatus, this.category, this.priority, this.description, this.subject, this.start, this.target, this.statusDate, this.statusReason, this.expressedBy, this.addresses, this.note, this.outcomeCode, this.outcomeReference);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Target
    extends BackboneElement {
        @Summary
        @Binding(bindingName="GoalTargetMeasure", strength=BindingStrength.Value.EXAMPLE, description="Codes to identify the value being tracked, e.g. body weight, blood pressure, or hemoglobin A1c level.", valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
        private final CodeableConcept measure;
        @Summary
        @Choice(value={Quantity.class, Range.class, CodeableConcept.class, String.class, Boolean.class, Integer.class, Ratio.class})
        @Binding(bindingName="GoalTargetDetail", strength=BindingStrength.Value.EXAMPLE, description="Codes to identify the target value of the focus to be achieved to signify the fulfillment of the goal.")
        private final Element detail;
        @Summary
        @Choice(value={Date.class, Duration.class})
        private final Element due;

        private Target(Builder builder) {
            super(builder);
            this.measure = builder.measure;
            this.detail = builder.detail;
            this.due = builder.due;
        }

        public CodeableConcept getMeasure() {
            return this.measure;
        }

        public Element getDetail() {
            return this.detail;
        }

        public Element getDue() {
            return this.due;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.measure != null || this.detail != null || this.due != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.measure, "measure", visitor);
                    this.accept(this.detail, "detail", visitor);
                    this.accept(this.due, "due", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Target other = (Target)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.measure, other.measure) && Objects.equals(this.detail, other.detail) && Objects.equals(this.due, other.due);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.measure, this.detail, this.due);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept measure;
            private Element detail;
            private Element due;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder measure(CodeableConcept measure) {
                this.measure = measure;
                return this;
            }

            public Builder detail(Element detail) {
                this.detail = detail;
                return this;
            }

            public Builder due(Element due) {
                this.due = due;
                return this;
            }

            @Override
            public Target build() {
                Target target = new Target(this);
                if (this.validating) {
                    this.validate(target);
                }
                return target;
            }

            protected void validate(Target target) {
                super.validate(target);
                ValidationSupport.choiceElement(target.detail, "detail", Quantity.class, Range.class, CodeableConcept.class, String.class, Boolean.class, Integer.class, Ratio.class);
                ValidationSupport.choiceElement(target.due, "due", Date.class, Duration.class);
                ValidationSupport.requireValueOrChildren(target);
            }

            protected Builder from(Target target) {
                super.from(target);
                this.measure = target.measure;
                this.detail = target.detail;
                this.due = target.due;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private GoalLifecycleStatus lifecycleStatus;
        private CodeableConcept achievementStatus;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private CodeableConcept priority;
        private CodeableConcept description;
        private Reference subject;
        private Element start;
        private List<Target> target = new ArrayList<Target>();
        private Date statusDate;
        private String statusReason;
        private Reference expressedBy;
        private List<Reference> addresses = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<CodeableConcept> outcomeCode = new ArrayList<CodeableConcept>();
        private List<Reference> outcomeReference = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder lifecycleStatus(GoalLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        public Builder achievementStatus(CodeableConcept achievementStatus) {
            this.achievementStatus = achievementStatus;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder priority(CodeableConcept priority) {
            this.priority = priority;
            return this;
        }

        public Builder description(CodeableConcept description) {
            this.description = description;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder start(Element start) {
            this.start = start;
            return this;
        }

        public Builder target(Target ... target) {
            for (Target value : target) {
                this.target.add(value);
            }
            return this;
        }

        public Builder target(Collection<Target> target) {
            this.target = new ArrayList<Target>(target);
            return this;
        }

        public Builder statusDate(Date statusDate) {
            this.statusDate = statusDate;
            return this;
        }

        public Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public Builder expressedBy(Reference expressedBy) {
            this.expressedBy = expressedBy;
            return this;
        }

        public Builder addresses(Reference ... addresses) {
            for (Reference value : addresses) {
                this.addresses.add(value);
            }
            return this;
        }

        public Builder addresses(Collection<Reference> addresses) {
            this.addresses = new ArrayList<Reference>(addresses);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder outcomeCode(CodeableConcept ... outcomeCode) {
            for (CodeableConcept value : outcomeCode) {
                this.outcomeCode.add(value);
            }
            return this;
        }

        public Builder outcomeCode(Collection<CodeableConcept> outcomeCode) {
            this.outcomeCode = new ArrayList<CodeableConcept>(outcomeCode);
            return this;
        }

        public Builder outcomeReference(Reference ... outcomeReference) {
            for (Reference value : outcomeReference) {
                this.outcomeReference.add(value);
            }
            return this;
        }

        public Builder outcomeReference(Collection<Reference> outcomeReference) {
            this.outcomeReference = new ArrayList<Reference>(outcomeReference);
            return this;
        }

        @Override
        public Goal build() {
            Goal goal = new Goal(this);
            if (this.validating) {
                this.validate(goal);
            }
            return goal;
        }

        protected void validate(Goal goal) {
            super.validate(goal);
            ValidationSupport.checkList(goal.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(goal.lifecycleStatus, "lifecycleStatus");
            ValidationSupport.checkList(goal.category, "category", CodeableConcept.class);
            ValidationSupport.requireNonNull(goal.description, "description");
            ValidationSupport.requireNonNull(goal.subject, "subject");
            ValidationSupport.choiceElement(goal.start, "start", Date.class, CodeableConcept.class);
            ValidationSupport.checkList(goal.target, "target", Target.class);
            ValidationSupport.checkList(goal.addresses, "addresses", Reference.class);
            ValidationSupport.checkList(goal.note, "note", Annotation.class);
            ValidationSupport.checkList(goal.outcomeCode, "outcomeCode", CodeableConcept.class);
            ValidationSupport.checkList(goal.outcomeReference, "outcomeReference", Reference.class);
            ValidationSupport.checkReferenceType(goal.subject, "subject", "Patient", "Group", "Organization");
            ValidationSupport.checkReferenceType(goal.expressedBy, "expressedBy", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson");
            ValidationSupport.checkReferenceType(goal.addresses, "addresses", "Condition", "Observation", "MedicationStatement", "NutritionOrder", "ServiceRequest", "RiskAssessment");
            ValidationSupport.checkReferenceType(goal.outcomeReference, "outcomeReference", "Observation");
        }

        protected Builder from(Goal goal) {
            super.from(goal);
            this.identifier.addAll(goal.identifier);
            this.lifecycleStatus = goal.lifecycleStatus;
            this.achievementStatus = goal.achievementStatus;
            this.category.addAll(goal.category);
            this.priority = goal.priority;
            this.description = goal.description;
            this.subject = goal.subject;
            this.start = goal.start;
            this.target.addAll(goal.target);
            this.statusDate = goal.statusDate;
            this.statusReason = goal.statusReason;
            this.expressedBy = goal.expressedBy;
            this.addresses.addAll(goal.addresses);
            this.note.addAll(goal.note);
            this.outcomeCode.addAll(goal.outcomeCode);
            this.outcomeReference.addAll(goal.outcomeReference);
            return this;
        }
    }
}

