/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.DataRequirement;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.ParameterDefinition;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.RelatedArtifact;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="lib-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/Library"), @Constraint(id="library-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/library-type", expression="type.exists() and type.memberOf('http://hl7.org/fhir/ValueSet/library-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Library", generated=true), @Constraint(id="library-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/subject-type", expression="subject.as(CodeableConcept).exists() implies (subject.as(CodeableConcept).memberOf('http://hl7.org/fhir/ValueSet/subject-type', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/Library", generated=true), @Constraint(id="library-3", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/Library", generated=true)})
public class Library
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final String version;
    @Summary
    private final String name;
    @Summary
    private final String title;
    private final String subtitle;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    @Binding(bindingName="LibraryType", strength=BindingStrength.Value.EXTENSIBLE, description="The type of knowledge asset this library contains.", valueSet="http://hl7.org/fhir/ValueSet/library-type")
    @Required
    private final CodeableConcept type;
    @ReferenceTarget(value={"Group"})
    @Choice(value={CodeableConcept.class, Reference.class})
    @Binding(bindingName="SubjectType", strength=BindingStrength.Value.EXTENSIBLE, description="The possible types of subjects for a library (E.g. Patient, Practitioner, Organization, Location, etc.).", valueSet="http://hl7.org/fhir/ValueSet/subject-type")
    private final Element subject;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    @Summary
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final String usage;
    private final Markdown copyright;
    private final Date approvalDate;
    private final Date lastReviewDate;
    @Summary
    private final Period effectivePeriod;
    @Binding(bindingName="DefinitionTopic", strength=BindingStrength.Value.EXAMPLE, description="High-level categorization of the definition, used for searching, sorting, and filtering.", valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    private final List<CodeableConcept> topic;
    private final List<ContactDetail> author;
    private final List<ContactDetail> editor;
    private final List<ContactDetail> reviewer;
    private final List<ContactDetail> endorser;
    private final List<RelatedArtifact> relatedArtifact;
    private final List<ParameterDefinition> parameter;
    private final List<DataRequirement> dataRequirement;
    @Summary
    private final List<Attachment> content;

    private Library(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.type = builder.type;
        this.subject = builder.subject;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.usage = builder.usage;
        this.copyright = builder.copyright;
        this.approvalDate = builder.approvalDate;
        this.lastReviewDate = builder.lastReviewDate;
        this.effectivePeriod = builder.effectivePeriod;
        this.topic = Collections.unmodifiableList(builder.topic);
        this.author = Collections.unmodifiableList(builder.author);
        this.editor = Collections.unmodifiableList(builder.editor);
        this.reviewer = Collections.unmodifiableList(builder.reviewer);
        this.endorser = Collections.unmodifiableList(builder.endorser);
        this.relatedArtifact = Collections.unmodifiableList(builder.relatedArtifact);
        this.parameter = Collections.unmodifiableList(builder.parameter);
        this.dataRequirement = Collections.unmodifiableList(builder.dataRequirement);
        this.content = Collections.unmodifiableList(builder.content);
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Element getSubject() {
        return this.subject;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public String getUsage() {
        return this.usage;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public List<CodeableConcept> getTopic() {
        return this.topic;
    }

    public List<ContactDetail> getAuthor() {
        return this.author;
    }

    public List<ContactDetail> getEditor() {
        return this.editor;
    }

    public List<ContactDetail> getReviewer() {
        return this.reviewer;
    }

    public List<ContactDetail> getEndorser() {
        return this.endorser;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        return this.relatedArtifact;
    }

    public List<ParameterDefinition> getParameter() {
        return this.parameter;
    }

    public List<DataRequirement> getDataRequirement() {
        return this.dataRequirement;
    }

    public List<Attachment> getContent() {
        return this.content;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || this.subtitle != null || this.status != null || this.experimental != null || this.type != null || this.subject != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.usage != null || this.copyright != null || this.approvalDate != null || this.lastReviewDate != null || this.effectivePeriod != null || !this.topic.isEmpty() || !this.author.isEmpty() || !this.editor.isEmpty() || !this.reviewer.isEmpty() || !this.endorser.isEmpty() || !this.relatedArtifact.isEmpty() || !this.parameter.isEmpty() || !this.dataRequirement.isEmpty() || !this.content.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.subtitle, "subtitle", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.usage, "usage", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.approvalDate, "approvalDate", visitor);
                this.accept(this.lastReviewDate, "lastReviewDate", visitor);
                this.accept(this.effectivePeriod, "effectivePeriod", visitor);
                this.accept(this.topic, "topic", visitor, CodeableConcept.class);
                this.accept(this.author, "author", visitor, ContactDetail.class);
                this.accept(this.editor, "editor", visitor, ContactDetail.class);
                this.accept(this.reviewer, "reviewer", visitor, ContactDetail.class);
                this.accept(this.endorser, "endorser", visitor, ContactDetail.class);
                this.accept(this.relatedArtifact, "relatedArtifact", visitor, RelatedArtifact.class);
                this.accept(this.parameter, "parameter", visitor, ParameterDefinition.class);
                this.accept(this.dataRequirement, "dataRequirement", visitor, DataRequirement.class);
                this.accept(this.content, "content", visitor, Attachment.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Library other = (Library)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.subtitle, other.subtitle) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.type, other.type) && Objects.equals(this.subject, other.subject) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.usage, other.usage) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.approvalDate, other.approvalDate) && Objects.equals(this.lastReviewDate, other.lastReviewDate) && Objects.equals(this.effectivePeriod, other.effectivePeriod) && Objects.equals(this.topic, other.topic) && Objects.equals(this.author, other.author) && Objects.equals(this.editor, other.editor) && Objects.equals(this.reviewer, other.reviewer) && Objects.equals(this.endorser, other.endorser) && Objects.equals(this.relatedArtifact, other.relatedArtifact) && Objects.equals(this.parameter, other.parameter) && Objects.equals(this.dataRequirement, other.dataRequirement) && Objects.equals(this.content, other.content);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.subtitle, this.status, this.experimental, this.type, this.subject, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.usage, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.parameter, this.dataRequirement, this.content);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private String version;
        private String name;
        private String title;
        private String subtitle;
        private PublicationStatus status;
        private Boolean experimental;
        private CodeableConcept type;
        private Element subject;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private String usage;
        private Markdown copyright;
        private Date approvalDate;
        private Date lastReviewDate;
        private Period effectivePeriod;
        private List<CodeableConcept> topic = new ArrayList<CodeableConcept>();
        private List<ContactDetail> author = new ArrayList<ContactDetail>();
        private List<ContactDetail> editor = new ArrayList<ContactDetail>();
        private List<ContactDetail> reviewer = new ArrayList<ContactDetail>();
        private List<ContactDetail> endorser = new ArrayList<ContactDetail>();
        private List<RelatedArtifact> relatedArtifact = new ArrayList<RelatedArtifact>();
        private List<ParameterDefinition> parameter = new ArrayList<ParameterDefinition>();
        private List<DataRequirement> dataRequirement = new ArrayList<DataRequirement>();
        private List<Attachment> content = new ArrayList<Attachment>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder subject(Element subject) {
            this.subject = subject;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder approvalDate(Date approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public Builder lastReviewDate(Date lastReviewDate) {
            this.lastReviewDate = lastReviewDate;
            return this;
        }

        public Builder effectivePeriod(Period effectivePeriod) {
            this.effectivePeriod = effectivePeriod;
            return this;
        }

        public Builder topic(CodeableConcept ... topic) {
            for (CodeableConcept value : topic) {
                this.topic.add(value);
            }
            return this;
        }

        public Builder topic(Collection<CodeableConcept> topic) {
            this.topic = new ArrayList<CodeableConcept>(topic);
            return this;
        }

        public Builder author(ContactDetail ... author) {
            for (ContactDetail value : author) {
                this.author.add(value);
            }
            return this;
        }

        public Builder author(Collection<ContactDetail> author) {
            this.author = new ArrayList<ContactDetail>(author);
            return this;
        }

        public Builder editor(ContactDetail ... editor) {
            for (ContactDetail value : editor) {
                this.editor.add(value);
            }
            return this;
        }

        public Builder editor(Collection<ContactDetail> editor) {
            this.editor = new ArrayList<ContactDetail>(editor);
            return this;
        }

        public Builder reviewer(ContactDetail ... reviewer) {
            for (ContactDetail value : reviewer) {
                this.reviewer.add(value);
            }
            return this;
        }

        public Builder reviewer(Collection<ContactDetail> reviewer) {
            this.reviewer = new ArrayList<ContactDetail>(reviewer);
            return this;
        }

        public Builder endorser(ContactDetail ... endorser) {
            for (ContactDetail value : endorser) {
                this.endorser.add(value);
            }
            return this;
        }

        public Builder endorser(Collection<ContactDetail> endorser) {
            this.endorser = new ArrayList<ContactDetail>(endorser);
            return this;
        }

        public Builder relatedArtifact(RelatedArtifact ... relatedArtifact) {
            for (RelatedArtifact value : relatedArtifact) {
                this.relatedArtifact.add(value);
            }
            return this;
        }

        public Builder relatedArtifact(Collection<RelatedArtifact> relatedArtifact) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>(relatedArtifact);
            return this;
        }

        public Builder parameter(ParameterDefinition ... parameter) {
            for (ParameterDefinition value : parameter) {
                this.parameter.add(value);
            }
            return this;
        }

        public Builder parameter(Collection<ParameterDefinition> parameter) {
            this.parameter = new ArrayList<ParameterDefinition>(parameter);
            return this;
        }

        public Builder dataRequirement(DataRequirement ... dataRequirement) {
            for (DataRequirement value : dataRequirement) {
                this.dataRequirement.add(value);
            }
            return this;
        }

        public Builder dataRequirement(Collection<DataRequirement> dataRequirement) {
            this.dataRequirement = new ArrayList<DataRequirement>(dataRequirement);
            return this;
        }

        public Builder content(Attachment ... content) {
            for (Attachment value : content) {
                this.content.add(value);
            }
            return this;
        }

        public Builder content(Collection<Attachment> content) {
            this.content = new ArrayList<Attachment>(content);
            return this;
        }

        @Override
        public Library build() {
            Library library = new Library(this);
            if (this.validating) {
                this.validate(library);
            }
            return library;
        }

        protected void validate(Library library) {
            super.validate(library);
            ValidationSupport.checkList(library.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(library.status, "status");
            ValidationSupport.requireNonNull(library.type, "type");
            ValidationSupport.choiceElement(library.subject, "subject", CodeableConcept.class, Reference.class);
            ValidationSupport.checkList(library.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(library.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(library.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkList(library.topic, "topic", CodeableConcept.class);
            ValidationSupport.checkList(library.author, "author", ContactDetail.class);
            ValidationSupport.checkList(library.editor, "editor", ContactDetail.class);
            ValidationSupport.checkList(library.reviewer, "reviewer", ContactDetail.class);
            ValidationSupport.checkList(library.endorser, "endorser", ContactDetail.class);
            ValidationSupport.checkList(library.relatedArtifact, "relatedArtifact", RelatedArtifact.class);
            ValidationSupport.checkList(library.parameter, "parameter", ParameterDefinition.class);
            ValidationSupport.checkList(library.dataRequirement, "dataRequirement", DataRequirement.class);
            ValidationSupport.checkList(library.content, "content", Attachment.class);
            ValidationSupport.checkReferenceType(library.subject, "subject", "Group");
        }

        protected Builder from(Library library) {
            super.from(library);
            this.url = library.url;
            this.identifier.addAll(library.identifier);
            this.version = library.version;
            this.name = library.name;
            this.title = library.title;
            this.subtitle = library.subtitle;
            this.status = library.status;
            this.experimental = library.experimental;
            this.type = library.type;
            this.subject = library.subject;
            this.date = library.date;
            this.publisher = library.publisher;
            this.contact.addAll(library.contact);
            this.description = library.description;
            this.useContext.addAll(library.useContext);
            this.jurisdiction.addAll(library.jurisdiction);
            this.purpose = library.purpose;
            this.usage = library.usage;
            this.copyright = library.copyright;
            this.approvalDate = library.approvalDate;
            this.lastReviewDate = library.lastReviewDate;
            this.effectivePeriod = library.effectivePeriod;
            this.topic.addAll(library.topic);
            this.author.addAll(library.author);
            this.editor.addAll(library.editor);
            this.reviewer.addAll(library.reviewer);
            this.endorser.addAll(library.endorser);
            this.relatedArtifact.addAll(library.relatedArtifact);
            this.parameter.addAll(library.parameter);
            this.dataRequirement.addAll(library.dataRequirement);
            this.content.addAll(library.content);
            return this;
        }
    }
}

