/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.MeasureReportStatus;
import com.ibm.fhir.model.type.code.MeasureReportType;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="mrp-1", level="Rule", location="(base)", description="Measure Reports used for data collection SHALL NOT communicate group and score information", expression="(type != 'data-collection') or group.exists().not()", source="http://hl7.org/fhir/StructureDefinition/MeasureReport"), @Constraint(id="mrp-2", level="Rule", location="(base)", description="Stratifiers SHALL be either a single criteria or a set of criteria components", expression="group.stratifier.stratum.all(value.exists() xor component.exists())", source="http://hl7.org/fhir/StructureDefinition/MeasureReport"), @Constraint(id="measureReport-3", level="Warning", location="group.population.code", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/measure-population", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/measure-population', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/MeasureReport", generated=true), @Constraint(id="measureReport-4", level="Warning", location="group.stratifier.stratum.population.code", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/measure-population", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/measure-population', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/MeasureReport", generated=true)})
public class MeasureReport
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="MeasureReportStatus", strength=BindingStrength.Value.REQUIRED, description="The status of the measure report.", valueSet="http://hl7.org/fhir/ValueSet/measure-report-status|4.0.1")
    @Required
    private final MeasureReportStatus status;
    @Summary
    @Binding(bindingName="MeasureReportType", strength=BindingStrength.Value.REQUIRED, description="The type of the measure report.", valueSet="http://hl7.org/fhir/ValueSet/measure-report-type|4.0.1")
    @Required
    private final MeasureReportType type;
    @Summary
    @Required
    private final Canonical measure;
    @Summary
    @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "Location", "Device", "RelatedPerson", "Group"})
    private final Reference subject;
    @Summary
    private final DateTime date;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Location", "Organization"})
    private final Reference reporter;
    @Summary
    @Required
    private final Period period;
    @Summary
    @Binding(bindingName="MeasureImprovementNotation", strength=BindingStrength.Value.REQUIRED, description="Observation values that indicate what change in a measurement value or score is indicative of an improvement in the measured item or scored issue.", valueSet="http://hl7.org/fhir/ValueSet/measure-improvement-notation|4.0.1")
    private final CodeableConcept improvementNotation;
    private final List<Group> group;
    private final List<Reference> evaluatedResource;

    private MeasureReport(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.type = builder.type;
        this.measure = builder.measure;
        this.subject = builder.subject;
        this.date = builder.date;
        this.reporter = builder.reporter;
        this.period = builder.period;
        this.improvementNotation = builder.improvementNotation;
        this.group = Collections.unmodifiableList(builder.group);
        this.evaluatedResource = Collections.unmodifiableList(builder.evaluatedResource);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public MeasureReportStatus getStatus() {
        return this.status;
    }

    public MeasureReportType getType() {
        return this.type;
    }

    public Canonical getMeasure() {
        return this.measure;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public DateTime getDate() {
        return this.date;
    }

    public Reference getReporter() {
        return this.reporter;
    }

    public Period getPeriod() {
        return this.period;
    }

    public CodeableConcept getImprovementNotation() {
        return this.improvementNotation;
    }

    public List<Group> getGroup() {
        return this.group;
    }

    public List<Reference> getEvaluatedResource() {
        return this.evaluatedResource;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.type != null || this.measure != null || this.subject != null || this.date != null || this.reporter != null || this.period != null || this.improvementNotation != null || !this.group.isEmpty() || !this.evaluatedResource.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.type, "type", visitor);
                this.accept(this.measure, "measure", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.reporter, "reporter", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.improvementNotation, "improvementNotation", visitor);
                this.accept(this.group, "group", visitor, Group.class);
                this.accept(this.evaluatedResource, "evaluatedResource", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MeasureReport other = (MeasureReport)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.type, other.type) && Objects.equals(this.measure, other.measure) && Objects.equals(this.subject, other.subject) && Objects.equals(this.date, other.date) && Objects.equals(this.reporter, other.reporter) && Objects.equals(this.period, other.period) && Objects.equals(this.improvementNotation, other.improvementNotation) && Objects.equals(this.group, other.group) && Objects.equals(this.evaluatedResource, other.evaluatedResource);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.type, this.measure, this.subject, this.date, this.reporter, this.period, this.improvementNotation, this.group, this.evaluatedResource);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Group
    extends BackboneElement {
        @Summary
        private final CodeableConcept code;
        private final List<Population> population;
        @Summary
        private final Quantity measureScore;
        private final List<Stratifier> stratifier;

        private Group(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.population = Collections.unmodifiableList(builder.population);
            this.measureScore = builder.measureScore;
            this.stratifier = Collections.unmodifiableList(builder.stratifier);
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public List<Population> getPopulation() {
            return this.population;
        }

        public Quantity getMeasureScore() {
            return this.measureScore;
        }

        public List<Stratifier> getStratifier() {
            return this.stratifier;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || !this.population.isEmpty() || this.measureScore != null || !this.stratifier.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.population, "population", visitor, Population.class);
                    this.accept(this.measureScore, "measureScore", visitor);
                    this.accept(this.stratifier, "stratifier", visitor, Stratifier.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Group other = (Group)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.population, other.population) && Objects.equals(this.measureScore, other.measureScore) && Objects.equals(this.stratifier, other.stratifier);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.population, this.measureScore, this.stratifier);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Stratifier
        extends BackboneElement {
            private final List<CodeableConcept> code;
            private final List<Stratum> stratum;

            private Stratifier(Builder builder) {
                super(builder);
                this.code = Collections.unmodifiableList(builder.code);
                this.stratum = Collections.unmodifiableList(builder.stratum);
            }

            public List<CodeableConcept> getCode() {
                return this.code;
            }

            public List<Stratum> getStratum() {
                return this.stratum;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || !this.code.isEmpty() || !this.stratum.isEmpty();
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor, CodeableConcept.class);
                        this.accept(this.stratum, "stratum", visitor, Stratum.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Stratifier other = (Stratifier)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.stratum, other.stratum);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.stratum);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Stratum
            extends BackboneElement {
                private final CodeableConcept value;
                private final List<Component> component;
                private final List<Population> population;
                private final Quantity measureScore;

                private Stratum(Builder builder) {
                    super(builder);
                    this.value = builder.value;
                    this.component = Collections.unmodifiableList(builder.component);
                    this.population = Collections.unmodifiableList(builder.population);
                    this.measureScore = builder.measureScore;
                }

                public CodeableConcept getValue() {
                    return this.value;
                }

                public List<Component> getComponent() {
                    return this.component;
                }

                public List<Population> getPopulation() {
                    return this.population;
                }

                public Quantity getMeasureScore() {
                    return this.measureScore;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.value != null || !this.component.isEmpty() || !this.population.isEmpty() || this.measureScore != null;
                }

                @Override
                public void accept(String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.value, "value", visitor);
                            this.accept(this.component, "component", visitor, Component.class);
                            this.accept(this.population, "population", visitor, Population.class);
                            this.accept(this.measureScore, "measureScore", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Stratum other = (Stratum)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.value, other.value) && Objects.equals(this.component, other.component) && Objects.equals(this.population, other.population) && Objects.equals(this.measureScore, other.measureScore);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.value, this.component, this.population, this.measureScore);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Population
                extends BackboneElement {
                    @Binding(bindingName="MeasurePopulation", strength=BindingStrength.Value.EXTENSIBLE, description="The type of population (e.g. initial, numerator, denominator, etc.).", valueSet="http://hl7.org/fhir/ValueSet/measure-population")
                    private final CodeableConcept code;
                    private final Integer count;
                    @ReferenceTarget(value={"List"})
                    private final Reference subjectResults;

                    private Population(Builder builder) {
                        super(builder);
                        this.code = builder.code;
                        this.count = builder.count;
                        this.subjectResults = builder.subjectResults;
                    }

                    public CodeableConcept getCode() {
                        return this.code;
                    }

                    public Integer getCount() {
                        return this.count;
                    }

                    public Reference getSubjectResults() {
                        return this.subjectResults;
                    }

                    @Override
                    public boolean hasChildren() {
                        return super.hasChildren() || this.code != null || this.count != null || this.subjectResults != null;
                    }

                    @Override
                    public void accept(String elementName, int elementIndex, Visitor visitor) {
                        if (visitor.preVisit(this)) {
                            visitor.visitStart(elementName, elementIndex, this);
                            if (visitor.visit(elementName, elementIndex, this)) {
                                this.accept(this.id, "id", visitor);
                                this.accept(this.extension, "extension", visitor, Extension.class);
                                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                                this.accept(this.code, "code", visitor);
                                this.accept(this.count, "count", visitor);
                                this.accept(this.subjectResults, "subjectResults", visitor);
                            }
                            visitor.visitEnd(elementName, elementIndex, this);
                            visitor.postVisit(this);
                        }
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        Population other = (Population)obj;
                        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.count, other.count) && Objects.equals(this.subjectResults, other.subjectResults);
                    }

                    public int hashCode() {
                        int result = this.hashCode;
                        if (result == 0) {
                            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.count, this.subjectResults);
                        }
                        return result;
                    }

                    @Override
                    public Builder toBuilder() {
                        return new Builder().from(this);
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    public static class Builder
                    extends BackboneElement.Builder {
                        private CodeableConcept code;
                        private Integer count;
                        private Reference subjectResults;

                        private Builder() {
                        }

                        @Override
                        public Builder id(String id) {
                            return (Builder)super.id(id);
                        }

                        @Override
                        public Builder extension(Extension ... extension) {
                            return (Builder)super.extension(extension);
                        }

                        @Override
                        public Builder extension(Collection<Extension> extension) {
                            return (Builder)super.extension((Collection)extension);
                        }

                        @Override
                        public Builder modifierExtension(Extension ... modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        @Override
                        public Builder modifierExtension(Collection<Extension> modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        public Builder code(CodeableConcept code) {
                            this.code = code;
                            return this;
                        }

                        public Builder count(Integer count) {
                            this.count = count;
                            return this;
                        }

                        public Builder subjectResults(Reference subjectResults) {
                            this.subjectResults = subjectResults;
                            return this;
                        }

                        @Override
                        public Population build() {
                            Population population = new Population(this);
                            if (this.validating) {
                                this.validate(population);
                            }
                            return population;
                        }

                        protected void validate(Population population) {
                            super.validate(population);
                            ValidationSupport.checkReferenceType(population.subjectResults, "subjectResults", "List");
                            ValidationSupport.requireValueOrChildren(population);
                        }

                        protected Builder from(Population population) {
                            super.from(population);
                            this.code = population.code;
                            this.count = population.count;
                            this.subjectResults = population.subjectResults;
                            return this;
                        }
                    }
                }

                public static class Component
                extends BackboneElement {
                    @Required
                    private final CodeableConcept code;
                    @Required
                    private final CodeableConcept value;

                    private Component(Builder builder) {
                        super(builder);
                        this.code = builder.code;
                        this.value = builder.value;
                    }

                    public CodeableConcept getCode() {
                        return this.code;
                    }

                    public CodeableConcept getValue() {
                        return this.value;
                    }

                    @Override
                    public boolean hasChildren() {
                        return super.hasChildren() || this.code != null || this.value != null;
                    }

                    @Override
                    public void accept(String elementName, int elementIndex, Visitor visitor) {
                        if (visitor.preVisit(this)) {
                            visitor.visitStart(elementName, elementIndex, this);
                            if (visitor.visit(elementName, elementIndex, this)) {
                                this.accept(this.id, "id", visitor);
                                this.accept(this.extension, "extension", visitor, Extension.class);
                                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                                this.accept(this.code, "code", visitor);
                                this.accept(this.value, "value", visitor);
                            }
                            visitor.visitEnd(elementName, elementIndex, this);
                            visitor.postVisit(this);
                        }
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        Component other = (Component)obj;
                        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.value, other.value);
                    }

                    public int hashCode() {
                        int result = this.hashCode;
                        if (result == 0) {
                            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.value);
                        }
                        return result;
                    }

                    @Override
                    public Builder toBuilder() {
                        return new Builder().from(this);
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    public static class Builder
                    extends BackboneElement.Builder {
                        private CodeableConcept code;
                        private CodeableConcept value;

                        private Builder() {
                        }

                        @Override
                        public Builder id(String id) {
                            return (Builder)super.id(id);
                        }

                        @Override
                        public Builder extension(Extension ... extension) {
                            return (Builder)super.extension(extension);
                        }

                        @Override
                        public Builder extension(Collection<Extension> extension) {
                            return (Builder)super.extension((Collection)extension);
                        }

                        @Override
                        public Builder modifierExtension(Extension ... modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        @Override
                        public Builder modifierExtension(Collection<Extension> modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        public Builder code(CodeableConcept code) {
                            this.code = code;
                            return this;
                        }

                        public Builder value(CodeableConcept value) {
                            this.value = value;
                            return this;
                        }

                        @Override
                        public Component build() {
                            Component component = new Component(this);
                            if (this.validating) {
                                this.validate(component);
                            }
                            return component;
                        }

                        protected void validate(Component component) {
                            super.validate(component);
                            ValidationSupport.requireNonNull(component.code, "code");
                            ValidationSupport.requireNonNull(component.value, "value");
                            ValidationSupport.requireValueOrChildren(component);
                        }

                        protected Builder from(Component component) {
                            super.from(component);
                            this.code = component.code;
                            this.value = component.value;
                            return this;
                        }
                    }
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableConcept value;
                    private List<Component> component = new ArrayList<Component>();
                    private List<Population> population = new ArrayList<Population>();
                    private Quantity measureScore;

                    private Builder() {
                    }

                    @Override
                    public Builder id(String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder value(CodeableConcept value) {
                        this.value = value;
                        return this;
                    }

                    public Builder component(Component ... component) {
                        for (Component value : component) {
                            this.component.add(value);
                        }
                        return this;
                    }

                    public Builder component(Collection<Component> component) {
                        this.component = new ArrayList<Component>(component);
                        return this;
                    }

                    public Builder population(Population ... population) {
                        for (Population value : population) {
                            this.population.add(value);
                        }
                        return this;
                    }

                    public Builder population(Collection<Population> population) {
                        this.population = new ArrayList<Population>(population);
                        return this;
                    }

                    public Builder measureScore(Quantity measureScore) {
                        this.measureScore = measureScore;
                        return this;
                    }

                    @Override
                    public Stratum build() {
                        Stratum stratum = new Stratum(this);
                        if (this.validating) {
                            this.validate(stratum);
                        }
                        return stratum;
                    }

                    protected void validate(Stratum stratum) {
                        super.validate(stratum);
                        ValidationSupport.checkList(stratum.component, "component", Component.class);
                        ValidationSupport.checkList(stratum.population, "population", Population.class);
                        ValidationSupport.requireValueOrChildren(stratum);
                    }

                    protected Builder from(Stratum stratum) {
                        super.from(stratum);
                        this.value = stratum.value;
                        this.component.addAll(stratum.component);
                        this.population.addAll(stratum.population);
                        this.measureScore = stratum.measureScore;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private List<CodeableConcept> code = new ArrayList<CodeableConcept>();
                private List<Stratum> stratum = new ArrayList<Stratum>();

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(CodeableConcept ... code) {
                    for (CodeableConcept value : code) {
                        this.code.add(value);
                    }
                    return this;
                }

                public Builder code(Collection<CodeableConcept> code) {
                    this.code = new ArrayList<CodeableConcept>(code);
                    return this;
                }

                public Builder stratum(Stratum ... stratum) {
                    for (Stratum value : stratum) {
                        this.stratum.add(value);
                    }
                    return this;
                }

                public Builder stratum(Collection<Stratum> stratum) {
                    this.stratum = new ArrayList<Stratum>(stratum);
                    return this;
                }

                @Override
                public Stratifier build() {
                    Stratifier stratifier = new Stratifier(this);
                    if (this.validating) {
                        this.validate(stratifier);
                    }
                    return stratifier;
                }

                protected void validate(Stratifier stratifier) {
                    super.validate(stratifier);
                    ValidationSupport.checkList(stratifier.code, "code", CodeableConcept.class);
                    ValidationSupport.checkList(stratifier.stratum, "stratum", Stratum.class);
                    ValidationSupport.requireValueOrChildren(stratifier);
                }

                protected Builder from(Stratifier stratifier) {
                    super.from(stratifier);
                    this.code.addAll(stratifier.code);
                    this.stratum.addAll(stratifier.stratum);
                    return this;
                }
            }
        }

        public static class Population
        extends BackboneElement {
            @Summary
            @Binding(bindingName="MeasurePopulation", strength=BindingStrength.Value.EXTENSIBLE, description="The type of population (e.g. initial, numerator, denominator, etc.).", valueSet="http://hl7.org/fhir/ValueSet/measure-population")
            private final CodeableConcept code;
            private final Integer count;
            @ReferenceTarget(value={"List"})
            private final Reference subjectResults;

            private Population(Builder builder) {
                super(builder);
                this.code = builder.code;
                this.count = builder.count;
                this.subjectResults = builder.subjectResults;
            }

            public CodeableConcept getCode() {
                return this.code;
            }

            public Integer getCount() {
                return this.count;
            }

            public Reference getSubjectResults() {
                return this.subjectResults;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || this.count != null || this.subjectResults != null;
            }

            @Override
            public void accept(String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.count, "count", visitor);
                        this.accept(this.subjectResults, "subjectResults", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Population other = (Population)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.count, other.count) && Objects.equals(this.subjectResults, other.subjectResults);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.count, this.subjectResults);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept code;
                private Integer count;
                private Reference subjectResults;

                private Builder() {
                }

                @Override
                public Builder id(String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(CodeableConcept code) {
                    this.code = code;
                    return this;
                }

                public Builder count(Integer count) {
                    this.count = count;
                    return this;
                }

                public Builder subjectResults(Reference subjectResults) {
                    this.subjectResults = subjectResults;
                    return this;
                }

                @Override
                public Population build() {
                    Population population = new Population(this);
                    if (this.validating) {
                        this.validate(population);
                    }
                    return population;
                }

                protected void validate(Population population) {
                    super.validate(population);
                    ValidationSupport.checkReferenceType(population.subjectResults, "subjectResults", "List");
                    ValidationSupport.requireValueOrChildren(population);
                }

                protected Builder from(Population population) {
                    super.from(population);
                    this.code = population.code;
                    this.count = population.count;
                    this.subjectResults = population.subjectResults;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private List<Population> population = new ArrayList<Population>();
            private Quantity measureScore;
            private List<Stratifier> stratifier = new ArrayList<Stratifier>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder population(Population ... population) {
                for (Population value : population) {
                    this.population.add(value);
                }
                return this;
            }

            public Builder population(Collection<Population> population) {
                this.population = new ArrayList<Population>(population);
                return this;
            }

            public Builder measureScore(Quantity measureScore) {
                this.measureScore = measureScore;
                return this;
            }

            public Builder stratifier(Stratifier ... stratifier) {
                for (Stratifier value : stratifier) {
                    this.stratifier.add(value);
                }
                return this;
            }

            public Builder stratifier(Collection<Stratifier> stratifier) {
                this.stratifier = new ArrayList<Stratifier>(stratifier);
                return this;
            }

            @Override
            public Group build() {
                Group group = new Group(this);
                if (this.validating) {
                    this.validate(group);
                }
                return group;
            }

            protected void validate(Group group) {
                super.validate(group);
                ValidationSupport.checkList(group.population, "population", Population.class);
                ValidationSupport.checkList(group.stratifier, "stratifier", Stratifier.class);
                ValidationSupport.requireValueOrChildren(group);
            }

            protected Builder from(Group group) {
                super.from(group);
                this.code = group.code;
                this.population.addAll(group.population);
                this.measureScore = group.measureScore;
                this.stratifier.addAll(group.stratifier);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private MeasureReportStatus status;
        private MeasureReportType type;
        private Canonical measure;
        private Reference subject;
        private DateTime date;
        private Reference reporter;
        private Period period;
        private CodeableConcept improvementNotation;
        private List<Group> group = new ArrayList<Group>();
        private List<Reference> evaluatedResource = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(MeasureReportStatus status) {
            this.status = status;
            return this;
        }

        public Builder type(MeasureReportType type) {
            this.type = type;
            return this;
        }

        public Builder measure(Canonical measure) {
            this.measure = measure;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder reporter(Reference reporter) {
            this.reporter = reporter;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder improvementNotation(CodeableConcept improvementNotation) {
            this.improvementNotation = improvementNotation;
            return this;
        }

        public Builder group(Group ... group) {
            for (Group value : group) {
                this.group.add(value);
            }
            return this;
        }

        public Builder group(Collection<Group> group) {
            this.group = new ArrayList<Group>(group);
            return this;
        }

        public Builder evaluatedResource(Reference ... evaluatedResource) {
            for (Reference value : evaluatedResource) {
                this.evaluatedResource.add(value);
            }
            return this;
        }

        public Builder evaluatedResource(Collection<Reference> evaluatedResource) {
            this.evaluatedResource = new ArrayList<Reference>(evaluatedResource);
            return this;
        }

        @Override
        public MeasureReport build() {
            MeasureReport measureReport = new MeasureReport(this);
            if (this.validating) {
                this.validate(measureReport);
            }
            return measureReport;
        }

        protected void validate(MeasureReport measureReport) {
            super.validate(measureReport);
            ValidationSupport.checkList(measureReport.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(measureReport.status, "status");
            ValidationSupport.requireNonNull(measureReport.type, "type");
            ValidationSupport.requireNonNull(measureReport.measure, "measure");
            ValidationSupport.requireNonNull(measureReport.period, "period");
            ValidationSupport.checkList(measureReport.group, "group", Group.class);
            ValidationSupport.checkList(measureReport.evaluatedResource, "evaluatedResource", Reference.class);
            ValidationSupport.checkValueSetBinding(measureReport.improvementNotation, "improvementNotation", "http://hl7.org/fhir/ValueSet/measure-improvement-notation", "http://terminology.hl7.org/CodeSystem/measure-improvement-notation", "increase", "decrease");
            ValidationSupport.checkReferenceType(measureReport.subject, "subject", "Patient", "Practitioner", "PractitionerRole", "Location", "Device", "RelatedPerson", "Group");
            ValidationSupport.checkReferenceType(measureReport.reporter, "reporter", "Practitioner", "PractitionerRole", "Location", "Organization");
        }

        protected Builder from(MeasureReport measureReport) {
            super.from(measureReport);
            this.identifier.addAll(measureReport.identifier);
            this.status = measureReport.status;
            this.type = measureReport.type;
            this.measure = measureReport.measure;
            this.subject = measureReport.subject;
            this.date = measureReport.date;
            this.reporter = measureReport.reporter;
            this.period = measureReport.period;
            this.improvementNotation = measureReport.improvementNotation;
            this.group.addAll(measureReport.group);
            this.evaluatedResource.addAll(measureReport.evaluatedResource);
            return this;
        }
    }
}

