/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.MedicationAdministrationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="mad-1", level="Rule", location="MedicationAdministration.dosage", description="SHALL have at least one of dosage.dose or dosage.rate[x]", expression="dose.exists() or rate.exists()", source="http://hl7.org/fhir/StructureDefinition/MedicationAdministration"), @Constraint(id="medicationAdministration-2", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/medication-admin-category", expression="category.exists() implies (category.memberOf('http://hl7.org/fhir/ValueSet/medication-admin-category', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/MedicationAdministration", generated=true)})
public class MedicationAdministration
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    private final List<Uri> instantiates;
    @Summary
    @ReferenceTarget(value={"MedicationAdministration", "Procedure"})
    private final List<Reference> partOf;
    @Summary
    @Binding(bindingName="MedicationAdministrationStatus", strength=BindingStrength.Value.REQUIRED, description="A set of codes indicating the current status of a MedicationAdministration.", valueSet="http://hl7.org/fhir/ValueSet/medication-admin-status|4.0.1")
    @Required
    private final MedicationAdministrationStatus status;
    @Binding(bindingName="MedicationAdministrationNegationReason", strength=BindingStrength.Value.EXAMPLE, description="A set of codes indicating the reason why the MedicationAdministration is negated.", valueSet="http://hl7.org/fhir/ValueSet/reason-medication-not-given-codes")
    private final List<CodeableConcept> statusReason;
    @Binding(bindingName="MedicationAdministrationCategory", strength=BindingStrength.Value.PREFERRED, description="A coded concept describing where the medication administered is expected to occur.", valueSet="http://hl7.org/fhir/ValueSet/medication-admin-category")
    private final CodeableConcept category;
    @Summary
    @ReferenceTarget(value={"Medication"})
    @Choice(value={CodeableConcept.class, Reference.class})
    @Binding(bindingName="MedicationCode", strength=BindingStrength.Value.EXAMPLE, description="Codes identifying substance or product that can be administered.", valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    @Required
    private final Element medication;
    @Summary
    @ReferenceTarget(value={"Patient", "Group"})
    @Required
    private final Reference subject;
    @ReferenceTarget(value={"Encounter", "EpisodeOfCare"})
    private final Reference context;
    private final List<Reference> supportingInformation;
    @Summary
    @Choice(value={DateTime.class, Period.class})
    @Required
    private final Element effective;
    @Summary
    private final List<Performer> performer;
    @Binding(bindingName="MedicationAdministrationReason", strength=BindingStrength.Value.EXAMPLE, description="A set of codes indicating the reason why the MedicationAdministration was made.", valueSet="http://hl7.org/fhir/ValueSet/reason-medication-given-codes")
    private final List<CodeableConcept> reasonCode;
    @ReferenceTarget(value={"Condition", "Observation", "DiagnosticReport"})
    private final List<Reference> reasonReference;
    @ReferenceTarget(value={"MedicationRequest"})
    private final Reference request;
    @ReferenceTarget(value={"Device"})
    private final List<Reference> device;
    private final List<Annotation> note;
    private final Dosage dosage;
    @ReferenceTarget(value={"Provenance"})
    private final List<Reference> eventHistory;

    private MedicationAdministration(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.instantiates = Collections.unmodifiableList(builder.instantiates);
        this.partOf = Collections.unmodifiableList(builder.partOf);
        this.status = builder.status;
        this.statusReason = Collections.unmodifiableList(builder.statusReason);
        this.category = builder.category;
        this.medication = builder.medication;
        this.subject = builder.subject;
        this.context = builder.context;
        this.supportingInformation = Collections.unmodifiableList(builder.supportingInformation);
        this.effective = builder.effective;
        this.performer = Collections.unmodifiableList(builder.performer);
        this.reasonCode = Collections.unmodifiableList(builder.reasonCode);
        this.reasonReference = Collections.unmodifiableList(builder.reasonReference);
        this.request = builder.request;
        this.device = Collections.unmodifiableList(builder.device);
        this.note = Collections.unmodifiableList(builder.note);
        this.dosage = builder.dosage;
        this.eventHistory = Collections.unmodifiableList(builder.eventHistory);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Uri> getInstantiates() {
        return this.instantiates;
    }

    public List<Reference> getPartOf() {
        return this.partOf;
    }

    public MedicationAdministrationStatus getStatus() {
        return this.status;
    }

    public List<CodeableConcept> getStatusReason() {
        return this.statusReason;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public Element getMedication() {
        return this.medication;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getContext() {
        return this.context;
    }

    public List<Reference> getSupportingInformation() {
        return this.supportingInformation;
    }

    public Element getEffective() {
        return this.effective;
    }

    public List<Performer> getPerformer() {
        return this.performer;
    }

    public List<CodeableConcept> getReasonCode() {
        return this.reasonCode;
    }

    public List<Reference> getReasonReference() {
        return this.reasonReference;
    }

    public Reference getRequest() {
        return this.request;
    }

    public List<Reference> getDevice() {
        return this.device;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public Dosage getDosage() {
        return this.dosage;
    }

    public List<Reference> getEventHistory() {
        return this.eventHistory;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.instantiates.isEmpty() || !this.partOf.isEmpty() || this.status != null || !this.statusReason.isEmpty() || this.category != null || this.medication != null || this.subject != null || this.context != null || !this.supportingInformation.isEmpty() || this.effective != null || !this.performer.isEmpty() || !this.reasonCode.isEmpty() || !this.reasonReference.isEmpty() || this.request != null || !this.device.isEmpty() || !this.note.isEmpty() || this.dosage != null || !this.eventHistory.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.instantiates, "instantiates", visitor, Uri.class);
                this.accept(this.partOf, "partOf", visitor, Reference.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.statusReason, "statusReason", visitor, CodeableConcept.class);
                this.accept(this.category, "category", visitor);
                this.accept(this.medication, "medication", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.context, "context", visitor);
                this.accept(this.supportingInformation, "supportingInformation", visitor, Reference.class);
                this.accept(this.effective, "effective", visitor);
                this.accept(this.performer, "performer", visitor, Performer.class);
                this.accept(this.reasonCode, "reasonCode", visitor, CodeableConcept.class);
                this.accept(this.reasonReference, "reasonReference", visitor, Reference.class);
                this.accept(this.request, "request", visitor);
                this.accept(this.device, "device", visitor, Reference.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.dosage, "dosage", visitor);
                this.accept(this.eventHistory, "eventHistory", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicationAdministration other = (MedicationAdministration)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.instantiates, other.instantiates) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.status, other.status) && Objects.equals(this.statusReason, other.statusReason) && Objects.equals(this.category, other.category) && Objects.equals(this.medication, other.medication) && Objects.equals(this.subject, other.subject) && Objects.equals(this.context, other.context) && Objects.equals(this.supportingInformation, other.supportingInformation) && Objects.equals(this.effective, other.effective) && Objects.equals(this.performer, other.performer) && Objects.equals(this.reasonCode, other.reasonCode) && Objects.equals(this.reasonReference, other.reasonReference) && Objects.equals(this.request, other.request) && Objects.equals(this.device, other.device) && Objects.equals(this.note, other.note) && Objects.equals(this.dosage, other.dosage) && Objects.equals(this.eventHistory, other.eventHistory);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.instantiates, this.partOf, this.status, this.statusReason, this.category, this.medication, this.subject, this.context, this.supportingInformation, this.effective, this.performer, this.reasonCode, this.reasonReference, this.request, this.device, this.note, this.dosage, this.eventHistory);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Dosage
    extends BackboneElement {
        private final String text;
        @Binding(bindingName="MedicationAdministrationSite", strength=BindingStrength.Value.EXAMPLE, description="A coded concept describing the site location the medicine enters into or onto the body.", valueSet="http://hl7.org/fhir/ValueSet/approach-site-codes")
        private final CodeableConcept site;
        @Binding(bindingName="RouteOfAdministration", strength=BindingStrength.Value.EXAMPLE, description="A coded concept describing the route or physiological path of administration of a therapeutic agent into or onto the body of a subject.", valueSet="http://hl7.org/fhir/ValueSet/route-codes")
        private final CodeableConcept route;
        @Binding(bindingName="MedicationAdministrationMethod", strength=BindingStrength.Value.EXAMPLE, description="A coded concept describing the technique by which the medicine is administered.", valueSet="http://hl7.org/fhir/ValueSet/administration-method-codes")
        private final CodeableConcept method;
        private final SimpleQuantity dose;
        @Choice(value={Ratio.class, SimpleQuantity.class})
        private final Element rate;

        private Dosage(Builder builder) {
            super(builder);
            this.text = builder.text;
            this.site = builder.site;
            this.route = builder.route;
            this.method = builder.method;
            this.dose = builder.dose;
            this.rate = builder.rate;
        }

        public String getText() {
            return this.text;
        }

        public CodeableConcept getSite() {
            return this.site;
        }

        public CodeableConcept getRoute() {
            return this.route;
        }

        public CodeableConcept getMethod() {
            return this.method;
        }

        public SimpleQuantity getDose() {
            return this.dose;
        }

        public Element getRate() {
            return this.rate;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.text != null || this.site != null || this.route != null || this.method != null || this.dose != null || this.rate != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.text, "text", visitor);
                    this.accept(this.site, "site", visitor);
                    this.accept(this.route, "route", visitor);
                    this.accept(this.method, "method", visitor);
                    this.accept(this.dose, "dose", visitor);
                    this.accept(this.rate, "rate", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Dosage other = (Dosage)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.text, other.text) && Objects.equals(this.site, other.site) && Objects.equals(this.route, other.route) && Objects.equals(this.method, other.method) && Objects.equals(this.dose, other.dose) && Objects.equals(this.rate, other.rate);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.text, this.site, this.route, this.method, this.dose, this.rate);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String text;
            private CodeableConcept site;
            private CodeableConcept route;
            private CodeableConcept method;
            private SimpleQuantity dose;
            private Element rate;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            public Builder site(CodeableConcept site) {
                this.site = site;
                return this;
            }

            public Builder route(CodeableConcept route) {
                this.route = route;
                return this;
            }

            public Builder method(CodeableConcept method) {
                this.method = method;
                return this;
            }

            public Builder dose(SimpleQuantity dose) {
                this.dose = dose;
                return this;
            }

            public Builder rate(Element rate) {
                this.rate = rate;
                return this;
            }

            @Override
            public Dosage build() {
                Dosage dosage = new Dosage(this);
                if (this.validating) {
                    this.validate(dosage);
                }
                return dosage;
            }

            protected void validate(Dosage dosage) {
                super.validate(dosage);
                ValidationSupport.choiceElement(dosage.rate, "rate", Ratio.class, SimpleQuantity.class);
                ValidationSupport.requireValueOrChildren(dosage);
            }

            protected Builder from(Dosage dosage) {
                super.from(dosage);
                this.text = dosage.text;
                this.site = dosage.site;
                this.route = dosage.route;
                this.method = dosage.method;
                this.dose = dosage.dose;
                this.rate = dosage.rate;
                return this;
            }
        }
    }

    public static class Performer
    extends BackboneElement {
        @Binding(bindingName="MedicationAdministrationPerformerFunction", strength=BindingStrength.Value.EXAMPLE, description="A code describing the role an individual played in administering the medication.", valueSet="http://hl7.org/fhir/ValueSet/med-admin-perform-function")
        private final CodeableConcept function;
        @Summary
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Patient", "RelatedPerson", "Device"})
        @Required
        private final Reference actor;

        private Performer(Builder builder) {
            super(builder);
            this.function = builder.function;
            this.actor = builder.actor;
        }

        public CodeableConcept getFunction() {
            return this.function;
        }

        public Reference getActor() {
            return this.actor;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.function != null || this.actor != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.function, "function", visitor);
                    this.accept(this.actor, "actor", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Performer other = (Performer)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.function, other.function) && Objects.equals(this.actor, other.actor);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.function, this.actor);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept function;
            private Reference actor;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder function(CodeableConcept function) {
                this.function = function;
                return this;
            }

            public Builder actor(Reference actor) {
                this.actor = actor;
                return this;
            }

            @Override
            public Performer build() {
                Performer performer = new Performer(this);
                if (this.validating) {
                    this.validate(performer);
                }
                return performer;
            }

            protected void validate(Performer performer) {
                super.validate(performer);
                ValidationSupport.requireNonNull(performer.actor, "actor");
                ValidationSupport.checkReferenceType(performer.actor, "actor", "Practitioner", "PractitionerRole", "Patient", "RelatedPerson", "Device");
                ValidationSupport.requireValueOrChildren(performer);
            }

            protected Builder from(Performer performer) {
                super.from(performer);
                this.function = performer.function;
                this.actor = performer.actor;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Uri> instantiates = new ArrayList<Uri>();
        private List<Reference> partOf = new ArrayList<Reference>();
        private MedicationAdministrationStatus status;
        private List<CodeableConcept> statusReason = new ArrayList<CodeableConcept>();
        private CodeableConcept category;
        private Element medication;
        private Reference subject;
        private Reference context;
        private List<Reference> supportingInformation = new ArrayList<Reference>();
        private Element effective;
        private List<Performer> performer = new ArrayList<Performer>();
        private List<CodeableConcept> reasonCode = new ArrayList<CodeableConcept>();
        private List<Reference> reasonReference = new ArrayList<Reference>();
        private Reference request;
        private List<Reference> device = new ArrayList<Reference>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private Dosage dosage;
        private List<Reference> eventHistory = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder instantiates(Uri ... instantiates) {
            for (Uri value : instantiates) {
                this.instantiates.add(value);
            }
            return this;
        }

        public Builder instantiates(Collection<Uri> instantiates) {
            this.instantiates = new ArrayList<Uri>(instantiates);
            return this;
        }

        public Builder partOf(Reference ... partOf) {
            for (Reference value : partOf) {
                this.partOf.add(value);
            }
            return this;
        }

        public Builder partOf(Collection<Reference> partOf) {
            this.partOf = new ArrayList<Reference>(partOf);
            return this;
        }

        public Builder status(MedicationAdministrationStatus status) {
            this.status = status;
            return this;
        }

        public Builder statusReason(CodeableConcept ... statusReason) {
            for (CodeableConcept value : statusReason) {
                this.statusReason.add(value);
            }
            return this;
        }

        public Builder statusReason(Collection<CodeableConcept> statusReason) {
            this.statusReason = new ArrayList<CodeableConcept>(statusReason);
            return this;
        }

        public Builder category(CodeableConcept category) {
            this.category = category;
            return this;
        }

        public Builder medication(Element medication) {
            this.medication = medication;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder context(Reference context) {
            this.context = context;
            return this;
        }

        public Builder supportingInformation(Reference ... supportingInformation) {
            for (Reference value : supportingInformation) {
                this.supportingInformation.add(value);
            }
            return this;
        }

        public Builder supportingInformation(Collection<Reference> supportingInformation) {
            this.supportingInformation = new ArrayList<Reference>(supportingInformation);
            return this;
        }

        public Builder effective(Element effective) {
            this.effective = effective;
            return this;
        }

        public Builder performer(Performer ... performer) {
            for (Performer value : performer) {
                this.performer.add(value);
            }
            return this;
        }

        public Builder performer(Collection<Performer> performer) {
            this.performer = new ArrayList<Performer>(performer);
            return this;
        }

        public Builder reasonCode(CodeableConcept ... reasonCode) {
            for (CodeableConcept value : reasonCode) {
                this.reasonCode.add(value);
            }
            return this;
        }

        public Builder reasonCode(Collection<CodeableConcept> reasonCode) {
            this.reasonCode = new ArrayList<CodeableConcept>(reasonCode);
            return this;
        }

        public Builder reasonReference(Reference ... reasonReference) {
            for (Reference value : reasonReference) {
                this.reasonReference.add(value);
            }
            return this;
        }

        public Builder reasonReference(Collection<Reference> reasonReference) {
            this.reasonReference = new ArrayList<Reference>(reasonReference);
            return this;
        }

        public Builder request(Reference request) {
            this.request = request;
            return this;
        }

        public Builder device(Reference ... device) {
            for (Reference value : device) {
                this.device.add(value);
            }
            return this;
        }

        public Builder device(Collection<Reference> device) {
            this.device = new ArrayList<Reference>(device);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder dosage(Dosage dosage) {
            this.dosage = dosage;
            return this;
        }

        public Builder eventHistory(Reference ... eventHistory) {
            for (Reference value : eventHistory) {
                this.eventHistory.add(value);
            }
            return this;
        }

        public Builder eventHistory(Collection<Reference> eventHistory) {
            this.eventHistory = new ArrayList<Reference>(eventHistory);
            return this;
        }

        @Override
        public MedicationAdministration build() {
            MedicationAdministration medicationAdministration = new MedicationAdministration(this);
            if (this.validating) {
                this.validate(medicationAdministration);
            }
            return medicationAdministration;
        }

        protected void validate(MedicationAdministration medicationAdministration) {
            super.validate(medicationAdministration);
            ValidationSupport.checkList(medicationAdministration.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(medicationAdministration.instantiates, "instantiates", Uri.class);
            ValidationSupport.checkList(medicationAdministration.partOf, "partOf", Reference.class);
            ValidationSupport.requireNonNull(medicationAdministration.status, "status");
            ValidationSupport.checkList(medicationAdministration.statusReason, "statusReason", CodeableConcept.class);
            ValidationSupport.requireChoiceElement(medicationAdministration.medication, "medication", CodeableConcept.class, Reference.class);
            ValidationSupport.requireNonNull(medicationAdministration.subject, "subject");
            ValidationSupport.checkList(medicationAdministration.supportingInformation, "supportingInformation", Reference.class);
            ValidationSupport.requireChoiceElement(medicationAdministration.effective, "effective", DateTime.class, Period.class);
            ValidationSupport.checkList(medicationAdministration.performer, "performer", Performer.class);
            ValidationSupport.checkList(medicationAdministration.reasonCode, "reasonCode", CodeableConcept.class);
            ValidationSupport.checkList(medicationAdministration.reasonReference, "reasonReference", Reference.class);
            ValidationSupport.checkList(medicationAdministration.device, "device", Reference.class);
            ValidationSupport.checkList(medicationAdministration.note, "note", Annotation.class);
            ValidationSupport.checkList(medicationAdministration.eventHistory, "eventHistory", Reference.class);
            ValidationSupport.checkReferenceType(medicationAdministration.partOf, "partOf", "MedicationAdministration", "Procedure");
            ValidationSupport.checkReferenceType(medicationAdministration.medication, "medication", "Medication");
            ValidationSupport.checkReferenceType(medicationAdministration.subject, "subject", "Patient", "Group");
            ValidationSupport.checkReferenceType(medicationAdministration.context, "context", "Encounter", "EpisodeOfCare");
            ValidationSupport.checkReferenceType(medicationAdministration.reasonReference, "reasonReference", "Condition", "Observation", "DiagnosticReport");
            ValidationSupport.checkReferenceType(medicationAdministration.request, "request", "MedicationRequest");
            ValidationSupport.checkReferenceType(medicationAdministration.device, "device", "Device");
            ValidationSupport.checkReferenceType(medicationAdministration.eventHistory, "eventHistory", "Provenance");
        }

        protected Builder from(MedicationAdministration medicationAdministration) {
            super.from(medicationAdministration);
            this.identifier.addAll(medicationAdministration.identifier);
            this.instantiates.addAll(medicationAdministration.instantiates);
            this.partOf.addAll(medicationAdministration.partOf);
            this.status = medicationAdministration.status;
            this.statusReason.addAll(medicationAdministration.statusReason);
            this.category = medicationAdministration.category;
            this.medication = medicationAdministration.medication;
            this.subject = medicationAdministration.subject;
            this.context = medicationAdministration.context;
            this.supportingInformation.addAll(medicationAdministration.supportingInformation);
            this.effective = medicationAdministration.effective;
            this.performer.addAll(medicationAdministration.performer);
            this.reasonCode.addAll(medicationAdministration.reasonCode);
            this.reasonReference.addAll(medicationAdministration.reasonReference);
            this.request = medicationAdministration.request;
            this.device.addAll(medicationAdministration.device);
            this.note.addAll(medicationAdministration.note);
            this.dosage = medicationAdministration.dosage;
            this.eventHistory.addAll(medicationAdministration.eventHistory);
            return this;
        }
    }
}

