/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Base64Binary;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Dosage;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.MedicationKnowledgeStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class MedicationKnowledge
extends DomainResource {
    @Summary
    @Binding(bindingName="MedicationFormalRepresentation", strength=BindingStrength.Value.EXAMPLE, description="A coded concept that defines the type of a medication.", valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    private final CodeableConcept code;
    @Summary
    @Binding(bindingName="MedicationKnowledgeStatus", strength=BindingStrength.Value.REQUIRED, description="A coded concept defining if the medication is in active use.", valueSet="http://hl7.org/fhir/ValueSet/medicationknowledge-status|4.0.1")
    private final MedicationKnowledgeStatus status;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference manufacturer;
    @Binding(bindingName="MedicationForm", strength=BindingStrength.Value.EXAMPLE, description="A coded concept defining the form of a medication.", valueSet="http://hl7.org/fhir/ValueSet/medication-form-codes")
    private final CodeableConcept doseForm;
    @Summary
    private final SimpleQuantity amount;
    @Summary
    private final List<String> synonym;
    private final List<RelatedMedicationKnowledge> relatedMedicationKnowledge;
    @ReferenceTarget(value={"Medication"})
    private final List<Reference> associatedMedication;
    private final List<CodeableConcept> productType;
    private final List<Monograph> monograph;
    private final List<Ingredient> ingredient;
    private final Markdown preparationInstruction;
    @Binding(bindingName="MedicationRoute", strength=BindingStrength.Value.EXAMPLE, description="A coded concept defining the intended route of administration.", valueSet="http://hl7.org/fhir/ValueSet/route-codes")
    private final List<CodeableConcept> intendedRoute;
    private final List<Cost> cost;
    private final List<MonitoringProgram> monitoringProgram;
    private final List<AdministrationGuidelines> administrationGuidelines;
    private final List<MedicineClassification> medicineClassification;
    private final Packaging packaging;
    private final List<DrugCharacteristic> drugCharacteristic;
    @ReferenceTarget(value={"DetectedIssue"})
    private final List<Reference> contraindication;
    private final List<Regulatory> regulatory;
    private final List<Kinetics> kinetics;

    private MedicationKnowledge(Builder builder) {
        super(builder);
        this.code = builder.code;
        this.status = builder.status;
        this.manufacturer = builder.manufacturer;
        this.doseForm = builder.doseForm;
        this.amount = builder.amount;
        this.synonym = Collections.unmodifiableList(builder.synonym);
        this.relatedMedicationKnowledge = Collections.unmodifiableList(builder.relatedMedicationKnowledge);
        this.associatedMedication = Collections.unmodifiableList(builder.associatedMedication);
        this.productType = Collections.unmodifiableList(builder.productType);
        this.monograph = Collections.unmodifiableList(builder.monograph);
        this.ingredient = Collections.unmodifiableList(builder.ingredient);
        this.preparationInstruction = builder.preparationInstruction;
        this.intendedRoute = Collections.unmodifiableList(builder.intendedRoute);
        this.cost = Collections.unmodifiableList(builder.cost);
        this.monitoringProgram = Collections.unmodifiableList(builder.monitoringProgram);
        this.administrationGuidelines = Collections.unmodifiableList(builder.administrationGuidelines);
        this.medicineClassification = Collections.unmodifiableList(builder.medicineClassification);
        this.packaging = builder.packaging;
        this.drugCharacteristic = Collections.unmodifiableList(builder.drugCharacteristic);
        this.contraindication = Collections.unmodifiableList(builder.contraindication);
        this.regulatory = Collections.unmodifiableList(builder.regulatory);
        this.kinetics = Collections.unmodifiableList(builder.kinetics);
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public MedicationKnowledgeStatus getStatus() {
        return this.status;
    }

    public Reference getManufacturer() {
        return this.manufacturer;
    }

    public CodeableConcept getDoseForm() {
        return this.doseForm;
    }

    public SimpleQuantity getAmount() {
        return this.amount;
    }

    public List<String> getSynonym() {
        return this.synonym;
    }

    public List<RelatedMedicationKnowledge> getRelatedMedicationKnowledge() {
        return this.relatedMedicationKnowledge;
    }

    public List<Reference> getAssociatedMedication() {
        return this.associatedMedication;
    }

    public List<CodeableConcept> getProductType() {
        return this.productType;
    }

    public List<Monograph> getMonograph() {
        return this.monograph;
    }

    public List<Ingredient> getIngredient() {
        return this.ingredient;
    }

    public Markdown getPreparationInstruction() {
        return this.preparationInstruction;
    }

    public List<CodeableConcept> getIntendedRoute() {
        return this.intendedRoute;
    }

    public List<Cost> getCost() {
        return this.cost;
    }

    public List<MonitoringProgram> getMonitoringProgram() {
        return this.monitoringProgram;
    }

    public List<AdministrationGuidelines> getAdministrationGuidelines() {
        return this.administrationGuidelines;
    }

    public List<MedicineClassification> getMedicineClassification() {
        return this.medicineClassification;
    }

    public Packaging getPackaging() {
        return this.packaging;
    }

    public List<DrugCharacteristic> getDrugCharacteristic() {
        return this.drugCharacteristic;
    }

    public List<Reference> getContraindication() {
        return this.contraindication;
    }

    public List<Regulatory> getRegulatory() {
        return this.regulatory;
    }

    public List<Kinetics> getKinetics() {
        return this.kinetics;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.code != null || this.status != null || this.manufacturer != null || this.doseForm != null || this.amount != null || !this.synonym.isEmpty() || !this.relatedMedicationKnowledge.isEmpty() || !this.associatedMedication.isEmpty() || !this.productType.isEmpty() || !this.monograph.isEmpty() || !this.ingredient.isEmpty() || this.preparationInstruction != null || !this.intendedRoute.isEmpty() || !this.cost.isEmpty() || !this.monitoringProgram.isEmpty() || !this.administrationGuidelines.isEmpty() || !this.medicineClassification.isEmpty() || this.packaging != null || !this.drugCharacteristic.isEmpty() || !this.contraindication.isEmpty() || !this.regulatory.isEmpty() || !this.kinetics.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.code, "code", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.manufacturer, "manufacturer", visitor);
                this.accept(this.doseForm, "doseForm", visitor);
                this.accept(this.amount, "amount", visitor);
                this.accept(this.synonym, "synonym", visitor, String.class);
                this.accept(this.relatedMedicationKnowledge, "relatedMedicationKnowledge", visitor, RelatedMedicationKnowledge.class);
                this.accept(this.associatedMedication, "associatedMedication", visitor, Reference.class);
                this.accept(this.productType, "productType", visitor, CodeableConcept.class);
                this.accept(this.monograph, "monograph", visitor, Monograph.class);
                this.accept(this.ingredient, "ingredient", visitor, Ingredient.class);
                this.accept(this.preparationInstruction, "preparationInstruction", visitor);
                this.accept(this.intendedRoute, "intendedRoute", visitor, CodeableConcept.class);
                this.accept(this.cost, "cost", visitor, Cost.class);
                this.accept(this.monitoringProgram, "monitoringProgram", visitor, MonitoringProgram.class);
                this.accept(this.administrationGuidelines, "administrationGuidelines", visitor, AdministrationGuidelines.class);
                this.accept(this.medicineClassification, "medicineClassification", visitor, MedicineClassification.class);
                this.accept(this.packaging, "packaging", visitor);
                this.accept(this.drugCharacteristic, "drugCharacteristic", visitor, DrugCharacteristic.class);
                this.accept(this.contraindication, "contraindication", visitor, Reference.class);
                this.accept(this.regulatory, "regulatory", visitor, Regulatory.class);
                this.accept(this.kinetics, "kinetics", visitor, Kinetics.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicationKnowledge other = (MedicationKnowledge)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.status, other.status) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.doseForm, other.doseForm) && Objects.equals(this.amount, other.amount) && Objects.equals(this.synonym, other.synonym) && Objects.equals(this.relatedMedicationKnowledge, other.relatedMedicationKnowledge) && Objects.equals(this.associatedMedication, other.associatedMedication) && Objects.equals(this.productType, other.productType) && Objects.equals(this.monograph, other.monograph) && Objects.equals(this.ingredient, other.ingredient) && Objects.equals(this.preparationInstruction, other.preparationInstruction) && Objects.equals(this.intendedRoute, other.intendedRoute) && Objects.equals(this.cost, other.cost) && Objects.equals(this.monitoringProgram, other.monitoringProgram) && Objects.equals(this.administrationGuidelines, other.administrationGuidelines) && Objects.equals(this.medicineClassification, other.medicineClassification) && Objects.equals(this.packaging, other.packaging) && Objects.equals(this.drugCharacteristic, other.drugCharacteristic) && Objects.equals(this.contraindication, other.contraindication) && Objects.equals(this.regulatory, other.regulatory) && Objects.equals(this.kinetics, other.kinetics);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.code, this.status, this.manufacturer, this.doseForm, this.amount, this.synonym, this.relatedMedicationKnowledge, this.associatedMedication, this.productType, this.monograph, this.ingredient, this.preparationInstruction, this.intendedRoute, this.cost, this.monitoringProgram, this.administrationGuidelines, this.medicineClassification, this.packaging, this.drugCharacteristic, this.contraindication, this.regulatory, this.kinetics);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Kinetics
    extends BackboneElement {
        private final List<SimpleQuantity> areaUnderCurve;
        private final List<SimpleQuantity> lethalDose50;
        private final Duration halfLifePeriod;

        private Kinetics(Builder builder) {
            super(builder);
            this.areaUnderCurve = Collections.unmodifiableList(builder.areaUnderCurve);
            this.lethalDose50 = Collections.unmodifiableList(builder.lethalDose50);
            this.halfLifePeriod = builder.halfLifePeriod;
        }

        public List<SimpleQuantity> getAreaUnderCurve() {
            return this.areaUnderCurve;
        }

        public List<SimpleQuantity> getLethalDose50() {
            return this.lethalDose50;
        }

        public Duration getHalfLifePeriod() {
            return this.halfLifePeriod;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.areaUnderCurve.isEmpty() || !this.lethalDose50.isEmpty() || this.halfLifePeriod != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.areaUnderCurve, "areaUnderCurve", visitor, SimpleQuantity.class);
                    this.accept(this.lethalDose50, "lethalDose50", visitor, SimpleQuantity.class);
                    this.accept(this.halfLifePeriod, "halfLifePeriod", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Kinetics other = (Kinetics)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.areaUnderCurve, other.areaUnderCurve) && Objects.equals(this.lethalDose50, other.lethalDose50) && Objects.equals(this.halfLifePeriod, other.halfLifePeriod);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.areaUnderCurve, this.lethalDose50, this.halfLifePeriod);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<SimpleQuantity> areaUnderCurve = new ArrayList<SimpleQuantity>();
            private List<SimpleQuantity> lethalDose50 = new ArrayList<SimpleQuantity>();
            private Duration halfLifePeriod;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder areaUnderCurve(SimpleQuantity ... areaUnderCurve) {
                for (SimpleQuantity value : areaUnderCurve) {
                    this.areaUnderCurve.add(value);
                }
                return this;
            }

            public Builder areaUnderCurve(Collection<SimpleQuantity> areaUnderCurve) {
                this.areaUnderCurve = new ArrayList<SimpleQuantity>(areaUnderCurve);
                return this;
            }

            public Builder lethalDose50(SimpleQuantity ... lethalDose50) {
                for (SimpleQuantity value : lethalDose50) {
                    this.lethalDose50.add(value);
                }
                return this;
            }

            public Builder lethalDose50(Collection<SimpleQuantity> lethalDose50) {
                this.lethalDose50 = new ArrayList<SimpleQuantity>(lethalDose50);
                return this;
            }

            public Builder halfLifePeriod(Duration halfLifePeriod) {
                this.halfLifePeriod = halfLifePeriod;
                return this;
            }

            @Override
            public Kinetics build() {
                Kinetics kinetics = new Kinetics(this);
                if (this.validating) {
                    this.validate(kinetics);
                }
                return kinetics;
            }

            protected void validate(Kinetics kinetics) {
                super.validate(kinetics);
                ValidationSupport.checkList(kinetics.areaUnderCurve, "areaUnderCurve", SimpleQuantity.class);
                ValidationSupport.checkList(kinetics.lethalDose50, "lethalDose50", SimpleQuantity.class);
                ValidationSupport.requireValueOrChildren(kinetics);
            }

            protected Builder from(Kinetics kinetics) {
                super.from(kinetics);
                this.areaUnderCurve.addAll(kinetics.areaUnderCurve);
                this.lethalDose50.addAll(kinetics.lethalDose50);
                this.halfLifePeriod = kinetics.halfLifePeriod;
                return this;
            }
        }
    }

    public static class Regulatory
    extends BackboneElement {
        @ReferenceTarget(value={"Organization"})
        @Required
        private final Reference regulatoryAuthority;
        private final List<Substitution> substitution;
        private final List<Schedule> schedule;
        private final MaxDispense maxDispense;

        private Regulatory(Builder builder) {
            super(builder);
            this.regulatoryAuthority = builder.regulatoryAuthority;
            this.substitution = Collections.unmodifiableList(builder.substitution);
            this.schedule = Collections.unmodifiableList(builder.schedule);
            this.maxDispense = builder.maxDispense;
        }

        public Reference getRegulatoryAuthority() {
            return this.regulatoryAuthority;
        }

        public List<Substitution> getSubstitution() {
            return this.substitution;
        }

        public List<Schedule> getSchedule() {
            return this.schedule;
        }

        public MaxDispense getMaxDispense() {
            return this.maxDispense;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.regulatoryAuthority != null || !this.substitution.isEmpty() || !this.schedule.isEmpty() || this.maxDispense != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.regulatoryAuthority, "regulatoryAuthority", visitor);
                    this.accept(this.substitution, "substitution", visitor, Substitution.class);
                    this.accept(this.schedule, "schedule", visitor, Schedule.class);
                    this.accept(this.maxDispense, "maxDispense", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Regulatory other = (Regulatory)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.regulatoryAuthority, other.regulatoryAuthority) && Objects.equals(this.substitution, other.substitution) && Objects.equals(this.schedule, other.schedule) && Objects.equals(this.maxDispense, other.maxDispense);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.regulatoryAuthority, this.substitution, this.schedule, this.maxDispense);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class MaxDispense
        extends BackboneElement {
            @Required
            private final SimpleQuantity quantity;
            private final Duration period;

            private MaxDispense(Builder builder) {
                super(builder);
                this.quantity = builder.quantity;
                this.period = builder.period;
            }

            public SimpleQuantity getQuantity() {
                return this.quantity;
            }

            public Duration getPeriod() {
                return this.period;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.quantity != null || this.period != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.quantity, "quantity", visitor);
                        this.accept(this.period, "period", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                MaxDispense other = (MaxDispense)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.period, other.period);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.quantity, this.period);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private SimpleQuantity quantity;
                private Duration period;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder quantity(SimpleQuantity quantity) {
                    this.quantity = quantity;
                    return this;
                }

                public Builder period(Duration period) {
                    this.period = period;
                    return this;
                }

                @Override
                public MaxDispense build() {
                    MaxDispense maxDispense = new MaxDispense(this);
                    if (this.validating) {
                        this.validate(maxDispense);
                    }
                    return maxDispense;
                }

                protected void validate(MaxDispense maxDispense) {
                    super.validate(maxDispense);
                    ValidationSupport.requireNonNull(maxDispense.quantity, "quantity");
                    ValidationSupport.requireValueOrChildren(maxDispense);
                }

                protected Builder from(MaxDispense maxDispense) {
                    super.from(maxDispense);
                    this.quantity = maxDispense.quantity;
                    this.period = maxDispense.period;
                    return this;
                }
            }
        }

        public static class Schedule
        extends BackboneElement {
            @Required
            private final CodeableConcept schedule;

            private Schedule(Builder builder) {
                super(builder);
                this.schedule = builder.schedule;
            }

            public CodeableConcept getSchedule() {
                return this.schedule;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.schedule != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.schedule, "schedule", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Schedule other = (Schedule)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.schedule, other.schedule);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.schedule);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept schedule;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder schedule(CodeableConcept schedule) {
                    this.schedule = schedule;
                    return this;
                }

                @Override
                public Schedule build() {
                    Schedule schedule = new Schedule(this);
                    if (this.validating) {
                        this.validate(schedule);
                    }
                    return schedule;
                }

                protected void validate(Schedule schedule) {
                    super.validate(schedule);
                    ValidationSupport.requireNonNull(schedule.schedule, "schedule");
                    ValidationSupport.requireValueOrChildren(schedule);
                }

                protected Builder from(Schedule schedule) {
                    super.from(schedule);
                    this.schedule = schedule.schedule;
                    return this;
                }
            }
        }

        public static class Substitution
        extends BackboneElement {
            @Required
            private final CodeableConcept type;
            @Required
            private final Boolean allowed;

            private Substitution(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.allowed = builder.allowed;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public Boolean getAllowed() {
                return this.allowed;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.allowed != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.allowed, "allowed", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Substitution other = (Substitution)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.allowed, other.allowed);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.allowed);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private Boolean allowed;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder allowed(Boolean allowed) {
                    this.allowed = allowed;
                    return this;
                }

                @Override
                public Substitution build() {
                    Substitution substitution = new Substitution(this);
                    if (this.validating) {
                        this.validate(substitution);
                    }
                    return substitution;
                }

                protected void validate(Substitution substitution) {
                    super.validate(substitution);
                    ValidationSupport.requireNonNull(substitution.type, "type");
                    ValidationSupport.requireNonNull(substitution.allowed, "allowed");
                    ValidationSupport.requireValueOrChildren(substitution);
                }

                protected Builder from(Substitution substitution) {
                    super.from(substitution);
                    this.type = substitution.type;
                    this.allowed = substitution.allowed;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Reference regulatoryAuthority;
            private List<Substitution> substitution = new ArrayList<Substitution>();
            private List<Schedule> schedule = new ArrayList<Schedule>();
            private MaxDispense maxDispense;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder regulatoryAuthority(Reference regulatoryAuthority) {
                this.regulatoryAuthority = regulatoryAuthority;
                return this;
            }

            public Builder substitution(Substitution ... substitution) {
                for (Substitution value : substitution) {
                    this.substitution.add(value);
                }
                return this;
            }

            public Builder substitution(Collection<Substitution> substitution) {
                this.substitution = new ArrayList<Substitution>(substitution);
                return this;
            }

            public Builder schedule(Schedule ... schedule) {
                for (Schedule value : schedule) {
                    this.schedule.add(value);
                }
                return this;
            }

            public Builder schedule(Collection<Schedule> schedule) {
                this.schedule = new ArrayList<Schedule>(schedule);
                return this;
            }

            public Builder maxDispense(MaxDispense maxDispense) {
                this.maxDispense = maxDispense;
                return this;
            }

            @Override
            public Regulatory build() {
                Regulatory regulatory = new Regulatory(this);
                if (this.validating) {
                    this.validate(regulatory);
                }
                return regulatory;
            }

            protected void validate(Regulatory regulatory) {
                super.validate(regulatory);
                ValidationSupport.requireNonNull(regulatory.regulatoryAuthority, "regulatoryAuthority");
                ValidationSupport.checkList(regulatory.substitution, "substitution", Substitution.class);
                ValidationSupport.checkList(regulatory.schedule, "schedule", Schedule.class);
                ValidationSupport.checkReferenceType(regulatory.regulatoryAuthority, "regulatoryAuthority", "Organization");
                ValidationSupport.requireValueOrChildren(regulatory);
            }

            protected Builder from(Regulatory regulatory) {
                super.from(regulatory);
                this.regulatoryAuthority = regulatory.regulatoryAuthority;
                this.substitution.addAll(regulatory.substitution);
                this.schedule.addAll(regulatory.schedule);
                this.maxDispense = regulatory.maxDispense;
                return this;
            }
        }
    }

    public static class DrugCharacteristic
    extends BackboneElement {
        @Binding(bindingName="MedicationCharacteristic", strength=BindingStrength.Value.EXAMPLE, description="A coded concept defining the characteristic types of a medication.", valueSet="http://hl7.org/fhir/ValueSet/medicationknowledge-characteristic")
        private final CodeableConcept type;
        @Choice(value={CodeableConcept.class, String.class, SimpleQuantity.class, Base64Binary.class})
        private final Element value;

        private DrugCharacteristic(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.value = builder.value;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Element getValue() {
            return this.value;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.value != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.value, "value", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DrugCharacteristic other = (DrugCharacteristic)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.value);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Element value;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            @Override
            public DrugCharacteristic build() {
                DrugCharacteristic drugCharacteristic = new DrugCharacteristic(this);
                if (this.validating) {
                    this.validate(drugCharacteristic);
                }
                return drugCharacteristic;
            }

            protected void validate(DrugCharacteristic drugCharacteristic) {
                super.validate(drugCharacteristic);
                ValidationSupport.choiceElement(drugCharacteristic.value, "value", CodeableConcept.class, String.class, SimpleQuantity.class, Base64Binary.class);
                ValidationSupport.requireValueOrChildren(drugCharacteristic);
            }

            protected Builder from(DrugCharacteristic drugCharacteristic) {
                super.from(drugCharacteristic);
                this.type = drugCharacteristic.type;
                this.value = drugCharacteristic.value;
                return this;
            }
        }
    }

    public static class Packaging
    extends BackboneElement {
        @Binding(bindingName="MedicationPackageType", strength=BindingStrength.Value.EXAMPLE, description="A coded concept defining the type of packaging of a medication.", valueSet="http://hl7.org/fhir/ValueSet/medicationknowledge-package-type")
        private final CodeableConcept type;
        private final SimpleQuantity quantity;

        private Packaging(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.quantity = builder.quantity;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public SimpleQuantity getQuantity() {
            return this.quantity;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.quantity != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.quantity, "quantity", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Packaging other = (Packaging)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.quantity, other.quantity);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.quantity);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private SimpleQuantity quantity;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder quantity(SimpleQuantity quantity) {
                this.quantity = quantity;
                return this;
            }

            @Override
            public Packaging build() {
                Packaging packaging = new Packaging(this);
                if (this.validating) {
                    this.validate(packaging);
                }
                return packaging;
            }

            protected void validate(Packaging packaging) {
                super.validate(packaging);
                ValidationSupport.requireValueOrChildren(packaging);
            }

            protected Builder from(Packaging packaging) {
                super.from(packaging);
                this.type = packaging.type;
                this.quantity = packaging.quantity;
                return this;
            }
        }
    }

    public static class MedicineClassification
    extends BackboneElement {
        @Required
        private final CodeableConcept type;
        private final List<CodeableConcept> classification;

        private MedicineClassification(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.classification = Collections.unmodifiableList(builder.classification);
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public List<CodeableConcept> getClassification() {
            return this.classification;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || !this.classification.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.classification, "classification", visitor, CodeableConcept.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MedicineClassification other = (MedicineClassification)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.classification, other.classification);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.classification);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private List<CodeableConcept> classification = new ArrayList<CodeableConcept>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder classification(CodeableConcept ... classification) {
                for (CodeableConcept value : classification) {
                    this.classification.add(value);
                }
                return this;
            }

            public Builder classification(Collection<CodeableConcept> classification) {
                this.classification = new ArrayList<CodeableConcept>(classification);
                return this;
            }

            @Override
            public MedicineClassification build() {
                MedicineClassification medicineClassification = new MedicineClassification(this);
                if (this.validating) {
                    this.validate(medicineClassification);
                }
                return medicineClassification;
            }

            protected void validate(MedicineClassification medicineClassification) {
                super.validate(medicineClassification);
                ValidationSupport.requireNonNull(medicineClassification.type, "type");
                ValidationSupport.checkList(medicineClassification.classification, "classification", CodeableConcept.class);
                ValidationSupport.requireValueOrChildren(medicineClassification);
            }

            protected Builder from(MedicineClassification medicineClassification) {
                super.from(medicineClassification);
                this.type = medicineClassification.type;
                this.classification.addAll(medicineClassification.classification);
                return this;
            }
        }
    }

    public static class AdministrationGuidelines
    extends BackboneElement {
        private final List<Dosage> dosage;
        @ReferenceTarget(value={"ObservationDefinition"})
        @Choice(value={CodeableConcept.class, Reference.class})
        private final Element indication;
        private final List<PatientCharacteristics> patientCharacteristics;

        private AdministrationGuidelines(Builder builder) {
            super(builder);
            this.dosage = Collections.unmodifiableList(builder.dosage);
            this.indication = builder.indication;
            this.patientCharacteristics = Collections.unmodifiableList(builder.patientCharacteristics);
        }

        public List<Dosage> getDosage() {
            return this.dosage;
        }

        public Element getIndication() {
            return this.indication;
        }

        public List<PatientCharacteristics> getPatientCharacteristics() {
            return this.patientCharacteristics;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.dosage.isEmpty() || this.indication != null || !this.patientCharacteristics.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.dosage, "dosage", visitor, Dosage.class);
                    this.accept(this.indication, "indication", visitor);
                    this.accept(this.patientCharacteristics, "patientCharacteristics", visitor, PatientCharacteristics.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AdministrationGuidelines other = (AdministrationGuidelines)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.dosage, other.dosage) && Objects.equals(this.indication, other.indication) && Objects.equals(this.patientCharacteristics, other.patientCharacteristics);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.dosage, this.indication, this.patientCharacteristics);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class PatientCharacteristics
        extends BackboneElement {
            @Choice(value={CodeableConcept.class, SimpleQuantity.class})
            @Required
            private final Element characteristic;
            private final List<String> value;

            private PatientCharacteristics(Builder builder) {
                super(builder);
                this.characteristic = builder.characteristic;
                this.value = Collections.unmodifiableList(builder.value);
            }

            public Element getCharacteristic() {
                return this.characteristic;
            }

            public List<String> getValue() {
                return this.value;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.characteristic != null || !this.value.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.characteristic, "characteristic", visitor);
                        this.accept(this.value, "value", visitor, String.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                PatientCharacteristics other = (PatientCharacteristics)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.characteristic, other.characteristic) && Objects.equals(this.value, other.value);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.characteristic, this.value);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Element characteristic;
                private List<String> value = new ArrayList<String>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder characteristic(Element characteristic) {
                    this.characteristic = characteristic;
                    return this;
                }

                public Builder value(String ... value) {
                    for (String _value : value) {
                        this.value.add(_value);
                    }
                    return this;
                }

                public Builder value(Collection<String> value) {
                    this.value = new ArrayList<String>(value);
                    return this;
                }

                @Override
                public PatientCharacteristics build() {
                    PatientCharacteristics patientCharacteristics = new PatientCharacteristics(this);
                    if (this.validating) {
                        this.validate(patientCharacteristics);
                    }
                    return patientCharacteristics;
                }

                protected void validate(PatientCharacteristics patientCharacteristics) {
                    super.validate(patientCharacteristics);
                    ValidationSupport.requireChoiceElement(patientCharacteristics.characteristic, "characteristic", CodeableConcept.class, SimpleQuantity.class);
                    ValidationSupport.checkList(patientCharacteristics.value, "value", String.class);
                    ValidationSupport.requireValueOrChildren(patientCharacteristics);
                }

                protected Builder from(PatientCharacteristics patientCharacteristics) {
                    super.from(patientCharacteristics);
                    this.characteristic = patientCharacteristics.characteristic;
                    this.value.addAll(patientCharacteristics.value);
                    return this;
                }
            }
        }

        public static class Dosage
        extends BackboneElement {
            @Required
            private final CodeableConcept type;
            @Required
            private final List<com.ibm.fhir.model.type.Dosage> dosage;

            private Dosage(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.dosage = Collections.unmodifiableList(builder.dosage);
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public List<com.ibm.fhir.model.type.Dosage> getDosage() {
                return this.dosage;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || !this.dosage.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.dosage, "dosage", visitor, com.ibm.fhir.model.type.Dosage.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Dosage other = (Dosage)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.dosage, other.dosage);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.dosage);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private List<com.ibm.fhir.model.type.Dosage> dosage = new ArrayList<com.ibm.fhir.model.type.Dosage>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder dosage(com.ibm.fhir.model.type.Dosage ... dosage) {
                    for (com.ibm.fhir.model.type.Dosage value : dosage) {
                        this.dosage.add(value);
                    }
                    return this;
                }

                public Builder dosage(Collection<com.ibm.fhir.model.type.Dosage> dosage) {
                    this.dosage = new ArrayList<com.ibm.fhir.model.type.Dosage>(dosage);
                    return this;
                }

                @Override
                public Dosage build() {
                    Dosage dosage = new Dosage(this);
                    if (this.validating) {
                        this.validate(dosage);
                    }
                    return dosage;
                }

                protected void validate(Dosage dosage) {
                    super.validate(dosage);
                    ValidationSupport.requireNonNull(dosage.type, "type");
                    ValidationSupport.checkNonEmptyList(dosage.dosage, "dosage", com.ibm.fhir.model.type.Dosage.class);
                    ValidationSupport.requireValueOrChildren(dosage);
                }

                protected Builder from(Dosage dosage) {
                    super.from(dosage);
                    this.type = dosage.type;
                    this.dosage.addAll(dosage.dosage);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Dosage> dosage = new ArrayList<Dosage>();
            private Element indication;
            private List<PatientCharacteristics> patientCharacteristics = new ArrayList<PatientCharacteristics>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder dosage(Dosage ... dosage) {
                for (Dosage value : dosage) {
                    this.dosage.add(value);
                }
                return this;
            }

            public Builder dosage(Collection<Dosage> dosage) {
                this.dosage = new ArrayList<Dosage>(dosage);
                return this;
            }

            public Builder indication(Element indication) {
                this.indication = indication;
                return this;
            }

            public Builder patientCharacteristics(PatientCharacteristics ... patientCharacteristics) {
                for (PatientCharacteristics value : patientCharacteristics) {
                    this.patientCharacteristics.add(value);
                }
                return this;
            }

            public Builder patientCharacteristics(Collection<PatientCharacteristics> patientCharacteristics) {
                this.patientCharacteristics = new ArrayList<PatientCharacteristics>(patientCharacteristics);
                return this;
            }

            @Override
            public AdministrationGuidelines build() {
                AdministrationGuidelines administrationGuidelines = new AdministrationGuidelines(this);
                if (this.validating) {
                    this.validate(administrationGuidelines);
                }
                return administrationGuidelines;
            }

            protected void validate(AdministrationGuidelines administrationGuidelines) {
                super.validate(administrationGuidelines);
                ValidationSupport.checkList(administrationGuidelines.dosage, "dosage", Dosage.class);
                ValidationSupport.choiceElement(administrationGuidelines.indication, "indication", CodeableConcept.class, Reference.class);
                ValidationSupport.checkList(administrationGuidelines.patientCharacteristics, "patientCharacteristics", PatientCharacteristics.class);
                ValidationSupport.checkReferenceType(administrationGuidelines.indication, "indication", "ObservationDefinition");
                ValidationSupport.requireValueOrChildren(administrationGuidelines);
            }

            protected Builder from(AdministrationGuidelines administrationGuidelines) {
                super.from(administrationGuidelines);
                this.dosage.addAll(administrationGuidelines.dosage);
                this.indication = administrationGuidelines.indication;
                this.patientCharacteristics.addAll(administrationGuidelines.patientCharacteristics);
                return this;
            }
        }
    }

    public static class MonitoringProgram
    extends BackboneElement {
        private final CodeableConcept type;
        private final String name;

        private MonitoringProgram(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.name = builder.name;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.name != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.name, "name", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MonitoringProgram other = (MonitoringProgram)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.name);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private String name;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            @Override
            public MonitoringProgram build() {
                MonitoringProgram monitoringProgram = new MonitoringProgram(this);
                if (this.validating) {
                    this.validate(monitoringProgram);
                }
                return monitoringProgram;
            }

            protected void validate(MonitoringProgram monitoringProgram) {
                super.validate(monitoringProgram);
                ValidationSupport.requireValueOrChildren(monitoringProgram);
            }

            protected Builder from(MonitoringProgram monitoringProgram) {
                super.from(monitoringProgram);
                this.type = monitoringProgram.type;
                this.name = monitoringProgram.name;
                return this;
            }
        }
    }

    public static class Cost
    extends BackboneElement {
        @Required
        private final CodeableConcept type;
        private final String source;
        @Required
        private final Money cost;

        private Cost(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.source = builder.source;
            this.cost = builder.cost;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public String getSource() {
            return this.source;
        }

        public Money getCost() {
            return this.cost;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.source != null || this.cost != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.source, "source", visitor);
                    this.accept(this.cost, "cost", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Cost other = (Cost)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.source, other.source) && Objects.equals(this.cost, other.cost);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.source, this.cost);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private String source;
            private Money cost;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder source(String source) {
                this.source = source;
                return this;
            }

            public Builder cost(Money cost) {
                this.cost = cost;
                return this;
            }

            @Override
            public Cost build() {
                Cost cost = new Cost(this);
                if (this.validating) {
                    this.validate(cost);
                }
                return cost;
            }

            protected void validate(Cost cost) {
                super.validate(cost);
                ValidationSupport.requireNonNull(cost.type, "type");
                ValidationSupport.requireNonNull(cost.cost, "cost");
                ValidationSupport.requireValueOrChildren(cost);
            }

            protected Builder from(Cost cost) {
                super.from(cost);
                this.type = cost.type;
                this.source = cost.source;
                this.cost = cost.cost;
                return this;
            }
        }
    }

    public static class Ingredient
    extends BackboneElement {
        @ReferenceTarget(value={"Substance"})
        @Choice(value={CodeableConcept.class, Reference.class})
        @Required
        private final Element item;
        private final Boolean isActive;
        private final Ratio strength;

        private Ingredient(Builder builder) {
            super(builder);
            this.item = builder.item;
            this.isActive = builder.isActive;
            this.strength = builder.strength;
        }

        public Element getItem() {
            return this.item;
        }

        public Boolean getIsActive() {
            return this.isActive;
        }

        public Ratio getStrength() {
            return this.strength;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.item != null || this.isActive != null || this.strength != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.item, "item", visitor);
                    this.accept(this.isActive, "isActive", visitor);
                    this.accept(this.strength, "strength", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Ingredient other = (Ingredient)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.item, other.item) && Objects.equals(this.isActive, other.isActive) && Objects.equals(this.strength, other.strength);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.item, this.isActive, this.strength);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Element item;
            private Boolean isActive;
            private Ratio strength;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder item(Element item) {
                this.item = item;
                return this;
            }

            public Builder isActive(Boolean isActive) {
                this.isActive = isActive;
                return this;
            }

            public Builder strength(Ratio strength) {
                this.strength = strength;
                return this;
            }

            @Override
            public Ingredient build() {
                Ingredient ingredient = new Ingredient(this);
                if (this.validating) {
                    this.validate(ingredient);
                }
                return ingredient;
            }

            protected void validate(Ingredient ingredient) {
                super.validate(ingredient);
                ValidationSupport.requireChoiceElement(ingredient.item, "item", CodeableConcept.class, Reference.class);
                ValidationSupport.checkReferenceType(ingredient.item, "item", "Substance");
                ValidationSupport.requireValueOrChildren(ingredient);
            }

            protected Builder from(Ingredient ingredient) {
                super.from(ingredient);
                this.item = ingredient.item;
                this.isActive = ingredient.isActive;
                this.strength = ingredient.strength;
                return this;
            }
        }
    }

    public static class Monograph
    extends BackboneElement {
        private final CodeableConcept type;
        @ReferenceTarget(value={"DocumentReference", "Media"})
        private final Reference source;

        private Monograph(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.source = builder.source;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Reference getSource() {
            return this.source;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.source != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.source, "source", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Monograph other = (Monograph)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.source, other.source);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.source);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private Reference source;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder source(Reference source) {
                this.source = source;
                return this;
            }

            @Override
            public Monograph build() {
                Monograph monograph = new Monograph(this);
                if (this.validating) {
                    this.validate(monograph);
                }
                return monograph;
            }

            protected void validate(Monograph monograph) {
                super.validate(monograph);
                ValidationSupport.checkReferenceType(monograph.source, "source", "DocumentReference", "Media");
                ValidationSupport.requireValueOrChildren(monograph);
            }

            protected Builder from(Monograph monograph) {
                super.from(monograph);
                this.type = monograph.type;
                this.source = monograph.source;
                return this;
            }
        }
    }

    public static class RelatedMedicationKnowledge
    extends BackboneElement {
        @Required
        private final CodeableConcept type;
        @ReferenceTarget(value={"MedicationKnowledge"})
        @Required
        private final List<Reference> reference;

        private RelatedMedicationKnowledge(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.reference = Collections.unmodifiableList(builder.reference);
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public List<Reference> getReference() {
            return this.reference;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || !this.reference.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.reference, "reference", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RelatedMedicationKnowledge other = (RelatedMedicationKnowledge)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.reference, other.reference);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.reference);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private List<Reference> reference = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder reference(Reference ... reference) {
                for (Reference value : reference) {
                    this.reference.add(value);
                }
                return this;
            }

            public Builder reference(Collection<Reference> reference) {
                this.reference = new ArrayList<Reference>(reference);
                return this;
            }

            @Override
            public RelatedMedicationKnowledge build() {
                RelatedMedicationKnowledge relatedMedicationKnowledge = new RelatedMedicationKnowledge(this);
                if (this.validating) {
                    this.validate(relatedMedicationKnowledge);
                }
                return relatedMedicationKnowledge;
            }

            protected void validate(RelatedMedicationKnowledge relatedMedicationKnowledge) {
                super.validate(relatedMedicationKnowledge);
                ValidationSupport.requireNonNull(relatedMedicationKnowledge.type, "type");
                ValidationSupport.checkNonEmptyList(relatedMedicationKnowledge.reference, "reference", Reference.class);
                ValidationSupport.checkReferenceType(relatedMedicationKnowledge.reference, "reference", "MedicationKnowledge");
                ValidationSupport.requireValueOrChildren(relatedMedicationKnowledge);
            }

            protected Builder from(RelatedMedicationKnowledge relatedMedicationKnowledge) {
                super.from(relatedMedicationKnowledge);
                this.type = relatedMedicationKnowledge.type;
                this.reference.addAll(relatedMedicationKnowledge.reference);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private CodeableConcept code;
        private MedicationKnowledgeStatus status;
        private Reference manufacturer;
        private CodeableConcept doseForm;
        private SimpleQuantity amount;
        private List<String> synonym = new ArrayList<String>();
        private List<RelatedMedicationKnowledge> relatedMedicationKnowledge = new ArrayList<RelatedMedicationKnowledge>();
        private List<Reference> associatedMedication = new ArrayList<Reference>();
        private List<CodeableConcept> productType = new ArrayList<CodeableConcept>();
        private List<Monograph> monograph = new ArrayList<Monograph>();
        private List<Ingredient> ingredient = new ArrayList<Ingredient>();
        private Markdown preparationInstruction;
        private List<CodeableConcept> intendedRoute = new ArrayList<CodeableConcept>();
        private List<Cost> cost = new ArrayList<Cost>();
        private List<MonitoringProgram> monitoringProgram = new ArrayList<MonitoringProgram>();
        private List<AdministrationGuidelines> administrationGuidelines = new ArrayList<AdministrationGuidelines>();
        private List<MedicineClassification> medicineClassification = new ArrayList<MedicineClassification>();
        private Packaging packaging;
        private List<DrugCharacteristic> drugCharacteristic = new ArrayList<DrugCharacteristic>();
        private List<Reference> contraindication = new ArrayList<Reference>();
        private List<Regulatory> regulatory = new ArrayList<Regulatory>();
        private List<Kinetics> kinetics = new ArrayList<Kinetics>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder status(MedicationKnowledgeStatus status) {
            this.status = status;
            return this;
        }

        public Builder manufacturer(Reference manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public Builder doseForm(CodeableConcept doseForm) {
            this.doseForm = doseForm;
            return this;
        }

        public Builder amount(SimpleQuantity amount) {
            this.amount = amount;
            return this;
        }

        public Builder synonym(String ... synonym) {
            for (String value : synonym) {
                this.synonym.add(value);
            }
            return this;
        }

        public Builder synonym(Collection<String> synonym) {
            this.synonym = new ArrayList<String>(synonym);
            return this;
        }

        public Builder relatedMedicationKnowledge(RelatedMedicationKnowledge ... relatedMedicationKnowledge) {
            for (RelatedMedicationKnowledge value : relatedMedicationKnowledge) {
                this.relatedMedicationKnowledge.add(value);
            }
            return this;
        }

        public Builder relatedMedicationKnowledge(Collection<RelatedMedicationKnowledge> relatedMedicationKnowledge) {
            this.relatedMedicationKnowledge = new ArrayList<RelatedMedicationKnowledge>(relatedMedicationKnowledge);
            return this;
        }

        public Builder associatedMedication(Reference ... associatedMedication) {
            for (Reference value : associatedMedication) {
                this.associatedMedication.add(value);
            }
            return this;
        }

        public Builder associatedMedication(Collection<Reference> associatedMedication) {
            this.associatedMedication = new ArrayList<Reference>(associatedMedication);
            return this;
        }

        public Builder productType(CodeableConcept ... productType) {
            for (CodeableConcept value : productType) {
                this.productType.add(value);
            }
            return this;
        }

        public Builder productType(Collection<CodeableConcept> productType) {
            this.productType = new ArrayList<CodeableConcept>(productType);
            return this;
        }

        public Builder monograph(Monograph ... monograph) {
            for (Monograph value : monograph) {
                this.monograph.add(value);
            }
            return this;
        }

        public Builder monograph(Collection<Monograph> monograph) {
            this.monograph = new ArrayList<Monograph>(monograph);
            return this;
        }

        public Builder ingredient(Ingredient ... ingredient) {
            for (Ingredient value : ingredient) {
                this.ingredient.add(value);
            }
            return this;
        }

        public Builder ingredient(Collection<Ingredient> ingredient) {
            this.ingredient = new ArrayList<Ingredient>(ingredient);
            return this;
        }

        public Builder preparationInstruction(Markdown preparationInstruction) {
            this.preparationInstruction = preparationInstruction;
            return this;
        }

        public Builder intendedRoute(CodeableConcept ... intendedRoute) {
            for (CodeableConcept value : intendedRoute) {
                this.intendedRoute.add(value);
            }
            return this;
        }

        public Builder intendedRoute(Collection<CodeableConcept> intendedRoute) {
            this.intendedRoute = new ArrayList<CodeableConcept>(intendedRoute);
            return this;
        }

        public Builder cost(Cost ... cost) {
            for (Cost value : cost) {
                this.cost.add(value);
            }
            return this;
        }

        public Builder cost(Collection<Cost> cost) {
            this.cost = new ArrayList<Cost>(cost);
            return this;
        }

        public Builder monitoringProgram(MonitoringProgram ... monitoringProgram) {
            for (MonitoringProgram value : monitoringProgram) {
                this.monitoringProgram.add(value);
            }
            return this;
        }

        public Builder monitoringProgram(Collection<MonitoringProgram> monitoringProgram) {
            this.monitoringProgram = new ArrayList<MonitoringProgram>(monitoringProgram);
            return this;
        }

        public Builder administrationGuidelines(AdministrationGuidelines ... administrationGuidelines) {
            for (AdministrationGuidelines value : administrationGuidelines) {
                this.administrationGuidelines.add(value);
            }
            return this;
        }

        public Builder administrationGuidelines(Collection<AdministrationGuidelines> administrationGuidelines) {
            this.administrationGuidelines = new ArrayList<AdministrationGuidelines>(administrationGuidelines);
            return this;
        }

        public Builder medicineClassification(MedicineClassification ... medicineClassification) {
            for (MedicineClassification value : medicineClassification) {
                this.medicineClassification.add(value);
            }
            return this;
        }

        public Builder medicineClassification(Collection<MedicineClassification> medicineClassification) {
            this.medicineClassification = new ArrayList<MedicineClassification>(medicineClassification);
            return this;
        }

        public Builder packaging(Packaging packaging) {
            this.packaging = packaging;
            return this;
        }

        public Builder drugCharacteristic(DrugCharacteristic ... drugCharacteristic) {
            for (DrugCharacteristic value : drugCharacteristic) {
                this.drugCharacteristic.add(value);
            }
            return this;
        }

        public Builder drugCharacteristic(Collection<DrugCharacteristic> drugCharacteristic) {
            this.drugCharacteristic = new ArrayList<DrugCharacteristic>(drugCharacteristic);
            return this;
        }

        public Builder contraindication(Reference ... contraindication) {
            for (Reference value : contraindication) {
                this.contraindication.add(value);
            }
            return this;
        }

        public Builder contraindication(Collection<Reference> contraindication) {
            this.contraindication = new ArrayList<Reference>(contraindication);
            return this;
        }

        public Builder regulatory(Regulatory ... regulatory) {
            for (Regulatory value : regulatory) {
                this.regulatory.add(value);
            }
            return this;
        }

        public Builder regulatory(Collection<Regulatory> regulatory) {
            this.regulatory = new ArrayList<Regulatory>(regulatory);
            return this;
        }

        public Builder kinetics(Kinetics ... kinetics) {
            for (Kinetics value : kinetics) {
                this.kinetics.add(value);
            }
            return this;
        }

        public Builder kinetics(Collection<Kinetics> kinetics) {
            this.kinetics = new ArrayList<Kinetics>(kinetics);
            return this;
        }

        @Override
        public MedicationKnowledge build() {
            MedicationKnowledge medicationKnowledge = new MedicationKnowledge(this);
            if (this.validating) {
                this.validate(medicationKnowledge);
            }
            return medicationKnowledge;
        }

        protected void validate(MedicationKnowledge medicationKnowledge) {
            super.validate(medicationKnowledge);
            ValidationSupport.checkList(medicationKnowledge.synonym, "synonym", String.class);
            ValidationSupport.checkList(medicationKnowledge.relatedMedicationKnowledge, "relatedMedicationKnowledge", RelatedMedicationKnowledge.class);
            ValidationSupport.checkList(medicationKnowledge.associatedMedication, "associatedMedication", Reference.class);
            ValidationSupport.checkList(medicationKnowledge.productType, "productType", CodeableConcept.class);
            ValidationSupport.checkList(medicationKnowledge.monograph, "monograph", Monograph.class);
            ValidationSupport.checkList(medicationKnowledge.ingredient, "ingredient", Ingredient.class);
            ValidationSupport.checkList(medicationKnowledge.intendedRoute, "intendedRoute", CodeableConcept.class);
            ValidationSupport.checkList(medicationKnowledge.cost, "cost", Cost.class);
            ValidationSupport.checkList(medicationKnowledge.monitoringProgram, "monitoringProgram", MonitoringProgram.class);
            ValidationSupport.checkList(medicationKnowledge.administrationGuidelines, "administrationGuidelines", AdministrationGuidelines.class);
            ValidationSupport.checkList(medicationKnowledge.medicineClassification, "medicineClassification", MedicineClassification.class);
            ValidationSupport.checkList(medicationKnowledge.drugCharacteristic, "drugCharacteristic", DrugCharacteristic.class);
            ValidationSupport.checkList(medicationKnowledge.contraindication, "contraindication", Reference.class);
            ValidationSupport.checkList(medicationKnowledge.regulatory, "regulatory", Regulatory.class);
            ValidationSupport.checkList(medicationKnowledge.kinetics, "kinetics", Kinetics.class);
            ValidationSupport.checkReferenceType(medicationKnowledge.manufacturer, "manufacturer", "Organization");
            ValidationSupport.checkReferenceType(medicationKnowledge.associatedMedication, "associatedMedication", "Medication");
            ValidationSupport.checkReferenceType(medicationKnowledge.contraindication, "contraindication", "DetectedIssue");
        }

        protected Builder from(MedicationKnowledge medicationKnowledge) {
            super.from(medicationKnowledge);
            this.code = medicationKnowledge.code;
            this.status = medicationKnowledge.status;
            this.manufacturer = medicationKnowledge.manufacturer;
            this.doseForm = medicationKnowledge.doseForm;
            this.amount = medicationKnowledge.amount;
            this.synonym.addAll(medicationKnowledge.synonym);
            this.relatedMedicationKnowledge.addAll(medicationKnowledge.relatedMedicationKnowledge);
            this.associatedMedication.addAll(medicationKnowledge.associatedMedication);
            this.productType.addAll(medicationKnowledge.productType);
            this.monograph.addAll(medicationKnowledge.monograph);
            this.ingredient.addAll(medicationKnowledge.ingredient);
            this.preparationInstruction = medicationKnowledge.preparationInstruction;
            this.intendedRoute.addAll(medicationKnowledge.intendedRoute);
            this.cost.addAll(medicationKnowledge.cost);
            this.monitoringProgram.addAll(medicationKnowledge.monitoringProgram);
            this.administrationGuidelines.addAll(medicationKnowledge.administrationGuidelines);
            this.medicineClassification.addAll(medicationKnowledge.medicineClassification);
            this.packaging = medicationKnowledge.packaging;
            this.drugCharacteristic.addAll(medicationKnowledge.drugCharacteristic);
            this.contraindication.addAll(medicationKnowledge.contraindication);
            this.regulatory.addAll(medicationKnowledge.regulatory);
            this.kinetics.addAll(medicationKnowledge.kinetics);
            return this;
        }
    }
}

