/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.MarketingStatus;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class MedicinalProduct
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final CodeableConcept type;
    @Summary
    private final Coding domain;
    @Summary
    private final CodeableConcept combinedPharmaceuticalDoseForm;
    @Summary
    private final CodeableConcept legalStatusOfSupply;
    @Summary
    private final CodeableConcept additionalMonitoringIndicator;
    @Summary
    private final List<String> specialMeasures;
    @Summary
    private final CodeableConcept paediatricUseIndicator;
    @Summary
    private final List<CodeableConcept> productClassification;
    @Summary
    private final List<MarketingStatus> marketingStatus;
    @Summary
    @ReferenceTarget(value={"MedicinalProductPharmaceutical"})
    private final List<Reference> pharmaceuticalProduct;
    @Summary
    @ReferenceTarget(value={"MedicinalProductPackaged"})
    private final List<Reference> packagedMedicinalProduct;
    @Summary
    @ReferenceTarget(value={"DocumentReference"})
    private final List<Reference> attachedDocument;
    @Summary
    @ReferenceTarget(value={"DocumentReference"})
    private final List<Reference> masterFile;
    @Summary
    @ReferenceTarget(value={"Organization", "PractitionerRole"})
    private final List<Reference> contact;
    @Summary
    @ReferenceTarget(value={"ResearchStudy"})
    private final List<Reference> clinicalTrial;
    @Summary
    @Required
    private final List<Name> name;
    @Summary
    private final List<Identifier> crossReference;
    @Summary
    private final List<ManufacturingBusinessOperation> manufacturingBusinessOperation;
    @Summary
    private final List<SpecialDesignation> specialDesignation;

    private MedicinalProduct(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.type = builder.type;
        this.domain = builder.domain;
        this.combinedPharmaceuticalDoseForm = builder.combinedPharmaceuticalDoseForm;
        this.legalStatusOfSupply = builder.legalStatusOfSupply;
        this.additionalMonitoringIndicator = builder.additionalMonitoringIndicator;
        this.specialMeasures = Collections.unmodifiableList(builder.specialMeasures);
        this.paediatricUseIndicator = builder.paediatricUseIndicator;
        this.productClassification = Collections.unmodifiableList(builder.productClassification);
        this.marketingStatus = Collections.unmodifiableList(builder.marketingStatus);
        this.pharmaceuticalProduct = Collections.unmodifiableList(builder.pharmaceuticalProduct);
        this.packagedMedicinalProduct = Collections.unmodifiableList(builder.packagedMedicinalProduct);
        this.attachedDocument = Collections.unmodifiableList(builder.attachedDocument);
        this.masterFile = Collections.unmodifiableList(builder.masterFile);
        this.contact = Collections.unmodifiableList(builder.contact);
        this.clinicalTrial = Collections.unmodifiableList(builder.clinicalTrial);
        this.name = Collections.unmodifiableList(builder.name);
        this.crossReference = Collections.unmodifiableList(builder.crossReference);
        this.manufacturingBusinessOperation = Collections.unmodifiableList(builder.manufacturingBusinessOperation);
        this.specialDesignation = Collections.unmodifiableList(builder.specialDesignation);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Coding getDomain() {
        return this.domain;
    }

    public CodeableConcept getCombinedPharmaceuticalDoseForm() {
        return this.combinedPharmaceuticalDoseForm;
    }

    public CodeableConcept getLegalStatusOfSupply() {
        return this.legalStatusOfSupply;
    }

    public CodeableConcept getAdditionalMonitoringIndicator() {
        return this.additionalMonitoringIndicator;
    }

    public List<String> getSpecialMeasures() {
        return this.specialMeasures;
    }

    public CodeableConcept getPaediatricUseIndicator() {
        return this.paediatricUseIndicator;
    }

    public List<CodeableConcept> getProductClassification() {
        return this.productClassification;
    }

    public List<MarketingStatus> getMarketingStatus() {
        return this.marketingStatus;
    }

    public List<Reference> getPharmaceuticalProduct() {
        return this.pharmaceuticalProduct;
    }

    public List<Reference> getPackagedMedicinalProduct() {
        return this.packagedMedicinalProduct;
    }

    public List<Reference> getAttachedDocument() {
        return this.attachedDocument;
    }

    public List<Reference> getMasterFile() {
        return this.masterFile;
    }

    public List<Reference> getContact() {
        return this.contact;
    }

    public List<Reference> getClinicalTrial() {
        return this.clinicalTrial;
    }

    public List<Name> getName() {
        return this.name;
    }

    public List<Identifier> getCrossReference() {
        return this.crossReference;
    }

    public List<ManufacturingBusinessOperation> getManufacturingBusinessOperation() {
        return this.manufacturingBusinessOperation;
    }

    public List<SpecialDesignation> getSpecialDesignation() {
        return this.specialDesignation;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.type != null || this.domain != null || this.combinedPharmaceuticalDoseForm != null || this.legalStatusOfSupply != null || this.additionalMonitoringIndicator != null || !this.specialMeasures.isEmpty() || this.paediatricUseIndicator != null || !this.productClassification.isEmpty() || !this.marketingStatus.isEmpty() || !this.pharmaceuticalProduct.isEmpty() || !this.packagedMedicinalProduct.isEmpty() || !this.attachedDocument.isEmpty() || !this.masterFile.isEmpty() || !this.contact.isEmpty() || !this.clinicalTrial.isEmpty() || !this.name.isEmpty() || !this.crossReference.isEmpty() || !this.manufacturingBusinessOperation.isEmpty() || !this.specialDesignation.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.domain, "domain", visitor);
                this.accept(this.combinedPharmaceuticalDoseForm, "combinedPharmaceuticalDoseForm", visitor);
                this.accept(this.legalStatusOfSupply, "legalStatusOfSupply", visitor);
                this.accept(this.additionalMonitoringIndicator, "additionalMonitoringIndicator", visitor);
                this.accept(this.specialMeasures, "specialMeasures", visitor, String.class);
                this.accept(this.paediatricUseIndicator, "paediatricUseIndicator", visitor);
                this.accept(this.productClassification, "productClassification", visitor, CodeableConcept.class);
                this.accept(this.marketingStatus, "marketingStatus", visitor, MarketingStatus.class);
                this.accept(this.pharmaceuticalProduct, "pharmaceuticalProduct", visitor, Reference.class);
                this.accept(this.packagedMedicinalProduct, "packagedMedicinalProduct", visitor, Reference.class);
                this.accept(this.attachedDocument, "attachedDocument", visitor, Reference.class);
                this.accept(this.masterFile, "masterFile", visitor, Reference.class);
                this.accept(this.contact, "contact", visitor, Reference.class);
                this.accept(this.clinicalTrial, "clinicalTrial", visitor, Reference.class);
                this.accept(this.name, "name", visitor, Name.class);
                this.accept(this.crossReference, "crossReference", visitor, Identifier.class);
                this.accept(this.manufacturingBusinessOperation, "manufacturingBusinessOperation", visitor, ManufacturingBusinessOperation.class);
                this.accept(this.specialDesignation, "specialDesignation", visitor, SpecialDesignation.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicinalProduct other = (MedicinalProduct)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.domain, other.domain) && Objects.equals(this.combinedPharmaceuticalDoseForm, other.combinedPharmaceuticalDoseForm) && Objects.equals(this.legalStatusOfSupply, other.legalStatusOfSupply) && Objects.equals(this.additionalMonitoringIndicator, other.additionalMonitoringIndicator) && Objects.equals(this.specialMeasures, other.specialMeasures) && Objects.equals(this.paediatricUseIndicator, other.paediatricUseIndicator) && Objects.equals(this.productClassification, other.productClassification) && Objects.equals(this.marketingStatus, other.marketingStatus) && Objects.equals(this.pharmaceuticalProduct, other.pharmaceuticalProduct) && Objects.equals(this.packagedMedicinalProduct, other.packagedMedicinalProduct) && Objects.equals(this.attachedDocument, other.attachedDocument) && Objects.equals(this.masterFile, other.masterFile) && Objects.equals(this.contact, other.contact) && Objects.equals(this.clinicalTrial, other.clinicalTrial) && Objects.equals(this.name, other.name) && Objects.equals(this.crossReference, other.crossReference) && Objects.equals(this.manufacturingBusinessOperation, other.manufacturingBusinessOperation) && Objects.equals(this.specialDesignation, other.specialDesignation);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.type, this.domain, this.combinedPharmaceuticalDoseForm, this.legalStatusOfSupply, this.additionalMonitoringIndicator, this.specialMeasures, this.paediatricUseIndicator, this.productClassification, this.marketingStatus, this.pharmaceuticalProduct, this.packagedMedicinalProduct, this.attachedDocument, this.masterFile, this.contact, this.clinicalTrial, this.name, this.crossReference, this.manufacturingBusinessOperation, this.specialDesignation);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class SpecialDesignation
    extends BackboneElement {
        @Summary
        private final List<Identifier> identifier;
        @Summary
        private final CodeableConcept type;
        @Summary
        private final CodeableConcept intendedUse;
        @Summary
        @ReferenceTarget(value={"MedicinalProductIndication"})
        @Choice(value={CodeableConcept.class, Reference.class})
        private final Element indication;
        @Summary
        private final CodeableConcept status;
        @Summary
        private final DateTime date;
        @Summary
        private final CodeableConcept species;

        private SpecialDesignation(Builder builder) {
            super(builder);
            this.identifier = Collections.unmodifiableList(builder.identifier);
            this.type = builder.type;
            this.intendedUse = builder.intendedUse;
            this.indication = builder.indication;
            this.status = builder.status;
            this.date = builder.date;
            this.species = builder.species;
        }

        public List<Identifier> getIdentifier() {
            return this.identifier;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public CodeableConcept getIntendedUse() {
            return this.intendedUse;
        }

        public Element getIndication() {
            return this.indication;
        }

        public CodeableConcept getStatus() {
            return this.status;
        }

        public DateTime getDate() {
            return this.date;
        }

        public CodeableConcept getSpecies() {
            return this.species;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.identifier.isEmpty() || this.type != null || this.intendedUse != null || this.indication != null || this.status != null || this.date != null || this.species != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor, Identifier.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.intendedUse, "intendedUse", visitor);
                    this.accept(this.indication, "indication", visitor);
                    this.accept(this.status, "status", visitor);
                    this.accept(this.date, "date", visitor);
                    this.accept(this.species, "species", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SpecialDesignation other = (SpecialDesignation)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.intendedUse, other.intendedUse) && Objects.equals(this.indication, other.indication) && Objects.equals(this.status, other.status) && Objects.equals(this.date, other.date) && Objects.equals(this.species, other.species);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.type, this.intendedUse, this.indication, this.status, this.date, this.species);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Identifier> identifier = new ArrayList<Identifier>();
            private CodeableConcept type;
            private CodeableConcept intendedUse;
            private Element indication;
            private CodeableConcept status;
            private DateTime date;
            private CodeableConcept species;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Identifier ... identifier) {
                for (Identifier value : identifier) {
                    this.identifier.add(value);
                }
                return this;
            }

            public Builder identifier(Collection<Identifier> identifier) {
                this.identifier = new ArrayList<Identifier>(identifier);
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder intendedUse(CodeableConcept intendedUse) {
                this.intendedUse = intendedUse;
                return this;
            }

            public Builder indication(Element indication) {
                this.indication = indication;
                return this;
            }

            public Builder status(CodeableConcept status) {
                this.status = status;
                return this;
            }

            public Builder date(DateTime date) {
                this.date = date;
                return this;
            }

            public Builder species(CodeableConcept species) {
                this.species = species;
                return this;
            }

            @Override
            public SpecialDesignation build() {
                SpecialDesignation specialDesignation = new SpecialDesignation(this);
                if (this.validating) {
                    this.validate(specialDesignation);
                }
                return specialDesignation;
            }

            protected void validate(SpecialDesignation specialDesignation) {
                super.validate(specialDesignation);
                ValidationSupport.checkList(specialDesignation.identifier, "identifier", Identifier.class);
                ValidationSupport.choiceElement(specialDesignation.indication, "indication", CodeableConcept.class, Reference.class);
                ValidationSupport.checkReferenceType(specialDesignation.indication, "indication", "MedicinalProductIndication");
                ValidationSupport.requireValueOrChildren(specialDesignation);
            }

            protected Builder from(SpecialDesignation specialDesignation) {
                super.from(specialDesignation);
                this.identifier.addAll(specialDesignation.identifier);
                this.type = specialDesignation.type;
                this.intendedUse = specialDesignation.intendedUse;
                this.indication = specialDesignation.indication;
                this.status = specialDesignation.status;
                this.date = specialDesignation.date;
                this.species = specialDesignation.species;
                return this;
            }
        }
    }

    public static class ManufacturingBusinessOperation
    extends BackboneElement {
        @Summary
        private final CodeableConcept operationType;
        @Summary
        private final Identifier authorisationReferenceNumber;
        @Summary
        private final DateTime effectiveDate;
        @Summary
        private final CodeableConcept confidentialityIndicator;
        @Summary
        @ReferenceTarget(value={"Organization"})
        private final List<Reference> manufacturer;
        @Summary
        @ReferenceTarget(value={"Organization"})
        private final Reference regulator;

        private ManufacturingBusinessOperation(Builder builder) {
            super(builder);
            this.operationType = builder.operationType;
            this.authorisationReferenceNumber = builder.authorisationReferenceNumber;
            this.effectiveDate = builder.effectiveDate;
            this.confidentialityIndicator = builder.confidentialityIndicator;
            this.manufacturer = Collections.unmodifiableList(builder.manufacturer);
            this.regulator = builder.regulator;
        }

        public CodeableConcept getOperationType() {
            return this.operationType;
        }

        public Identifier getAuthorisationReferenceNumber() {
            return this.authorisationReferenceNumber;
        }

        public DateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        public CodeableConcept getConfidentialityIndicator() {
            return this.confidentialityIndicator;
        }

        public List<Reference> getManufacturer() {
            return this.manufacturer;
        }

        public Reference getRegulator() {
            return this.regulator;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.operationType != null || this.authorisationReferenceNumber != null || this.effectiveDate != null || this.confidentialityIndicator != null || !this.manufacturer.isEmpty() || this.regulator != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.operationType, "operationType", visitor);
                    this.accept(this.authorisationReferenceNumber, "authorisationReferenceNumber", visitor);
                    this.accept(this.effectiveDate, "effectiveDate", visitor);
                    this.accept(this.confidentialityIndicator, "confidentialityIndicator", visitor);
                    this.accept(this.manufacturer, "manufacturer", visitor, Reference.class);
                    this.accept(this.regulator, "regulator", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ManufacturingBusinessOperation other = (ManufacturingBusinessOperation)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.operationType, other.operationType) && Objects.equals(this.authorisationReferenceNumber, other.authorisationReferenceNumber) && Objects.equals(this.effectiveDate, other.effectiveDate) && Objects.equals(this.confidentialityIndicator, other.confidentialityIndicator) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.regulator, other.regulator);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.operationType, this.authorisationReferenceNumber, this.effectiveDate, this.confidentialityIndicator, this.manufacturer, this.regulator);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept operationType;
            private Identifier authorisationReferenceNumber;
            private DateTime effectiveDate;
            private CodeableConcept confidentialityIndicator;
            private List<Reference> manufacturer = new ArrayList<Reference>();
            private Reference regulator;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder operationType(CodeableConcept operationType) {
                this.operationType = operationType;
                return this;
            }

            public Builder authorisationReferenceNumber(Identifier authorisationReferenceNumber) {
                this.authorisationReferenceNumber = authorisationReferenceNumber;
                return this;
            }

            public Builder effectiveDate(DateTime effectiveDate) {
                this.effectiveDate = effectiveDate;
                return this;
            }

            public Builder confidentialityIndicator(CodeableConcept confidentialityIndicator) {
                this.confidentialityIndicator = confidentialityIndicator;
                return this;
            }

            public Builder manufacturer(Reference ... manufacturer) {
                for (Reference value : manufacturer) {
                    this.manufacturer.add(value);
                }
                return this;
            }

            public Builder manufacturer(Collection<Reference> manufacturer) {
                this.manufacturer = new ArrayList<Reference>(manufacturer);
                return this;
            }

            public Builder regulator(Reference regulator) {
                this.regulator = regulator;
                return this;
            }

            @Override
            public ManufacturingBusinessOperation build() {
                ManufacturingBusinessOperation manufacturingBusinessOperation = new ManufacturingBusinessOperation(this);
                if (this.validating) {
                    this.validate(manufacturingBusinessOperation);
                }
                return manufacturingBusinessOperation;
            }

            protected void validate(ManufacturingBusinessOperation manufacturingBusinessOperation) {
                super.validate(manufacturingBusinessOperation);
                ValidationSupport.checkList(manufacturingBusinessOperation.manufacturer, "manufacturer", Reference.class);
                ValidationSupport.checkReferenceType(manufacturingBusinessOperation.manufacturer, "manufacturer", "Organization");
                ValidationSupport.checkReferenceType(manufacturingBusinessOperation.regulator, "regulator", "Organization");
                ValidationSupport.requireValueOrChildren(manufacturingBusinessOperation);
            }

            protected Builder from(ManufacturingBusinessOperation manufacturingBusinessOperation) {
                super.from(manufacturingBusinessOperation);
                this.operationType = manufacturingBusinessOperation.operationType;
                this.authorisationReferenceNumber = manufacturingBusinessOperation.authorisationReferenceNumber;
                this.effectiveDate = manufacturingBusinessOperation.effectiveDate;
                this.confidentialityIndicator = manufacturingBusinessOperation.confidentialityIndicator;
                this.manufacturer.addAll(manufacturingBusinessOperation.manufacturer);
                this.regulator = manufacturingBusinessOperation.regulator;
                return this;
            }
        }
    }

    public static class Name
    extends BackboneElement {
        @Summary
        @Required
        private final String productName;
        @Summary
        private final List<NamePart> namePart;
        @Summary
        private final List<CountryLanguage> countryLanguage;

        private Name(Builder builder) {
            super(builder);
            this.productName = builder.productName;
            this.namePart = Collections.unmodifiableList(builder.namePart);
            this.countryLanguage = Collections.unmodifiableList(builder.countryLanguage);
        }

        public String getProductName() {
            return this.productName;
        }

        public List<NamePart> getNamePart() {
            return this.namePart;
        }

        public List<CountryLanguage> getCountryLanguage() {
            return this.countryLanguage;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.productName != null || !this.namePart.isEmpty() || !this.countryLanguage.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.productName, "productName", visitor);
                    this.accept(this.namePart, "namePart", visitor, NamePart.class);
                    this.accept(this.countryLanguage, "countryLanguage", visitor, CountryLanguage.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Name other = (Name)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.productName, other.productName) && Objects.equals(this.namePart, other.namePart) && Objects.equals(this.countryLanguage, other.countryLanguage);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.productName, this.namePart, this.countryLanguage);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class CountryLanguage
        extends BackboneElement {
            @Summary
            @Required
            private final CodeableConcept country;
            @Summary
            private final CodeableConcept jurisdiction;
            @Summary
            @Required
            private final CodeableConcept language;

            private CountryLanguage(Builder builder) {
                super(builder);
                this.country = builder.country;
                this.jurisdiction = builder.jurisdiction;
                this.language = builder.language;
            }

            public CodeableConcept getCountry() {
                return this.country;
            }

            public CodeableConcept getJurisdiction() {
                return this.jurisdiction;
            }

            public CodeableConcept getLanguage() {
                return this.language;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.country != null || this.jurisdiction != null || this.language != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.country, "country", visitor);
                        this.accept(this.jurisdiction, "jurisdiction", visitor);
                        this.accept(this.language, "language", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                CountryLanguage other = (CountryLanguage)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.country, other.country) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.language, other.language);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.country, this.jurisdiction, this.language);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept country;
                private CodeableConcept jurisdiction;
                private CodeableConcept language;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder country(CodeableConcept country) {
                    this.country = country;
                    return this;
                }

                public Builder jurisdiction(CodeableConcept jurisdiction) {
                    this.jurisdiction = jurisdiction;
                    return this;
                }

                public Builder language(CodeableConcept language) {
                    this.language = language;
                    return this;
                }

                @Override
                public CountryLanguage build() {
                    CountryLanguage countryLanguage = new CountryLanguage(this);
                    if (this.validating) {
                        this.validate(countryLanguage);
                    }
                    return countryLanguage;
                }

                protected void validate(CountryLanguage countryLanguage) {
                    super.validate(countryLanguage);
                    ValidationSupport.requireNonNull(countryLanguage.country, "country");
                    ValidationSupport.requireNonNull(countryLanguage.language, "language");
                    ValidationSupport.requireValueOrChildren(countryLanguage);
                }

                protected Builder from(CountryLanguage countryLanguage) {
                    super.from(countryLanguage);
                    this.country = countryLanguage.country;
                    this.jurisdiction = countryLanguage.jurisdiction;
                    this.language = countryLanguage.language;
                    return this;
                }
            }
        }

        public static class NamePart
        extends BackboneElement {
            @Summary
            @Required
            private final String part;
            @Summary
            @Required
            private final Coding type;

            private NamePart(Builder builder) {
                super(builder);
                this.part = builder.part;
                this.type = builder.type;
            }

            public String getPart() {
                return this.part;
            }

            public Coding getType() {
                return this.type;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.part != null || this.type != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.part, "part", visitor);
                        this.accept(this.type, "type", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                NamePart other = (NamePart)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.part, other.part) && Objects.equals(this.type, other.type);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.part, this.type);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private String part;
                private Coding type;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder part(String part) {
                    this.part = part;
                    return this;
                }

                public Builder type(Coding type) {
                    this.type = type;
                    return this;
                }

                @Override
                public NamePart build() {
                    NamePart namePart = new NamePart(this);
                    if (this.validating) {
                        this.validate(namePart);
                    }
                    return namePart;
                }

                protected void validate(NamePart namePart) {
                    super.validate(namePart);
                    ValidationSupport.requireNonNull(namePart.part, "part");
                    ValidationSupport.requireNonNull(namePart.type, "type");
                    ValidationSupport.requireValueOrChildren(namePart);
                }

                protected Builder from(NamePart namePart) {
                    super.from(namePart);
                    this.part = namePart.part;
                    this.type = namePart.type;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String productName;
            private List<NamePart> namePart = new ArrayList<NamePart>();
            private List<CountryLanguage> countryLanguage = new ArrayList<CountryLanguage>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder productName(String productName) {
                this.productName = productName;
                return this;
            }

            public Builder namePart(NamePart ... namePart) {
                for (NamePart value : namePart) {
                    this.namePart.add(value);
                }
                return this;
            }

            public Builder namePart(Collection<NamePart> namePart) {
                this.namePart = new ArrayList<NamePart>(namePart);
                return this;
            }

            public Builder countryLanguage(CountryLanguage ... countryLanguage) {
                for (CountryLanguage value : countryLanguage) {
                    this.countryLanguage.add(value);
                }
                return this;
            }

            public Builder countryLanguage(Collection<CountryLanguage> countryLanguage) {
                this.countryLanguage = new ArrayList<CountryLanguage>(countryLanguage);
                return this;
            }

            @Override
            public Name build() {
                Name name = new Name(this);
                if (this.validating) {
                    this.validate(name);
                }
                return name;
            }

            protected void validate(Name name) {
                super.validate(name);
                ValidationSupport.requireNonNull(name.productName, "productName");
                ValidationSupport.checkList(name.namePart, "namePart", NamePart.class);
                ValidationSupport.checkList(name.countryLanguage, "countryLanguage", CountryLanguage.class);
                ValidationSupport.requireValueOrChildren(name);
            }

            protected Builder from(Name name) {
                super.from(name);
                this.productName = name.productName;
                this.namePart.addAll(name.namePart);
                this.countryLanguage.addAll(name.countryLanguage);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private CodeableConcept type;
        private Coding domain;
        private CodeableConcept combinedPharmaceuticalDoseForm;
        private CodeableConcept legalStatusOfSupply;
        private CodeableConcept additionalMonitoringIndicator;
        private List<String> specialMeasures = new ArrayList<String>();
        private CodeableConcept paediatricUseIndicator;
        private List<CodeableConcept> productClassification = new ArrayList<CodeableConcept>();
        private List<MarketingStatus> marketingStatus = new ArrayList<MarketingStatus>();
        private List<Reference> pharmaceuticalProduct = new ArrayList<Reference>();
        private List<Reference> packagedMedicinalProduct = new ArrayList<Reference>();
        private List<Reference> attachedDocument = new ArrayList<Reference>();
        private List<Reference> masterFile = new ArrayList<Reference>();
        private List<Reference> contact = new ArrayList<Reference>();
        private List<Reference> clinicalTrial = new ArrayList<Reference>();
        private List<Name> name = new ArrayList<Name>();
        private List<Identifier> crossReference = new ArrayList<Identifier>();
        private List<ManufacturingBusinessOperation> manufacturingBusinessOperation = new ArrayList<ManufacturingBusinessOperation>();
        private List<SpecialDesignation> specialDesignation = new ArrayList<SpecialDesignation>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder domain(Coding domain) {
            this.domain = domain;
            return this;
        }

        public Builder combinedPharmaceuticalDoseForm(CodeableConcept combinedPharmaceuticalDoseForm) {
            this.combinedPharmaceuticalDoseForm = combinedPharmaceuticalDoseForm;
            return this;
        }

        public Builder legalStatusOfSupply(CodeableConcept legalStatusOfSupply) {
            this.legalStatusOfSupply = legalStatusOfSupply;
            return this;
        }

        public Builder additionalMonitoringIndicator(CodeableConcept additionalMonitoringIndicator) {
            this.additionalMonitoringIndicator = additionalMonitoringIndicator;
            return this;
        }

        public Builder specialMeasures(String ... specialMeasures) {
            for (String value : specialMeasures) {
                this.specialMeasures.add(value);
            }
            return this;
        }

        public Builder specialMeasures(Collection<String> specialMeasures) {
            this.specialMeasures = new ArrayList<String>(specialMeasures);
            return this;
        }

        public Builder paediatricUseIndicator(CodeableConcept paediatricUseIndicator) {
            this.paediatricUseIndicator = paediatricUseIndicator;
            return this;
        }

        public Builder productClassification(CodeableConcept ... productClassification) {
            for (CodeableConcept value : productClassification) {
                this.productClassification.add(value);
            }
            return this;
        }

        public Builder productClassification(Collection<CodeableConcept> productClassification) {
            this.productClassification = new ArrayList<CodeableConcept>(productClassification);
            return this;
        }

        public Builder marketingStatus(MarketingStatus ... marketingStatus) {
            for (MarketingStatus value : marketingStatus) {
                this.marketingStatus.add(value);
            }
            return this;
        }

        public Builder marketingStatus(Collection<MarketingStatus> marketingStatus) {
            this.marketingStatus = new ArrayList<MarketingStatus>(marketingStatus);
            return this;
        }

        public Builder pharmaceuticalProduct(Reference ... pharmaceuticalProduct) {
            for (Reference value : pharmaceuticalProduct) {
                this.pharmaceuticalProduct.add(value);
            }
            return this;
        }

        public Builder pharmaceuticalProduct(Collection<Reference> pharmaceuticalProduct) {
            this.pharmaceuticalProduct = new ArrayList<Reference>(pharmaceuticalProduct);
            return this;
        }

        public Builder packagedMedicinalProduct(Reference ... packagedMedicinalProduct) {
            for (Reference value : packagedMedicinalProduct) {
                this.packagedMedicinalProduct.add(value);
            }
            return this;
        }

        public Builder packagedMedicinalProduct(Collection<Reference> packagedMedicinalProduct) {
            this.packagedMedicinalProduct = new ArrayList<Reference>(packagedMedicinalProduct);
            return this;
        }

        public Builder attachedDocument(Reference ... attachedDocument) {
            for (Reference value : attachedDocument) {
                this.attachedDocument.add(value);
            }
            return this;
        }

        public Builder attachedDocument(Collection<Reference> attachedDocument) {
            this.attachedDocument = new ArrayList<Reference>(attachedDocument);
            return this;
        }

        public Builder masterFile(Reference ... masterFile) {
            for (Reference value : masterFile) {
                this.masterFile.add(value);
            }
            return this;
        }

        public Builder masterFile(Collection<Reference> masterFile) {
            this.masterFile = new ArrayList<Reference>(masterFile);
            return this;
        }

        public Builder contact(Reference ... contact) {
            for (Reference value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<Reference> contact) {
            this.contact = new ArrayList<Reference>(contact);
            return this;
        }

        public Builder clinicalTrial(Reference ... clinicalTrial) {
            for (Reference value : clinicalTrial) {
                this.clinicalTrial.add(value);
            }
            return this;
        }

        public Builder clinicalTrial(Collection<Reference> clinicalTrial) {
            this.clinicalTrial = new ArrayList<Reference>(clinicalTrial);
            return this;
        }

        public Builder name(Name ... name) {
            for (Name value : name) {
                this.name.add(value);
            }
            return this;
        }

        public Builder name(Collection<Name> name) {
            this.name = new ArrayList<Name>(name);
            return this;
        }

        public Builder crossReference(Identifier ... crossReference) {
            for (Identifier value : crossReference) {
                this.crossReference.add(value);
            }
            return this;
        }

        public Builder crossReference(Collection<Identifier> crossReference) {
            this.crossReference = new ArrayList<Identifier>(crossReference);
            return this;
        }

        public Builder manufacturingBusinessOperation(ManufacturingBusinessOperation ... manufacturingBusinessOperation) {
            for (ManufacturingBusinessOperation value : manufacturingBusinessOperation) {
                this.manufacturingBusinessOperation.add(value);
            }
            return this;
        }

        public Builder manufacturingBusinessOperation(Collection<ManufacturingBusinessOperation> manufacturingBusinessOperation) {
            this.manufacturingBusinessOperation = new ArrayList<ManufacturingBusinessOperation>(manufacturingBusinessOperation);
            return this;
        }

        public Builder specialDesignation(SpecialDesignation ... specialDesignation) {
            for (SpecialDesignation value : specialDesignation) {
                this.specialDesignation.add(value);
            }
            return this;
        }

        public Builder specialDesignation(Collection<SpecialDesignation> specialDesignation) {
            this.specialDesignation = new ArrayList<SpecialDesignation>(specialDesignation);
            return this;
        }

        @Override
        public MedicinalProduct build() {
            MedicinalProduct medicinalProduct = new MedicinalProduct(this);
            if (this.validating) {
                this.validate(medicinalProduct);
            }
            return medicinalProduct;
        }

        protected void validate(MedicinalProduct medicinalProduct) {
            super.validate(medicinalProduct);
            ValidationSupport.checkList(medicinalProduct.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(medicinalProduct.specialMeasures, "specialMeasures", String.class);
            ValidationSupport.checkList(medicinalProduct.productClassification, "productClassification", CodeableConcept.class);
            ValidationSupport.checkList(medicinalProduct.marketingStatus, "marketingStatus", MarketingStatus.class);
            ValidationSupport.checkList(medicinalProduct.pharmaceuticalProduct, "pharmaceuticalProduct", Reference.class);
            ValidationSupport.checkList(medicinalProduct.packagedMedicinalProduct, "packagedMedicinalProduct", Reference.class);
            ValidationSupport.checkList(medicinalProduct.attachedDocument, "attachedDocument", Reference.class);
            ValidationSupport.checkList(medicinalProduct.masterFile, "masterFile", Reference.class);
            ValidationSupport.checkList(medicinalProduct.contact, "contact", Reference.class);
            ValidationSupport.checkList(medicinalProduct.clinicalTrial, "clinicalTrial", Reference.class);
            ValidationSupport.checkNonEmptyList(medicinalProduct.name, "name", Name.class);
            ValidationSupport.checkList(medicinalProduct.crossReference, "crossReference", Identifier.class);
            ValidationSupport.checkList(medicinalProduct.manufacturingBusinessOperation, "manufacturingBusinessOperation", ManufacturingBusinessOperation.class);
            ValidationSupport.checkList(medicinalProduct.specialDesignation, "specialDesignation", SpecialDesignation.class);
            ValidationSupport.checkReferenceType(medicinalProduct.pharmaceuticalProduct, "pharmaceuticalProduct", "MedicinalProductPharmaceutical");
            ValidationSupport.checkReferenceType(medicinalProduct.packagedMedicinalProduct, "packagedMedicinalProduct", "MedicinalProductPackaged");
            ValidationSupport.checkReferenceType(medicinalProduct.attachedDocument, "attachedDocument", "DocumentReference");
            ValidationSupport.checkReferenceType(medicinalProduct.masterFile, "masterFile", "DocumentReference");
            ValidationSupport.checkReferenceType(medicinalProduct.contact, "contact", "Organization", "PractitionerRole");
            ValidationSupport.checkReferenceType(medicinalProduct.clinicalTrial, "clinicalTrial", "ResearchStudy");
        }

        protected Builder from(MedicinalProduct medicinalProduct) {
            super.from(medicinalProduct);
            this.identifier.addAll(medicinalProduct.identifier);
            this.type = medicinalProduct.type;
            this.domain = medicinalProduct.domain;
            this.combinedPharmaceuticalDoseForm = medicinalProduct.combinedPharmaceuticalDoseForm;
            this.legalStatusOfSupply = medicinalProduct.legalStatusOfSupply;
            this.additionalMonitoringIndicator = medicinalProduct.additionalMonitoringIndicator;
            this.specialMeasures.addAll(medicinalProduct.specialMeasures);
            this.paediatricUseIndicator = medicinalProduct.paediatricUseIndicator;
            this.productClassification.addAll(medicinalProduct.productClassification);
            this.marketingStatus.addAll(medicinalProduct.marketingStatus);
            this.pharmaceuticalProduct.addAll(medicinalProduct.pharmaceuticalProduct);
            this.packagedMedicinalProduct.addAll(medicinalProduct.packagedMedicinalProduct);
            this.attachedDocument.addAll(medicinalProduct.attachedDocument);
            this.masterFile.addAll(medicinalProduct.masterFile);
            this.contact.addAll(medicinalProduct.contact);
            this.clinicalTrial.addAll(medicinalProduct.clinicalTrial);
            this.name.addAll(medicinalProduct.name);
            this.crossReference.addAll(medicinalProduct.crossReference);
            this.manufacturingBusinessOperation.addAll(medicinalProduct.manufacturingBusinessOperation);
            this.specialDesignation.addAll(medicinalProduct.specialDesignation);
            return this;
        }
    }
}

