/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class MedicinalProductInteraction
extends DomainResource {
    @Summary
    @ReferenceTarget(value={"MedicinalProduct", "Medication", "Substance"})
    private final List<Reference> subject;
    @Summary
    private final String description;
    @Summary
    private final List<Interactant> interactant;
    @Summary
    private final CodeableConcept type;
    @Summary
    private final CodeableConcept effect;
    @Summary
    private final CodeableConcept incidence;
    @Summary
    private final CodeableConcept management;

    private MedicinalProductInteraction(Builder builder) {
        super(builder);
        this.subject = Collections.unmodifiableList(builder.subject);
        this.description = builder.description;
        this.interactant = Collections.unmodifiableList(builder.interactant);
        this.type = builder.type;
        this.effect = builder.effect;
        this.incidence = builder.incidence;
        this.management = builder.management;
    }

    public List<Reference> getSubject() {
        return this.subject;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Interactant> getInteractant() {
        return this.interactant;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public CodeableConcept getEffect() {
        return this.effect;
    }

    public CodeableConcept getIncidence() {
        return this.incidence;
    }

    public CodeableConcept getManagement() {
        return this.management;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.subject.isEmpty() || this.description != null || !this.interactant.isEmpty() || this.type != null || this.effect != null || this.incidence != null || this.management != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.subject, "subject", visitor, Reference.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.interactant, "interactant", visitor, Interactant.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.effect, "effect", visitor);
                this.accept(this.incidence, "incidence", visitor);
                this.accept(this.management, "management", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicinalProductInteraction other = (MedicinalProductInteraction)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.subject, other.subject) && Objects.equals(this.description, other.description) && Objects.equals(this.interactant, other.interactant) && Objects.equals(this.type, other.type) && Objects.equals(this.effect, other.effect) && Objects.equals(this.incidence, other.incidence) && Objects.equals(this.management, other.management);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.subject, this.description, this.interactant, this.type, this.effect, this.incidence, this.management);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Interactant
    extends BackboneElement {
        @Summary
        @ReferenceTarget(value={"MedicinalProduct", "Medication", "Substance", "ObservationDefinition"})
        @Choice(value={Reference.class, CodeableConcept.class})
        @Required
        private final Element item;

        private Interactant(Builder builder) {
            super(builder);
            this.item = builder.item;
        }

        public Element getItem() {
            return this.item;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.item != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.item, "item", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Interactant other = (Interactant)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.item, other.item);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.item);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Element item;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder item(Element item) {
                this.item = item;
                return this;
            }

            @Override
            public Interactant build() {
                Interactant interactant = new Interactant(this);
                if (this.validating) {
                    this.validate(interactant);
                }
                return interactant;
            }

            protected void validate(Interactant interactant) {
                super.validate(interactant);
                ValidationSupport.requireChoiceElement(interactant.item, "item", Reference.class, CodeableConcept.class);
                ValidationSupport.checkReferenceType(interactant.item, "item", "MedicinalProduct", "Medication", "Substance", "ObservationDefinition");
                ValidationSupport.requireValueOrChildren(interactant);
            }

            protected Builder from(Interactant interactant) {
                super.from(interactant);
                this.item = interactant.item;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Reference> subject = new ArrayList<Reference>();
        private String description;
        private List<Interactant> interactant = new ArrayList<Interactant>();
        private CodeableConcept type;
        private CodeableConcept effect;
        private CodeableConcept incidence;
        private CodeableConcept management;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder subject(Reference ... subject) {
            for (Reference value : subject) {
                this.subject.add(value);
            }
            return this;
        }

        public Builder subject(Collection<Reference> subject) {
            this.subject = new ArrayList<Reference>(subject);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder interactant(Interactant ... interactant) {
            for (Interactant value : interactant) {
                this.interactant.add(value);
            }
            return this;
        }

        public Builder interactant(Collection<Interactant> interactant) {
            this.interactant = new ArrayList<Interactant>(interactant);
            return this;
        }

        public Builder type(CodeableConcept type) {
            this.type = type;
            return this;
        }

        public Builder effect(CodeableConcept effect) {
            this.effect = effect;
            return this;
        }

        public Builder incidence(CodeableConcept incidence) {
            this.incidence = incidence;
            return this;
        }

        public Builder management(CodeableConcept management) {
            this.management = management;
            return this;
        }

        @Override
        public MedicinalProductInteraction build() {
            MedicinalProductInteraction medicinalProductInteraction = new MedicinalProductInteraction(this);
            if (this.validating) {
                this.validate(medicinalProductInteraction);
            }
            return medicinalProductInteraction;
        }

        protected void validate(MedicinalProductInteraction medicinalProductInteraction) {
            super.validate(medicinalProductInteraction);
            ValidationSupport.checkList(medicinalProductInteraction.subject, "subject", Reference.class);
            ValidationSupport.checkList(medicinalProductInteraction.interactant, "interactant", Interactant.class);
            ValidationSupport.checkReferenceType(medicinalProductInteraction.subject, "subject", "MedicinalProduct", "Medication", "Substance");
        }

        protected Builder from(MedicinalProductInteraction medicinalProductInteraction) {
            super.from(medicinalProductInteraction);
            this.subject.addAll(medicinalProductInteraction.subject);
            this.description = medicinalProductInteraction.description;
            this.interactant.addAll(medicinalProductInteraction.interactant);
            this.type = medicinalProductInteraction.type;
            this.effect = medicinalProductInteraction.effect;
            this.incidence = medicinalProductInteraction.incidence;
            this.management = medicinalProductInteraction.management;
            return this;
        }
    }
}

