/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.MarketingStatus;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.ProdCharacteristic;
import com.ibm.fhir.model.type.ProductShelfLife;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class MedicinalProductPackaged
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @ReferenceTarget(value={"MedicinalProduct"})
    private final List<Reference> subject;
    @Summary
    private final String description;
    @Summary
    private final CodeableConcept legalStatusOfSupply;
    @Summary
    private final List<MarketingStatus> marketingStatus;
    @Summary
    @ReferenceTarget(value={"MedicinalProductAuthorization"})
    private final Reference marketingAuthorization;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final List<Reference> manufacturer;
    @Summary
    private final List<BatchIdentifier> batchIdentifier;
    @Summary
    @Required
    private final List<PackageItem> packageItem;

    private MedicinalProductPackaged(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.subject = Collections.unmodifiableList(builder.subject);
        this.description = builder.description;
        this.legalStatusOfSupply = builder.legalStatusOfSupply;
        this.marketingStatus = Collections.unmodifiableList(builder.marketingStatus);
        this.marketingAuthorization = builder.marketingAuthorization;
        this.manufacturer = Collections.unmodifiableList(builder.manufacturer);
        this.batchIdentifier = Collections.unmodifiableList(builder.batchIdentifier);
        this.packageItem = Collections.unmodifiableList(builder.packageItem);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Reference> getSubject() {
        return this.subject;
    }

    public String getDescription() {
        return this.description;
    }

    public CodeableConcept getLegalStatusOfSupply() {
        return this.legalStatusOfSupply;
    }

    public List<MarketingStatus> getMarketingStatus() {
        return this.marketingStatus;
    }

    public Reference getMarketingAuthorization() {
        return this.marketingAuthorization;
    }

    public List<Reference> getManufacturer() {
        return this.manufacturer;
    }

    public List<BatchIdentifier> getBatchIdentifier() {
        return this.batchIdentifier;
    }

    public List<PackageItem> getPackageItem() {
        return this.packageItem;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.subject.isEmpty() || this.description != null || this.legalStatusOfSupply != null || !this.marketingStatus.isEmpty() || this.marketingAuthorization != null || !this.manufacturer.isEmpty() || !this.batchIdentifier.isEmpty() || !this.packageItem.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.subject, "subject", visitor, Reference.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.legalStatusOfSupply, "legalStatusOfSupply", visitor);
                this.accept(this.marketingStatus, "marketingStatus", visitor, MarketingStatus.class);
                this.accept(this.marketingAuthorization, "marketingAuthorization", visitor);
                this.accept(this.manufacturer, "manufacturer", visitor, Reference.class);
                this.accept(this.batchIdentifier, "batchIdentifier", visitor, BatchIdentifier.class);
                this.accept(this.packageItem, "packageItem", visitor, PackageItem.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicinalProductPackaged other = (MedicinalProductPackaged)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.subject, other.subject) && Objects.equals(this.description, other.description) && Objects.equals(this.legalStatusOfSupply, other.legalStatusOfSupply) && Objects.equals(this.marketingStatus, other.marketingStatus) && Objects.equals(this.marketingAuthorization, other.marketingAuthorization) && Objects.equals(this.manufacturer, other.manufacturer) && Objects.equals(this.batchIdentifier, other.batchIdentifier) && Objects.equals(this.packageItem, other.packageItem);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.subject, this.description, this.legalStatusOfSupply, this.marketingStatus, this.marketingAuthorization, this.manufacturer, this.batchIdentifier, this.packageItem);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class PackageItem
    extends BackboneElement {
        @Summary
        private final List<Identifier> identifier;
        @Summary
        @Required
        private final CodeableConcept type;
        @Summary
        @Required
        private final Quantity quantity;
        @Summary
        private final List<CodeableConcept> material;
        @Summary
        private final List<CodeableConcept> alternateMaterial;
        @Summary
        @ReferenceTarget(value={"DeviceDefinition"})
        private final List<Reference> device;
        @Summary
        @ReferenceTarget(value={"MedicinalProductManufactured"})
        private final List<Reference> manufacturedItem;
        @Summary
        private final List<PackageItem> packageItem;
        @Summary
        private final ProdCharacteristic physicalCharacteristics;
        @Summary
        private final List<CodeableConcept> otherCharacteristics;
        @Summary
        private final List<ProductShelfLife> shelfLifeStorage;
        @Summary
        @ReferenceTarget(value={"Organization"})
        private final List<Reference> manufacturer;

        private PackageItem(Builder builder) {
            super(builder);
            this.identifier = Collections.unmodifiableList(builder.identifier);
            this.type = builder.type;
            this.quantity = builder.quantity;
            this.material = Collections.unmodifiableList(builder.material);
            this.alternateMaterial = Collections.unmodifiableList(builder.alternateMaterial);
            this.device = Collections.unmodifiableList(builder.device);
            this.manufacturedItem = Collections.unmodifiableList(builder.manufacturedItem);
            this.packageItem = Collections.unmodifiableList(builder.packageItem);
            this.physicalCharacteristics = builder.physicalCharacteristics;
            this.otherCharacteristics = Collections.unmodifiableList(builder.otherCharacteristics);
            this.shelfLifeStorage = Collections.unmodifiableList(builder.shelfLifeStorage);
            this.manufacturer = Collections.unmodifiableList(builder.manufacturer);
        }

        public List<Identifier> getIdentifier() {
            return this.identifier;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Quantity getQuantity() {
            return this.quantity;
        }

        public List<CodeableConcept> getMaterial() {
            return this.material;
        }

        public List<CodeableConcept> getAlternateMaterial() {
            return this.alternateMaterial;
        }

        public List<Reference> getDevice() {
            return this.device;
        }

        public List<Reference> getManufacturedItem() {
            return this.manufacturedItem;
        }

        public List<PackageItem> getPackageItem() {
            return this.packageItem;
        }

        public ProdCharacteristic getPhysicalCharacteristics() {
            return this.physicalCharacteristics;
        }

        public List<CodeableConcept> getOtherCharacteristics() {
            return this.otherCharacteristics;
        }

        public List<ProductShelfLife> getShelfLifeStorage() {
            return this.shelfLifeStorage;
        }

        public List<Reference> getManufacturer() {
            return this.manufacturer;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.identifier.isEmpty() || this.type != null || this.quantity != null || !this.material.isEmpty() || !this.alternateMaterial.isEmpty() || !this.device.isEmpty() || !this.manufacturedItem.isEmpty() || !this.packageItem.isEmpty() || this.physicalCharacteristics != null || !this.otherCharacteristics.isEmpty() || !this.shelfLifeStorage.isEmpty() || !this.manufacturer.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor, Identifier.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.quantity, "quantity", visitor);
                    this.accept(this.material, "material", visitor, CodeableConcept.class);
                    this.accept(this.alternateMaterial, "alternateMaterial", visitor, CodeableConcept.class);
                    this.accept(this.device, "device", visitor, Reference.class);
                    this.accept(this.manufacturedItem, "manufacturedItem", visitor, Reference.class);
                    this.accept(this.packageItem, "packageItem", visitor, PackageItem.class);
                    this.accept(this.physicalCharacteristics, "physicalCharacteristics", visitor);
                    this.accept(this.otherCharacteristics, "otherCharacteristics", visitor, CodeableConcept.class);
                    this.accept(this.shelfLifeStorage, "shelfLifeStorage", visitor, ProductShelfLife.class);
                    this.accept(this.manufacturer, "manufacturer", visitor, Reference.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PackageItem other = (PackageItem)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.type, other.type) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.material, other.material) && Objects.equals(this.alternateMaterial, other.alternateMaterial) && Objects.equals(this.device, other.device) && Objects.equals(this.manufacturedItem, other.manufacturedItem) && Objects.equals(this.packageItem, other.packageItem) && Objects.equals(this.physicalCharacteristics, other.physicalCharacteristics) && Objects.equals(this.otherCharacteristics, other.otherCharacteristics) && Objects.equals(this.shelfLifeStorage, other.shelfLifeStorage) && Objects.equals(this.manufacturer, other.manufacturer);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.type, this.quantity, this.material, this.alternateMaterial, this.device, this.manufacturedItem, this.packageItem, this.physicalCharacteristics, this.otherCharacteristics, this.shelfLifeStorage, this.manufacturer);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Identifier> identifier = new ArrayList<Identifier>();
            private CodeableConcept type;
            private Quantity quantity;
            private List<CodeableConcept> material = new ArrayList<CodeableConcept>();
            private List<CodeableConcept> alternateMaterial = new ArrayList<CodeableConcept>();
            private List<Reference> device = new ArrayList<Reference>();
            private List<Reference> manufacturedItem = new ArrayList<Reference>();
            private List<PackageItem> packageItem = new ArrayList<PackageItem>();
            private ProdCharacteristic physicalCharacteristics;
            private List<CodeableConcept> otherCharacteristics = new ArrayList<CodeableConcept>();
            private List<ProductShelfLife> shelfLifeStorage = new ArrayList<ProductShelfLife>();
            private List<Reference> manufacturer = new ArrayList<Reference>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Identifier ... identifier) {
                for (Identifier value : identifier) {
                    this.identifier.add(value);
                }
                return this;
            }

            public Builder identifier(Collection<Identifier> identifier) {
                this.identifier = new ArrayList<Identifier>(identifier);
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder quantity(Quantity quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder material(CodeableConcept ... material) {
                for (CodeableConcept value : material) {
                    this.material.add(value);
                }
                return this;
            }

            public Builder material(Collection<CodeableConcept> material) {
                this.material = new ArrayList<CodeableConcept>(material);
                return this;
            }

            public Builder alternateMaterial(CodeableConcept ... alternateMaterial) {
                for (CodeableConcept value : alternateMaterial) {
                    this.alternateMaterial.add(value);
                }
                return this;
            }

            public Builder alternateMaterial(Collection<CodeableConcept> alternateMaterial) {
                this.alternateMaterial = new ArrayList<CodeableConcept>(alternateMaterial);
                return this;
            }

            public Builder device(Reference ... device) {
                for (Reference value : device) {
                    this.device.add(value);
                }
                return this;
            }

            public Builder device(Collection<Reference> device) {
                this.device = new ArrayList<Reference>(device);
                return this;
            }

            public Builder manufacturedItem(Reference ... manufacturedItem) {
                for (Reference value : manufacturedItem) {
                    this.manufacturedItem.add(value);
                }
                return this;
            }

            public Builder manufacturedItem(Collection<Reference> manufacturedItem) {
                this.manufacturedItem = new ArrayList<Reference>(manufacturedItem);
                return this;
            }

            public Builder packageItem(PackageItem ... packageItem) {
                for (PackageItem value : packageItem) {
                    this.packageItem.add(value);
                }
                return this;
            }

            public Builder packageItem(Collection<PackageItem> packageItem) {
                this.packageItem = new ArrayList<PackageItem>(packageItem);
                return this;
            }

            public Builder physicalCharacteristics(ProdCharacteristic physicalCharacteristics) {
                this.physicalCharacteristics = physicalCharacteristics;
                return this;
            }

            public Builder otherCharacteristics(CodeableConcept ... otherCharacteristics) {
                for (CodeableConcept value : otherCharacteristics) {
                    this.otherCharacteristics.add(value);
                }
                return this;
            }

            public Builder otherCharacteristics(Collection<CodeableConcept> otherCharacteristics) {
                this.otherCharacteristics = new ArrayList<CodeableConcept>(otherCharacteristics);
                return this;
            }

            public Builder shelfLifeStorage(ProductShelfLife ... shelfLifeStorage) {
                for (ProductShelfLife value : shelfLifeStorage) {
                    this.shelfLifeStorage.add(value);
                }
                return this;
            }

            public Builder shelfLifeStorage(Collection<ProductShelfLife> shelfLifeStorage) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>(shelfLifeStorage);
                return this;
            }

            public Builder manufacturer(Reference ... manufacturer) {
                for (Reference value : manufacturer) {
                    this.manufacturer.add(value);
                }
                return this;
            }

            public Builder manufacturer(Collection<Reference> manufacturer) {
                this.manufacturer = new ArrayList<Reference>(manufacturer);
                return this;
            }

            @Override
            public PackageItem build() {
                PackageItem packageItem = new PackageItem(this);
                if (this.validating) {
                    this.validate(packageItem);
                }
                return packageItem;
            }

            protected void validate(PackageItem packageItem) {
                super.validate(packageItem);
                ValidationSupport.checkList(packageItem.identifier, "identifier", Identifier.class);
                ValidationSupport.requireNonNull(packageItem.type, "type");
                ValidationSupport.requireNonNull(packageItem.quantity, "quantity");
                ValidationSupport.checkList(packageItem.material, "material", CodeableConcept.class);
                ValidationSupport.checkList(packageItem.alternateMaterial, "alternateMaterial", CodeableConcept.class);
                ValidationSupport.checkList(packageItem.device, "device", Reference.class);
                ValidationSupport.checkList(packageItem.manufacturedItem, "manufacturedItem", Reference.class);
                ValidationSupport.checkList(packageItem.packageItem, "packageItem", PackageItem.class);
                ValidationSupport.checkList(packageItem.otherCharacteristics, "otherCharacteristics", CodeableConcept.class);
                ValidationSupport.checkList(packageItem.shelfLifeStorage, "shelfLifeStorage", ProductShelfLife.class);
                ValidationSupport.checkList(packageItem.manufacturer, "manufacturer", Reference.class);
                ValidationSupport.checkReferenceType(packageItem.device, "device", "DeviceDefinition");
                ValidationSupport.checkReferenceType(packageItem.manufacturedItem, "manufacturedItem", "MedicinalProductManufactured");
                ValidationSupport.checkReferenceType(packageItem.manufacturer, "manufacturer", "Organization");
                ValidationSupport.requireValueOrChildren(packageItem);
            }

            protected Builder from(PackageItem packageItem) {
                super.from(packageItem);
                this.identifier.addAll(packageItem.identifier);
                this.type = packageItem.type;
                this.quantity = packageItem.quantity;
                this.material.addAll(packageItem.material);
                this.alternateMaterial.addAll(packageItem.alternateMaterial);
                this.device.addAll(packageItem.device);
                this.manufacturedItem.addAll(packageItem.manufacturedItem);
                this.packageItem.addAll(packageItem.packageItem);
                this.physicalCharacteristics = packageItem.physicalCharacteristics;
                this.otherCharacteristics.addAll(packageItem.otherCharacteristics);
                this.shelfLifeStorage.addAll(packageItem.shelfLifeStorage);
                this.manufacturer.addAll(packageItem.manufacturer);
                return this;
            }
        }
    }

    public static class BatchIdentifier
    extends BackboneElement {
        @Summary
        @Required
        private final Identifier outerPackaging;
        @Summary
        private final Identifier immediatePackaging;

        private BatchIdentifier(Builder builder) {
            super(builder);
            this.outerPackaging = builder.outerPackaging;
            this.immediatePackaging = builder.immediatePackaging;
        }

        public Identifier getOuterPackaging() {
            return this.outerPackaging;
        }

        public Identifier getImmediatePackaging() {
            return this.immediatePackaging;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.outerPackaging != null || this.immediatePackaging != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.outerPackaging, "outerPackaging", visitor);
                    this.accept(this.immediatePackaging, "immediatePackaging", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BatchIdentifier other = (BatchIdentifier)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.outerPackaging, other.outerPackaging) && Objects.equals(this.immediatePackaging, other.immediatePackaging);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.outerPackaging, this.immediatePackaging);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Identifier outerPackaging;
            private Identifier immediatePackaging;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder outerPackaging(Identifier outerPackaging) {
                this.outerPackaging = outerPackaging;
                return this;
            }

            public Builder immediatePackaging(Identifier immediatePackaging) {
                this.immediatePackaging = immediatePackaging;
                return this;
            }

            @Override
            public BatchIdentifier build() {
                BatchIdentifier batchIdentifier = new BatchIdentifier(this);
                if (this.validating) {
                    this.validate(batchIdentifier);
                }
                return batchIdentifier;
            }

            protected void validate(BatchIdentifier batchIdentifier) {
                super.validate(batchIdentifier);
                ValidationSupport.requireNonNull(batchIdentifier.outerPackaging, "outerPackaging");
                ValidationSupport.requireValueOrChildren(batchIdentifier);
            }

            protected Builder from(BatchIdentifier batchIdentifier) {
                super.from(batchIdentifier);
                this.outerPackaging = batchIdentifier.outerPackaging;
                this.immediatePackaging = batchIdentifier.immediatePackaging;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Reference> subject = new ArrayList<Reference>();
        private String description;
        private CodeableConcept legalStatusOfSupply;
        private List<MarketingStatus> marketingStatus = new ArrayList<MarketingStatus>();
        private Reference marketingAuthorization;
        private List<Reference> manufacturer = new ArrayList<Reference>();
        private List<BatchIdentifier> batchIdentifier = new ArrayList<BatchIdentifier>();
        private List<PackageItem> packageItem = new ArrayList<PackageItem>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder subject(Reference ... subject) {
            for (Reference value : subject) {
                this.subject.add(value);
            }
            return this;
        }

        public Builder subject(Collection<Reference> subject) {
            this.subject = new ArrayList<Reference>(subject);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder legalStatusOfSupply(CodeableConcept legalStatusOfSupply) {
            this.legalStatusOfSupply = legalStatusOfSupply;
            return this;
        }

        public Builder marketingStatus(MarketingStatus ... marketingStatus) {
            for (MarketingStatus value : marketingStatus) {
                this.marketingStatus.add(value);
            }
            return this;
        }

        public Builder marketingStatus(Collection<MarketingStatus> marketingStatus) {
            this.marketingStatus = new ArrayList<MarketingStatus>(marketingStatus);
            return this;
        }

        public Builder marketingAuthorization(Reference marketingAuthorization) {
            this.marketingAuthorization = marketingAuthorization;
            return this;
        }

        public Builder manufacturer(Reference ... manufacturer) {
            for (Reference value : manufacturer) {
                this.manufacturer.add(value);
            }
            return this;
        }

        public Builder manufacturer(Collection<Reference> manufacturer) {
            this.manufacturer = new ArrayList<Reference>(manufacturer);
            return this;
        }

        public Builder batchIdentifier(BatchIdentifier ... batchIdentifier) {
            for (BatchIdentifier value : batchIdentifier) {
                this.batchIdentifier.add(value);
            }
            return this;
        }

        public Builder batchIdentifier(Collection<BatchIdentifier> batchIdentifier) {
            this.batchIdentifier = new ArrayList<BatchIdentifier>(batchIdentifier);
            return this;
        }

        public Builder packageItem(PackageItem ... packageItem) {
            for (PackageItem value : packageItem) {
                this.packageItem.add(value);
            }
            return this;
        }

        public Builder packageItem(Collection<PackageItem> packageItem) {
            this.packageItem = new ArrayList<PackageItem>(packageItem);
            return this;
        }

        @Override
        public MedicinalProductPackaged build() {
            MedicinalProductPackaged medicinalProductPackaged = new MedicinalProductPackaged(this);
            if (this.validating) {
                this.validate(medicinalProductPackaged);
            }
            return medicinalProductPackaged;
        }

        protected void validate(MedicinalProductPackaged medicinalProductPackaged) {
            super.validate(medicinalProductPackaged);
            ValidationSupport.checkList(medicinalProductPackaged.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(medicinalProductPackaged.subject, "subject", Reference.class);
            ValidationSupport.checkList(medicinalProductPackaged.marketingStatus, "marketingStatus", MarketingStatus.class);
            ValidationSupport.checkList(medicinalProductPackaged.manufacturer, "manufacturer", Reference.class);
            ValidationSupport.checkList(medicinalProductPackaged.batchIdentifier, "batchIdentifier", BatchIdentifier.class);
            ValidationSupport.checkNonEmptyList(medicinalProductPackaged.packageItem, "packageItem", PackageItem.class);
            ValidationSupport.checkReferenceType(medicinalProductPackaged.subject, "subject", "MedicinalProduct");
            ValidationSupport.checkReferenceType(medicinalProductPackaged.marketingAuthorization, "marketingAuthorization", "MedicinalProductAuthorization");
            ValidationSupport.checkReferenceType(medicinalProductPackaged.manufacturer, "manufacturer", "Organization");
        }

        protected Builder from(MedicinalProductPackaged medicinalProductPackaged) {
            super.from(medicinalProductPackaged);
            this.identifier.addAll(medicinalProductPackaged.identifier);
            this.subject.addAll(medicinalProductPackaged.subject);
            this.description = medicinalProductPackaged.description;
            this.legalStatusOfSupply = medicinalProductPackaged.legalStatusOfSupply;
            this.marketingStatus.addAll(medicinalProductPackaged.marketingStatus);
            this.marketingAuthorization = medicinalProductPackaged.marketingAuthorization;
            this.manufacturer.addAll(medicinalProductPackaged.manufacturer);
            this.batchIdentifier.addAll(medicinalProductPackaged.batchIdentifier);
            this.packageItem.addAll(medicinalProductPackaged.packageItem);
            return this;
        }
    }
}

