/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class MedicinalProductPharmaceutical
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Required
    private final CodeableConcept administrableDoseForm;
    @Summary
    private final CodeableConcept unitOfPresentation;
    @Summary
    @ReferenceTarget(value={"MedicinalProductIngredient"})
    private final List<Reference> ingredient;
    @Summary
    @ReferenceTarget(value={"DeviceDefinition"})
    private final List<Reference> device;
    @Summary
    private final List<Characteristics> characteristics;
    @Summary
    @Required
    private final List<RouteOfAdministration> routeOfAdministration;

    private MedicinalProductPharmaceutical(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.administrableDoseForm = builder.administrableDoseForm;
        this.unitOfPresentation = builder.unitOfPresentation;
        this.ingredient = Collections.unmodifiableList(builder.ingredient);
        this.device = Collections.unmodifiableList(builder.device);
        this.characteristics = Collections.unmodifiableList(builder.characteristics);
        this.routeOfAdministration = Collections.unmodifiableList(builder.routeOfAdministration);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public CodeableConcept getAdministrableDoseForm() {
        return this.administrableDoseForm;
    }

    public CodeableConcept getUnitOfPresentation() {
        return this.unitOfPresentation;
    }

    public List<Reference> getIngredient() {
        return this.ingredient;
    }

    public List<Reference> getDevice() {
        return this.device;
    }

    public List<Characteristics> getCharacteristics() {
        return this.characteristics;
    }

    public List<RouteOfAdministration> getRouteOfAdministration() {
        return this.routeOfAdministration;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.administrableDoseForm != null || this.unitOfPresentation != null || !this.ingredient.isEmpty() || !this.device.isEmpty() || !this.characteristics.isEmpty() || !this.routeOfAdministration.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.administrableDoseForm, "administrableDoseForm", visitor);
                this.accept(this.unitOfPresentation, "unitOfPresentation", visitor);
                this.accept(this.ingredient, "ingredient", visitor, Reference.class);
                this.accept(this.device, "device", visitor, Reference.class);
                this.accept(this.characteristics, "characteristics", visitor, Characteristics.class);
                this.accept(this.routeOfAdministration, "routeOfAdministration", visitor, RouteOfAdministration.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicinalProductPharmaceutical other = (MedicinalProductPharmaceutical)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.administrableDoseForm, other.administrableDoseForm) && Objects.equals(this.unitOfPresentation, other.unitOfPresentation) && Objects.equals(this.ingredient, other.ingredient) && Objects.equals(this.device, other.device) && Objects.equals(this.characteristics, other.characteristics) && Objects.equals(this.routeOfAdministration, other.routeOfAdministration);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.administrableDoseForm, this.unitOfPresentation, this.ingredient, this.device, this.characteristics, this.routeOfAdministration);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class RouteOfAdministration
    extends BackboneElement {
        @Summary
        @Required
        private final CodeableConcept code;
        @Summary
        private final Quantity firstDose;
        @Summary
        private final Quantity maxSingleDose;
        @Summary
        private final Quantity maxDosePerDay;
        @Summary
        private final Ratio maxDosePerTreatmentPeriod;
        @Summary
        private final Duration maxTreatmentPeriod;
        @Summary
        private final List<TargetSpecies> targetSpecies;

        private RouteOfAdministration(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.firstDose = builder.firstDose;
            this.maxSingleDose = builder.maxSingleDose;
            this.maxDosePerDay = builder.maxDosePerDay;
            this.maxDosePerTreatmentPeriod = builder.maxDosePerTreatmentPeriod;
            this.maxTreatmentPeriod = builder.maxTreatmentPeriod;
            this.targetSpecies = Collections.unmodifiableList(builder.targetSpecies);
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public Quantity getFirstDose() {
            return this.firstDose;
        }

        public Quantity getMaxSingleDose() {
            return this.maxSingleDose;
        }

        public Quantity getMaxDosePerDay() {
            return this.maxDosePerDay;
        }

        public Ratio getMaxDosePerTreatmentPeriod() {
            return this.maxDosePerTreatmentPeriod;
        }

        public Duration getMaxTreatmentPeriod() {
            return this.maxTreatmentPeriod;
        }

        public List<TargetSpecies> getTargetSpecies() {
            return this.targetSpecies;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.firstDose != null || this.maxSingleDose != null || this.maxDosePerDay != null || this.maxDosePerTreatmentPeriod != null || this.maxTreatmentPeriod != null || !this.targetSpecies.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.firstDose, "firstDose", visitor);
                    this.accept(this.maxSingleDose, "maxSingleDose", visitor);
                    this.accept(this.maxDosePerDay, "maxDosePerDay", visitor);
                    this.accept(this.maxDosePerTreatmentPeriod, "maxDosePerTreatmentPeriod", visitor);
                    this.accept(this.maxTreatmentPeriod, "maxTreatmentPeriod", visitor);
                    this.accept(this.targetSpecies, "targetSpecies", visitor, TargetSpecies.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RouteOfAdministration other = (RouteOfAdministration)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.firstDose, other.firstDose) && Objects.equals(this.maxSingleDose, other.maxSingleDose) && Objects.equals(this.maxDosePerDay, other.maxDosePerDay) && Objects.equals(this.maxDosePerTreatmentPeriod, other.maxDosePerTreatmentPeriod) && Objects.equals(this.maxTreatmentPeriod, other.maxTreatmentPeriod) && Objects.equals(this.targetSpecies, other.targetSpecies);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.firstDose, this.maxSingleDose, this.maxDosePerDay, this.maxDosePerTreatmentPeriod, this.maxTreatmentPeriod, this.targetSpecies);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class TargetSpecies
        extends BackboneElement {
            @Summary
            @Required
            private final CodeableConcept code;
            @Summary
            private final List<WithdrawalPeriod> withdrawalPeriod;

            private TargetSpecies(Builder builder) {
                super(builder);
                this.code = builder.code;
                this.withdrawalPeriod = Collections.unmodifiableList(builder.withdrawalPeriod);
            }

            public CodeableConcept getCode() {
                return this.code;
            }

            public List<WithdrawalPeriod> getWithdrawalPeriod() {
                return this.withdrawalPeriod;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.code != null || !this.withdrawalPeriod.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.withdrawalPeriod, "withdrawalPeriod", visitor, WithdrawalPeriod.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                TargetSpecies other = (TargetSpecies)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.withdrawalPeriod, other.withdrawalPeriod);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.withdrawalPeriod);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class WithdrawalPeriod
            extends BackboneElement {
                @Summary
                @Required
                private final CodeableConcept tissue;
                @Summary
                @Required
                private final Quantity value;
                @Summary
                private final String supportingInformation;

                private WithdrawalPeriod(Builder builder) {
                    super(builder);
                    this.tissue = builder.tissue;
                    this.value = builder.value;
                    this.supportingInformation = builder.supportingInformation;
                }

                public CodeableConcept getTissue() {
                    return this.tissue;
                }

                public Quantity getValue() {
                    return this.value;
                }

                public String getSupportingInformation() {
                    return this.supportingInformation;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.tissue != null || this.value != null || this.supportingInformation != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.tissue, "tissue", visitor);
                            this.accept(this.value, "value", visitor);
                            this.accept(this.supportingInformation, "supportingInformation", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    WithdrawalPeriod other = (WithdrawalPeriod)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.tissue, other.tissue) && Objects.equals(this.value, other.value) && Objects.equals(this.supportingInformation, other.supportingInformation);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.tissue, this.value, this.supportingInformation);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private CodeableConcept tissue;
                    private Quantity value;
                    private String supportingInformation;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder tissue(CodeableConcept tissue) {
                        this.tissue = tissue;
                        return this;
                    }

                    public Builder value(Quantity value) {
                        this.value = value;
                        return this;
                    }

                    public Builder supportingInformation(String supportingInformation) {
                        this.supportingInformation = supportingInformation;
                        return this;
                    }

                    @Override
                    public WithdrawalPeriod build() {
                        WithdrawalPeriod withdrawalPeriod = new WithdrawalPeriod(this);
                        if (this.validating) {
                            this.validate(withdrawalPeriod);
                        }
                        return withdrawalPeriod;
                    }

                    protected void validate(WithdrawalPeriod withdrawalPeriod) {
                        super.validate(withdrawalPeriod);
                        ValidationSupport.requireNonNull(withdrawalPeriod.tissue, "tissue");
                        ValidationSupport.requireNonNull(withdrawalPeriod.value, "value");
                        ValidationSupport.requireValueOrChildren(withdrawalPeriod);
                    }

                    protected Builder from(WithdrawalPeriod withdrawalPeriod) {
                        super.from(withdrawalPeriod);
                        this.tissue = withdrawalPeriod.tissue;
                        this.value = withdrawalPeriod.value;
                        this.supportingInformation = withdrawalPeriod.supportingInformation;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept code;
                private List<WithdrawalPeriod> withdrawalPeriod = new ArrayList<WithdrawalPeriod>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder code(CodeableConcept code) {
                    this.code = code;
                    return this;
                }

                public Builder withdrawalPeriod(WithdrawalPeriod ... withdrawalPeriod) {
                    for (WithdrawalPeriod value : withdrawalPeriod) {
                        this.withdrawalPeriod.add(value);
                    }
                    return this;
                }

                public Builder withdrawalPeriod(Collection<WithdrawalPeriod> withdrawalPeriod) {
                    this.withdrawalPeriod = new ArrayList<WithdrawalPeriod>(withdrawalPeriod);
                    return this;
                }

                @Override
                public TargetSpecies build() {
                    TargetSpecies targetSpecies = new TargetSpecies(this);
                    if (this.validating) {
                        this.validate(targetSpecies);
                    }
                    return targetSpecies;
                }

                protected void validate(TargetSpecies targetSpecies) {
                    super.validate(targetSpecies);
                    ValidationSupport.requireNonNull(targetSpecies.code, "code");
                    ValidationSupport.checkList(targetSpecies.withdrawalPeriod, "withdrawalPeriod", WithdrawalPeriod.class);
                    ValidationSupport.requireValueOrChildren(targetSpecies);
                }

                protected Builder from(TargetSpecies targetSpecies) {
                    super.from(targetSpecies);
                    this.code = targetSpecies.code;
                    this.withdrawalPeriod.addAll(targetSpecies.withdrawalPeriod);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private Quantity firstDose;
            private Quantity maxSingleDose;
            private Quantity maxDosePerDay;
            private Ratio maxDosePerTreatmentPeriod;
            private Duration maxTreatmentPeriod;
            private List<TargetSpecies> targetSpecies = new ArrayList<TargetSpecies>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder firstDose(Quantity firstDose) {
                this.firstDose = firstDose;
                return this;
            }

            public Builder maxSingleDose(Quantity maxSingleDose) {
                this.maxSingleDose = maxSingleDose;
                return this;
            }

            public Builder maxDosePerDay(Quantity maxDosePerDay) {
                this.maxDosePerDay = maxDosePerDay;
                return this;
            }

            public Builder maxDosePerTreatmentPeriod(Ratio maxDosePerTreatmentPeriod) {
                this.maxDosePerTreatmentPeriod = maxDosePerTreatmentPeriod;
                return this;
            }

            public Builder maxTreatmentPeriod(Duration maxTreatmentPeriod) {
                this.maxTreatmentPeriod = maxTreatmentPeriod;
                return this;
            }

            public Builder targetSpecies(TargetSpecies ... targetSpecies) {
                for (TargetSpecies value : targetSpecies) {
                    this.targetSpecies.add(value);
                }
                return this;
            }

            public Builder targetSpecies(Collection<TargetSpecies> targetSpecies) {
                this.targetSpecies = new ArrayList<TargetSpecies>(targetSpecies);
                return this;
            }

            @Override
            public RouteOfAdministration build() {
                RouteOfAdministration routeOfAdministration = new RouteOfAdministration(this);
                if (this.validating) {
                    this.validate(routeOfAdministration);
                }
                return routeOfAdministration;
            }

            protected void validate(RouteOfAdministration routeOfAdministration) {
                super.validate(routeOfAdministration);
                ValidationSupport.requireNonNull(routeOfAdministration.code, "code");
                ValidationSupport.checkList(routeOfAdministration.targetSpecies, "targetSpecies", TargetSpecies.class);
                ValidationSupport.requireValueOrChildren(routeOfAdministration);
            }

            protected Builder from(RouteOfAdministration routeOfAdministration) {
                super.from(routeOfAdministration);
                this.code = routeOfAdministration.code;
                this.firstDose = routeOfAdministration.firstDose;
                this.maxSingleDose = routeOfAdministration.maxSingleDose;
                this.maxDosePerDay = routeOfAdministration.maxDosePerDay;
                this.maxDosePerTreatmentPeriod = routeOfAdministration.maxDosePerTreatmentPeriod;
                this.maxTreatmentPeriod = routeOfAdministration.maxTreatmentPeriod;
                this.targetSpecies.addAll(routeOfAdministration.targetSpecies);
                return this;
            }
        }
    }

    public static class Characteristics
    extends BackboneElement {
        @Summary
        @Required
        private final CodeableConcept code;
        @Summary
        private final CodeableConcept status;

        private Characteristics(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.status = builder.status;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public CodeableConcept getStatus() {
            return this.status;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.status != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.status, "status", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Characteristics other = (Characteristics)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.status, other.status);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.status);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private CodeableConcept status;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder status(CodeableConcept status) {
                this.status = status;
                return this;
            }

            @Override
            public Characteristics build() {
                Characteristics characteristics = new Characteristics(this);
                if (this.validating) {
                    this.validate(characteristics);
                }
                return characteristics;
            }

            protected void validate(Characteristics characteristics) {
                super.validate(characteristics);
                ValidationSupport.requireNonNull(characteristics.code, "code");
                ValidationSupport.requireValueOrChildren(characteristics);
            }

            protected Builder from(Characteristics characteristics) {
                super.from(characteristics);
                this.code = characteristics.code;
                this.status = characteristics.status;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private CodeableConcept administrableDoseForm;
        private CodeableConcept unitOfPresentation;
        private List<Reference> ingredient = new ArrayList<Reference>();
        private List<Reference> device = new ArrayList<Reference>();
        private List<Characteristics> characteristics = new ArrayList<Characteristics>();
        private List<RouteOfAdministration> routeOfAdministration = new ArrayList<RouteOfAdministration>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder administrableDoseForm(CodeableConcept administrableDoseForm) {
            this.administrableDoseForm = administrableDoseForm;
            return this;
        }

        public Builder unitOfPresentation(CodeableConcept unitOfPresentation) {
            this.unitOfPresentation = unitOfPresentation;
            return this;
        }

        public Builder ingredient(Reference ... ingredient) {
            for (Reference value : ingredient) {
                this.ingredient.add(value);
            }
            return this;
        }

        public Builder ingredient(Collection<Reference> ingredient) {
            this.ingredient = new ArrayList<Reference>(ingredient);
            return this;
        }

        public Builder device(Reference ... device) {
            for (Reference value : device) {
                this.device.add(value);
            }
            return this;
        }

        public Builder device(Collection<Reference> device) {
            this.device = new ArrayList<Reference>(device);
            return this;
        }

        public Builder characteristics(Characteristics ... characteristics) {
            for (Characteristics value : characteristics) {
                this.characteristics.add(value);
            }
            return this;
        }

        public Builder characteristics(Collection<Characteristics> characteristics) {
            this.characteristics = new ArrayList<Characteristics>(characteristics);
            return this;
        }

        public Builder routeOfAdministration(RouteOfAdministration ... routeOfAdministration) {
            for (RouteOfAdministration value : routeOfAdministration) {
                this.routeOfAdministration.add(value);
            }
            return this;
        }

        public Builder routeOfAdministration(Collection<RouteOfAdministration> routeOfAdministration) {
            this.routeOfAdministration = new ArrayList<RouteOfAdministration>(routeOfAdministration);
            return this;
        }

        @Override
        public MedicinalProductPharmaceutical build() {
            MedicinalProductPharmaceutical medicinalProductPharmaceutical = new MedicinalProductPharmaceutical(this);
            if (this.validating) {
                this.validate(medicinalProductPharmaceutical);
            }
            return medicinalProductPharmaceutical;
        }

        protected void validate(MedicinalProductPharmaceutical medicinalProductPharmaceutical) {
            super.validate(medicinalProductPharmaceutical);
            ValidationSupport.checkList(medicinalProductPharmaceutical.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(medicinalProductPharmaceutical.administrableDoseForm, "administrableDoseForm");
            ValidationSupport.checkList(medicinalProductPharmaceutical.ingredient, "ingredient", Reference.class);
            ValidationSupport.checkList(medicinalProductPharmaceutical.device, "device", Reference.class);
            ValidationSupport.checkList(medicinalProductPharmaceutical.characteristics, "characteristics", Characteristics.class);
            ValidationSupport.checkNonEmptyList(medicinalProductPharmaceutical.routeOfAdministration, "routeOfAdministration", RouteOfAdministration.class);
            ValidationSupport.checkReferenceType(medicinalProductPharmaceutical.ingredient, "ingredient", "MedicinalProductIngredient");
            ValidationSupport.checkReferenceType(medicinalProductPharmaceutical.device, "device", "DeviceDefinition");
        }

        protected Builder from(MedicinalProductPharmaceutical medicinalProductPharmaceutical) {
            super.from(medicinalProductPharmaceutical);
            this.identifier.addAll(medicinalProductPharmaceutical.identifier);
            this.administrableDoseForm = medicinalProductPharmaceutical.administrableDoseForm;
            this.unitOfPresentation = medicinalProductPharmaceutical.unitOfPresentation;
            this.ingredient.addAll(medicinalProductPharmaceutical.ingredient);
            this.device.addAll(medicinalProductPharmaceutical.device);
            this.characteristics.addAll(medicinalProductPharmaceutical.characteristics);
            this.routeOfAdministration.addAll(medicinalProductPharmaceutical.routeOfAdministration);
            return this;
        }
    }
}

