/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.Url;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ResponseType;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=4, status=StandardsStatus.Value.TRIAL_USE)
public class MessageHeader
extends DomainResource {
    @Summary
    @Choice(value={Coding.class, Uri.class})
    @Binding(bindingName="MessageEvent", strength=BindingStrength.Value.EXAMPLE, description="One of the message events defined as part of this version of FHIR.", valueSet="http://hl7.org/fhir/ValueSet/message-events")
    @Required
    private final Element event;
    @Summary
    private final List<Destination> destination;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
    private final Reference sender;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
    private final Reference enterer;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole"})
    private final Reference author;
    @Summary
    @Required
    private final Source source;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
    private final Reference responsible;
    @Summary
    @Binding(bindingName="EventReason", strength=BindingStrength.Value.EXAMPLE, description="Reason for event occurrence.", valueSet="http://hl7.org/fhir/ValueSet/message-reason-encounter")
    private final CodeableConcept reason;
    @Summary
    private final Response response;
    @Summary
    private final List<Reference> focus;
    @Summary
    private final Canonical definition;

    private MessageHeader(Builder builder) {
        super(builder);
        this.event = builder.event;
        this.destination = Collections.unmodifiableList(builder.destination);
        this.sender = builder.sender;
        this.enterer = builder.enterer;
        this.author = builder.author;
        this.source = builder.source;
        this.responsible = builder.responsible;
        this.reason = builder.reason;
        this.response = builder.response;
        this.focus = Collections.unmodifiableList(builder.focus);
        this.definition = builder.definition;
    }

    public Element getEvent() {
        return this.event;
    }

    public List<Destination> getDestination() {
        return this.destination;
    }

    public Reference getSender() {
        return this.sender;
    }

    public Reference getEnterer() {
        return this.enterer;
    }

    public Reference getAuthor() {
        return this.author;
    }

    public Source getSource() {
        return this.source;
    }

    public Reference getResponsible() {
        return this.responsible;
    }

    public CodeableConcept getReason() {
        return this.reason;
    }

    public Response getResponse() {
        return this.response;
    }

    public List<Reference> getFocus() {
        return this.focus;
    }

    public Canonical getDefinition() {
        return this.definition;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.event != null || !this.destination.isEmpty() || this.sender != null || this.enterer != null || this.author != null || this.source != null || this.responsible != null || this.reason != null || this.response != null || !this.focus.isEmpty() || this.definition != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.event, "event", visitor);
                this.accept(this.destination, "destination", visitor, Destination.class);
                this.accept(this.sender, "sender", visitor);
                this.accept(this.enterer, "enterer", visitor);
                this.accept(this.author, "author", visitor);
                this.accept(this.source, "source", visitor);
                this.accept(this.responsible, "responsible", visitor);
                this.accept(this.reason, "reason", visitor);
                this.accept(this.response, "response", visitor);
                this.accept(this.focus, "focus", visitor, Reference.class);
                this.accept(this.definition, "definition", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageHeader other = (MessageHeader)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.event, other.event) && Objects.equals(this.destination, other.destination) && Objects.equals(this.sender, other.sender) && Objects.equals(this.enterer, other.enterer) && Objects.equals(this.author, other.author) && Objects.equals(this.source, other.source) && Objects.equals(this.responsible, other.responsible) && Objects.equals(this.reason, other.reason) && Objects.equals(this.response, other.response) && Objects.equals(this.focus, other.focus) && Objects.equals(this.definition, other.definition);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.event, this.destination, this.sender, this.enterer, this.author, this.source, this.responsible, this.reason, this.response, this.focus, this.definition);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Response
    extends BackboneElement {
        @Summary
        @Required
        private final Id identifier;
        @Summary
        @Binding(bindingName="ResponseType", strength=BindingStrength.Value.REQUIRED, description="The kind of response to a message.", valueSet="http://hl7.org/fhir/ValueSet/response-code|4.0.1")
        @Required
        private final ResponseType code;
        @Summary
        @ReferenceTarget(value={"OperationOutcome"})
        private final Reference details;

        private Response(Builder builder) {
            super(builder);
            this.identifier = builder.identifier;
            this.code = builder.code;
            this.details = builder.details;
        }

        public Id getIdentifier() {
            return this.identifier;
        }

        public ResponseType getCode() {
            return this.code;
        }

        public Reference getDetails() {
            return this.details;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.identifier != null || this.code != null || this.details != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.details, "details", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.code, other.code) && Objects.equals(this.details, other.details);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.code, this.details);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Id identifier;
            private ResponseType code;
            private Reference details;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Id identifier) {
                this.identifier = identifier;
                return this;
            }

            public Builder code(ResponseType code) {
                this.code = code;
                return this;
            }

            public Builder details(Reference details) {
                this.details = details;
                return this;
            }

            @Override
            public Response build() {
                Response response = new Response(this);
                if (this.validating) {
                    this.validate(response);
                }
                return response;
            }

            protected void validate(Response response) {
                super.validate(response);
                ValidationSupport.requireNonNull(response.identifier, "identifier");
                ValidationSupport.requireNonNull(response.code, "code");
                ValidationSupport.checkReferenceType(response.details, "details", "OperationOutcome");
                ValidationSupport.requireValueOrChildren(response);
            }

            protected Builder from(Response response) {
                super.from(response);
                this.identifier = response.identifier;
                this.code = response.code;
                this.details = response.details;
                return this;
            }
        }
    }

    public static class Source
    extends BackboneElement {
        @Summary
        private final String name;
        @Summary
        private final String software;
        @Summary
        private final String version;
        @Summary
        private final ContactPoint contact;
        @Summary
        @Required
        private final Url endpoint;

        private Source(Builder builder) {
            super(builder);
            this.name = builder.name;
            this.software = builder.software;
            this.version = builder.version;
            this.contact = builder.contact;
            this.endpoint = builder.endpoint;
        }

        public String getName() {
            return this.name;
        }

        public String getSoftware() {
            return this.software;
        }

        public String getVersion() {
            return this.version;
        }

        public ContactPoint getContact() {
            return this.contact;
        }

        public Url getEndpoint() {
            return this.endpoint;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.software != null || this.version != null || this.contact != null || this.endpoint != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.software, "software", visitor);
                    this.accept(this.version, "version", visitor);
                    this.accept(this.contact, "contact", visitor);
                    this.accept(this.endpoint, "endpoint", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Source other = (Source)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.software, other.software) && Objects.equals(this.version, other.version) && Objects.equals(this.contact, other.contact) && Objects.equals(this.endpoint, other.endpoint);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.software, this.version, this.contact, this.endpoint);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String name;
            private String software;
            private String version;
            private ContactPoint contact;
            private Url endpoint;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder software(String software) {
                this.software = software;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public Builder contact(ContactPoint contact) {
                this.contact = contact;
                return this;
            }

            public Builder endpoint(Url endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            @Override
            public Source build() {
                Source source = new Source(this);
                if (this.validating) {
                    this.validate(source);
                }
                return source;
            }

            protected void validate(Source source) {
                super.validate(source);
                ValidationSupport.requireNonNull(source.endpoint, "endpoint");
                ValidationSupport.requireValueOrChildren(source);
            }

            protected Builder from(Source source) {
                super.from(source);
                this.name = source.name;
                this.software = source.software;
                this.version = source.version;
                this.contact = source.contact;
                this.endpoint = source.endpoint;
                return this;
            }
        }
    }

    public static class Destination
    extends BackboneElement {
        @Summary
        private final String name;
        @Summary
        @ReferenceTarget(value={"Device"})
        private final Reference target;
        @Summary
        @Required
        private final Url endpoint;
        @Summary
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
        private final Reference receiver;

        private Destination(Builder builder) {
            super(builder);
            this.name = builder.name;
            this.target = builder.target;
            this.endpoint = builder.endpoint;
            this.receiver = builder.receiver;
        }

        public String getName() {
            return this.name;
        }

        public Reference getTarget() {
            return this.target;
        }

        public Url getEndpoint() {
            return this.endpoint;
        }

        public Reference getReceiver() {
            return this.receiver;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.target != null || this.endpoint != null || this.receiver != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.target, "target", visitor);
                    this.accept(this.endpoint, "endpoint", visitor);
                    this.accept(this.receiver, "receiver", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Destination other = (Destination)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.target, other.target) && Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.receiver, other.receiver);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.target, this.endpoint, this.receiver);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String name;
            private Reference target;
            private Url endpoint;
            private Reference receiver;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder target(Reference target) {
                this.target = target;
                return this;
            }

            public Builder endpoint(Url endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public Builder receiver(Reference receiver) {
                this.receiver = receiver;
                return this;
            }

            @Override
            public Destination build() {
                Destination destination = new Destination(this);
                if (this.validating) {
                    this.validate(destination);
                }
                return destination;
            }

            protected void validate(Destination destination) {
                super.validate(destination);
                ValidationSupport.requireNonNull(destination.endpoint, "endpoint");
                ValidationSupport.checkReferenceType(destination.target, "target", "Device");
                ValidationSupport.checkReferenceType(destination.receiver, "receiver", "Practitioner", "PractitionerRole", "Organization");
                ValidationSupport.requireValueOrChildren(destination);
            }

            protected Builder from(Destination destination) {
                super.from(destination);
                this.name = destination.name;
                this.target = destination.target;
                this.endpoint = destination.endpoint;
                this.receiver = destination.receiver;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Element event;
        private List<Destination> destination = new ArrayList<Destination>();
        private Reference sender;
        private Reference enterer;
        private Reference author;
        private Source source;
        private Reference responsible;
        private CodeableConcept reason;
        private Response response;
        private List<Reference> focus = new ArrayList<Reference>();
        private Canonical definition;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder event(Element event) {
            this.event = event;
            return this;
        }

        public Builder destination(Destination ... destination) {
            for (Destination value : destination) {
                this.destination.add(value);
            }
            return this;
        }

        public Builder destination(Collection<Destination> destination) {
            this.destination = new ArrayList<Destination>(destination);
            return this;
        }

        public Builder sender(Reference sender) {
            this.sender = sender;
            return this;
        }

        public Builder enterer(Reference enterer) {
            this.enterer = enterer;
            return this;
        }

        public Builder author(Reference author) {
            this.author = author;
            return this;
        }

        public Builder source(Source source) {
            this.source = source;
            return this;
        }

        public Builder responsible(Reference responsible) {
            this.responsible = responsible;
            return this;
        }

        public Builder reason(CodeableConcept reason) {
            this.reason = reason;
            return this;
        }

        public Builder response(Response response) {
            this.response = response;
            return this;
        }

        public Builder focus(Reference ... focus) {
            for (Reference value : focus) {
                this.focus.add(value);
            }
            return this;
        }

        public Builder focus(Collection<Reference> focus) {
            this.focus = new ArrayList<Reference>(focus);
            return this;
        }

        public Builder definition(Canonical definition) {
            this.definition = definition;
            return this;
        }

        @Override
        public MessageHeader build() {
            MessageHeader messageHeader = new MessageHeader(this);
            if (this.validating) {
                this.validate(messageHeader);
            }
            return messageHeader;
        }

        protected void validate(MessageHeader messageHeader) {
            super.validate(messageHeader);
            ValidationSupport.requireChoiceElement(messageHeader.event, "event", Coding.class, Uri.class);
            ValidationSupport.checkList(messageHeader.destination, "destination", Destination.class);
            ValidationSupport.requireNonNull(messageHeader.source, "source");
            ValidationSupport.checkList(messageHeader.focus, "focus", Reference.class);
            ValidationSupport.checkReferenceType(messageHeader.sender, "sender", "Practitioner", "PractitionerRole", "Organization");
            ValidationSupport.checkReferenceType(messageHeader.enterer, "enterer", "Practitioner", "PractitionerRole");
            ValidationSupport.checkReferenceType(messageHeader.author, "author", "Practitioner", "PractitionerRole");
            ValidationSupport.checkReferenceType(messageHeader.responsible, "responsible", "Practitioner", "PractitionerRole", "Organization");
        }

        protected Builder from(MessageHeader messageHeader) {
            super.from(messageHeader);
            this.event = messageHeader.event;
            this.destination.addAll(messageHeader.destination);
            this.sender = messageHeader.sender;
            this.enterer = messageHeader.enterer;
            this.author = messageHeader.author;
            this.source = messageHeader.source;
            this.responsible = messageHeader.responsible;
            this.reason = messageHeader.reason;
            this.response = messageHeader.response;
            this.focus.addAll(messageHeader.focus);
            this.definition = messageHeader.definition;
            return this;
        }
    }
}

