/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.SampledData;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Time;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ObservationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=5, status=StandardsStatus.Value.NORMATIVE)
@Constraints(value={@Constraint(id="obs-3", level="Rule", location="Observation.referenceRange", description="Must have at least a low or a high or text", expression="low.exists() or high.exists() or text.exists()", source="http://hl7.org/fhir/StructureDefinition/Observation"), @Constraint(id="obs-6", level="Rule", location="(base)", description="dataAbsentReason SHALL only be present if Observation.value[x] is not present", expression="dataAbsentReason.empty() or value.empty()", source="http://hl7.org/fhir/StructureDefinition/Observation"), @Constraint(id="obs-7", level="Rule", location="(base)", description="If Observation.code is the same as an Observation.component.code then the value element associated with the code SHALL NOT be present", expression="value.empty() or component.code.where(coding.intersect(%resource.code.coding).exists()).empty()", source="http://hl7.org/fhir/StructureDefinition/Observation"), @Constraint(id="observation-8", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/observation-category", expression="category.exists() implies (category.all(memberOf('http://hl7.org/fhir/ValueSet/observation-category', 'preferred')))", source="http://hl7.org/fhir/StructureDefinition/Observation", generated=true), @Constraint(id="observation-9", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/data-absent-reason", expression="dataAbsentReason.exists() implies (dataAbsentReason.memberOf('http://hl7.org/fhir/ValueSet/data-absent-reason', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/Observation", generated=true), @Constraint(id="observation-10", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/observation-interpretation", expression="interpretation.exists() implies (interpretation.all(memberOf('http://hl7.org/fhir/ValueSet/observation-interpretation', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/Observation", generated=true), @Constraint(id="observation-11", level="Warning", location="referenceRange.type", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/referencerange-meaning", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/referencerange-meaning', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/Observation", generated=true), @Constraint(id="observation-12", level="Warning", location="component.dataAbsentReason", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/data-absent-reason", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/data-absent-reason', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Observation", generated=true), @Constraint(id="observation-13", level="Warning", location="component.interpretation", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/observation-interpretation", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/observation-interpretation', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Observation", generated=true)})
public class Observation
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @ReferenceTarget(value={"CarePlan", "DeviceRequest", "ImmunizationRecommendation", "MedicationRequest", "NutritionOrder", "ServiceRequest"})
    private final List<Reference> basedOn;
    @Summary
    @ReferenceTarget(value={"MedicationAdministration", "MedicationDispense", "MedicationStatement", "Procedure", "Immunization", "ImagingStudy"})
    private final List<Reference> partOf;
    @Summary
    @Binding(bindingName="ObservationStatus", strength=BindingStrength.Value.REQUIRED, description="Codes providing the status of an observation.", valueSet="http://hl7.org/fhir/ValueSet/observation-status|4.0.1")
    @Required
    private final ObservationStatus status;
    @Binding(bindingName="ObservationCategory", strength=BindingStrength.Value.PREFERRED, description="Codes for high level observation categories.", valueSet="http://hl7.org/fhir/ValueSet/observation-category")
    private final List<CodeableConcept> category;
    @Summary
    @Binding(bindingName="ObservationCode", strength=BindingStrength.Value.EXAMPLE, description="Codes identifying names of simple observations.", valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
    @Required
    private final CodeableConcept code;
    @Summary
    @ReferenceTarget(value={"Patient", "Group", "Device", "Location"})
    private final Reference subject;
    @Summary
    private final List<Reference> focus;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    @Choice(value={DateTime.class, Period.class, Timing.class, Instant.class})
    private final Element effective;
    @Summary
    private final Instant issued;
    @Summary
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization", "CareTeam", "Patient", "RelatedPerson"})
    private final List<Reference> performer;
    @Summary
    @Choice(value={Quantity.class, CodeableConcept.class, String.class, Boolean.class, Integer.class, Range.class, Ratio.class, SampledData.class, Time.class, DateTime.class, Period.class})
    private final Element value;
    @Binding(bindingName="ObservationValueAbsentReason", strength=BindingStrength.Value.EXTENSIBLE, description="Codes specifying why the result (`Observation.value[x]`) is missing.", valueSet="http://hl7.org/fhir/ValueSet/data-absent-reason")
    private final CodeableConcept dataAbsentReason;
    @Binding(bindingName="ObservationInterpretation", strength=BindingStrength.Value.EXTENSIBLE, description="Codes identifying interpretations of observations.", valueSet="http://hl7.org/fhir/ValueSet/observation-interpretation")
    private final List<CodeableConcept> interpretation;
    private final List<Annotation> note;
    @Binding(bindingName="BodySite", strength=BindingStrength.Value.EXAMPLE, description="Codes describing anatomical locations. May include laterality.", valueSet="http://hl7.org/fhir/ValueSet/body-site")
    private final CodeableConcept bodySite;
    @Binding(bindingName="ObservationMethod", strength=BindingStrength.Value.EXAMPLE, description="Methods for simple observations.", valueSet="http://hl7.org/fhir/ValueSet/observation-methods")
    private final CodeableConcept method;
    @ReferenceTarget(value={"Specimen"})
    private final Reference specimen;
    @ReferenceTarget(value={"Device", "DeviceMetric"})
    private final Reference device;
    private final List<ReferenceRange> referenceRange;
    @Summary
    @ReferenceTarget(value={"Observation", "QuestionnaireResponse", "MolecularSequence"})
    private final List<Reference> hasMember;
    @Summary
    @ReferenceTarget(value={"DocumentReference", "ImagingStudy", "Media", "QuestionnaireResponse", "Observation", "MolecularSequence"})
    private final List<Reference> derivedFrom;
    @Summary
    private final List<Component> component;

    private Observation(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.basedOn = Collections.unmodifiableList(builder.basedOn);
        this.partOf = Collections.unmodifiableList(builder.partOf);
        this.status = builder.status;
        this.category = Collections.unmodifiableList(builder.category);
        this.code = builder.code;
        this.subject = builder.subject;
        this.focus = Collections.unmodifiableList(builder.focus);
        this.encounter = builder.encounter;
        this.effective = builder.effective;
        this.issued = builder.issued;
        this.performer = Collections.unmodifiableList(builder.performer);
        this.value = builder.value;
        this.dataAbsentReason = builder.dataAbsentReason;
        this.interpretation = Collections.unmodifiableList(builder.interpretation);
        this.note = Collections.unmodifiableList(builder.note);
        this.bodySite = builder.bodySite;
        this.method = builder.method;
        this.specimen = builder.specimen;
        this.device = builder.device;
        this.referenceRange = Collections.unmodifiableList(builder.referenceRange);
        this.hasMember = Collections.unmodifiableList(builder.hasMember);
        this.derivedFrom = Collections.unmodifiableList(builder.derivedFrom);
        this.component = Collections.unmodifiableList(builder.component);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public List<Reference> getPartOf() {
        return this.partOf;
    }

    public ObservationStatus getStatus() {
        return this.status;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public List<Reference> getFocus() {
        return this.focus;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public Element getEffective() {
        return this.effective;
    }

    public Instant getIssued() {
        return this.issued;
    }

    public List<Reference> getPerformer() {
        return this.performer;
    }

    public Element getValue() {
        return this.value;
    }

    public CodeableConcept getDataAbsentReason() {
        return this.dataAbsentReason;
    }

    public List<CodeableConcept> getInterpretation() {
        return this.interpretation;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public CodeableConcept getBodySite() {
        return this.bodySite;
    }

    public CodeableConcept getMethod() {
        return this.method;
    }

    public Reference getSpecimen() {
        return this.specimen;
    }

    public Reference getDevice() {
        return this.device;
    }

    public List<ReferenceRange> getReferenceRange() {
        return this.referenceRange;
    }

    public List<Reference> getHasMember() {
        return this.hasMember;
    }

    public List<Reference> getDerivedFrom() {
        return this.derivedFrom;
    }

    public List<Component> getComponent() {
        return this.component;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.basedOn.isEmpty() || !this.partOf.isEmpty() || this.status != null || !this.category.isEmpty() || this.code != null || this.subject != null || !this.focus.isEmpty() || this.encounter != null || this.effective != null || this.issued != null || !this.performer.isEmpty() || this.value != null || this.dataAbsentReason != null || !this.interpretation.isEmpty() || !this.note.isEmpty() || this.bodySite != null || this.method != null || this.specimen != null || this.device != null || !this.referenceRange.isEmpty() || !this.hasMember.isEmpty() || !this.derivedFrom.isEmpty() || !this.component.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.partOf, "partOf", visitor, Reference.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.code, "code", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.focus, "focus", visitor, Reference.class);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.effective, "effective", visitor);
                this.accept(this.issued, "issued", visitor);
                this.accept(this.performer, "performer", visitor, Reference.class);
                this.accept(this.value, "value", visitor);
                this.accept(this.dataAbsentReason, "dataAbsentReason", visitor);
                this.accept(this.interpretation, "interpretation", visitor, CodeableConcept.class);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.bodySite, "bodySite", visitor);
                this.accept(this.method, "method", visitor);
                this.accept(this.specimen, "specimen", visitor);
                this.accept(this.device, "device", visitor);
                this.accept(this.referenceRange, "referenceRange", visitor, ReferenceRange.class);
                this.accept(this.hasMember, "hasMember", visitor, Reference.class);
                this.accept(this.derivedFrom, "derivedFrom", visitor, Reference.class);
                this.accept(this.component, "component", visitor, Component.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Observation other = (Observation)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.status, other.status) && Objects.equals(this.category, other.category) && Objects.equals(this.code, other.code) && Objects.equals(this.subject, other.subject) && Objects.equals(this.focus, other.focus) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.effective, other.effective) && Objects.equals(this.issued, other.issued) && Objects.equals(this.performer, other.performer) && Objects.equals(this.value, other.value) && Objects.equals(this.dataAbsentReason, other.dataAbsentReason) && Objects.equals(this.interpretation, other.interpretation) && Objects.equals(this.note, other.note) && Objects.equals(this.bodySite, other.bodySite) && Objects.equals(this.method, other.method) && Objects.equals(this.specimen, other.specimen) && Objects.equals(this.device, other.device) && Objects.equals(this.referenceRange, other.referenceRange) && Objects.equals(this.hasMember, other.hasMember) && Objects.equals(this.derivedFrom, other.derivedFrom) && Objects.equals(this.component, other.component);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.basedOn, this.partOf, this.status, this.category, this.code, this.subject, this.focus, this.encounter, this.effective, this.issued, this.performer, this.value, this.dataAbsentReason, this.interpretation, this.note, this.bodySite, this.method, this.specimen, this.device, this.referenceRange, this.hasMember, this.derivedFrom, this.component);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Component
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ObservationCode", strength=BindingStrength.Value.EXAMPLE, description="Codes identifying names of simple observations.", valueSet="http://hl7.org/fhir/ValueSet/observation-codes")
        @Required
        private final CodeableConcept code;
        @Summary
        @Choice(value={Quantity.class, CodeableConcept.class, String.class, Boolean.class, Integer.class, Range.class, Ratio.class, SampledData.class, Time.class, DateTime.class, Period.class})
        private final Element value;
        @Binding(bindingName="ObservationValueAbsentReason", strength=BindingStrength.Value.EXTENSIBLE, description="Codes specifying why the result (`Observation.value[x]`) is missing.", valueSet="http://hl7.org/fhir/ValueSet/data-absent-reason")
        private final CodeableConcept dataAbsentReason;
        @Binding(bindingName="ObservationInterpretation", strength=BindingStrength.Value.EXTENSIBLE, description="Codes identifying interpretations of observations.", valueSet="http://hl7.org/fhir/ValueSet/observation-interpretation")
        private final List<CodeableConcept> interpretation;
        private final List<ReferenceRange> referenceRange;

        private Component(Builder builder) {
            super(builder);
            this.code = builder.code;
            this.value = builder.value;
            this.dataAbsentReason = builder.dataAbsentReason;
            this.interpretation = Collections.unmodifiableList(builder.interpretation);
            this.referenceRange = Collections.unmodifiableList(builder.referenceRange);
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public Element getValue() {
            return this.value;
        }

        public CodeableConcept getDataAbsentReason() {
            return this.dataAbsentReason;
        }

        public List<CodeableConcept> getInterpretation() {
            return this.interpretation;
        }

        public List<ReferenceRange> getReferenceRange() {
            return this.referenceRange;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.code != null || this.value != null || this.dataAbsentReason != null || !this.interpretation.isEmpty() || !this.referenceRange.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.code, "code", visitor);
                    this.accept(this.value, "value", visitor);
                    this.accept(this.dataAbsentReason, "dataAbsentReason", visitor);
                    this.accept(this.interpretation, "interpretation", visitor, CodeableConcept.class);
                    this.accept(this.referenceRange, "referenceRange", visitor, ReferenceRange.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Component other = (Component)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.value, other.value) && Objects.equals(this.dataAbsentReason, other.dataAbsentReason) && Objects.equals(this.interpretation, other.interpretation) && Objects.equals(this.referenceRange, other.referenceRange);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.value, this.dataAbsentReason, this.interpretation, this.referenceRange);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept code;
            private Element value;
            private CodeableConcept dataAbsentReason;
            private List<CodeableConcept> interpretation = new ArrayList<CodeableConcept>();
            private List<ReferenceRange> referenceRange = new ArrayList<ReferenceRange>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder code(CodeableConcept code) {
                this.code = code;
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            public Builder dataAbsentReason(CodeableConcept dataAbsentReason) {
                this.dataAbsentReason = dataAbsentReason;
                return this;
            }

            public Builder interpretation(CodeableConcept ... interpretation) {
                for (CodeableConcept value : interpretation) {
                    this.interpretation.add(value);
                }
                return this;
            }

            public Builder interpretation(Collection<CodeableConcept> interpretation) {
                this.interpretation = new ArrayList<CodeableConcept>(interpretation);
                return this;
            }

            public Builder referenceRange(ReferenceRange ... referenceRange) {
                for (ReferenceRange value : referenceRange) {
                    this.referenceRange.add(value);
                }
                return this;
            }

            public Builder referenceRange(Collection<ReferenceRange> referenceRange) {
                this.referenceRange = new ArrayList<ReferenceRange>(referenceRange);
                return this;
            }

            @Override
            public Component build() {
                Component component = new Component(this);
                if (this.validating) {
                    this.validate(component);
                }
                return component;
            }

            protected void validate(Component component) {
                super.validate(component);
                ValidationSupport.requireNonNull(component.code, "code");
                ValidationSupport.choiceElement(component.value, "value", Quantity.class, CodeableConcept.class, String.class, Boolean.class, Integer.class, Range.class, Ratio.class, SampledData.class, Time.class, DateTime.class, Period.class);
                ValidationSupport.checkList(component.interpretation, "interpretation", CodeableConcept.class);
                ValidationSupport.checkList(component.referenceRange, "referenceRange", ReferenceRange.class);
                ValidationSupport.requireValueOrChildren(component);
            }

            protected Builder from(Component component) {
                super.from(component);
                this.code = component.code;
                this.value = component.value;
                this.dataAbsentReason = component.dataAbsentReason;
                this.interpretation.addAll(component.interpretation);
                this.referenceRange.addAll(component.referenceRange);
                return this;
            }
        }
    }

    public static class ReferenceRange
    extends BackboneElement {
        private final SimpleQuantity low;
        private final SimpleQuantity high;
        @Binding(bindingName="ObservationRangeMeaning", strength=BindingStrength.Value.PREFERRED, description="Code for the meaning of a reference range.", valueSet="http://hl7.org/fhir/ValueSet/referencerange-meaning")
        private final CodeableConcept type;
        @Binding(bindingName="ObservationRangeType", strength=BindingStrength.Value.EXAMPLE, description="Codes identifying the population the reference range applies to.", valueSet="http://hl7.org/fhir/ValueSet/referencerange-appliesto")
        private final List<CodeableConcept> appliesTo;
        private final Range age;
        private final String text;

        private ReferenceRange(Builder builder) {
            super(builder);
            this.low = builder.low;
            this.high = builder.high;
            this.type = builder.type;
            this.appliesTo = Collections.unmodifiableList(builder.appliesTo);
            this.age = builder.age;
            this.text = builder.text;
        }

        public SimpleQuantity getLow() {
            return this.low;
        }

        public SimpleQuantity getHigh() {
            return this.high;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public List<CodeableConcept> getAppliesTo() {
            return this.appliesTo;
        }

        public Range getAge() {
            return this.age;
        }

        public String getText() {
            return this.text;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.low != null || this.high != null || this.type != null || !this.appliesTo.isEmpty() || this.age != null || this.text != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.low, "low", visitor);
                    this.accept(this.high, "high", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.appliesTo, "appliesTo", visitor, CodeableConcept.class);
                    this.accept(this.age, "age", visitor);
                    this.accept(this.text, "text", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReferenceRange other = (ReferenceRange)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.low, other.low) && Objects.equals(this.high, other.high) && Objects.equals(this.type, other.type) && Objects.equals(this.appliesTo, other.appliesTo) && Objects.equals(this.age, other.age) && Objects.equals(this.text, other.text);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.low, this.high, this.type, this.appliesTo, this.age, this.text);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private SimpleQuantity low;
            private SimpleQuantity high;
            private CodeableConcept type;
            private List<CodeableConcept> appliesTo = new ArrayList<CodeableConcept>();
            private Range age;
            private String text;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder low(SimpleQuantity low) {
                this.low = low;
                return this;
            }

            public Builder high(SimpleQuantity high) {
                this.high = high;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder appliesTo(CodeableConcept ... appliesTo) {
                for (CodeableConcept value : appliesTo) {
                    this.appliesTo.add(value);
                }
                return this;
            }

            public Builder appliesTo(Collection<CodeableConcept> appliesTo) {
                this.appliesTo = new ArrayList<CodeableConcept>(appliesTo);
                return this;
            }

            public Builder age(Range age) {
                this.age = age;
                return this;
            }

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            @Override
            public ReferenceRange build() {
                ReferenceRange referenceRange = new ReferenceRange(this);
                if (this.validating) {
                    this.validate(referenceRange);
                }
                return referenceRange;
            }

            protected void validate(ReferenceRange referenceRange) {
                super.validate(referenceRange);
                ValidationSupport.checkList(referenceRange.appliesTo, "appliesTo", CodeableConcept.class);
                ValidationSupport.requireValueOrChildren(referenceRange);
            }

            protected Builder from(ReferenceRange referenceRange) {
                super.from(referenceRange);
                this.low = referenceRange.low;
                this.high = referenceRange.high;
                this.type = referenceRange.type;
                this.appliesTo.addAll(referenceRange.appliesTo);
                this.age = referenceRange.age;
                this.text = referenceRange.text;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<Reference> basedOn = new ArrayList<Reference>();
        private List<Reference> partOf = new ArrayList<Reference>();
        private ObservationStatus status;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private CodeableConcept code;
        private Reference subject;
        private List<Reference> focus = new ArrayList<Reference>();
        private Reference encounter;
        private Element effective;
        private Instant issued;
        private List<Reference> performer = new ArrayList<Reference>();
        private Element value;
        private CodeableConcept dataAbsentReason;
        private List<CodeableConcept> interpretation = new ArrayList<CodeableConcept>();
        private List<Annotation> note = new ArrayList<Annotation>();
        private CodeableConcept bodySite;
        private CodeableConcept method;
        private Reference specimen;
        private Reference device;
        private List<ReferenceRange> referenceRange = new ArrayList<ReferenceRange>();
        private List<Reference> hasMember = new ArrayList<Reference>();
        private List<Reference> derivedFrom = new ArrayList<Reference>();
        private List<Component> component = new ArrayList<Component>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder partOf(Reference ... partOf) {
            for (Reference value : partOf) {
                this.partOf.add(value);
            }
            return this;
        }

        public Builder partOf(Collection<Reference> partOf) {
            this.partOf = new ArrayList<Reference>(partOf);
            return this;
        }

        public Builder status(ObservationStatus status) {
            this.status = status;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder focus(Reference ... focus) {
            for (Reference value : focus) {
                this.focus.add(value);
            }
            return this;
        }

        public Builder focus(Collection<Reference> focus) {
            this.focus = new ArrayList<Reference>(focus);
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder effective(Element effective) {
            this.effective = effective;
            return this;
        }

        public Builder issued(Instant issued) {
            this.issued = issued;
            return this;
        }

        public Builder performer(Reference ... performer) {
            for (Reference value : performer) {
                this.performer.add(value);
            }
            return this;
        }

        public Builder performer(Collection<Reference> performer) {
            this.performer = new ArrayList<Reference>(performer);
            return this;
        }

        public Builder value(Element value) {
            this.value = value;
            return this;
        }

        public Builder dataAbsentReason(CodeableConcept dataAbsentReason) {
            this.dataAbsentReason = dataAbsentReason;
            return this;
        }

        public Builder interpretation(CodeableConcept ... interpretation) {
            for (CodeableConcept value : interpretation) {
                this.interpretation.add(value);
            }
            return this;
        }

        public Builder interpretation(Collection<CodeableConcept> interpretation) {
            this.interpretation = new ArrayList<CodeableConcept>(interpretation);
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder bodySite(CodeableConcept bodySite) {
            this.bodySite = bodySite;
            return this;
        }

        public Builder method(CodeableConcept method) {
            this.method = method;
            return this;
        }

        public Builder specimen(Reference specimen) {
            this.specimen = specimen;
            return this;
        }

        public Builder device(Reference device) {
            this.device = device;
            return this;
        }

        public Builder referenceRange(ReferenceRange ... referenceRange) {
            for (ReferenceRange value : referenceRange) {
                this.referenceRange.add(value);
            }
            return this;
        }

        public Builder referenceRange(Collection<ReferenceRange> referenceRange) {
            this.referenceRange = new ArrayList<ReferenceRange>(referenceRange);
            return this;
        }

        public Builder hasMember(Reference ... hasMember) {
            for (Reference value : hasMember) {
                this.hasMember.add(value);
            }
            return this;
        }

        public Builder hasMember(Collection<Reference> hasMember) {
            this.hasMember = new ArrayList<Reference>(hasMember);
            return this;
        }

        public Builder derivedFrom(Reference ... derivedFrom) {
            for (Reference value : derivedFrom) {
                this.derivedFrom.add(value);
            }
            return this;
        }

        public Builder derivedFrom(Collection<Reference> derivedFrom) {
            this.derivedFrom = new ArrayList<Reference>(derivedFrom);
            return this;
        }

        public Builder component(Component ... component) {
            for (Component value : component) {
                this.component.add(value);
            }
            return this;
        }

        public Builder component(Collection<Component> component) {
            this.component = new ArrayList<Component>(component);
            return this;
        }

        @Override
        public Observation build() {
            Observation observation = new Observation(this);
            if (this.validating) {
                this.validate(observation);
            }
            return observation;
        }

        protected void validate(Observation observation) {
            super.validate(observation);
            ValidationSupport.checkList(observation.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(observation.basedOn, "basedOn", Reference.class);
            ValidationSupport.checkList(observation.partOf, "partOf", Reference.class);
            ValidationSupport.requireNonNull(observation.status, "status");
            ValidationSupport.checkList(observation.category, "category", CodeableConcept.class);
            ValidationSupport.requireNonNull(observation.code, "code");
            ValidationSupport.checkList(observation.focus, "focus", Reference.class);
            ValidationSupport.choiceElement(observation.effective, "effective", DateTime.class, Period.class, Timing.class, Instant.class);
            ValidationSupport.checkList(observation.performer, "performer", Reference.class);
            ValidationSupport.choiceElement(observation.value, "value", Quantity.class, CodeableConcept.class, String.class, Boolean.class, Integer.class, Range.class, Ratio.class, SampledData.class, Time.class, DateTime.class, Period.class);
            ValidationSupport.checkList(observation.interpretation, "interpretation", CodeableConcept.class);
            ValidationSupport.checkList(observation.note, "note", Annotation.class);
            ValidationSupport.checkList(observation.referenceRange, "referenceRange", ReferenceRange.class);
            ValidationSupport.checkList(observation.hasMember, "hasMember", Reference.class);
            ValidationSupport.checkList(observation.derivedFrom, "derivedFrom", Reference.class);
            ValidationSupport.checkList(observation.component, "component", Component.class);
            ValidationSupport.checkReferenceType(observation.basedOn, "basedOn", "CarePlan", "DeviceRequest", "ImmunizationRecommendation", "MedicationRequest", "NutritionOrder", "ServiceRequest");
            ValidationSupport.checkReferenceType(observation.partOf, "partOf", "MedicationAdministration", "MedicationDispense", "MedicationStatement", "Procedure", "Immunization", "ImagingStudy");
            ValidationSupport.checkReferenceType(observation.subject, "subject", "Patient", "Group", "Device", "Location");
            ValidationSupport.checkReferenceType(observation.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(observation.performer, "performer", "Practitioner", "PractitionerRole", "Organization", "CareTeam", "Patient", "RelatedPerson");
            ValidationSupport.checkReferenceType(observation.specimen, "specimen", "Specimen");
            ValidationSupport.checkReferenceType(observation.device, "device", "Device", "DeviceMetric");
            ValidationSupport.checkReferenceType(observation.hasMember, "hasMember", "Observation", "QuestionnaireResponse", "MolecularSequence");
            ValidationSupport.checkReferenceType(observation.derivedFrom, "derivedFrom", "DocumentReference", "ImagingStudy", "Media", "QuestionnaireResponse", "Observation", "MolecularSequence");
        }

        protected Builder from(Observation observation) {
            super.from(observation);
            this.identifier.addAll(observation.identifier);
            this.basedOn.addAll(observation.basedOn);
            this.partOf.addAll(observation.partOf);
            this.status = observation.status;
            this.category.addAll(observation.category);
            this.code = observation.code;
            this.subject = observation.subject;
            this.focus.addAll(observation.focus);
            this.encounter = observation.encounter;
            this.effective = observation.effective;
            this.issued = observation.issued;
            this.performer.addAll(observation.performer);
            this.value = observation.value;
            this.dataAbsentReason = observation.dataAbsentReason;
            this.interpretation.addAll(observation.interpretation);
            this.note.addAll(observation.note);
            this.bodySite = observation.bodySite;
            this.method = observation.method;
            this.specimen = observation.specimen;
            this.device = observation.device;
            this.referenceRange.addAll(observation.referenceRange);
            this.hasMember.addAll(observation.hasMember);
            this.derivedFrom.addAll(observation.derivedFrom);
            this.component.addAll(observation.component);
            return this;
        }
    }
}

