/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Address;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.HumanName;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="org-1", level="Rule", location="(base)", description="The organization SHALL at least have a name or an identifier, and possibly more than one", expression="(identifier.count() + name.count()) > 0", source="http://hl7.org/fhir/StructureDefinition/Organization"), @Constraint(id="org-2", level="Rule", location="Organization.address", description="An address of an organization can never be of use 'home'", expression="where(use = 'home').empty()", source="http://hl7.org/fhir/StructureDefinition/Organization"), @Constraint(id="org-3", level="Rule", location="Organization.telecom", description="The telecom of an organization can never be of use 'home'", expression="where(use = 'home').empty()", source="http://hl7.org/fhir/StructureDefinition/Organization"), @Constraint(id="organization-4", level="Warning", location="contact.purpose", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/contactentity-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/contactentity-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Organization", generated=true)})
public class Organization
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final Boolean active;
    @Summary
    @Binding(bindingName="OrganizationType", strength=BindingStrength.Value.EXAMPLE, description="Used to categorize the organization.", valueSet="http://hl7.org/fhir/ValueSet/organization-type")
    private final List<CodeableConcept> type;
    @Summary
    private final String name;
    private final List<String> alias;
    private final List<ContactPoint> telecom;
    private final List<Address> address;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference partOf;
    private final List<Contact> contact;
    @ReferenceTarget(value={"Endpoint"})
    private final List<Reference> endpoint;

    private Organization(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.active = builder.active;
        this.type = Collections.unmodifiableList(builder.type);
        this.name = builder.name;
        this.alias = Collections.unmodifiableList(builder.alias);
        this.telecom = Collections.unmodifiableList(builder.telecom);
        this.address = Collections.unmodifiableList(builder.address);
        this.partOf = builder.partOf;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.endpoint = Collections.unmodifiableList(builder.endpoint);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Boolean getActive() {
        return this.active;
    }

    public List<CodeableConcept> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAlias() {
        return this.alias;
    }

    public List<ContactPoint> getTelecom() {
        return this.telecom;
    }

    public List<Address> getAddress() {
        return this.address;
    }

    public Reference getPartOf() {
        return this.partOf;
    }

    public List<Contact> getContact() {
        return this.contact;
    }

    public List<Reference> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.active != null || !this.type.isEmpty() || this.name != null || !this.alias.isEmpty() || !this.telecom.isEmpty() || !this.address.isEmpty() || this.partOf != null || !this.contact.isEmpty() || !this.endpoint.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.active, "active", visitor);
                this.accept(this.type, "type", visitor, CodeableConcept.class);
                this.accept(this.name, "name", visitor);
                this.accept(this.alias, "alias", visitor, String.class);
                this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                this.accept(this.address, "address", visitor, Address.class);
                this.accept(this.partOf, "partOf", visitor);
                this.accept(this.contact, "contact", visitor, Contact.class);
                this.accept(this.endpoint, "endpoint", visitor, Reference.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Organization other = (Organization)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.active, other.active) && Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name) && Objects.equals(this.alias, other.alias) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.address, other.address) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.contact, other.contact) && Objects.equals(this.endpoint, other.endpoint);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.active, this.type, this.name, this.alias, this.telecom, this.address, this.partOf, this.contact, this.endpoint);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Contact
    extends BackboneElement {
        @Binding(bindingName="ContactPartyType", strength=BindingStrength.Value.EXTENSIBLE, description="The purpose for which you would contact a contact party.", valueSet="http://hl7.org/fhir/ValueSet/contactentity-type")
        private final CodeableConcept purpose;
        private final HumanName name;
        private final List<ContactPoint> telecom;
        private final Address address;

        private Contact(Builder builder) {
            super(builder);
            this.purpose = builder.purpose;
            this.name = builder.name;
            this.telecom = Collections.unmodifiableList(builder.telecom);
            this.address = builder.address;
        }

        public CodeableConcept getPurpose() {
            return this.purpose;
        }

        public HumanName getName() {
            return this.name;
        }

        public List<ContactPoint> getTelecom() {
            return this.telecom;
        }

        public Address getAddress() {
            return this.address;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.purpose != null || this.name != null || !this.telecom.isEmpty() || this.address != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.purpose, "purpose", visitor);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.telecom, "telecom", visitor, ContactPoint.class);
                    this.accept(this.address, "address", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Contact other = (Contact)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.name, other.name) && Objects.equals(this.telecom, other.telecom) && Objects.equals(this.address, other.address);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.purpose, this.name, this.telecom, this.address);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept purpose;
            private HumanName name;
            private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
            private Address address;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder purpose(CodeableConcept purpose) {
                this.purpose = purpose;
                return this;
            }

            public Builder name(HumanName name) {
                this.name = name;
                return this;
            }

            public Builder telecom(ContactPoint ... telecom) {
                for (ContactPoint value : telecom) {
                    this.telecom.add(value);
                }
                return this;
            }

            public Builder telecom(Collection<ContactPoint> telecom) {
                this.telecom = new ArrayList<ContactPoint>(telecom);
                return this;
            }

            public Builder address(Address address) {
                this.address = address;
                return this;
            }

            @Override
            public Contact build() {
                Contact contact = new Contact(this);
                if (this.validating) {
                    this.validate(contact);
                }
                return contact;
            }

            protected void validate(Contact contact) {
                super.validate(contact);
                ValidationSupport.checkList(contact.telecom, "telecom", ContactPoint.class);
                ValidationSupport.requireValueOrChildren(contact);
            }

            protected Builder from(Contact contact) {
                super.from(contact);
                this.purpose = contact.purpose;
                this.name = contact.name;
                this.telecom.addAll(contact.telecom);
                this.address = contact.address;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private Boolean active;
        private List<CodeableConcept> type = new ArrayList<CodeableConcept>();
        private String name;
        private List<String> alias = new ArrayList<String>();
        private List<ContactPoint> telecom = new ArrayList<ContactPoint>();
        private List<Address> address = new ArrayList<Address>();
        private Reference partOf;
        private List<Contact> contact = new ArrayList<Contact>();
        private List<Reference> endpoint = new ArrayList<Reference>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder type(CodeableConcept ... type) {
            for (CodeableConcept value : type) {
                this.type.add(value);
            }
            return this;
        }

        public Builder type(Collection<CodeableConcept> type) {
            this.type = new ArrayList<CodeableConcept>(type);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder alias(String ... alias) {
            for (String value : alias) {
                this.alias.add(value);
            }
            return this;
        }

        public Builder alias(Collection<String> alias) {
            this.alias = new ArrayList<String>(alias);
            return this;
        }

        public Builder telecom(ContactPoint ... telecom) {
            for (ContactPoint value : telecom) {
                this.telecom.add(value);
            }
            return this;
        }

        public Builder telecom(Collection<ContactPoint> telecom) {
            this.telecom = new ArrayList<ContactPoint>(telecom);
            return this;
        }

        public Builder address(Address ... address) {
            for (Address value : address) {
                this.address.add(value);
            }
            return this;
        }

        public Builder address(Collection<Address> address) {
            this.address = new ArrayList<Address>(address);
            return this;
        }

        public Builder partOf(Reference partOf) {
            this.partOf = partOf;
            return this;
        }

        public Builder contact(Contact ... contact) {
            for (Contact value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<Contact> contact) {
            this.contact = new ArrayList<Contact>(contact);
            return this;
        }

        public Builder endpoint(Reference ... endpoint) {
            for (Reference value : endpoint) {
                this.endpoint.add(value);
            }
            return this;
        }

        public Builder endpoint(Collection<Reference> endpoint) {
            this.endpoint = new ArrayList<Reference>(endpoint);
            return this;
        }

        @Override
        public Organization build() {
            Organization organization = new Organization(this);
            if (this.validating) {
                this.validate(organization);
            }
            return organization;
        }

        protected void validate(Organization organization) {
            super.validate(organization);
            ValidationSupport.checkList(organization.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(organization.type, "type", CodeableConcept.class);
            ValidationSupport.checkList(organization.alias, "alias", String.class);
            ValidationSupport.checkList(organization.telecom, "telecom", ContactPoint.class);
            ValidationSupport.checkList(organization.address, "address", Address.class);
            ValidationSupport.checkList(organization.contact, "contact", Contact.class);
            ValidationSupport.checkList(organization.endpoint, "endpoint", Reference.class);
            ValidationSupport.checkReferenceType(organization.partOf, "partOf", "Organization");
            ValidationSupport.checkReferenceType(organization.endpoint, "endpoint", "Endpoint");
        }

        protected Builder from(Organization organization) {
            super.from(organization);
            this.identifier.addAll(organization.identifier);
            this.active = organization.active;
            this.type.addAll(organization.type);
            this.name = organization.name;
            this.alias.addAll(organization.alias);
            this.telecom.addAll(organization.telecom);
            this.address.addAll(organization.address);
            this.partOf = organization.partOf;
            this.contact.addAll(organization.contact);
            this.endpoint.addAll(organization.endpoint);
            return this;
        }
    }
}

