/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.NoteType;
import com.ibm.fhir.model.type.code.PaymentReconciliationStatus;
import com.ibm.fhir.model.type.code.RemittanceOutcome;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
public class PaymentReconciliation
extends DomainResource {
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="PaymentReconciliationStatus", strength=BindingStrength.Value.REQUIRED, description="A code specifying the state of the resource instance.", valueSet="http://hl7.org/fhir/ValueSet/fm-status|4.0.1")
    @Required
    private final PaymentReconciliationStatus status;
    @Summary
    private final Period period;
    @Summary
    @Required
    private final DateTime created;
    @Summary
    @ReferenceTarget(value={"Organization"})
    private final Reference paymentIssuer;
    @ReferenceTarget(value={"Task"})
    private final Reference request;
    @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
    private final Reference requestor;
    @Binding(bindingName="RemittanceOutcome", strength=BindingStrength.Value.REQUIRED, description="The outcome of the processing.", valueSet="http://hl7.org/fhir/ValueSet/remittance-outcome|4.0.1")
    private final RemittanceOutcome outcome;
    private final String disposition;
    @Summary
    @Required
    private final Date paymentDate;
    @Summary
    @Required
    private final Money paymentAmount;
    private final Identifier paymentIdentifier;
    private final List<Detail> detail;
    @Binding(bindingName="Forms", strength=BindingStrength.Value.EXAMPLE, description="The forms codes.", valueSet="http://hl7.org/fhir/ValueSet/forms")
    private final CodeableConcept formCode;
    private final List<ProcessNote> processNote;

    private PaymentReconciliation(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.period = builder.period;
        this.created = builder.created;
        this.paymentIssuer = builder.paymentIssuer;
        this.request = builder.request;
        this.requestor = builder.requestor;
        this.outcome = builder.outcome;
        this.disposition = builder.disposition;
        this.paymentDate = builder.paymentDate;
        this.paymentAmount = builder.paymentAmount;
        this.paymentIdentifier = builder.paymentIdentifier;
        this.detail = Collections.unmodifiableList(builder.detail);
        this.formCode = builder.formCode;
        this.processNote = Collections.unmodifiableList(builder.processNote);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public PaymentReconciliationStatus getStatus() {
        return this.status;
    }

    public Period getPeriod() {
        return this.period;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public Reference getPaymentIssuer() {
        return this.paymentIssuer;
    }

    public Reference getRequest() {
        return this.request;
    }

    public Reference getRequestor() {
        return this.requestor;
    }

    public RemittanceOutcome getOutcome() {
        return this.outcome;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public Date getPaymentDate() {
        return this.paymentDate;
    }

    public Money getPaymentAmount() {
        return this.paymentAmount;
    }

    public Identifier getPaymentIdentifier() {
        return this.paymentIdentifier;
    }

    public List<Detail> getDetail() {
        return this.detail;
    }

    public CodeableConcept getFormCode() {
        return this.formCode;
    }

    public List<ProcessNote> getProcessNote() {
        return this.processNote;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || this.period != null || this.created != null || this.paymentIssuer != null || this.request != null || this.requestor != null || this.outcome != null || this.disposition != null || this.paymentDate != null || this.paymentAmount != null || this.paymentIdentifier != null || !this.detail.isEmpty() || this.formCode != null || !this.processNote.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.period, "period", visitor);
                this.accept(this.created, "created", visitor);
                this.accept(this.paymentIssuer, "paymentIssuer", visitor);
                this.accept(this.request, "request", visitor);
                this.accept(this.requestor, "requestor", visitor);
                this.accept(this.outcome, "outcome", visitor);
                this.accept(this.disposition, "disposition", visitor);
                this.accept(this.paymentDate, "paymentDate", visitor);
                this.accept(this.paymentAmount, "paymentAmount", visitor);
                this.accept(this.paymentIdentifier, "paymentIdentifier", visitor);
                this.accept(this.detail, "detail", visitor, Detail.class);
                this.accept(this.formCode, "formCode", visitor);
                this.accept(this.processNote, "processNote", visitor, ProcessNote.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaymentReconciliation other = (PaymentReconciliation)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.period, other.period) && Objects.equals(this.created, other.created) && Objects.equals(this.paymentIssuer, other.paymentIssuer) && Objects.equals(this.request, other.request) && Objects.equals(this.requestor, other.requestor) && Objects.equals(this.outcome, other.outcome) && Objects.equals(this.disposition, other.disposition) && Objects.equals(this.paymentDate, other.paymentDate) && Objects.equals(this.paymentAmount, other.paymentAmount) && Objects.equals(this.paymentIdentifier, other.paymentIdentifier) && Objects.equals(this.detail, other.detail) && Objects.equals(this.formCode, other.formCode) && Objects.equals(this.processNote, other.processNote);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.period, this.created, this.paymentIssuer, this.request, this.requestor, this.outcome, this.disposition, this.paymentDate, this.paymentAmount, this.paymentIdentifier, this.detail, this.formCode, this.processNote);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class ProcessNote
    extends BackboneElement {
        @Binding(bindingName="NoteType", strength=BindingStrength.Value.REQUIRED, description="The presentation types of notes.", valueSet="http://hl7.org/fhir/ValueSet/note-type|4.0.1")
        private final NoteType type;
        private final String text;

        private ProcessNote(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.text = builder.text;
        }

        public NoteType getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || this.text != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.text, "text", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProcessNote other = (ProcessNote)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.text, other.text);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.text);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private NoteType type;
            private String text;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(NoteType type) {
                this.type = type;
                return this;
            }

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            @Override
            public ProcessNote build() {
                ProcessNote processNote = new ProcessNote(this);
                if (this.validating) {
                    this.validate(processNote);
                }
                return processNote;
            }

            protected void validate(ProcessNote processNote) {
                super.validate(processNote);
                ValidationSupport.requireValueOrChildren(processNote);
            }

            protected Builder from(ProcessNote processNote) {
                super.from(processNote);
                this.type = processNote.type;
                this.text = processNote.text;
                return this;
            }
        }
    }

    public static class Detail
    extends BackboneElement {
        private final Identifier identifier;
        private final Identifier predecessor;
        @Binding(bindingName="PaymentType", strength=BindingStrength.Value.EXAMPLE, description="The reason for the amount: payment, adjustment, advance.", valueSet="http://hl7.org/fhir/ValueSet/payment-type")
        @Required
        private final CodeableConcept type;
        private final Reference request;
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
        private final Reference submitter;
        private final Reference response;
        private final Date date;
        @ReferenceTarget(value={"PractitionerRole"})
        private final Reference responsible;
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "Organization"})
        private final Reference payee;
        private final Money amount;

        private Detail(Builder builder) {
            super(builder);
            this.identifier = builder.identifier;
            this.predecessor = builder.predecessor;
            this.type = builder.type;
            this.request = builder.request;
            this.submitter = builder.submitter;
            this.response = builder.response;
            this.date = builder.date;
            this.responsible = builder.responsible;
            this.payee = builder.payee;
            this.amount = builder.amount;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public Identifier getPredecessor() {
            return this.predecessor;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Reference getRequest() {
            return this.request;
        }

        public Reference getSubmitter() {
            return this.submitter;
        }

        public Reference getResponse() {
            return this.response;
        }

        public Date getDate() {
            return this.date;
        }

        public Reference getResponsible() {
            return this.responsible;
        }

        public Reference getPayee() {
            return this.payee;
        }

        public Money getAmount() {
            return this.amount;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.identifier != null || this.predecessor != null || this.type != null || this.request != null || this.submitter != null || this.response != null || this.date != null || this.responsible != null || this.payee != null || this.amount != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor);
                    this.accept(this.predecessor, "predecessor", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.request, "request", visitor);
                    this.accept(this.submitter, "submitter", visitor);
                    this.accept(this.response, "response", visitor);
                    this.accept(this.date, "date", visitor);
                    this.accept(this.responsible, "responsible", visitor);
                    this.accept(this.payee, "payee", visitor);
                    this.accept(this.amount, "amount", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Detail other = (Detail)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.predecessor, other.predecessor) && Objects.equals(this.type, other.type) && Objects.equals(this.request, other.request) && Objects.equals(this.submitter, other.submitter) && Objects.equals(this.response, other.response) && Objects.equals(this.date, other.date) && Objects.equals(this.responsible, other.responsible) && Objects.equals(this.payee, other.payee) && Objects.equals(this.amount, other.amount);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.predecessor, this.type, this.request, this.submitter, this.response, this.date, this.responsible, this.payee, this.amount);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Identifier identifier;
            private Identifier predecessor;
            private CodeableConcept type;
            private Reference request;
            private Reference submitter;
            private Reference response;
            private Date date;
            private Reference responsible;
            private Reference payee;
            private Money amount;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Identifier identifier) {
                this.identifier = identifier;
                return this;
            }

            public Builder predecessor(Identifier predecessor) {
                this.predecessor = predecessor;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder request(Reference request) {
                this.request = request;
                return this;
            }

            public Builder submitter(Reference submitter) {
                this.submitter = submitter;
                return this;
            }

            public Builder response(Reference response) {
                this.response = response;
                return this;
            }

            public Builder date(Date date) {
                this.date = date;
                return this;
            }

            public Builder responsible(Reference responsible) {
                this.responsible = responsible;
                return this;
            }

            public Builder payee(Reference payee) {
                this.payee = payee;
                return this;
            }

            public Builder amount(Money amount) {
                this.amount = amount;
                return this;
            }

            @Override
            public Detail build() {
                Detail detail = new Detail(this);
                if (this.validating) {
                    this.validate(detail);
                }
                return detail;
            }

            protected void validate(Detail detail) {
                super.validate(detail);
                ValidationSupport.requireNonNull(detail.type, "type");
                ValidationSupport.checkReferenceType(detail.submitter, "submitter", "Practitioner", "PractitionerRole", "Organization");
                ValidationSupport.checkReferenceType(detail.responsible, "responsible", "PractitionerRole");
                ValidationSupport.checkReferenceType(detail.payee, "payee", "Practitioner", "PractitionerRole", "Organization");
                ValidationSupport.requireValueOrChildren(detail);
            }

            protected Builder from(Detail detail) {
                super.from(detail);
                this.identifier = detail.identifier;
                this.predecessor = detail.predecessor;
                this.type = detail.type;
                this.request = detail.request;
                this.submitter = detail.submitter;
                this.response = detail.response;
                this.date = detail.date;
                this.responsible = detail.responsible;
                this.payee = detail.payee;
                this.amount = detail.amount;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private PaymentReconciliationStatus status;
        private Period period;
        private DateTime created;
        private Reference paymentIssuer;
        private Reference request;
        private Reference requestor;
        private RemittanceOutcome outcome;
        private String disposition;
        private Date paymentDate;
        private Money paymentAmount;
        private Identifier paymentIdentifier;
        private List<Detail> detail = new ArrayList<Detail>();
        private CodeableConcept formCode;
        private List<ProcessNote> processNote = new ArrayList<ProcessNote>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(PaymentReconciliationStatus status) {
            this.status = status;
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        public Builder created(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder paymentIssuer(Reference paymentIssuer) {
            this.paymentIssuer = paymentIssuer;
            return this;
        }

        public Builder request(Reference request) {
            this.request = request;
            return this;
        }

        public Builder requestor(Reference requestor) {
            this.requestor = requestor;
            return this;
        }

        public Builder outcome(RemittanceOutcome outcome) {
            this.outcome = outcome;
            return this;
        }

        public Builder disposition(String disposition) {
            this.disposition = disposition;
            return this;
        }

        public Builder paymentDate(Date paymentDate) {
            this.paymentDate = paymentDate;
            return this;
        }

        public Builder paymentAmount(Money paymentAmount) {
            this.paymentAmount = paymentAmount;
            return this;
        }

        public Builder paymentIdentifier(Identifier paymentIdentifier) {
            this.paymentIdentifier = paymentIdentifier;
            return this;
        }

        public Builder detail(Detail ... detail) {
            for (Detail value : detail) {
                this.detail.add(value);
            }
            return this;
        }

        public Builder detail(Collection<Detail> detail) {
            this.detail = new ArrayList<Detail>(detail);
            return this;
        }

        public Builder formCode(CodeableConcept formCode) {
            this.formCode = formCode;
            return this;
        }

        public Builder processNote(ProcessNote ... processNote) {
            for (ProcessNote value : processNote) {
                this.processNote.add(value);
            }
            return this;
        }

        public Builder processNote(Collection<ProcessNote> processNote) {
            this.processNote = new ArrayList<ProcessNote>(processNote);
            return this;
        }

        @Override
        public PaymentReconciliation build() {
            PaymentReconciliation paymentReconciliation = new PaymentReconciliation(this);
            if (this.validating) {
                this.validate(paymentReconciliation);
            }
            return paymentReconciliation;
        }

        protected void validate(PaymentReconciliation paymentReconciliation) {
            super.validate(paymentReconciliation);
            ValidationSupport.checkList(paymentReconciliation.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(paymentReconciliation.status, "status");
            ValidationSupport.requireNonNull(paymentReconciliation.created, "created");
            ValidationSupport.requireNonNull(paymentReconciliation.paymentDate, "paymentDate");
            ValidationSupport.requireNonNull(paymentReconciliation.paymentAmount, "paymentAmount");
            ValidationSupport.checkList(paymentReconciliation.detail, "detail", Detail.class);
            ValidationSupport.checkList(paymentReconciliation.processNote, "processNote", ProcessNote.class);
            ValidationSupport.checkReferenceType(paymentReconciliation.paymentIssuer, "paymentIssuer", "Organization");
            ValidationSupport.checkReferenceType(paymentReconciliation.request, "request", "Task");
            ValidationSupport.checkReferenceType(paymentReconciliation.requestor, "requestor", "Practitioner", "PractitionerRole", "Organization");
        }

        protected Builder from(PaymentReconciliation paymentReconciliation) {
            super.from(paymentReconciliation);
            this.identifier.addAll(paymentReconciliation.identifier);
            this.status = paymentReconciliation.status;
            this.period = paymentReconciliation.period;
            this.created = paymentReconciliation.created;
            this.paymentIssuer = paymentReconciliation.paymentIssuer;
            this.request = paymentReconciliation.request;
            this.requestor = paymentReconciliation.requestor;
            this.outcome = paymentReconciliation.outcome;
            this.disposition = paymentReconciliation.disposition;
            this.paymentDate = paymentReconciliation.paymentDate;
            this.paymentAmount = paymentReconciliation.paymentAmount;
            this.paymentIdentifier = paymentReconciliation.paymentIdentifier;
            this.detail.addAll(paymentReconciliation.detail);
            this.formCode = paymentReconciliation.formCode;
            this.processNote.addAll(paymentReconciliation.processNote);
            return this;
        }
    }
}

