/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.Signature;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.ProvenanceEntityRole;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="provenance-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://terminology.hl7.org/ValueSet/v3-PurposeOfUse", expression="reason.exists() implies (reason.all(memberOf('http://terminology.hl7.org/ValueSet/v3-PurposeOfUse', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/Provenance", generated=true), @Constraint(id="provenance-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/provenance-activity-type", expression="activity.exists() implies (activity.memberOf('http://hl7.org/fhir/ValueSet/provenance-activity-type', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/Provenance", generated=true), @Constraint(id="provenance-2", level="Warning", location="agent.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/provenance-agent-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/provenance-agent-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/Provenance", generated=true)})
public class Provenance
extends DomainResource {
    @Summary
    @Required
    private final List<Reference> target;
    @Choice(value={Period.class, DateTime.class})
    private final Element occurred;
    @Summary
    @Required
    private final Instant recorded;
    private final List<Uri> policy;
    @ReferenceTarget(value={"Location"})
    private final Reference location;
    @Binding(bindingName="ProvenanceReason", strength=BindingStrength.Value.EXTENSIBLE, description="The reason the activity took place.", valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
    private final List<CodeableConcept> reason;
    @Binding(bindingName="ProvenanceActivity", strength=BindingStrength.Value.EXTENSIBLE, description="The activity that took place.", valueSet="http://hl7.org/fhir/ValueSet/provenance-activity-type")
    private final CodeableConcept activity;
    @Required
    private final List<Agent> agent;
    private final List<Entity> entity;
    private final List<Signature> signature;

    private Provenance(Builder builder) {
        super(builder);
        this.target = Collections.unmodifiableList(builder.target);
        this.occurred = builder.occurred;
        this.recorded = builder.recorded;
        this.policy = Collections.unmodifiableList(builder.policy);
        this.location = builder.location;
        this.reason = Collections.unmodifiableList(builder.reason);
        this.activity = builder.activity;
        this.agent = Collections.unmodifiableList(builder.agent);
        this.entity = Collections.unmodifiableList(builder.entity);
        this.signature = Collections.unmodifiableList(builder.signature);
    }

    public List<Reference> getTarget() {
        return this.target;
    }

    public Element getOccurred() {
        return this.occurred;
    }

    public Instant getRecorded() {
        return this.recorded;
    }

    public List<Uri> getPolicy() {
        return this.policy;
    }

    public Reference getLocation() {
        return this.location;
    }

    public List<CodeableConcept> getReason() {
        return this.reason;
    }

    public CodeableConcept getActivity() {
        return this.activity;
    }

    public List<Agent> getAgent() {
        return this.agent;
    }

    public List<Entity> getEntity() {
        return this.entity;
    }

    public List<Signature> getSignature() {
        return this.signature;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.target.isEmpty() || this.occurred != null || this.recorded != null || !this.policy.isEmpty() || this.location != null || !this.reason.isEmpty() || this.activity != null || !this.agent.isEmpty() || !this.entity.isEmpty() || !this.signature.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.target, "target", visitor, Reference.class);
                this.accept(this.occurred, "occurred", visitor);
                this.accept(this.recorded, "recorded", visitor);
                this.accept(this.policy, "policy", visitor, Uri.class);
                this.accept(this.location, "location", visitor);
                this.accept(this.reason, "reason", visitor, CodeableConcept.class);
                this.accept(this.activity, "activity", visitor);
                this.accept(this.agent, "agent", visitor, Agent.class);
                this.accept(this.entity, "entity", visitor, Entity.class);
                this.accept(this.signature, "signature", visitor, Signature.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Provenance other = (Provenance)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.target, other.target) && Objects.equals(this.occurred, other.occurred) && Objects.equals(this.recorded, other.recorded) && Objects.equals(this.policy, other.policy) && Objects.equals(this.location, other.location) && Objects.equals(this.reason, other.reason) && Objects.equals(this.activity, other.activity) && Objects.equals(this.agent, other.agent) && Objects.equals(this.entity, other.entity) && Objects.equals(this.signature, other.signature);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.target, this.occurred, this.recorded, this.policy, this.location, this.reason, this.activity, this.agent, this.entity, this.signature);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Entity
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ProvenanceEntityRole", strength=BindingStrength.Value.REQUIRED, description="How an entity was used in an activity.", valueSet="http://hl7.org/fhir/ValueSet/provenance-entity-role|4.0.1")
        @Required
        private final ProvenanceEntityRole role;
        @Summary
        @Required
        private final Reference what;
        private final List<Agent> agent;

        private Entity(Builder builder) {
            super(builder);
            this.role = builder.role;
            this.what = builder.what;
            this.agent = Collections.unmodifiableList(builder.agent);
        }

        public ProvenanceEntityRole getRole() {
            return this.role;
        }

        public Reference getWhat() {
            return this.what;
        }

        public List<Agent> getAgent() {
            return this.agent;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.role != null || this.what != null || !this.agent.isEmpty();
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.role, "role", visitor);
                    this.accept(this.what, "what", visitor);
                    this.accept(this.agent, "agent", visitor, Agent.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entity other = (Entity)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.role, other.role) && Objects.equals(this.what, other.what) && Objects.equals(this.agent, other.agent);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.role, this.what, this.agent);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private ProvenanceEntityRole role;
            private Reference what;
            private List<Agent> agent = new ArrayList<Agent>();

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder role(ProvenanceEntityRole role) {
                this.role = role;
                return this;
            }

            public Builder what(Reference what) {
                this.what = what;
                return this;
            }

            public Builder agent(Agent ... agent) {
                for (Agent value : agent) {
                    this.agent.add(value);
                }
                return this;
            }

            public Builder agent(Collection<Agent> agent) {
                this.agent = new ArrayList<Agent>(agent);
                return this;
            }

            @Override
            public Entity build() {
                Entity entity = new Entity(this);
                if (this.validating) {
                    this.validate(entity);
                }
                return entity;
            }

            protected void validate(Entity entity) {
                super.validate(entity);
                ValidationSupport.requireNonNull(entity.role, "role");
                ValidationSupport.requireNonNull(entity.what, "what");
                ValidationSupport.checkList(entity.agent, "agent", Agent.class);
                ValidationSupport.requireValueOrChildren(entity);
            }

            protected Builder from(Entity entity) {
                super.from(entity);
                this.role = entity.role;
                this.what = entity.what;
                this.agent.addAll(entity.agent);
                return this;
            }
        }
    }

    public static class Agent
    extends BackboneElement {
        @Summary
        @Binding(bindingName="ProvenanceAgentType", strength=BindingStrength.Value.EXTENSIBLE, description="The type of participation that a provenance agent played with respect to the activity.", valueSet="http://hl7.org/fhir/ValueSet/provenance-agent-type")
        private final CodeableConcept type;
        @Binding(bindingName="ProvenanceAgentRole", strength=BindingStrength.Value.EXAMPLE, description="The role that a provenance agent played with respect to the activity.", valueSet="http://hl7.org/fhir/ValueSet/security-role-type")
        private final List<CodeableConcept> role;
        @Summary
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "RelatedPerson", "Patient", "Device", "Organization"})
        @Required
        private final Reference who;
        @ReferenceTarget(value={"Practitioner", "PractitionerRole", "RelatedPerson", "Patient", "Device", "Organization"})
        private final Reference onBehalfOf;

        private Agent(Builder builder) {
            super(builder);
            this.type = builder.type;
            this.role = Collections.unmodifiableList(builder.role);
            this.who = builder.who;
            this.onBehalfOf = builder.onBehalfOf;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public List<CodeableConcept> getRole() {
            return this.role;
        }

        public Reference getWho() {
            return this.who;
        }

        public Reference getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.type != null || !this.role.isEmpty() || this.who != null || this.onBehalfOf != null;
        }

        @Override
        public void accept(String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.role, "role", visitor, CodeableConcept.class);
                    this.accept(this.who, "who", visitor);
                    this.accept(this.onBehalfOf, "onBehalfOf", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Agent other = (Agent)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.role, other.role) && Objects.equals(this.who, other.who) && Objects.equals(this.onBehalfOf, other.onBehalfOf);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.role, this.who, this.onBehalfOf);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept type;
            private List<CodeableConcept> role = new ArrayList<CodeableConcept>();
            private Reference who;
            private Reference onBehalfOf;

            private Builder() {
            }

            @Override
            public Builder id(String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder role(CodeableConcept ... role) {
                for (CodeableConcept value : role) {
                    this.role.add(value);
                }
                return this;
            }

            public Builder role(Collection<CodeableConcept> role) {
                this.role = new ArrayList<CodeableConcept>(role);
                return this;
            }

            public Builder who(Reference who) {
                this.who = who;
                return this;
            }

            public Builder onBehalfOf(Reference onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            @Override
            public Agent build() {
                Agent agent = new Agent(this);
                if (this.validating) {
                    this.validate(agent);
                }
                return agent;
            }

            protected void validate(Agent agent) {
                super.validate(agent);
                ValidationSupport.checkList(agent.role, "role", CodeableConcept.class);
                ValidationSupport.requireNonNull(agent.who, "who");
                ValidationSupport.checkReferenceType(agent.who, "who", "Practitioner", "PractitionerRole", "RelatedPerson", "Patient", "Device", "Organization");
                ValidationSupport.checkReferenceType(agent.onBehalfOf, "onBehalfOf", "Practitioner", "PractitionerRole", "RelatedPerson", "Patient", "Device", "Organization");
                ValidationSupport.requireValueOrChildren(agent);
            }

            protected Builder from(Agent agent) {
                super.from(agent);
                this.type = agent.type;
                this.role.addAll(agent.role);
                this.who = agent.who;
                this.onBehalfOf = agent.onBehalfOf;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Reference> target = new ArrayList<Reference>();
        private Element occurred;
        private Instant recorded;
        private List<Uri> policy = new ArrayList<Uri>();
        private Reference location;
        private List<CodeableConcept> reason = new ArrayList<CodeableConcept>();
        private CodeableConcept activity;
        private List<Agent> agent = new ArrayList<Agent>();
        private List<Entity> entity = new ArrayList<Entity>();
        private List<Signature> signature = new ArrayList<Signature>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder target(Reference ... target) {
            for (Reference value : target) {
                this.target.add(value);
            }
            return this;
        }

        public Builder target(Collection<Reference> target) {
            this.target = new ArrayList<Reference>(target);
            return this;
        }

        public Builder occurred(Element occurred) {
            this.occurred = occurred;
            return this;
        }

        public Builder recorded(Instant recorded) {
            this.recorded = recorded;
            return this;
        }

        public Builder policy(Uri ... policy) {
            for (Uri value : policy) {
                this.policy.add(value);
            }
            return this;
        }

        public Builder policy(Collection<Uri> policy) {
            this.policy = new ArrayList<Uri>(policy);
            return this;
        }

        public Builder location(Reference location) {
            this.location = location;
            return this;
        }

        public Builder reason(CodeableConcept ... reason) {
            for (CodeableConcept value : reason) {
                this.reason.add(value);
            }
            return this;
        }

        public Builder reason(Collection<CodeableConcept> reason) {
            this.reason = new ArrayList<CodeableConcept>(reason);
            return this;
        }

        public Builder activity(CodeableConcept activity) {
            this.activity = activity;
            return this;
        }

        public Builder agent(Agent ... agent) {
            for (Agent value : agent) {
                this.agent.add(value);
            }
            return this;
        }

        public Builder agent(Collection<Agent> agent) {
            this.agent = new ArrayList<Agent>(agent);
            return this;
        }

        public Builder entity(Entity ... entity) {
            for (Entity value : entity) {
                this.entity.add(value);
            }
            return this;
        }

        public Builder entity(Collection<Entity> entity) {
            this.entity = new ArrayList<Entity>(entity);
            return this;
        }

        public Builder signature(Signature ... signature) {
            for (Signature value : signature) {
                this.signature.add(value);
            }
            return this;
        }

        public Builder signature(Collection<Signature> signature) {
            this.signature = new ArrayList<Signature>(signature);
            return this;
        }

        @Override
        public Provenance build() {
            Provenance provenance = new Provenance(this);
            if (this.validating) {
                this.validate(provenance);
            }
            return provenance;
        }

        protected void validate(Provenance provenance) {
            super.validate(provenance);
            ValidationSupport.checkNonEmptyList(provenance.target, "target", Reference.class);
            ValidationSupport.choiceElement(provenance.occurred, "occurred", Period.class, DateTime.class);
            ValidationSupport.requireNonNull(provenance.recorded, "recorded");
            ValidationSupport.checkList(provenance.policy, "policy", Uri.class);
            ValidationSupport.checkList(provenance.reason, "reason", CodeableConcept.class);
            ValidationSupport.checkNonEmptyList(provenance.agent, "agent", Agent.class);
            ValidationSupport.checkList(provenance.entity, "entity", Entity.class);
            ValidationSupport.checkList(provenance.signature, "signature", Signature.class);
            ValidationSupport.checkReferenceType(provenance.location, "location", "Location");
        }

        protected Builder from(Provenance provenance) {
            super.from(provenance);
            this.target.addAll(provenance.target);
            this.occurred = provenance.occurred;
            this.recorded = provenance.recorded;
            this.policy.addAll(provenance.policy);
            this.location = provenance.location;
            this.reason.addAll(provenance.reason);
            this.activity = provenance.activity;
            this.agent.addAll(provenance.agent);
            this.entity.addAll(provenance.entity);
            this.signature.addAll(provenance.signature);
            return this;
        }
    }
}

