/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Time;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.EnableWhenBehavior;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.QuestionnaireItemOperator;
import com.ibm.fhir.model.type.code.QuestionnaireItemType;
import com.ibm.fhir.model.type.code.ResourceType;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="que-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/Questionnaire"), @Constraint(id="que-1", level="Rule", location="Questionnaire.item", description="Group items must have nested items, display items cannot have nested items", expression="(type='group' implies item.empty().not()) and (type.trace('type')='display' implies item.trace('item').empty())", source="http://hl7.org/fhir/StructureDefinition/Questionnaire"), @Constraint(id="que-2", level="Rule", location="(base)", description="The link ids for groups and questions must be unique within the questionnaire", expression="descendants().linkId.isDistinct()", source="http://hl7.org/fhir/StructureDefinition/Questionnaire"), @Constraint(id="que-3", level="Rule", location="Questionnaire.item", description="Display items cannot have a \"code\" asserted", expression="type!='display' or code.empty()", source="http://hl7.org/fhir/StructureDefinition/Questionnaire"), @Constraint(id="que-4", level="Rule", location="Questionnaire.item", description="A question cannot have both answerOption and answerValueSet", expression="answerOption.empty() or answerValueSet.empty()", source="http://hl7.org/fhir/StructureDefinition/Questionnaire"), @Constraint(id="que-5", level="Rule", location="Questionnaire.item", description="Only 'choice' and 'open-choice' items can have answerValueSet", expression="(type ='choice' or type = 'open-choice' or type = 'decimal' or type = 'integer' or type = 'date' or type = 'dateTime' or type = 'time' or type = 'string' or type = 'quantity') or (answerValueSet.empty() and answerOption.empty())", source="http://hl7.org/fhir/StructureDefinition/Questionnaire"), @Constraint(id="que-6", level="Rule", location="Questionnaire.item", description="Required and repeat aren't permitted for display items", expression="type!='display' or (required.empty() and repeats.empty())", source="http://hl7.org/fhir/StructureDefinition/Questionnaire"), @Constraint(id="que-7", level="Rule", location="Questionnaire.item.enableWhen", description="If the operator is 'exists', the value must be a boolean", expression="operator = 'exists' implies (answer is Boolean)", source="http://hl7.org/fhir/StructureDefinition/Questionnaire"), @Constraint(id="que-8", level="Rule", location="Questionnaire.item", description="Initial values can't be specified for groups or display items", expression="(type!='group' and type!='display') or initial.empty()", source="http://hl7.org/fhir/StructureDefinition/Questionnaire"), @Constraint(id="que-9", level="Rule", location="Questionnaire.item", description="Read-only can't be specified for \"display\" items", expression="type!='display' or readOnly.empty()", source="http://hl7.org/fhir/StructureDefinition/Questionnaire"), @Constraint(id="que-10", level="Rule", location="Questionnaire.item", description="Maximum length can only be declared for simple question types", expression="(type in ('boolean' | 'decimal' | 'integer' | 'string' | 'text' | 'url' | 'open-choice')) or maxLength.empty()", source="http://hl7.org/fhir/StructureDefinition/Questionnaire"), @Constraint(id="que-11", level="Rule", location="Questionnaire.item", description="If one or more answerOption is present, initial[x] must be missing", expression="answerOption.empty() or initial.empty()", source="http://hl7.org/fhir/StructureDefinition/Questionnaire"), @Constraint(id="que-12", level="Rule", location="Questionnaire.item", description="If there are more than one enableWhen, enableBehavior must be specified", expression="enableWhen.count() > 2 implies enableBehavior.exists()", source="http://hl7.org/fhir/StructureDefinition/Questionnaire"), @Constraint(id="que-13", level="Rule", location="Questionnaire.item", description="Can only have multiple initial values for repeating items", expression="repeats=true or initial.count() <= 1", source="http://hl7.org/fhir/StructureDefinition/Questionnaire"), @Constraint(id="questionnaire-14", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/Questionnaire", generated=true)})
public class Questionnaire
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final String version;
    @Summary
    private final String name;
    @Summary
    private final String title;
    private final List<Canonical> derivedFrom;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    @Binding(bindingName="ResourceType", strength=BindingStrength.Value.REQUIRED, description="One of the resource types defined as part of this version of FHIR.", valueSet="http://hl7.org/fhir/ValueSet/resource-types|4.0.1")
    private final List<ResourceType> subjectType;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final Markdown copyright;
    private final Date approvalDate;
    private final Date lastReviewDate;
    @Summary
    private final Period effectivePeriod;
    @Summary
    @Binding(bindingName="QuestionnaireConcept", strength=BindingStrength.Value.EXAMPLE, description="Codes for questionnaires, groups and individual questions.", valueSet="http://hl7.org/fhir/ValueSet/questionnaire-questions")
    private final List<Coding> code;
    private final List<Item> item;

    private Questionnaire(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.derivedFrom = Collections.unmodifiableList(builder.derivedFrom);
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.subjectType = Collections.unmodifiableList(builder.subjectType);
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.copyright = builder.copyright;
        this.approvalDate = builder.approvalDate;
        this.lastReviewDate = builder.lastReviewDate;
        this.effectivePeriod = builder.effectivePeriod;
        this.code = Collections.unmodifiableList(builder.code);
        this.item = Collections.unmodifiableList(builder.item);
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Canonical> getDerivedFrom() {
        return this.derivedFrom;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public List<ResourceType> getSubjectType() {
        return this.subjectType;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public List<Coding> getCode() {
        return this.code;
    }

    public List<Item> getItem() {
        return this.item;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || !this.derivedFrom.isEmpty() || this.status != null || this.experimental != null || !this.subjectType.isEmpty() || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.copyright != null || this.approvalDate != null || this.lastReviewDate != null || this.effectivePeriod != null || !this.code.isEmpty() || !this.item.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.derivedFrom, "derivedFrom", visitor, Canonical.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.subjectType, "subjectType", visitor, ResourceType.class);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.approvalDate, "approvalDate", visitor);
                this.accept(this.lastReviewDate, "lastReviewDate", visitor);
                this.accept(this.effectivePeriod, "effectivePeriod", visitor);
                this.accept(this.code, "code", visitor, Coding.class);
                this.accept(this.item, "item", visitor, Item.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Questionnaire other = (Questionnaire)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.derivedFrom, other.derivedFrom) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.subjectType, other.subjectType) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.approvalDate, other.approvalDate) && Objects.equals(this.lastReviewDate, other.lastReviewDate) && Objects.equals(this.effectivePeriod, other.effectivePeriod) && Objects.equals(this.code, other.code) && Objects.equals(this.item, other.item);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.derivedFrom, this.status, this.experimental, this.subjectType, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.code, this.item);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Item
    extends BackboneElement {
        @Required
        private final String linkId;
        private final Uri definition;
        @Binding(bindingName="QuestionnaireConcept", strength=BindingStrength.Value.EXAMPLE, description="Codes for questionnaires, groups and individual questions.", valueSet="http://hl7.org/fhir/ValueSet/questionnaire-questions")
        private final List<Coding> code;
        private final String prefix;
        private final String text;
        @Binding(bindingName="QuestionnaireItemType", strength=BindingStrength.Value.REQUIRED, description="Distinguishes groups from questions and display text and indicates data type for questions.", valueSet="http://hl7.org/fhir/ValueSet/item-type|4.0.1")
        @Required
        private final QuestionnaireItemType type;
        private final List<EnableWhen> enableWhen;
        @Binding(bindingName="EnableWhenBehavior", strength=BindingStrength.Value.REQUIRED, description="Controls how multiple enableWhen values are interpreted -  whether all or any must be true.", valueSet="http://hl7.org/fhir/ValueSet/questionnaire-enable-behavior|4.0.1")
        private final EnableWhenBehavior enableBehavior;
        private final Boolean required;
        private final Boolean repeats;
        private final Boolean readOnly;
        private final Integer maxLength;
        private final Canonical answerValueSet;
        private final List<AnswerOption> answerOption;
        private final List<Initial> initial;
        private final List<Item> item;

        private Item(Builder builder) {
            super(builder);
            this.linkId = builder.linkId;
            this.definition = builder.definition;
            this.code = Collections.unmodifiableList(builder.code);
            this.prefix = builder.prefix;
            this.text = builder.text;
            this.type = builder.type;
            this.enableWhen = Collections.unmodifiableList(builder.enableWhen);
            this.enableBehavior = builder.enableBehavior;
            this.required = builder.required;
            this.repeats = builder.repeats;
            this.readOnly = builder.readOnly;
            this.maxLength = builder.maxLength;
            this.answerValueSet = builder.answerValueSet;
            this.answerOption = Collections.unmodifiableList(builder.answerOption);
            this.initial = Collections.unmodifiableList(builder.initial);
            this.item = Collections.unmodifiableList(builder.item);
        }

        public String getLinkId() {
            return this.linkId;
        }

        public Uri getDefinition() {
            return this.definition;
        }

        public List<Coding> getCode() {
            return this.code;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getText() {
            return this.text;
        }

        public QuestionnaireItemType getType() {
            return this.type;
        }

        public List<EnableWhen> getEnableWhen() {
            return this.enableWhen;
        }

        public EnableWhenBehavior getEnableBehavior() {
            return this.enableBehavior;
        }

        public Boolean getRequired() {
            return this.required;
        }

        public Boolean getRepeats() {
            return this.repeats;
        }

        public Boolean getReadOnly() {
            return this.readOnly;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Canonical getAnswerValueSet() {
            return this.answerValueSet;
        }

        public List<AnswerOption> getAnswerOption() {
            return this.answerOption;
        }

        public List<Initial> getInitial() {
            return this.initial;
        }

        public List<Item> getItem() {
            return this.item;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.linkId != null || this.definition != null || !this.code.isEmpty() || this.prefix != null || this.text != null || this.type != null || !this.enableWhen.isEmpty() || this.enableBehavior != null || this.required != null || this.repeats != null || this.readOnly != null || this.maxLength != null || this.answerValueSet != null || !this.answerOption.isEmpty() || !this.initial.isEmpty() || !this.item.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.linkId, "linkId", visitor);
                    this.accept(this.definition, "definition", visitor);
                    this.accept(this.code, "code", visitor, Coding.class);
                    this.accept(this.prefix, "prefix", visitor);
                    this.accept(this.text, "text", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.enableWhen, "enableWhen", visitor, EnableWhen.class);
                    this.accept(this.enableBehavior, "enableBehavior", visitor);
                    this.accept(this.required, "required", visitor);
                    this.accept(this.repeats, "repeats", visitor);
                    this.accept(this.readOnly, "readOnly", visitor);
                    this.accept(this.maxLength, "maxLength", visitor);
                    this.accept(this.answerValueSet, "answerValueSet", visitor);
                    this.accept(this.answerOption, "answerOption", visitor, AnswerOption.class);
                    this.accept(this.initial, "initial", visitor, Initial.class);
                    this.accept(this.item, "item", visitor, Item.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.linkId, other.linkId) && Objects.equals(this.definition, other.definition) && Objects.equals(this.code, other.code) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.text, other.text) && Objects.equals(this.type, other.type) && Objects.equals(this.enableWhen, other.enableWhen) && Objects.equals(this.enableBehavior, other.enableBehavior) && Objects.equals(this.required, other.required) && Objects.equals(this.repeats, other.repeats) && Objects.equals(this.readOnly, other.readOnly) && Objects.equals(this.maxLength, other.maxLength) && Objects.equals(this.answerValueSet, other.answerValueSet) && Objects.equals(this.answerOption, other.answerOption) && Objects.equals(this.initial, other.initial) && Objects.equals(this.item, other.item);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.linkId, this.definition, this.code, this.prefix, this.text, this.type, this.enableWhen, this.enableBehavior, this.required, this.repeats, this.readOnly, this.maxLength, this.answerValueSet, this.answerOption, this.initial, this.item);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Initial
        extends BackboneElement {
            @Choice(value={Boolean.class, Decimal.class, Integer.class, Date.class, DateTime.class, Time.class, String.class, Uri.class, Attachment.class, Coding.class, Quantity.class, Reference.class})
            @Binding(bindingName="QuestionnaireQuestionOption2", strength=BindingStrength.Value.EXAMPLE, description="Allowed values to answer questions.", valueSet="http://hl7.org/fhir/ValueSet/questionnaire-answers")
            @Required
            private final Element value;

            private Initial(Builder builder) {
                super(builder);
                this.value = builder.value;
            }

            public Element getValue() {
                return this.value;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.value != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.value, "value", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Initial other = (Initial)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.value, other.value);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.value);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Element value;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder value(Element value) {
                    this.value = value;
                    return this;
                }

                @Override
                public Initial build() {
                    Initial initial = new Initial(this);
                    if (this.validating) {
                        this.validate(initial);
                    }
                    return initial;
                }

                protected void validate(Initial initial) {
                    super.validate(initial);
                    ValidationSupport.requireChoiceElement(initial.value, "value", Boolean.class, Decimal.class, Integer.class, Date.class, DateTime.class, Time.class, String.class, Uri.class, Attachment.class, Coding.class, Quantity.class, Reference.class);
                    ValidationSupport.requireValueOrChildren(initial);
                }

                protected Builder from(Initial initial) {
                    super.from(initial);
                    this.value = initial.value;
                    return this;
                }
            }
        }

        public static class AnswerOption
        extends BackboneElement {
            @Choice(value={Integer.class, Date.class, Time.class, String.class, Coding.class, Reference.class})
            @Binding(bindingName="QuestionnaireQuestionOption", strength=BindingStrength.Value.EXAMPLE, description="Allowed values to answer questions.", valueSet="http://hl7.org/fhir/ValueSet/questionnaire-answers")
            @Required
            private final Element value;
            private final Boolean initialSelected;

            private AnswerOption(Builder builder) {
                super(builder);
                this.value = builder.value;
                this.initialSelected = builder.initialSelected;
            }

            public Element getValue() {
                return this.value;
            }

            public Boolean getInitialSelected() {
                return this.initialSelected;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.value != null || this.initialSelected != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.value, "value", visitor);
                        this.accept(this.initialSelected, "initialSelected", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                AnswerOption other = (AnswerOption)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.value, other.value) && Objects.equals(this.initialSelected, other.initialSelected);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.value, this.initialSelected);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Element value;
                private Boolean initialSelected;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder value(Element value) {
                    this.value = value;
                    return this;
                }

                public Builder initialSelected(Boolean initialSelected) {
                    this.initialSelected = initialSelected;
                    return this;
                }

                @Override
                public AnswerOption build() {
                    AnswerOption answerOption = new AnswerOption(this);
                    if (this.validating) {
                        this.validate(answerOption);
                    }
                    return answerOption;
                }

                protected void validate(AnswerOption answerOption) {
                    super.validate(answerOption);
                    ValidationSupport.requireChoiceElement(answerOption.value, "value", Integer.class, Date.class, Time.class, String.class, Coding.class, Reference.class);
                    ValidationSupport.requireValueOrChildren(answerOption);
                }

                protected Builder from(AnswerOption answerOption) {
                    super.from(answerOption);
                    this.value = answerOption.value;
                    this.initialSelected = answerOption.initialSelected;
                    return this;
                }
            }
        }

        public static class EnableWhen
        extends BackboneElement {
            @Required
            private final String question;
            @Binding(bindingName="QuestionnaireItemOperator", strength=BindingStrength.Value.REQUIRED, description="The criteria by which a question is enabled.", valueSet="http://hl7.org/fhir/ValueSet/questionnaire-enable-operator|4.0.1")
            @Required
            private final QuestionnaireItemOperator operator;
            @Choice(value={Boolean.class, Decimal.class, Integer.class, Date.class, DateTime.class, Time.class, String.class, Coding.class, Quantity.class, Reference.class})
            @Binding(bindingName="QuestionnaireQuestionOption3", strength=BindingStrength.Value.EXAMPLE, description="Allowed values to answer questions.", valueSet="http://hl7.org/fhir/ValueSet/questionnaire-answers")
            @Required
            private final Element answer;

            private EnableWhen(Builder builder) {
                super(builder);
                this.question = builder.question;
                this.operator = builder.operator;
                this.answer = builder.answer;
            }

            public String getQuestion() {
                return this.question;
            }

            public QuestionnaireItemOperator getOperator() {
                return this.operator;
            }

            public Element getAnswer() {
                return this.answer;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.question != null || this.operator != null || this.answer != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.question, "question", visitor);
                        this.accept(this.operator, "operator", visitor);
                        this.accept(this.answer, "answer", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                EnableWhen other = (EnableWhen)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.question, other.question) && Objects.equals(this.operator, other.operator) && Objects.equals(this.answer, other.answer);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.question, this.operator, this.answer);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private String question;
                private QuestionnaireItemOperator operator;
                private Element answer;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder question(String question) {
                    this.question = question;
                    return this;
                }

                public Builder operator(QuestionnaireItemOperator operator) {
                    this.operator = operator;
                    return this;
                }

                public Builder answer(Element answer) {
                    this.answer = answer;
                    return this;
                }

                @Override
                public EnableWhen build() {
                    EnableWhen enableWhen = new EnableWhen(this);
                    if (this.validating) {
                        this.validate(enableWhen);
                    }
                    return enableWhen;
                }

                protected void validate(EnableWhen enableWhen) {
                    super.validate(enableWhen);
                    ValidationSupport.requireNonNull(enableWhen.question, "question");
                    ValidationSupport.requireNonNull(enableWhen.operator, "operator");
                    ValidationSupport.requireChoiceElement(enableWhen.answer, "answer", Boolean.class, Decimal.class, Integer.class, Date.class, DateTime.class, Time.class, String.class, Coding.class, Quantity.class, Reference.class);
                    ValidationSupport.requireValueOrChildren(enableWhen);
                }

                protected Builder from(EnableWhen enableWhen) {
                    super.from(enableWhen);
                    this.question = enableWhen.question;
                    this.operator = enableWhen.operator;
                    this.answer = enableWhen.answer;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String linkId;
            private Uri definition;
            private List<Coding> code = new ArrayList<Coding>();
            private String prefix;
            private String text;
            private QuestionnaireItemType type;
            private List<EnableWhen> enableWhen = new ArrayList<EnableWhen>();
            private EnableWhenBehavior enableBehavior;
            private Boolean required;
            private Boolean repeats;
            private Boolean readOnly;
            private Integer maxLength;
            private Canonical answerValueSet;
            private List<AnswerOption> answerOption = new ArrayList<AnswerOption>();
            private List<Initial> initial = new ArrayList<Initial>();
            private List<Item> item = new ArrayList<Item>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder linkId(String linkId) {
                this.linkId = linkId;
                return this;
            }

            public Builder definition(Uri definition) {
                this.definition = definition;
                return this;
            }

            public Builder code(Coding ... code) {
                for (Coding value : code) {
                    this.code.add(value);
                }
                return this;
            }

            public Builder code(Collection<Coding> code) {
                this.code = new ArrayList<Coding>(code);
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            public Builder type(QuestionnaireItemType type) {
                this.type = type;
                return this;
            }

            public Builder enableWhen(EnableWhen ... enableWhen) {
                for (EnableWhen value : enableWhen) {
                    this.enableWhen.add(value);
                }
                return this;
            }

            public Builder enableWhen(Collection<EnableWhen> enableWhen) {
                this.enableWhen = new ArrayList<EnableWhen>(enableWhen);
                return this;
            }

            public Builder enableBehavior(EnableWhenBehavior enableBehavior) {
                this.enableBehavior = enableBehavior;
                return this;
            }

            public Builder required(Boolean required) {
                this.required = required;
                return this;
            }

            public Builder repeats(Boolean repeats) {
                this.repeats = repeats;
                return this;
            }

            public Builder readOnly(Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Builder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public Builder answerValueSet(Canonical answerValueSet) {
                this.answerValueSet = answerValueSet;
                return this;
            }

            public Builder answerOption(AnswerOption ... answerOption) {
                for (AnswerOption value : answerOption) {
                    this.answerOption.add(value);
                }
                return this;
            }

            public Builder answerOption(Collection<AnswerOption> answerOption) {
                this.answerOption = new ArrayList<AnswerOption>(answerOption);
                return this;
            }

            public Builder initial(Initial ... initial) {
                for (Initial value : initial) {
                    this.initial.add(value);
                }
                return this;
            }

            public Builder initial(Collection<Initial> initial) {
                this.initial = new ArrayList<Initial>(initial);
                return this;
            }

            public Builder item(Item ... item) {
                for (Item value : item) {
                    this.item.add(value);
                }
                return this;
            }

            public Builder item(Collection<Item> item) {
                this.item = new ArrayList<Item>(item);
                return this;
            }

            @Override
            public Item build() {
                Item item = new Item(this);
                if (this.validating) {
                    this.validate(item);
                }
                return item;
            }

            protected void validate(Item item) {
                super.validate(item);
                ValidationSupport.requireNonNull(item.linkId, "linkId");
                ValidationSupport.checkList(item.code, "code", Coding.class);
                ValidationSupport.requireNonNull(item.type, "type");
                ValidationSupport.checkList(item.enableWhen, "enableWhen", EnableWhen.class);
                ValidationSupport.checkList(item.answerOption, "answerOption", AnswerOption.class);
                ValidationSupport.checkList(item.initial, "initial", Initial.class);
                ValidationSupport.checkList(item.item, "item", Item.class);
                ValidationSupport.requireValueOrChildren(item);
            }

            protected Builder from(Item item) {
                super.from(item);
                this.linkId = item.linkId;
                this.definition = item.definition;
                this.code.addAll(item.code);
                this.prefix = item.prefix;
                this.text = item.text;
                this.type = item.type;
                this.enableWhen.addAll(item.enableWhen);
                this.enableBehavior = item.enableBehavior;
                this.required = item.required;
                this.repeats = item.repeats;
                this.readOnly = item.readOnly;
                this.maxLength = item.maxLength;
                this.answerValueSet = item.answerValueSet;
                this.answerOption.addAll(item.answerOption);
                this.initial.addAll(item.initial);
                this.item.addAll(item.item);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private String version;
        private String name;
        private String title;
        private List<Canonical> derivedFrom = new ArrayList<Canonical>();
        private PublicationStatus status;
        private Boolean experimental;
        private List<ResourceType> subjectType = new ArrayList<ResourceType>();
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private Markdown copyright;
        private Date approvalDate;
        private Date lastReviewDate;
        private Period effectivePeriod;
        private List<Coding> code = new ArrayList<Coding>();
        private List<Item> item = new ArrayList<Item>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder derivedFrom(Canonical ... derivedFrom) {
            for (Canonical value : derivedFrom) {
                this.derivedFrom.add(value);
            }
            return this;
        }

        public Builder derivedFrom(Collection<Canonical> derivedFrom) {
            this.derivedFrom = new ArrayList<Canonical>(derivedFrom);
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder subjectType(ResourceType ... subjectType) {
            for (ResourceType value : subjectType) {
                this.subjectType.add(value);
            }
            return this;
        }

        public Builder subjectType(Collection<ResourceType> subjectType) {
            this.subjectType = new ArrayList<ResourceType>(subjectType);
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder approvalDate(Date approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public Builder lastReviewDate(Date lastReviewDate) {
            this.lastReviewDate = lastReviewDate;
            return this;
        }

        public Builder effectivePeriod(Period effectivePeriod) {
            this.effectivePeriod = effectivePeriod;
            return this;
        }

        public Builder code(Coding ... code) {
            for (Coding value : code) {
                this.code.add(value);
            }
            return this;
        }

        public Builder code(Collection<Coding> code) {
            this.code = new ArrayList<Coding>(code);
            return this;
        }

        public Builder item(Item ... item) {
            for (Item value : item) {
                this.item.add(value);
            }
            return this;
        }

        public Builder item(Collection<Item> item) {
            this.item = new ArrayList<Item>(item);
            return this;
        }

        @Override
        public Questionnaire build() {
            Questionnaire questionnaire = new Questionnaire(this);
            if (this.validating) {
                this.validate(questionnaire);
            }
            return questionnaire;
        }

        protected void validate(Questionnaire questionnaire) {
            super.validate(questionnaire);
            ValidationSupport.checkList(questionnaire.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(questionnaire.derivedFrom, "derivedFrom", Canonical.class);
            ValidationSupport.requireNonNull(questionnaire.status, "status");
            ValidationSupport.checkList(questionnaire.subjectType, "subjectType", ResourceType.class);
            ValidationSupport.checkList(questionnaire.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(questionnaire.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(questionnaire.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkList(questionnaire.code, "code", Coding.class);
            ValidationSupport.checkList(questionnaire.item, "item", Item.class);
        }

        protected Builder from(Questionnaire questionnaire) {
            super.from(questionnaire);
            this.url = questionnaire.url;
            this.identifier.addAll(questionnaire.identifier);
            this.version = questionnaire.version;
            this.name = questionnaire.name;
            this.title = questionnaire.title;
            this.derivedFrom.addAll(questionnaire.derivedFrom);
            this.status = questionnaire.status;
            this.experimental = questionnaire.experimental;
            this.subjectType.addAll(questionnaire.subjectType);
            this.date = questionnaire.date;
            this.publisher = questionnaire.publisher;
            this.contact.addAll(questionnaire.contact);
            this.description = questionnaire.description;
            this.useContext.addAll(questionnaire.useContext);
            this.jurisdiction.addAll(questionnaire.jurisdiction);
            this.purpose = questionnaire.purpose;
            this.copyright = questionnaire.copyright;
            this.approvalDate = questionnaire.approvalDate;
            this.lastReviewDate = questionnaire.lastReviewDate;
            this.effectivePeriod = questionnaire.effectivePeriod;
            this.code.addAll(questionnaire.code);
            this.item.addAll(questionnaire.item);
            return this;
        }
    }
}

