/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Time;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.QuestionnaireResponseStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="qrs-1", level="Rule", location="QuestionnaireResponse.item", description="Nested item can't be beneath both item and answer", expression="(answer.exists() and item.exists()).not()", source="http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse")
public class QuestionnaireResponse
extends DomainResource {
    @Summary
    private final Identifier identifier;
    @Summary
    @ReferenceTarget(value={"CarePlan", "ServiceRequest"})
    private final List<Reference> basedOn;
    @Summary
    @ReferenceTarget(value={"Observation", "Procedure"})
    private final List<Reference> partOf;
    @Summary
    private final Canonical questionnaire;
    @Summary
    @Binding(bindingName="QuestionnaireResponseStatus", strength=BindingStrength.Value.REQUIRED, description="Lifecycle status of the questionnaire response.", valueSet="http://hl7.org/fhir/ValueSet/questionnaire-answers-status|4.0.1")
    @Required
    private final QuestionnaireResponseStatus status;
    @Summary
    private final Reference subject;
    @Summary
    @ReferenceTarget(value={"Encounter"})
    private final Reference encounter;
    @Summary
    private final DateTime authored;
    @Summary
    @ReferenceTarget(value={"Device", "Practitioner", "PractitionerRole", "Patient", "RelatedPerson", "Organization"})
    private final Reference author;
    @Summary
    @ReferenceTarget(value={"Patient", "Practitioner", "PractitionerRole", "RelatedPerson"})
    private final Reference source;
    private final List<Item> item;

    private QuestionnaireResponse(Builder builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.basedOn = Collections.unmodifiableList(builder.basedOn);
        this.partOf = Collections.unmodifiableList(builder.partOf);
        this.questionnaire = builder.questionnaire;
        this.status = builder.status;
        this.subject = builder.subject;
        this.encounter = builder.encounter;
        this.authored = builder.authored;
        this.author = builder.author;
        this.source = builder.source;
        this.item = Collections.unmodifiableList(builder.item);
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public List<Reference> getBasedOn() {
        return this.basedOn;
    }

    public List<Reference> getPartOf() {
        return this.partOf;
    }

    public Canonical getQuestionnaire() {
        return this.questionnaire;
    }

    public QuestionnaireResponseStatus getStatus() {
        return this.status;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public DateTime getAuthored() {
        return this.authored;
    }

    public Reference getAuthor() {
        return this.author;
    }

    public Reference getSource() {
        return this.source;
    }

    public List<Item> getItem() {
        return this.item;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.identifier != null || !this.basedOn.isEmpty() || !this.partOf.isEmpty() || this.questionnaire != null || this.status != null || this.subject != null || this.encounter != null || this.authored != null || this.author != null || this.source != null || !this.item.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor);
                this.accept(this.basedOn, "basedOn", visitor, Reference.class);
                this.accept(this.partOf, "partOf", visitor, Reference.class);
                this.accept(this.questionnaire, "questionnaire", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.encounter, "encounter", visitor);
                this.accept(this.authored, "authored", visitor);
                this.accept(this.author, "author", visitor);
                this.accept(this.source, "source", visitor);
                this.accept(this.item, "item", visitor, Item.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuestionnaireResponse other = (QuestionnaireResponse)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.basedOn, other.basedOn) && Objects.equals(this.partOf, other.partOf) && Objects.equals(this.questionnaire, other.questionnaire) && Objects.equals(this.status, other.status) && Objects.equals(this.subject, other.subject) && Objects.equals(this.encounter, other.encounter) && Objects.equals(this.authored, other.authored) && Objects.equals(this.author, other.author) && Objects.equals(this.source, other.source) && Objects.equals(this.item, other.item);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.basedOn, this.partOf, this.questionnaire, this.status, this.subject, this.encounter, this.authored, this.author, this.source, this.item);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Item
    extends BackboneElement {
        @Required
        private final String linkId;
        private final Uri definition;
        private final String text;
        private final List<Answer> answer;
        private final List<Item> item;

        private Item(Builder builder) {
            super(builder);
            this.linkId = builder.linkId;
            this.definition = builder.definition;
            this.text = builder.text;
            this.answer = Collections.unmodifiableList(builder.answer);
            this.item = Collections.unmodifiableList(builder.item);
        }

        public String getLinkId() {
            return this.linkId;
        }

        public Uri getDefinition() {
            return this.definition;
        }

        public String getText() {
            return this.text;
        }

        public List<Answer> getAnswer() {
            return this.answer;
        }

        public List<Item> getItem() {
            return this.item;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.linkId != null || this.definition != null || this.text != null || !this.answer.isEmpty() || !this.item.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.linkId, "linkId", visitor);
                    this.accept(this.definition, "definition", visitor);
                    this.accept(this.text, "text", visitor);
                    this.accept(this.answer, "answer", visitor, Answer.class);
                    this.accept(this.item, "item", visitor, Item.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.linkId, other.linkId) && Objects.equals(this.definition, other.definition) && Objects.equals(this.text, other.text) && Objects.equals(this.answer, other.answer) && Objects.equals(this.item, other.item);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.linkId, this.definition, this.text, this.answer, this.item);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Answer
        extends BackboneElement {
            @Choice(value={Boolean.class, Decimal.class, Integer.class, Date.class, DateTime.class, Time.class, String.class, Uri.class, Attachment.class, Coding.class, Quantity.class, Reference.class})
            @Binding(bindingName="QuestionnaireAnswer", strength=BindingStrength.Value.EXAMPLE, description="Code indicating the response provided for a question.", valueSet="http://hl7.org/fhir/ValueSet/questionnaire-answers")
            private final Element value;
            private final List<Item> item;

            private Answer(Builder builder) {
                super(builder);
                this.value = builder.value;
                this.item = Collections.unmodifiableList(builder.item);
            }

            public Element getValue() {
                return this.value;
            }

            public List<Item> getItem() {
                return this.item;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.value != null || !this.item.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.value, "value", visitor);
                        this.accept(this.item, "item", visitor, Item.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Answer other = (Answer)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.value, other.value) && Objects.equals(this.item, other.item);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.value, this.item);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Element value;
                private List<Item> item = new ArrayList<Item>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder value(Element value) {
                    this.value = value;
                    return this;
                }

                public Builder item(Item ... item) {
                    for (Item value : item) {
                        this.item.add(value);
                    }
                    return this;
                }

                public Builder item(Collection<Item> item) {
                    this.item = new ArrayList<Item>(item);
                    return this;
                }

                @Override
                public Answer build() {
                    Answer answer = new Answer(this);
                    if (this.validating) {
                        this.validate(answer);
                    }
                    return answer;
                }

                protected void validate(Answer answer) {
                    super.validate(answer);
                    ValidationSupport.choiceElement(answer.value, "value", Boolean.class, Decimal.class, Integer.class, Date.class, DateTime.class, Time.class, String.class, Uri.class, Attachment.class, Coding.class, Quantity.class, Reference.class);
                    ValidationSupport.checkList(answer.item, "item", Item.class);
                    ValidationSupport.requireValueOrChildren(answer);
                }

                protected Builder from(Answer answer) {
                    super.from(answer);
                    this.value = answer.value;
                    this.item.addAll(answer.item);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String linkId;
            private Uri definition;
            private String text;
            private List<Answer> answer = new ArrayList<Answer>();
            private List<Item> item = new ArrayList<Item>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder linkId(String linkId) {
                this.linkId = linkId;
                return this;
            }

            public Builder definition(Uri definition) {
                this.definition = definition;
                return this;
            }

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            public Builder answer(Answer ... answer) {
                for (Answer value : answer) {
                    this.answer.add(value);
                }
                return this;
            }

            public Builder answer(Collection<Answer> answer) {
                this.answer = new ArrayList<Answer>(answer);
                return this;
            }

            public Builder item(Item ... item) {
                for (Item value : item) {
                    this.item.add(value);
                }
                return this;
            }

            public Builder item(Collection<Item> item) {
                this.item = new ArrayList<Item>(item);
                return this;
            }

            @Override
            public Item build() {
                Item item = new Item(this);
                if (this.validating) {
                    this.validate(item);
                }
                return item;
            }

            protected void validate(Item item) {
                super.validate(item);
                ValidationSupport.requireNonNull(item.linkId, "linkId");
                ValidationSupport.checkList(item.answer, "answer", Answer.class);
                ValidationSupport.checkList(item.item, "item", Item.class);
                ValidationSupport.requireValueOrChildren(item);
            }

            protected Builder from(Item item) {
                super.from(item);
                this.linkId = item.linkId;
                this.definition = item.definition;
                this.text = item.text;
                this.answer.addAll(item.answer);
                this.item.addAll(item.item);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Identifier identifier;
        private List<Reference> basedOn = new ArrayList<Reference>();
        private List<Reference> partOf = new ArrayList<Reference>();
        private Canonical questionnaire;
        private QuestionnaireResponseStatus status;
        private Reference subject;
        private Reference encounter;
        private DateTime authored;
        private Reference author;
        private Reference source;
        private List<Item> item = new ArrayList<Item>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder basedOn(Reference ... basedOn) {
            for (Reference value : basedOn) {
                this.basedOn.add(value);
            }
            return this;
        }

        public Builder basedOn(Collection<Reference> basedOn) {
            this.basedOn = new ArrayList<Reference>(basedOn);
            return this;
        }

        public Builder partOf(Reference ... partOf) {
            for (Reference value : partOf) {
                this.partOf.add(value);
            }
            return this;
        }

        public Builder partOf(Collection<Reference> partOf) {
            this.partOf = new ArrayList<Reference>(partOf);
            return this;
        }

        public Builder questionnaire(Canonical questionnaire) {
            this.questionnaire = questionnaire;
            return this;
        }

        public Builder status(QuestionnaireResponseStatus status) {
            this.status = status;
            return this;
        }

        public Builder subject(Reference subject) {
            this.subject = subject;
            return this;
        }

        public Builder encounter(Reference encounter) {
            this.encounter = encounter;
            return this;
        }

        public Builder authored(DateTime authored) {
            this.authored = authored;
            return this;
        }

        public Builder author(Reference author) {
            this.author = author;
            return this;
        }

        public Builder source(Reference source) {
            this.source = source;
            return this;
        }

        public Builder item(Item ... item) {
            for (Item value : item) {
                this.item.add(value);
            }
            return this;
        }

        public Builder item(Collection<Item> item) {
            this.item = new ArrayList<Item>(item);
            return this;
        }

        @Override
        public QuestionnaireResponse build() {
            QuestionnaireResponse questionnaireResponse = new QuestionnaireResponse(this);
            if (this.validating) {
                this.validate(questionnaireResponse);
            }
            return questionnaireResponse;
        }

        protected void validate(QuestionnaireResponse questionnaireResponse) {
            super.validate(questionnaireResponse);
            ValidationSupport.checkList(questionnaireResponse.basedOn, "basedOn", Reference.class);
            ValidationSupport.checkList(questionnaireResponse.partOf, "partOf", Reference.class);
            ValidationSupport.requireNonNull(questionnaireResponse.status, "status");
            ValidationSupport.checkList(questionnaireResponse.item, "item", Item.class);
            ValidationSupport.checkReferenceType(questionnaireResponse.basedOn, "basedOn", "CarePlan", "ServiceRequest");
            ValidationSupport.checkReferenceType(questionnaireResponse.partOf, "partOf", "Observation", "Procedure");
            ValidationSupport.checkReferenceType(questionnaireResponse.encounter, "encounter", "Encounter");
            ValidationSupport.checkReferenceType(questionnaireResponse.author, "author", "Device", "Practitioner", "PractitionerRole", "Patient", "RelatedPerson", "Organization");
            ValidationSupport.checkReferenceType(questionnaireResponse.source, "source", "Patient", "Practitioner", "PractitionerRole", "RelatedPerson");
        }

        protected Builder from(QuestionnaireResponse questionnaireResponse) {
            super.from(questionnaireResponse);
            this.identifier = questionnaireResponse.identifier;
            this.basedOn.addAll(questionnaireResponse.basedOn);
            this.partOf.addAll(questionnaireResponse.partOf);
            this.questionnaire = questionnaireResponse.questionnaire;
            this.status = questionnaireResponse.status;
            this.subject = questionnaireResponse.subject;
            this.encounter = questionnaireResponse.encounter;
            this.authored = questionnaireResponse.authored;
            this.author = questionnaireResponse.author;
            this.source = questionnaireResponse.source;
            this.item.addAll(questionnaireResponse.item);
            return this;
        }
    }
}

