/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.DataRequirement;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Expression;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.RelatedArtifact;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.GroupMeasure;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.ResearchElementType;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.type.code.VariableType;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="red-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/ResearchElementDefinition"), @Constraint(id="researchElementDefinition-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/subject-type", expression="subject.as(CodeableConcept).exists() implies (subject.as(CodeableConcept).memberOf('http://hl7.org/fhir/ValueSet/subject-type', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/ResearchElementDefinition", generated=true), @Constraint(id="researchElementDefinition-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/ResearchElementDefinition", generated=true)})
public class ResearchElementDefinition
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final String version;
    @Summary
    private final String name;
    @Summary
    private final String title;
    @Summary
    private final String shortTitle;
    private final String subtitle;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @ReferenceTarget(value={"Group"})
    @Choice(value={CodeableConcept.class, Reference.class})
    @Binding(bindingName="SubjectType", strength=BindingStrength.Value.EXTENSIBLE, description="The possible types of subjects for a measure (E.g. Patient, Practitioner, Organization, Location, etc.).", valueSet="http://hl7.org/fhir/ValueSet/subject-type")
    private final Element subject;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    @Summary
    private final Markdown description;
    private final List<String> comment;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final String usage;
    private final Markdown copyright;
    private final Date approvalDate;
    private final Date lastReviewDate;
    @Summary
    private final Period effectivePeriod;
    @Binding(bindingName="DefinitionTopic", strength=BindingStrength.Value.EXAMPLE, description="High-level categorization of the definition, used for searching, sorting, and filtering.", valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    private final List<CodeableConcept> topic;
    private final List<ContactDetail> author;
    private final List<ContactDetail> editor;
    private final List<ContactDetail> reviewer;
    private final List<ContactDetail> endorser;
    private final List<RelatedArtifact> relatedArtifact;
    private final List<Canonical> library;
    @Summary
    @Binding(bindingName="ResearchElementType", strength=BindingStrength.Value.REQUIRED, description="The possible types of research elements (E.g. Population, Exposure, Outcome).", valueSet="http://hl7.org/fhir/ValueSet/research-element-type|4.0.1")
    @Required
    private final ResearchElementType type;
    @Binding(bindingName="VariableType", strength=BindingStrength.Value.REQUIRED, description="The possible types of variables for exposures or outcomes (E.g. Dichotomous, Continuous, Descriptive).", valueSet="http://hl7.org/fhir/ValueSet/variable-type|4.0.1")
    private final VariableType variableType;
    @Summary
    @Required
    private final List<Characteristic> characteristic;

    private ResearchElementDefinition(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.shortTitle = builder.shortTitle;
        this.subtitle = builder.subtitle;
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.subject = builder.subject;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.comment = Collections.unmodifiableList(builder.comment);
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.usage = builder.usage;
        this.copyright = builder.copyright;
        this.approvalDate = builder.approvalDate;
        this.lastReviewDate = builder.lastReviewDate;
        this.effectivePeriod = builder.effectivePeriod;
        this.topic = Collections.unmodifiableList(builder.topic);
        this.author = Collections.unmodifiableList(builder.author);
        this.editor = Collections.unmodifiableList(builder.editor);
        this.reviewer = Collections.unmodifiableList(builder.reviewer);
        this.endorser = Collections.unmodifiableList(builder.endorser);
        this.relatedArtifact = Collections.unmodifiableList(builder.relatedArtifact);
        this.library = Collections.unmodifiableList(builder.library);
        this.type = builder.type;
        this.variableType = builder.variableType;
        this.characteristic = Collections.unmodifiableList(builder.characteristic);
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public Element getSubject() {
        return this.subject;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<String> getComment() {
        return this.comment;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public String getUsage() {
        return this.usage;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public List<CodeableConcept> getTopic() {
        return this.topic;
    }

    public List<ContactDetail> getAuthor() {
        return this.author;
    }

    public List<ContactDetail> getEditor() {
        return this.editor;
    }

    public List<ContactDetail> getReviewer() {
        return this.reviewer;
    }

    public List<ContactDetail> getEndorser() {
        return this.endorser;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        return this.relatedArtifact;
    }

    public List<Canonical> getLibrary() {
        return this.library;
    }

    public ResearchElementType getType() {
        return this.type;
    }

    public VariableType getVariableType() {
        return this.variableType;
    }

    public List<Characteristic> getCharacteristic() {
        return this.characteristic;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || this.shortTitle != null || this.subtitle != null || this.status != null || this.experimental != null || this.subject != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.comment.isEmpty() || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.usage != null || this.copyright != null || this.approvalDate != null || this.lastReviewDate != null || this.effectivePeriod != null || !this.topic.isEmpty() || !this.author.isEmpty() || !this.editor.isEmpty() || !this.reviewer.isEmpty() || !this.endorser.isEmpty() || !this.relatedArtifact.isEmpty() || !this.library.isEmpty() || this.type != null || this.variableType != null || !this.characteristic.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.shortTitle, "shortTitle", visitor);
                this.accept(this.subtitle, "subtitle", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.comment, "comment", visitor, String.class);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.usage, "usage", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.approvalDate, "approvalDate", visitor);
                this.accept(this.lastReviewDate, "lastReviewDate", visitor);
                this.accept(this.effectivePeriod, "effectivePeriod", visitor);
                this.accept(this.topic, "topic", visitor, CodeableConcept.class);
                this.accept(this.author, "author", visitor, ContactDetail.class);
                this.accept(this.editor, "editor", visitor, ContactDetail.class);
                this.accept(this.reviewer, "reviewer", visitor, ContactDetail.class);
                this.accept(this.endorser, "endorser", visitor, ContactDetail.class);
                this.accept(this.relatedArtifact, "relatedArtifact", visitor, RelatedArtifact.class);
                this.accept(this.library, "library", visitor, Canonical.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.variableType, "variableType", visitor);
                this.accept(this.characteristic, "characteristic", visitor, Characteristic.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResearchElementDefinition other = (ResearchElementDefinition)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.shortTitle, other.shortTitle) && Objects.equals(this.subtitle, other.subtitle) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.subject, other.subject) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.comment, other.comment) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.usage, other.usage) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.approvalDate, other.approvalDate) && Objects.equals(this.lastReviewDate, other.lastReviewDate) && Objects.equals(this.effectivePeriod, other.effectivePeriod) && Objects.equals(this.topic, other.topic) && Objects.equals(this.author, other.author) && Objects.equals(this.editor, other.editor) && Objects.equals(this.reviewer, other.reviewer) && Objects.equals(this.endorser, other.endorser) && Objects.equals(this.relatedArtifact, other.relatedArtifact) && Objects.equals(this.library, other.library) && Objects.equals(this.type, other.type) && Objects.equals(this.variableType, other.variableType) && Objects.equals(this.characteristic, other.characteristic);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.shortTitle, this.subtitle, this.status, this.experimental, this.subject, this.date, this.publisher, this.contact, this.description, this.comment, this.useContext, this.jurisdiction, this.purpose, this.usage, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.library, this.type, this.variableType, this.characteristic);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Characteristic
    extends BackboneElement {
        @Summary
        @Choice(value={CodeableConcept.class, Canonical.class, Expression.class, DataRequirement.class})
        @Required
        private final Element definition;
        private final List<UsageContext> usageContext;
        private final Boolean exclude;
        @Binding(bindingName="UCUMUnits", strength=BindingStrength.Value.REQUIRED, description="Unified Code for Units of Measure (UCUM).", valueSet="http://hl7.org/fhir/ValueSet/ucum-units|4.0.1")
        private final CodeableConcept unitOfMeasure;
        private final String studyEffectiveDescription;
        @Choice(value={DateTime.class, Period.class, Duration.class, Timing.class})
        private final Element studyEffective;
        private final Duration studyEffectiveTimeFromStart;
        @Binding(bindingName="GroupMeasure", strength=BindingStrength.Value.REQUIRED, description="Possible group measure aggregates (E.g. Mean, Median).", valueSet="http://hl7.org/fhir/ValueSet/group-measure|4.0.1")
        private final GroupMeasure studyEffectiveGroupMeasure;
        private final String participantEffectiveDescription;
        @Choice(value={DateTime.class, Period.class, Duration.class, Timing.class})
        private final Element participantEffective;
        private final Duration participantEffectiveTimeFromStart;
        @Binding(bindingName="GroupMeasure", strength=BindingStrength.Value.REQUIRED, description="Possible group measure aggregates (E.g. Mean, Median).", valueSet="http://hl7.org/fhir/ValueSet/group-measure|4.0.1")
        private final GroupMeasure participantEffectiveGroupMeasure;

        private Characteristic(Builder builder) {
            super(builder);
            this.definition = builder.definition;
            this.usageContext = Collections.unmodifiableList(builder.usageContext);
            this.exclude = builder.exclude;
            this.unitOfMeasure = builder.unitOfMeasure;
            this.studyEffectiveDescription = builder.studyEffectiveDescription;
            this.studyEffective = builder.studyEffective;
            this.studyEffectiveTimeFromStart = builder.studyEffectiveTimeFromStart;
            this.studyEffectiveGroupMeasure = builder.studyEffectiveGroupMeasure;
            this.participantEffectiveDescription = builder.participantEffectiveDescription;
            this.participantEffective = builder.participantEffective;
            this.participantEffectiveTimeFromStart = builder.participantEffectiveTimeFromStart;
            this.participantEffectiveGroupMeasure = builder.participantEffectiveGroupMeasure;
        }

        public Element getDefinition() {
            return this.definition;
        }

        public List<UsageContext> getUsageContext() {
            return this.usageContext;
        }

        public Boolean getExclude() {
            return this.exclude;
        }

        public CodeableConcept getUnitOfMeasure() {
            return this.unitOfMeasure;
        }

        public String getStudyEffectiveDescription() {
            return this.studyEffectiveDescription;
        }

        public Element getStudyEffective() {
            return this.studyEffective;
        }

        public Duration getStudyEffectiveTimeFromStart() {
            return this.studyEffectiveTimeFromStart;
        }

        public GroupMeasure getStudyEffectiveGroupMeasure() {
            return this.studyEffectiveGroupMeasure;
        }

        public String getParticipantEffectiveDescription() {
            return this.participantEffectiveDescription;
        }

        public Element getParticipantEffective() {
            return this.participantEffective;
        }

        public Duration getParticipantEffectiveTimeFromStart() {
            return this.participantEffectiveTimeFromStart;
        }

        public GroupMeasure getParticipantEffectiveGroupMeasure() {
            return this.participantEffectiveGroupMeasure;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.definition != null || !this.usageContext.isEmpty() || this.exclude != null || this.unitOfMeasure != null || this.studyEffectiveDescription != null || this.studyEffective != null || this.studyEffectiveTimeFromStart != null || this.studyEffectiveGroupMeasure != null || this.participantEffectiveDescription != null || this.participantEffective != null || this.participantEffectiveTimeFromStart != null || this.participantEffectiveGroupMeasure != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.definition, "definition", visitor);
                    this.accept(this.usageContext, "usageContext", visitor, UsageContext.class);
                    this.accept(this.exclude, "exclude", visitor);
                    this.accept(this.unitOfMeasure, "unitOfMeasure", visitor);
                    this.accept(this.studyEffectiveDescription, "studyEffectiveDescription", visitor);
                    this.accept(this.studyEffective, "studyEffective", visitor);
                    this.accept(this.studyEffectiveTimeFromStart, "studyEffectiveTimeFromStart", visitor);
                    this.accept(this.studyEffectiveGroupMeasure, "studyEffectiveGroupMeasure", visitor);
                    this.accept(this.participantEffectiveDescription, "participantEffectiveDescription", visitor);
                    this.accept(this.participantEffective, "participantEffective", visitor);
                    this.accept(this.participantEffectiveTimeFromStart, "participantEffectiveTimeFromStart", visitor);
                    this.accept(this.participantEffectiveGroupMeasure, "participantEffectiveGroupMeasure", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Characteristic other = (Characteristic)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.definition, other.definition) && Objects.equals(this.usageContext, other.usageContext) && Objects.equals(this.exclude, other.exclude) && Objects.equals(this.unitOfMeasure, other.unitOfMeasure) && Objects.equals(this.studyEffectiveDescription, other.studyEffectiveDescription) && Objects.equals(this.studyEffective, other.studyEffective) && Objects.equals(this.studyEffectiveTimeFromStart, other.studyEffectiveTimeFromStart) && Objects.equals(this.studyEffectiveGroupMeasure, other.studyEffectiveGroupMeasure) && Objects.equals(this.participantEffectiveDescription, other.participantEffectiveDescription) && Objects.equals(this.participantEffective, other.participantEffective) && Objects.equals(this.participantEffectiveTimeFromStart, other.participantEffectiveTimeFromStart) && Objects.equals(this.participantEffectiveGroupMeasure, other.participantEffectiveGroupMeasure);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.definition, this.usageContext, this.exclude, this.unitOfMeasure, this.studyEffectiveDescription, this.studyEffective, this.studyEffectiveTimeFromStart, this.studyEffectiveGroupMeasure, this.participantEffectiveDescription, this.participantEffective, this.participantEffectiveTimeFromStart, this.participantEffectiveGroupMeasure);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Element definition;
            private List<UsageContext> usageContext = new ArrayList<UsageContext>();
            private Boolean exclude;
            private CodeableConcept unitOfMeasure;
            private String studyEffectiveDescription;
            private Element studyEffective;
            private Duration studyEffectiveTimeFromStart;
            private GroupMeasure studyEffectiveGroupMeasure;
            private String participantEffectiveDescription;
            private Element participantEffective;
            private Duration participantEffectiveTimeFromStart;
            private GroupMeasure participantEffectiveGroupMeasure;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder definition(Element definition) {
                this.definition = definition;
                return this;
            }

            public Builder usageContext(UsageContext ... usageContext) {
                for (UsageContext value : usageContext) {
                    this.usageContext.add(value);
                }
                return this;
            }

            public Builder usageContext(Collection<UsageContext> usageContext) {
                this.usageContext = new ArrayList<UsageContext>(usageContext);
                return this;
            }

            public Builder exclude(Boolean exclude) {
                this.exclude = exclude;
                return this;
            }

            public Builder unitOfMeasure(CodeableConcept unitOfMeasure) {
                this.unitOfMeasure = unitOfMeasure;
                return this;
            }

            public Builder studyEffectiveDescription(String studyEffectiveDescription) {
                this.studyEffectiveDescription = studyEffectiveDescription;
                return this;
            }

            public Builder studyEffective(Element studyEffective) {
                this.studyEffective = studyEffective;
                return this;
            }

            public Builder studyEffectiveTimeFromStart(Duration studyEffectiveTimeFromStart) {
                this.studyEffectiveTimeFromStart = studyEffectiveTimeFromStart;
                return this;
            }

            public Builder studyEffectiveGroupMeasure(GroupMeasure studyEffectiveGroupMeasure) {
                this.studyEffectiveGroupMeasure = studyEffectiveGroupMeasure;
                return this;
            }

            public Builder participantEffectiveDescription(String participantEffectiveDescription) {
                this.participantEffectiveDescription = participantEffectiveDescription;
                return this;
            }

            public Builder participantEffective(Element participantEffective) {
                this.participantEffective = participantEffective;
                return this;
            }

            public Builder participantEffectiveTimeFromStart(Duration participantEffectiveTimeFromStart) {
                this.participantEffectiveTimeFromStart = participantEffectiveTimeFromStart;
                return this;
            }

            public Builder participantEffectiveGroupMeasure(GroupMeasure participantEffectiveGroupMeasure) {
                this.participantEffectiveGroupMeasure = participantEffectiveGroupMeasure;
                return this;
            }

            @Override
            public Characteristic build() {
                Characteristic characteristic = new Characteristic(this);
                if (this.validating) {
                    this.validate(characteristic);
                }
                return characteristic;
            }

            protected void validate(Characteristic characteristic) {
                super.validate(characteristic);
                ValidationSupport.requireChoiceElement(characteristic.definition, "definition", CodeableConcept.class, Canonical.class, Expression.class, DataRequirement.class);
                ValidationSupport.checkList(characteristic.usageContext, "usageContext", UsageContext.class);
                ValidationSupport.choiceElement(characteristic.studyEffective, "studyEffective", DateTime.class, Period.class, Duration.class, Timing.class);
                ValidationSupport.choiceElement(characteristic.participantEffective, "participantEffective", DateTime.class, Period.class, Duration.class, Timing.class);
                ValidationSupport.checkValueSetBinding(characteristic.unitOfMeasure, "unitOfMeasure", "http://hl7.org/fhir/ValueSet/ucum-units", "http://unitsofmeasure.org", new java.lang.String[0]);
                ValidationSupport.requireValueOrChildren(characteristic);
            }

            protected Builder from(Characteristic characteristic) {
                super.from(characteristic);
                this.definition = characteristic.definition;
                this.usageContext.addAll(characteristic.usageContext);
                this.exclude = characteristic.exclude;
                this.unitOfMeasure = characteristic.unitOfMeasure;
                this.studyEffectiveDescription = characteristic.studyEffectiveDescription;
                this.studyEffective = characteristic.studyEffective;
                this.studyEffectiveTimeFromStart = characteristic.studyEffectiveTimeFromStart;
                this.studyEffectiveGroupMeasure = characteristic.studyEffectiveGroupMeasure;
                this.participantEffectiveDescription = characteristic.participantEffectiveDescription;
                this.participantEffective = characteristic.participantEffective;
                this.participantEffectiveTimeFromStart = characteristic.participantEffectiveTimeFromStart;
                this.participantEffectiveGroupMeasure = characteristic.participantEffectiveGroupMeasure;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private String version;
        private String name;
        private String title;
        private String shortTitle;
        private String subtitle;
        private PublicationStatus status;
        private Boolean experimental;
        private Element subject;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<String> comment = new ArrayList<String>();
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private String usage;
        private Markdown copyright;
        private Date approvalDate;
        private Date lastReviewDate;
        private Period effectivePeriod;
        private List<CodeableConcept> topic = new ArrayList<CodeableConcept>();
        private List<ContactDetail> author = new ArrayList<ContactDetail>();
        private List<ContactDetail> editor = new ArrayList<ContactDetail>();
        private List<ContactDetail> reviewer = new ArrayList<ContactDetail>();
        private List<ContactDetail> endorser = new ArrayList<ContactDetail>();
        private List<RelatedArtifact> relatedArtifact = new ArrayList<RelatedArtifact>();
        private List<Canonical> library = new ArrayList<Canonical>();
        private ResearchElementType type;
        private VariableType variableType;
        private List<Characteristic> characteristic = new ArrayList<Characteristic>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder shortTitle(String shortTitle) {
            this.shortTitle = shortTitle;
            return this;
        }

        public Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder subject(Element subject) {
            this.subject = subject;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder comment(String ... comment) {
            for (String value : comment) {
                this.comment.add(value);
            }
            return this;
        }

        public Builder comment(Collection<String> comment) {
            this.comment = new ArrayList<String>(comment);
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder approvalDate(Date approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public Builder lastReviewDate(Date lastReviewDate) {
            this.lastReviewDate = lastReviewDate;
            return this;
        }

        public Builder effectivePeriod(Period effectivePeriod) {
            this.effectivePeriod = effectivePeriod;
            return this;
        }

        public Builder topic(CodeableConcept ... topic) {
            for (CodeableConcept value : topic) {
                this.topic.add(value);
            }
            return this;
        }

        public Builder topic(Collection<CodeableConcept> topic) {
            this.topic = new ArrayList<CodeableConcept>(topic);
            return this;
        }

        public Builder author(ContactDetail ... author) {
            for (ContactDetail value : author) {
                this.author.add(value);
            }
            return this;
        }

        public Builder author(Collection<ContactDetail> author) {
            this.author = new ArrayList<ContactDetail>(author);
            return this;
        }

        public Builder editor(ContactDetail ... editor) {
            for (ContactDetail value : editor) {
                this.editor.add(value);
            }
            return this;
        }

        public Builder editor(Collection<ContactDetail> editor) {
            this.editor = new ArrayList<ContactDetail>(editor);
            return this;
        }

        public Builder reviewer(ContactDetail ... reviewer) {
            for (ContactDetail value : reviewer) {
                this.reviewer.add(value);
            }
            return this;
        }

        public Builder reviewer(Collection<ContactDetail> reviewer) {
            this.reviewer = new ArrayList<ContactDetail>(reviewer);
            return this;
        }

        public Builder endorser(ContactDetail ... endorser) {
            for (ContactDetail value : endorser) {
                this.endorser.add(value);
            }
            return this;
        }

        public Builder endorser(Collection<ContactDetail> endorser) {
            this.endorser = new ArrayList<ContactDetail>(endorser);
            return this;
        }

        public Builder relatedArtifact(RelatedArtifact ... relatedArtifact) {
            for (RelatedArtifact value : relatedArtifact) {
                this.relatedArtifact.add(value);
            }
            return this;
        }

        public Builder relatedArtifact(Collection<RelatedArtifact> relatedArtifact) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>(relatedArtifact);
            return this;
        }

        public Builder library(Canonical ... library) {
            for (Canonical value : library) {
                this.library.add(value);
            }
            return this;
        }

        public Builder library(Collection<Canonical> library) {
            this.library = new ArrayList<Canonical>(library);
            return this;
        }

        public Builder type(ResearchElementType type) {
            this.type = type;
            return this;
        }

        public Builder variableType(VariableType variableType) {
            this.variableType = variableType;
            return this;
        }

        public Builder characteristic(Characteristic ... characteristic) {
            for (Characteristic value : characteristic) {
                this.characteristic.add(value);
            }
            return this;
        }

        public Builder characteristic(Collection<Characteristic> characteristic) {
            this.characteristic = new ArrayList<Characteristic>(characteristic);
            return this;
        }

        @Override
        public ResearchElementDefinition build() {
            ResearchElementDefinition researchElementDefinition = new ResearchElementDefinition(this);
            if (this.validating) {
                this.validate(researchElementDefinition);
            }
            return researchElementDefinition;
        }

        protected void validate(ResearchElementDefinition researchElementDefinition) {
            super.validate(researchElementDefinition);
            ValidationSupport.checkList(researchElementDefinition.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(researchElementDefinition.status, "status");
            ValidationSupport.choiceElement(researchElementDefinition.subject, "subject", CodeableConcept.class, Reference.class);
            ValidationSupport.checkList(researchElementDefinition.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(researchElementDefinition.comment, "comment", String.class);
            ValidationSupport.checkList(researchElementDefinition.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(researchElementDefinition.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkList(researchElementDefinition.topic, "topic", CodeableConcept.class);
            ValidationSupport.checkList(researchElementDefinition.author, "author", ContactDetail.class);
            ValidationSupport.checkList(researchElementDefinition.editor, "editor", ContactDetail.class);
            ValidationSupport.checkList(researchElementDefinition.reviewer, "reviewer", ContactDetail.class);
            ValidationSupport.checkList(researchElementDefinition.endorser, "endorser", ContactDetail.class);
            ValidationSupport.checkList(researchElementDefinition.relatedArtifact, "relatedArtifact", RelatedArtifact.class);
            ValidationSupport.checkList(researchElementDefinition.library, "library", Canonical.class);
            ValidationSupport.requireNonNull(researchElementDefinition.type, "type");
            ValidationSupport.checkNonEmptyList(researchElementDefinition.characteristic, "characteristic", Characteristic.class);
            ValidationSupport.checkReferenceType(researchElementDefinition.subject, "subject", "Group");
        }

        protected Builder from(ResearchElementDefinition researchElementDefinition) {
            super.from(researchElementDefinition);
            this.url = researchElementDefinition.url;
            this.identifier.addAll(researchElementDefinition.identifier);
            this.version = researchElementDefinition.version;
            this.name = researchElementDefinition.name;
            this.title = researchElementDefinition.title;
            this.shortTitle = researchElementDefinition.shortTitle;
            this.subtitle = researchElementDefinition.subtitle;
            this.status = researchElementDefinition.status;
            this.experimental = researchElementDefinition.experimental;
            this.subject = researchElementDefinition.subject;
            this.date = researchElementDefinition.date;
            this.publisher = researchElementDefinition.publisher;
            this.contact.addAll(researchElementDefinition.contact);
            this.description = researchElementDefinition.description;
            this.comment.addAll(researchElementDefinition.comment);
            this.useContext.addAll(researchElementDefinition.useContext);
            this.jurisdiction.addAll(researchElementDefinition.jurisdiction);
            this.purpose = researchElementDefinition.purpose;
            this.usage = researchElementDefinition.usage;
            this.copyright = researchElementDefinition.copyright;
            this.approvalDate = researchElementDefinition.approvalDate;
            this.lastReviewDate = researchElementDefinition.lastReviewDate;
            this.effectivePeriod = researchElementDefinition.effectivePeriod;
            this.topic.addAll(researchElementDefinition.topic);
            this.author.addAll(researchElementDefinition.author);
            this.editor.addAll(researchElementDefinition.editor);
            this.reviewer.addAll(researchElementDefinition.reviewer);
            this.endorser.addAll(researchElementDefinition.endorser);
            this.relatedArtifact.addAll(researchElementDefinition.relatedArtifact);
            this.library.addAll(researchElementDefinition.library);
            this.type = researchElementDefinition.type;
            this.variableType = researchElementDefinition.variableType;
            this.characteristic.addAll(researchElementDefinition.characteristic);
            return this;
        }
    }
}

