/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.RelatedArtifact;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="rvs-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/RiskEvidenceSynthesis"), @Constraint(id="riskEvidenceSynthesis-1", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/RiskEvidenceSynthesis", generated=true), @Constraint(id="riskEvidenceSynthesis-2", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/synthesis-type", expression="synthesisType.exists() implies (synthesisType.memberOf('http://hl7.org/fhir/ValueSet/synthesis-type', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/RiskEvidenceSynthesis", generated=true), @Constraint(id="riskEvidenceSynthesis-3", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/study-type", expression="studyType.exists() implies (studyType.memberOf('http://hl7.org/fhir/ValueSet/study-type', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/RiskEvidenceSynthesis", generated=true), @Constraint(id="riskEvidenceSynthesis-4", level="Warning", location="riskEstimate.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/risk-estimate-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/risk-estimate-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/RiskEvidenceSynthesis", generated=true), @Constraint(id="riskEvidenceSynthesis-5", level="Warning", location="riskEstimate.precisionEstimate.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/precision-estimate-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/precision-estimate-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/RiskEvidenceSynthesis", generated=true), @Constraint(id="riskEvidenceSynthesis-6", level="Warning", location="certainty.rating", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/evidence-quality", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/evidence-quality', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/RiskEvidenceSynthesis", generated=true), @Constraint(id="riskEvidenceSynthesis-7", level="Warning", location="certainty.certaintySubcomponent.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/certainty-subcomponent-type", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/certainty-subcomponent-type', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/RiskEvidenceSynthesis", generated=true), @Constraint(id="riskEvidenceSynthesis-8", level="Warning", location="certainty.certaintySubcomponent.rating", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/certainty-subcomponent-rating", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/certainty-subcomponent-rating', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/RiskEvidenceSynthesis", generated=true)})
public class RiskEvidenceSynthesis
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final String version;
    @Summary
    private final String name;
    @Summary
    private final String title;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    @Summary
    private final Markdown description;
    private final List<Annotation> note;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown copyright;
    private final Date approvalDate;
    private final Date lastReviewDate;
    @Summary
    private final Period effectivePeriod;
    @Binding(bindingName="DefinitionTopic", strength=BindingStrength.Value.EXAMPLE, description="High-level categorization of the definition, used for searching, sorting, and filtering.", valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    private final List<CodeableConcept> topic;
    private final List<ContactDetail> author;
    private final List<ContactDetail> editor;
    private final List<ContactDetail> reviewer;
    private final List<ContactDetail> endorser;
    private final List<RelatedArtifact> relatedArtifact;
    @Binding(bindingName="SynthesisType", strength=BindingStrength.Value.EXTENSIBLE, description="Types of combining results from a body of evidence (eg. summary data meta-analysis).", valueSet="http://hl7.org/fhir/ValueSet/synthesis-type")
    private final CodeableConcept synthesisType;
    @Binding(bindingName="StudyType", strength=BindingStrength.Value.EXTENSIBLE, description="Types of research studies (types of research methods).", valueSet="http://hl7.org/fhir/ValueSet/study-type")
    private final CodeableConcept studyType;
    @Summary
    @ReferenceTarget(value={"EvidenceVariable"})
    @Required
    private final Reference population;
    @Summary
    @ReferenceTarget(value={"EvidenceVariable"})
    private final Reference exposure;
    @Summary
    @ReferenceTarget(value={"EvidenceVariable"})
    @Required
    private final Reference outcome;
    private final SampleSize sampleSize;
    @Summary
    private final RiskEstimate riskEstimate;
    private final List<Certainty> certainty;

    private RiskEvidenceSynthesis(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.status = builder.status;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.note = Collections.unmodifiableList(builder.note);
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.copyright = builder.copyright;
        this.approvalDate = builder.approvalDate;
        this.lastReviewDate = builder.lastReviewDate;
        this.effectivePeriod = builder.effectivePeriod;
        this.topic = Collections.unmodifiableList(builder.topic);
        this.author = Collections.unmodifiableList(builder.author);
        this.editor = Collections.unmodifiableList(builder.editor);
        this.reviewer = Collections.unmodifiableList(builder.reviewer);
        this.endorser = Collections.unmodifiableList(builder.endorser);
        this.relatedArtifact = Collections.unmodifiableList(builder.relatedArtifact);
        this.synthesisType = builder.synthesisType;
        this.studyType = builder.studyType;
        this.population = builder.population;
        this.exposure = builder.exposure;
        this.outcome = builder.outcome;
        this.sampleSize = builder.sampleSize;
        this.riskEstimate = builder.riskEstimate;
        this.certainty = Collections.unmodifiableList(builder.certainty);
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<Annotation> getNote() {
        return this.note;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public List<CodeableConcept> getTopic() {
        return this.topic;
    }

    public List<ContactDetail> getAuthor() {
        return this.author;
    }

    public List<ContactDetail> getEditor() {
        return this.editor;
    }

    public List<ContactDetail> getReviewer() {
        return this.reviewer;
    }

    public List<ContactDetail> getEndorser() {
        return this.endorser;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        return this.relatedArtifact;
    }

    public CodeableConcept getSynthesisType() {
        return this.synthesisType;
    }

    public CodeableConcept getStudyType() {
        return this.studyType;
    }

    public Reference getPopulation() {
        return this.population;
    }

    public Reference getExposure() {
        return this.exposure;
    }

    public Reference getOutcome() {
        return this.outcome;
    }

    public SampleSize getSampleSize() {
        return this.sampleSize;
    }

    public RiskEstimate getRiskEstimate() {
        return this.riskEstimate;
    }

    public List<Certainty> getCertainty() {
        return this.certainty;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || this.status != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.note.isEmpty() || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.copyright != null || this.approvalDate != null || this.lastReviewDate != null || this.effectivePeriod != null || !this.topic.isEmpty() || !this.author.isEmpty() || !this.editor.isEmpty() || !this.reviewer.isEmpty() || !this.endorser.isEmpty() || !this.relatedArtifact.isEmpty() || this.synthesisType != null || this.studyType != null || this.population != null || this.exposure != null || this.outcome != null || this.sampleSize != null || this.riskEstimate != null || !this.certainty.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.note, "note", visitor, Annotation.class);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.approvalDate, "approvalDate", visitor);
                this.accept(this.lastReviewDate, "lastReviewDate", visitor);
                this.accept(this.effectivePeriod, "effectivePeriod", visitor);
                this.accept(this.topic, "topic", visitor, CodeableConcept.class);
                this.accept(this.author, "author", visitor, ContactDetail.class);
                this.accept(this.editor, "editor", visitor, ContactDetail.class);
                this.accept(this.reviewer, "reviewer", visitor, ContactDetail.class);
                this.accept(this.endorser, "endorser", visitor, ContactDetail.class);
                this.accept(this.relatedArtifact, "relatedArtifact", visitor, RelatedArtifact.class);
                this.accept(this.synthesisType, "synthesisType", visitor);
                this.accept(this.studyType, "studyType", visitor);
                this.accept(this.population, "population", visitor);
                this.accept(this.exposure, "exposure", visitor);
                this.accept(this.outcome, "outcome", visitor);
                this.accept(this.sampleSize, "sampleSize", visitor);
                this.accept(this.riskEstimate, "riskEstimate", visitor);
                this.accept(this.certainty, "certainty", visitor, Certainty.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RiskEvidenceSynthesis other = (RiskEvidenceSynthesis)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.status, other.status) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.note, other.note) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.approvalDate, other.approvalDate) && Objects.equals(this.lastReviewDate, other.lastReviewDate) && Objects.equals(this.effectivePeriod, other.effectivePeriod) && Objects.equals(this.topic, other.topic) && Objects.equals(this.author, other.author) && Objects.equals(this.editor, other.editor) && Objects.equals(this.reviewer, other.reviewer) && Objects.equals(this.endorser, other.endorser) && Objects.equals(this.relatedArtifact, other.relatedArtifact) && Objects.equals(this.synthesisType, other.synthesisType) && Objects.equals(this.studyType, other.studyType) && Objects.equals(this.population, other.population) && Objects.equals(this.exposure, other.exposure) && Objects.equals(this.outcome, other.outcome) && Objects.equals(this.sampleSize, other.sampleSize) && Objects.equals(this.riskEstimate, other.riskEstimate) && Objects.equals(this.certainty, other.certainty);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.status, this.date, this.publisher, this.contact, this.description, this.note, this.useContext, this.jurisdiction, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.synthesisType, this.studyType, this.population, this.exposure, this.outcome, this.sampleSize, this.riskEstimate, this.certainty);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Certainty
    extends BackboneElement {
        @Binding(bindingName="QualityOfEvidenceRating", strength=BindingStrength.Value.EXTENSIBLE, description="The quality of the evidence described. The code system used specifies the quality scale used to grade this evidence source while the code specifies the actual quality score (represented as a coded value) associated with the evidence.", valueSet="http://hl7.org/fhir/ValueSet/evidence-quality")
        private final List<CodeableConcept> rating;
        private final List<Annotation> note;
        private final List<CertaintySubcomponent> certaintySubcomponent;

        private Certainty(Builder builder) {
            super(builder);
            this.rating = Collections.unmodifiableList(builder.rating);
            this.note = Collections.unmodifiableList(builder.note);
            this.certaintySubcomponent = Collections.unmodifiableList(builder.certaintySubcomponent);
        }

        public List<CodeableConcept> getRating() {
            return this.rating;
        }

        public List<Annotation> getNote() {
            return this.note;
        }

        public List<CertaintySubcomponent> getCertaintySubcomponent() {
            return this.certaintySubcomponent;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.rating.isEmpty() || !this.note.isEmpty() || !this.certaintySubcomponent.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.rating, "rating", visitor, CodeableConcept.class);
                    this.accept(this.note, "note", visitor, Annotation.class);
                    this.accept(this.certaintySubcomponent, "certaintySubcomponent", visitor, CertaintySubcomponent.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Certainty other = (Certainty)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.rating, other.rating) && Objects.equals(this.note, other.note) && Objects.equals(this.certaintySubcomponent, other.certaintySubcomponent);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.rating, this.note, this.certaintySubcomponent);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class CertaintySubcomponent
        extends BackboneElement {
            @Binding(bindingName="CertaintySubcomponentType", strength=BindingStrength.Value.EXTENSIBLE, description="The subcomponent classification of quality of evidence rating systems.", valueSet="http://hl7.org/fhir/ValueSet/certainty-subcomponent-type")
            private final CodeableConcept type;
            @Binding(bindingName="CertaintySubcomponentRating", strength=BindingStrength.Value.EXTENSIBLE, description="The quality rating of the subcomponent of a quality of evidence rating.", valueSet="http://hl7.org/fhir/ValueSet/certainty-subcomponent-rating")
            private final List<CodeableConcept> rating;
            private final List<Annotation> note;

            private CertaintySubcomponent(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.rating = Collections.unmodifiableList(builder.rating);
                this.note = Collections.unmodifiableList(builder.note);
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public List<CodeableConcept> getRating() {
                return this.rating;
            }

            public List<Annotation> getNote() {
                return this.note;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || !this.rating.isEmpty() || !this.note.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.rating, "rating", visitor, CodeableConcept.class);
                        this.accept(this.note, "note", visitor, Annotation.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                CertaintySubcomponent other = (CertaintySubcomponent)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.rating, other.rating) && Objects.equals(this.note, other.note);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.rating, this.note);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private List<CodeableConcept> rating = new ArrayList<CodeableConcept>();
                private List<Annotation> note = new ArrayList<Annotation>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder rating(CodeableConcept ... rating) {
                    for (CodeableConcept value : rating) {
                        this.rating.add(value);
                    }
                    return this;
                }

                public Builder rating(Collection<CodeableConcept> rating) {
                    this.rating = new ArrayList<CodeableConcept>(rating);
                    return this;
                }

                public Builder note(Annotation ... note) {
                    for (Annotation value : note) {
                        this.note.add(value);
                    }
                    return this;
                }

                public Builder note(Collection<Annotation> note) {
                    this.note = new ArrayList<Annotation>(note);
                    return this;
                }

                @Override
                public CertaintySubcomponent build() {
                    CertaintySubcomponent certaintySubcomponent = new CertaintySubcomponent(this);
                    if (this.validating) {
                        this.validate(certaintySubcomponent);
                    }
                    return certaintySubcomponent;
                }

                protected void validate(CertaintySubcomponent certaintySubcomponent) {
                    super.validate(certaintySubcomponent);
                    ValidationSupport.checkList(certaintySubcomponent.rating, "rating", CodeableConcept.class);
                    ValidationSupport.checkList(certaintySubcomponent.note, "note", Annotation.class);
                    ValidationSupport.requireValueOrChildren(certaintySubcomponent);
                }

                protected Builder from(CertaintySubcomponent certaintySubcomponent) {
                    super.from(certaintySubcomponent);
                    this.type = certaintySubcomponent.type;
                    this.rating.addAll(certaintySubcomponent.rating);
                    this.note.addAll(certaintySubcomponent.note);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<CodeableConcept> rating = new ArrayList<CodeableConcept>();
            private List<Annotation> note = new ArrayList<Annotation>();
            private List<CertaintySubcomponent> certaintySubcomponent = new ArrayList<CertaintySubcomponent>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder rating(CodeableConcept ... rating) {
                for (CodeableConcept value : rating) {
                    this.rating.add(value);
                }
                return this;
            }

            public Builder rating(Collection<CodeableConcept> rating) {
                this.rating = new ArrayList<CodeableConcept>(rating);
                return this;
            }

            public Builder note(Annotation ... note) {
                for (Annotation value : note) {
                    this.note.add(value);
                }
                return this;
            }

            public Builder note(Collection<Annotation> note) {
                this.note = new ArrayList<Annotation>(note);
                return this;
            }

            public Builder certaintySubcomponent(CertaintySubcomponent ... certaintySubcomponent) {
                for (CertaintySubcomponent value : certaintySubcomponent) {
                    this.certaintySubcomponent.add(value);
                }
                return this;
            }

            public Builder certaintySubcomponent(Collection<CertaintySubcomponent> certaintySubcomponent) {
                this.certaintySubcomponent = new ArrayList<CertaintySubcomponent>(certaintySubcomponent);
                return this;
            }

            @Override
            public Certainty build() {
                Certainty certainty = new Certainty(this);
                if (this.validating) {
                    this.validate(certainty);
                }
                return certainty;
            }

            protected void validate(Certainty certainty) {
                super.validate(certainty);
                ValidationSupport.checkList(certainty.rating, "rating", CodeableConcept.class);
                ValidationSupport.checkList(certainty.note, "note", Annotation.class);
                ValidationSupport.checkList(certainty.certaintySubcomponent, "certaintySubcomponent", CertaintySubcomponent.class);
                ValidationSupport.requireValueOrChildren(certainty);
            }

            protected Builder from(Certainty certainty) {
                super.from(certainty);
                this.rating.addAll(certainty.rating);
                this.note.addAll(certainty.note);
                this.certaintySubcomponent.addAll(certainty.certaintySubcomponent);
                return this;
            }
        }
    }

    public static class RiskEstimate
    extends BackboneElement {
        private final String description;
        @Binding(bindingName="RiskEstimateType", strength=BindingStrength.Value.EXTENSIBLE, description="Whether the risk estimate is dichotomous, continuous or qualitative and the specific type of risk estimate (eg proportion or median).", valueSet="http://hl7.org/fhir/ValueSet/risk-estimate-type")
        private final CodeableConcept type;
        private final Decimal value;
        @Binding(bindingName="UCUMUnits", strength=BindingStrength.Value.REQUIRED, description="Unified Code for Units of Measure (UCUM).", valueSet="http://hl7.org/fhir/ValueSet/ucum-units|4.0.1")
        private final CodeableConcept unitOfMeasure;
        private final Integer denominatorCount;
        private final Integer numeratorCount;
        private final List<PrecisionEstimate> precisionEstimate;

        private RiskEstimate(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.type = builder.type;
            this.value = builder.value;
            this.unitOfMeasure = builder.unitOfMeasure;
            this.denominatorCount = builder.denominatorCount;
            this.numeratorCount = builder.numeratorCount;
            this.precisionEstimate = Collections.unmodifiableList(builder.precisionEstimate);
        }

        public String getDescription() {
            return this.description;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public Decimal getValue() {
            return this.value;
        }

        public CodeableConcept getUnitOfMeasure() {
            return this.unitOfMeasure;
        }

        public Integer getDenominatorCount() {
            return this.denominatorCount;
        }

        public Integer getNumeratorCount() {
            return this.numeratorCount;
        }

        public List<PrecisionEstimate> getPrecisionEstimate() {
            return this.precisionEstimate;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.type != null || this.value != null || this.unitOfMeasure != null || this.denominatorCount != null || this.numeratorCount != null || !this.precisionEstimate.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.type, "type", visitor);
                    this.accept(this.value, "value", visitor);
                    this.accept(this.unitOfMeasure, "unitOfMeasure", visitor);
                    this.accept(this.denominatorCount, "denominatorCount", visitor);
                    this.accept(this.numeratorCount, "numeratorCount", visitor);
                    this.accept(this.precisionEstimate, "precisionEstimate", visitor, PrecisionEstimate.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RiskEstimate other = (RiskEstimate)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value) && Objects.equals(this.unitOfMeasure, other.unitOfMeasure) && Objects.equals(this.denominatorCount, other.denominatorCount) && Objects.equals(this.numeratorCount, other.numeratorCount) && Objects.equals(this.precisionEstimate, other.precisionEstimate);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.type, this.value, this.unitOfMeasure, this.denominatorCount, this.numeratorCount, this.precisionEstimate);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class PrecisionEstimate
        extends BackboneElement {
            @Binding(bindingName="PrecisionEstimateType", strength=BindingStrength.Value.EXTENSIBLE, description="Method of reporting variability of estimates, such as confidence intervals, interquartile range or standard deviation.", valueSet="http://hl7.org/fhir/ValueSet/precision-estimate-type")
            private final CodeableConcept type;
            private final Decimal level;
            private final Decimal from;
            private final Decimal to;

            private PrecisionEstimate(Builder builder) {
                super(builder);
                this.type = builder.type;
                this.level = builder.level;
                this.from = builder.from;
                this.to = builder.to;
            }

            public CodeableConcept getType() {
                return this.type;
            }

            public Decimal getLevel() {
                return this.level;
            }

            public Decimal getFrom() {
                return this.from;
            }

            public Decimal getTo() {
                return this.to;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.type != null || this.level != null || this.from != null || this.to != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.type, "type", visitor);
                        this.accept(this.level, "level", visitor);
                        this.accept(this.from, "from", visitor);
                        this.accept(this.to, "to", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                PrecisionEstimate other = (PrecisionEstimate)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.level, other.level) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.level, this.from, this.to);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept type;
                private Decimal level;
                private Decimal from;
                private Decimal to;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder type(CodeableConcept type) {
                    this.type = type;
                    return this;
                }

                public Builder level(Decimal level) {
                    this.level = level;
                    return this;
                }

                public Builder from(Decimal from) {
                    this.from = from;
                    return this;
                }

                public Builder to(Decimal to) {
                    this.to = to;
                    return this;
                }

                @Override
                public PrecisionEstimate build() {
                    PrecisionEstimate precisionEstimate = new PrecisionEstimate(this);
                    if (this.validating) {
                        this.validate(precisionEstimate);
                    }
                    return precisionEstimate;
                }

                protected void validate(PrecisionEstimate precisionEstimate) {
                    super.validate(precisionEstimate);
                    ValidationSupport.requireValueOrChildren(precisionEstimate);
                }

                protected Builder from(PrecisionEstimate precisionEstimate) {
                    super.from(precisionEstimate);
                    this.type = precisionEstimate.type;
                    this.level = precisionEstimate.level;
                    this.from = precisionEstimate.from;
                    this.to = precisionEstimate.to;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String description;
            private CodeableConcept type;
            private Decimal value;
            private CodeableConcept unitOfMeasure;
            private Integer denominatorCount;
            private Integer numeratorCount;
            private List<PrecisionEstimate> precisionEstimate = new ArrayList<PrecisionEstimate>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder type(CodeableConcept type) {
                this.type = type;
                return this;
            }

            public Builder value(Decimal value) {
                this.value = value;
                return this;
            }

            public Builder unitOfMeasure(CodeableConcept unitOfMeasure) {
                this.unitOfMeasure = unitOfMeasure;
                return this;
            }

            public Builder denominatorCount(Integer denominatorCount) {
                this.denominatorCount = denominatorCount;
                return this;
            }

            public Builder numeratorCount(Integer numeratorCount) {
                this.numeratorCount = numeratorCount;
                return this;
            }

            public Builder precisionEstimate(PrecisionEstimate ... precisionEstimate) {
                for (PrecisionEstimate value : precisionEstimate) {
                    this.precisionEstimate.add(value);
                }
                return this;
            }

            public Builder precisionEstimate(Collection<PrecisionEstimate> precisionEstimate) {
                this.precisionEstimate = new ArrayList<PrecisionEstimate>(precisionEstimate);
                return this;
            }

            @Override
            public RiskEstimate build() {
                RiskEstimate riskEstimate = new RiskEstimate(this);
                if (this.validating) {
                    this.validate(riskEstimate);
                }
                return riskEstimate;
            }

            protected void validate(RiskEstimate riskEstimate) {
                super.validate(riskEstimate);
                ValidationSupport.checkList(riskEstimate.precisionEstimate, "precisionEstimate", PrecisionEstimate.class);
                ValidationSupport.checkValueSetBinding(riskEstimate.unitOfMeasure, "unitOfMeasure", "http://hl7.org/fhir/ValueSet/ucum-units", "http://unitsofmeasure.org", new java.lang.String[0]);
                ValidationSupport.requireValueOrChildren(riskEstimate);
            }

            protected Builder from(RiskEstimate riskEstimate) {
                super.from(riskEstimate);
                this.description = riskEstimate.description;
                this.type = riskEstimate.type;
                this.value = riskEstimate.value;
                this.unitOfMeasure = riskEstimate.unitOfMeasure;
                this.denominatorCount = riskEstimate.denominatorCount;
                this.numeratorCount = riskEstimate.numeratorCount;
                this.precisionEstimate.addAll(riskEstimate.precisionEstimate);
                return this;
            }
        }
    }

    public static class SampleSize
    extends BackboneElement {
        private final String description;
        private final Integer numberOfStudies;
        private final Integer numberOfParticipants;

        private SampleSize(Builder builder) {
            super(builder);
            this.description = builder.description;
            this.numberOfStudies = builder.numberOfStudies;
            this.numberOfParticipants = builder.numberOfParticipants;
        }

        public String getDescription() {
            return this.description;
        }

        public Integer getNumberOfStudies() {
            return this.numberOfStudies;
        }

        public Integer getNumberOfParticipants() {
            return this.numberOfParticipants;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.description != null || this.numberOfStudies != null || this.numberOfParticipants != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.numberOfStudies, "numberOfStudies", visitor);
                    this.accept(this.numberOfParticipants, "numberOfParticipants", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SampleSize other = (SampleSize)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.description, other.description) && Objects.equals(this.numberOfStudies, other.numberOfStudies) && Objects.equals(this.numberOfParticipants, other.numberOfParticipants);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.description, this.numberOfStudies, this.numberOfParticipants);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String description;
            private Integer numberOfStudies;
            private Integer numberOfParticipants;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder numberOfStudies(Integer numberOfStudies) {
                this.numberOfStudies = numberOfStudies;
                return this;
            }

            public Builder numberOfParticipants(Integer numberOfParticipants) {
                this.numberOfParticipants = numberOfParticipants;
                return this;
            }

            @Override
            public SampleSize build() {
                SampleSize sampleSize = new SampleSize(this);
                if (this.validating) {
                    this.validate(sampleSize);
                }
                return sampleSize;
            }

            protected void validate(SampleSize sampleSize) {
                super.validate(sampleSize);
                ValidationSupport.requireValueOrChildren(sampleSize);
            }

            protected Builder from(SampleSize sampleSize) {
                super.from(sampleSize);
                this.description = sampleSize.description;
                this.numberOfStudies = sampleSize.numberOfStudies;
                this.numberOfParticipants = sampleSize.numberOfParticipants;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private String version;
        private String name;
        private String title;
        private PublicationStatus status;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<Annotation> note = new ArrayList<Annotation>();
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown copyright;
        private Date approvalDate;
        private Date lastReviewDate;
        private Period effectivePeriod;
        private List<CodeableConcept> topic = new ArrayList<CodeableConcept>();
        private List<ContactDetail> author = new ArrayList<ContactDetail>();
        private List<ContactDetail> editor = new ArrayList<ContactDetail>();
        private List<ContactDetail> reviewer = new ArrayList<ContactDetail>();
        private List<ContactDetail> endorser = new ArrayList<ContactDetail>();
        private List<RelatedArtifact> relatedArtifact = new ArrayList<RelatedArtifact>();
        private CodeableConcept synthesisType;
        private CodeableConcept studyType;
        private Reference population;
        private Reference exposure;
        private Reference outcome;
        private SampleSize sampleSize;
        private RiskEstimate riskEstimate;
        private List<Certainty> certainty = new ArrayList<Certainty>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder note(Annotation ... note) {
            for (Annotation value : note) {
                this.note.add(value);
            }
            return this;
        }

        public Builder note(Collection<Annotation> note) {
            this.note = new ArrayList<Annotation>(note);
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder approvalDate(Date approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public Builder lastReviewDate(Date lastReviewDate) {
            this.lastReviewDate = lastReviewDate;
            return this;
        }

        public Builder effectivePeriod(Period effectivePeriod) {
            this.effectivePeriod = effectivePeriod;
            return this;
        }

        public Builder topic(CodeableConcept ... topic) {
            for (CodeableConcept value : topic) {
                this.topic.add(value);
            }
            return this;
        }

        public Builder topic(Collection<CodeableConcept> topic) {
            this.topic = new ArrayList<CodeableConcept>(topic);
            return this;
        }

        public Builder author(ContactDetail ... author) {
            for (ContactDetail value : author) {
                this.author.add(value);
            }
            return this;
        }

        public Builder author(Collection<ContactDetail> author) {
            this.author = new ArrayList<ContactDetail>(author);
            return this;
        }

        public Builder editor(ContactDetail ... editor) {
            for (ContactDetail value : editor) {
                this.editor.add(value);
            }
            return this;
        }

        public Builder editor(Collection<ContactDetail> editor) {
            this.editor = new ArrayList<ContactDetail>(editor);
            return this;
        }

        public Builder reviewer(ContactDetail ... reviewer) {
            for (ContactDetail value : reviewer) {
                this.reviewer.add(value);
            }
            return this;
        }

        public Builder reviewer(Collection<ContactDetail> reviewer) {
            this.reviewer = new ArrayList<ContactDetail>(reviewer);
            return this;
        }

        public Builder endorser(ContactDetail ... endorser) {
            for (ContactDetail value : endorser) {
                this.endorser.add(value);
            }
            return this;
        }

        public Builder endorser(Collection<ContactDetail> endorser) {
            this.endorser = new ArrayList<ContactDetail>(endorser);
            return this;
        }

        public Builder relatedArtifact(RelatedArtifact ... relatedArtifact) {
            for (RelatedArtifact value : relatedArtifact) {
                this.relatedArtifact.add(value);
            }
            return this;
        }

        public Builder relatedArtifact(Collection<RelatedArtifact> relatedArtifact) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>(relatedArtifact);
            return this;
        }

        public Builder synthesisType(CodeableConcept synthesisType) {
            this.synthesisType = synthesisType;
            return this;
        }

        public Builder studyType(CodeableConcept studyType) {
            this.studyType = studyType;
            return this;
        }

        public Builder population(Reference population) {
            this.population = population;
            return this;
        }

        public Builder exposure(Reference exposure) {
            this.exposure = exposure;
            return this;
        }

        public Builder outcome(Reference outcome) {
            this.outcome = outcome;
            return this;
        }

        public Builder sampleSize(SampleSize sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public Builder riskEstimate(RiskEstimate riskEstimate) {
            this.riskEstimate = riskEstimate;
            return this;
        }

        public Builder certainty(Certainty ... certainty) {
            for (Certainty value : certainty) {
                this.certainty.add(value);
            }
            return this;
        }

        public Builder certainty(Collection<Certainty> certainty) {
            this.certainty = new ArrayList<Certainty>(certainty);
            return this;
        }

        @Override
        public RiskEvidenceSynthesis build() {
            RiskEvidenceSynthesis riskEvidenceSynthesis = new RiskEvidenceSynthesis(this);
            if (this.validating) {
                this.validate(riskEvidenceSynthesis);
            }
            return riskEvidenceSynthesis;
        }

        protected void validate(RiskEvidenceSynthesis riskEvidenceSynthesis) {
            super.validate(riskEvidenceSynthesis);
            ValidationSupport.checkList(riskEvidenceSynthesis.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(riskEvidenceSynthesis.status, "status");
            ValidationSupport.checkList(riskEvidenceSynthesis.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(riskEvidenceSynthesis.note, "note", Annotation.class);
            ValidationSupport.checkList(riskEvidenceSynthesis.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(riskEvidenceSynthesis.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkList(riskEvidenceSynthesis.topic, "topic", CodeableConcept.class);
            ValidationSupport.checkList(riskEvidenceSynthesis.author, "author", ContactDetail.class);
            ValidationSupport.checkList(riskEvidenceSynthesis.editor, "editor", ContactDetail.class);
            ValidationSupport.checkList(riskEvidenceSynthesis.reviewer, "reviewer", ContactDetail.class);
            ValidationSupport.checkList(riskEvidenceSynthesis.endorser, "endorser", ContactDetail.class);
            ValidationSupport.checkList(riskEvidenceSynthesis.relatedArtifact, "relatedArtifact", RelatedArtifact.class);
            ValidationSupport.requireNonNull(riskEvidenceSynthesis.population, "population");
            ValidationSupport.requireNonNull(riskEvidenceSynthesis.outcome, "outcome");
            ValidationSupport.checkList(riskEvidenceSynthesis.certainty, "certainty", Certainty.class);
            ValidationSupport.checkReferenceType(riskEvidenceSynthesis.population, "population", "EvidenceVariable");
            ValidationSupport.checkReferenceType(riskEvidenceSynthesis.exposure, "exposure", "EvidenceVariable");
            ValidationSupport.checkReferenceType(riskEvidenceSynthesis.outcome, "outcome", "EvidenceVariable");
        }

        protected Builder from(RiskEvidenceSynthesis riskEvidenceSynthesis) {
            super.from(riskEvidenceSynthesis);
            this.url = riskEvidenceSynthesis.url;
            this.identifier.addAll(riskEvidenceSynthesis.identifier);
            this.version = riskEvidenceSynthesis.version;
            this.name = riskEvidenceSynthesis.name;
            this.title = riskEvidenceSynthesis.title;
            this.status = riskEvidenceSynthesis.status;
            this.date = riskEvidenceSynthesis.date;
            this.publisher = riskEvidenceSynthesis.publisher;
            this.contact.addAll(riskEvidenceSynthesis.contact);
            this.description = riskEvidenceSynthesis.description;
            this.note.addAll(riskEvidenceSynthesis.note);
            this.useContext.addAll(riskEvidenceSynthesis.useContext);
            this.jurisdiction.addAll(riskEvidenceSynthesis.jurisdiction);
            this.copyright = riskEvidenceSynthesis.copyright;
            this.approvalDate = riskEvidenceSynthesis.approvalDate;
            this.lastReviewDate = riskEvidenceSynthesis.lastReviewDate;
            this.effectivePeriod = riskEvidenceSynthesis.effectivePeriod;
            this.topic.addAll(riskEvidenceSynthesis.topic);
            this.author.addAll(riskEvidenceSynthesis.author);
            this.editor.addAll(riskEvidenceSynthesis.editor);
            this.reviewer.addAll(riskEvidenceSynthesis.reviewer);
            this.endorser.addAll(riskEvidenceSynthesis.endorser);
            this.relatedArtifact.addAll(riskEvidenceSynthesis.relatedArtifact);
            this.synthesisType = riskEvidenceSynthesis.synthesisType;
            this.studyType = riskEvidenceSynthesis.studyType;
            this.population = riskEvidenceSynthesis.population;
            this.exposure = riskEvidenceSynthesis.exposure;
            this.outcome = riskEvidenceSynthesis.outcome;
            this.sampleSize = riskEvidenceSynthesis.sampleSize;
            this.riskEstimate = riskEvidenceSynthesis.riskEstimate;
            this.certainty.addAll(riskEvidenceSynthesis.certainty);
            return this;
        }
    }
}

