/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.SlotStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=3, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="slot-0", level="Warning", location="(base)", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/c80-practice-codes", expression="specialty.exists() implies (specialty.all(memberOf('http://hl7.org/fhir/ValueSet/c80-practice-codes', 'preferred')))", source="http://hl7.org/fhir/StructureDefinition/Slot", generated=true), @Constraint(id="slot-1", level="Warning", location="(base)", description="SHOULD contain a code from value set http://terminology.hl7.org/ValueSet/v2-0276", expression="appointmentType.exists() implies (appointmentType.memberOf('http://terminology.hl7.org/ValueSet/v2-0276', 'preferred'))", source="http://hl7.org/fhir/StructureDefinition/Slot", generated=true)})
public class Slot
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="service-category", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/service-category")
    private final List<CodeableConcept> serviceCategory;
    @Summary
    @Binding(bindingName="service-type", strength=BindingStrength.Value.EXAMPLE, valueSet="http://hl7.org/fhir/ValueSet/service-type")
    private final List<CodeableConcept> serviceType;
    @Summary
    @Binding(bindingName="specialty", strength=BindingStrength.Value.PREFERRED, description="Additional details about where the content was created (e.g. clinical specialty).", valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    private final List<CodeableConcept> specialty;
    @Summary
    @Binding(bindingName="appointment-type", strength=BindingStrength.Value.PREFERRED, valueSet="http://terminology.hl7.org/ValueSet/v2-0276")
    private final CodeableConcept appointmentType;
    @Summary
    @ReferenceTarget(value={"Schedule"})
    @Required
    private final Reference schedule;
    @Summary
    @Binding(bindingName="SlotStatus", strength=BindingStrength.Value.REQUIRED, description="The free/busy status of the slot.", valueSet="http://hl7.org/fhir/ValueSet/slotstatus|4.0.1")
    @Required
    private final SlotStatus status;
    @Summary
    @Required
    private final Instant start;
    @Summary
    @Required
    private final Instant end;
    private final Boolean overbooked;
    private final String comment;

    private Slot(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.serviceCategory = Collections.unmodifiableList(builder.serviceCategory);
        this.serviceType = Collections.unmodifiableList(builder.serviceType);
        this.specialty = Collections.unmodifiableList(builder.specialty);
        this.appointmentType = builder.appointmentType;
        this.schedule = builder.schedule;
        this.status = builder.status;
        this.start = builder.start;
        this.end = builder.end;
        this.overbooked = builder.overbooked;
        this.comment = builder.comment;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public List<CodeableConcept> getServiceCategory() {
        return this.serviceCategory;
    }

    public List<CodeableConcept> getServiceType() {
        return this.serviceType;
    }

    public List<CodeableConcept> getSpecialty() {
        return this.specialty;
    }

    public CodeableConcept getAppointmentType() {
        return this.appointmentType;
    }

    public Reference getSchedule() {
        return this.schedule;
    }

    public SlotStatus getStatus() {
        return this.status;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public Boolean getOverbooked() {
        return this.overbooked;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || !this.serviceCategory.isEmpty() || !this.serviceType.isEmpty() || !this.specialty.isEmpty() || this.appointmentType != null || this.schedule != null || this.status != null || this.start != null || this.end != null || this.overbooked != null || this.comment != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.serviceCategory, "serviceCategory", visitor, CodeableConcept.class);
                this.accept(this.serviceType, "serviceType", visitor, CodeableConcept.class);
                this.accept(this.specialty, "specialty", visitor, CodeableConcept.class);
                this.accept(this.appointmentType, "appointmentType", visitor);
                this.accept(this.schedule, "schedule", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.start, "start", visitor);
                this.accept(this.end, "end", visitor);
                this.accept(this.overbooked, "overbooked", visitor);
                this.accept(this.comment, "comment", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Slot other = (Slot)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.serviceCategory, other.serviceCategory) && Objects.equals(this.serviceType, other.serviceType) && Objects.equals(this.specialty, other.specialty) && Objects.equals(this.appointmentType, other.appointmentType) && Objects.equals(this.schedule, other.schedule) && Objects.equals(this.status, other.status) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.overbooked, other.overbooked) && Objects.equals(this.comment, other.comment);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.serviceCategory, this.serviceType, this.specialty, this.appointmentType, this.schedule, this.status, this.start, this.end, this.overbooked, this.comment);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private List<CodeableConcept> serviceCategory = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> serviceType = new ArrayList<CodeableConcept>();
        private List<CodeableConcept> specialty = new ArrayList<CodeableConcept>();
        private CodeableConcept appointmentType;
        private Reference schedule;
        private SlotStatus status;
        private Instant start;
        private Instant end;
        private Boolean overbooked;
        private String comment;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder serviceCategory(CodeableConcept ... serviceCategory) {
            for (CodeableConcept value : serviceCategory) {
                this.serviceCategory.add(value);
            }
            return this;
        }

        public Builder serviceCategory(Collection<CodeableConcept> serviceCategory) {
            this.serviceCategory = new ArrayList<CodeableConcept>(serviceCategory);
            return this;
        }

        public Builder serviceType(CodeableConcept ... serviceType) {
            for (CodeableConcept value : serviceType) {
                this.serviceType.add(value);
            }
            return this;
        }

        public Builder serviceType(Collection<CodeableConcept> serviceType) {
            this.serviceType = new ArrayList<CodeableConcept>(serviceType);
            return this;
        }

        public Builder specialty(CodeableConcept ... specialty) {
            for (CodeableConcept value : specialty) {
                this.specialty.add(value);
            }
            return this;
        }

        public Builder specialty(Collection<CodeableConcept> specialty) {
            this.specialty = new ArrayList<CodeableConcept>(specialty);
            return this;
        }

        public Builder appointmentType(CodeableConcept appointmentType) {
            this.appointmentType = appointmentType;
            return this;
        }

        public Builder schedule(Reference schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder status(SlotStatus status) {
            this.status = status;
            return this;
        }

        public Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public Builder overbooked(Boolean overbooked) {
            this.overbooked = overbooked;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Slot build() {
            Slot slot = new Slot(this);
            if (this.validating) {
                this.validate(slot);
            }
            return slot;
        }

        protected void validate(Slot slot) {
            super.validate(slot);
            ValidationSupport.checkList(slot.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(slot.serviceCategory, "serviceCategory", CodeableConcept.class);
            ValidationSupport.checkList(slot.serviceType, "serviceType", CodeableConcept.class);
            ValidationSupport.checkList(slot.specialty, "specialty", CodeableConcept.class);
            ValidationSupport.requireNonNull(slot.schedule, "schedule");
            ValidationSupport.requireNonNull(slot.status, "status");
            ValidationSupport.requireNonNull(slot.start, "start");
            ValidationSupport.requireNonNull(slot.end, "end");
            ValidationSupport.checkReferenceType(slot.schedule, "schedule", "Schedule");
        }

        protected Builder from(Slot slot) {
            super.from(slot);
            this.identifier.addAll(slot.identifier);
            this.serviceCategory.addAll(slot.serviceCategory);
            this.serviceType.addAll(slot.serviceType);
            this.specialty.addAll(slot.specialty);
            this.appointmentType = slot.appointmentType;
            this.schedule = slot.schedule;
            this.status = slot.status;
            this.start = slot.start;
            this.end = slot.end;
            this.overbooked = slot.overbooked;
            this.comment = slot.comment;
            return this;
        }
    }
}

