/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.FHIRSubstanceStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraint(id="substance-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/substance-category", expression="category.exists() implies (category.all(memberOf('http://hl7.org/fhir/ValueSet/substance-category', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/Substance", generated=true)
public class Substance
extends DomainResource {
    @Summary
    private final List<Identifier> identifier;
    @Summary
    @Binding(bindingName="FHIRSubstanceStatus", strength=BindingStrength.Value.REQUIRED, description="A code to indicate if the substance is actively used.", valueSet="http://hl7.org/fhir/ValueSet/substance-status|4.0.1")
    private final FHIRSubstanceStatus status;
    @Summary
    @Binding(bindingName="SubstanceCategory", strength=BindingStrength.Value.EXTENSIBLE, description="Category or classification of substance.", valueSet="http://hl7.org/fhir/ValueSet/substance-category")
    private final List<CodeableConcept> category;
    @Summary
    @Binding(bindingName="SubstanceCode", strength=BindingStrength.Value.EXAMPLE, description="Substance codes.", valueSet="http://hl7.org/fhir/ValueSet/substance-code")
    @Required
    private final CodeableConcept code;
    @Summary
    private final String description;
    @Summary
    private final List<Instance> instance;
    @Summary
    private final List<Ingredient> ingredient;

    private Substance(Builder builder) {
        super(builder);
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.status = builder.status;
        this.category = Collections.unmodifiableList(builder.category);
        this.code = builder.code;
        this.description = builder.description;
        this.instance = Collections.unmodifiableList(builder.instance);
        this.ingredient = Collections.unmodifiableList(builder.ingredient);
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public FHIRSubstanceStatus getStatus() {
        return this.status;
    }

    public List<CodeableConcept> getCategory() {
        return this.category;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Instance> getInstance() {
        return this.instance;
    }

    public List<Ingredient> getIngredient() {
        return this.ingredient;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.identifier.isEmpty() || this.status != null || !this.category.isEmpty() || this.code != null || this.description != null || !this.instance.isEmpty() || !this.ingredient.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.category, "category", visitor, CodeableConcept.class);
                this.accept(this.code, "code", visitor);
                this.accept(this.description, "description", visitor);
                this.accept(this.instance, "instance", visitor, Instance.class);
                this.accept(this.ingredient, "ingredient", visitor, Ingredient.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Substance other = (Substance)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.status, other.status) && Objects.equals(this.category, other.category) && Objects.equals(this.code, other.code) && Objects.equals(this.description, other.description) && Objects.equals(this.instance, other.instance) && Objects.equals(this.ingredient, other.ingredient);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.identifier, this.status, this.category, this.code, this.description, this.instance, this.ingredient);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Ingredient
    extends BackboneElement {
        @Summary
        private final Ratio quantity;
        @Summary
        @ReferenceTarget(value={"Substance"})
        @Choice(value={CodeableConcept.class, Reference.class})
        @Binding(bindingName="SubstanceIngredient", strength=BindingStrength.Value.EXAMPLE, description="Substance Ingredient codes.", valueSet="http://hl7.org/fhir/ValueSet/substance-code")
        @Required
        private final Element substance;

        private Ingredient(Builder builder) {
            super(builder);
            this.quantity = builder.quantity;
            this.substance = builder.substance;
        }

        public Ratio getQuantity() {
            return this.quantity;
        }

        public Element getSubstance() {
            return this.substance;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.quantity != null || this.substance != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.quantity, "quantity", visitor);
                    this.accept(this.substance, "substance", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Ingredient other = (Ingredient)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.substance, other.substance);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.quantity, this.substance);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Ratio quantity;
            private Element substance;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder quantity(Ratio quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder substance(Element substance) {
                this.substance = substance;
                return this;
            }

            @Override
            public Ingredient build() {
                Ingredient ingredient = new Ingredient(this);
                if (this.validating) {
                    this.validate(ingredient);
                }
                return ingredient;
            }

            protected void validate(Ingredient ingredient) {
                super.validate(ingredient);
                ValidationSupport.requireChoiceElement(ingredient.substance, "substance", CodeableConcept.class, Reference.class);
                ValidationSupport.checkReferenceType(ingredient.substance, "substance", "Substance");
                ValidationSupport.requireValueOrChildren(ingredient);
            }

            protected Builder from(Ingredient ingredient) {
                super.from(ingredient);
                this.quantity = ingredient.quantity;
                this.substance = ingredient.substance;
                return this;
            }
        }
    }

    public static class Instance
    extends BackboneElement {
        @Summary
        private final Identifier identifier;
        @Summary
        private final DateTime expiry;
        @Summary
        private final SimpleQuantity quantity;

        private Instance(Builder builder) {
            super(builder);
            this.identifier = builder.identifier;
            this.expiry = builder.expiry;
            this.quantity = builder.quantity;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public DateTime getExpiry() {
            return this.expiry;
        }

        public SimpleQuantity getQuantity() {
            return this.quantity;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.identifier != null || this.expiry != null || this.quantity != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor);
                    this.accept(this.expiry, "expiry", visitor);
                    this.accept(this.quantity, "quantity", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Instance other = (Instance)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.expiry, other.expiry) && Objects.equals(this.quantity, other.quantity);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.expiry, this.quantity);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Identifier identifier;
            private DateTime expiry;
            private SimpleQuantity quantity;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Identifier identifier) {
                this.identifier = identifier;
                return this;
            }

            public Builder expiry(DateTime expiry) {
                this.expiry = expiry;
                return this;
            }

            public Builder quantity(SimpleQuantity quantity) {
                this.quantity = quantity;
                return this;
            }

            @Override
            public Instance build() {
                Instance instance = new Instance(this);
                if (this.validating) {
                    this.validate(instance);
                }
                return instance;
            }

            protected void validate(Instance instance) {
                super.validate(instance);
                ValidationSupport.requireValueOrChildren(instance);
            }

            protected Builder from(Instance instance) {
                super.from(instance);
                this.identifier = instance.identifier;
                this.expiry = instance.expiry;
                this.quantity = instance.quantity;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private FHIRSubstanceStatus status;
        private List<CodeableConcept> category = new ArrayList<CodeableConcept>();
        private CodeableConcept code;
        private String description;
        private List<Instance> instance = new ArrayList<Instance>();
        private List<Ingredient> ingredient = new ArrayList<Ingredient>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder status(FHIRSubstanceStatus status) {
            this.status = status;
            return this;
        }

        public Builder category(CodeableConcept ... category) {
            for (CodeableConcept value : category) {
                this.category.add(value);
            }
            return this;
        }

        public Builder category(Collection<CodeableConcept> category) {
            this.category = new ArrayList<CodeableConcept>(category);
            return this;
        }

        public Builder code(CodeableConcept code) {
            this.code = code;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder instance(Instance ... instance) {
            for (Instance value : instance) {
                this.instance.add(value);
            }
            return this;
        }

        public Builder instance(Collection<Instance> instance) {
            this.instance = new ArrayList<Instance>(instance);
            return this;
        }

        public Builder ingredient(Ingredient ... ingredient) {
            for (Ingredient value : ingredient) {
                this.ingredient.add(value);
            }
            return this;
        }

        public Builder ingredient(Collection<Ingredient> ingredient) {
            this.ingredient = new ArrayList<Ingredient>(ingredient);
            return this;
        }

        @Override
        public Substance build() {
            Substance substance = new Substance(this);
            if (this.validating) {
                this.validate(substance);
            }
            return substance;
        }

        protected void validate(Substance substance) {
            super.validate(substance);
            ValidationSupport.checkList(substance.identifier, "identifier", Identifier.class);
            ValidationSupport.checkList(substance.category, "category", CodeableConcept.class);
            ValidationSupport.requireNonNull(substance.code, "code");
            ValidationSupport.checkList(substance.instance, "instance", Instance.class);
            ValidationSupport.checkList(substance.ingredient, "ingredient", Ingredient.class);
        }

        protected Builder from(Substance substance) {
            super.from(substance);
            this.identifier.addAll(substance.identifier);
            this.status = substance.status;
            this.category.addAll(substance.category);
            this.code = substance.code;
            this.description = substance.description;
            this.instance.addAll(substance.instance);
            this.ingredient.addAll(substance.ingredient);
            return this;
        }
    }
}

