/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=0, status=StandardsStatus.Value.TRIAL_USE)
public class SubstanceSourceMaterial
extends DomainResource {
    @Summary
    private final CodeableConcept sourceMaterialClass;
    @Summary
    private final CodeableConcept sourceMaterialType;
    @Summary
    private final CodeableConcept sourceMaterialState;
    @Summary
    private final Identifier organismId;
    @Summary
    private final String organismName;
    @Summary
    private final List<Identifier> parentSubstanceId;
    @Summary
    private final List<String> parentSubstanceName;
    @Summary
    private final List<CodeableConcept> countryOfOrigin;
    @Summary
    private final List<String> geographicalLocation;
    @Summary
    private final CodeableConcept developmentStage;
    @Summary
    private final List<FractionDescription> fractionDescription;
    @Summary
    private final Organism organism;
    @Summary
    private final List<PartDescription> partDescription;

    private SubstanceSourceMaterial(Builder builder) {
        super(builder);
        this.sourceMaterialClass = builder.sourceMaterialClass;
        this.sourceMaterialType = builder.sourceMaterialType;
        this.sourceMaterialState = builder.sourceMaterialState;
        this.organismId = builder.organismId;
        this.organismName = builder.organismName;
        this.parentSubstanceId = Collections.unmodifiableList(builder.parentSubstanceId);
        this.parentSubstanceName = Collections.unmodifiableList(builder.parentSubstanceName);
        this.countryOfOrigin = Collections.unmodifiableList(builder.countryOfOrigin);
        this.geographicalLocation = Collections.unmodifiableList(builder.geographicalLocation);
        this.developmentStage = builder.developmentStage;
        this.fractionDescription = Collections.unmodifiableList(builder.fractionDescription);
        this.organism = builder.organism;
        this.partDescription = Collections.unmodifiableList(builder.partDescription);
    }

    public CodeableConcept getSourceMaterialClass() {
        return this.sourceMaterialClass;
    }

    public CodeableConcept getSourceMaterialType() {
        return this.sourceMaterialType;
    }

    public CodeableConcept getSourceMaterialState() {
        return this.sourceMaterialState;
    }

    public Identifier getOrganismId() {
        return this.organismId;
    }

    public String getOrganismName() {
        return this.organismName;
    }

    public List<Identifier> getParentSubstanceId() {
        return this.parentSubstanceId;
    }

    public List<String> getParentSubstanceName() {
        return this.parentSubstanceName;
    }

    public List<CodeableConcept> getCountryOfOrigin() {
        return this.countryOfOrigin;
    }

    public List<String> getGeographicalLocation() {
        return this.geographicalLocation;
    }

    public CodeableConcept getDevelopmentStage() {
        return this.developmentStage;
    }

    public List<FractionDescription> getFractionDescription() {
        return this.fractionDescription;
    }

    public Organism getOrganism() {
        return this.organism;
    }

    public List<PartDescription> getPartDescription() {
        return this.partDescription;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.sourceMaterialClass != null || this.sourceMaterialType != null || this.sourceMaterialState != null || this.organismId != null || this.organismName != null || !this.parentSubstanceId.isEmpty() || !this.parentSubstanceName.isEmpty() || !this.countryOfOrigin.isEmpty() || !this.geographicalLocation.isEmpty() || this.developmentStage != null || !this.fractionDescription.isEmpty() || this.organism != null || !this.partDescription.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.sourceMaterialClass, "sourceMaterialClass", visitor);
                this.accept(this.sourceMaterialType, "sourceMaterialType", visitor);
                this.accept(this.sourceMaterialState, "sourceMaterialState", visitor);
                this.accept(this.organismId, "organismId", visitor);
                this.accept(this.organismName, "organismName", visitor);
                this.accept(this.parentSubstanceId, "parentSubstanceId", visitor, Identifier.class);
                this.accept(this.parentSubstanceName, "parentSubstanceName", visitor, String.class);
                this.accept(this.countryOfOrigin, "countryOfOrigin", visitor, CodeableConcept.class);
                this.accept(this.geographicalLocation, "geographicalLocation", visitor, String.class);
                this.accept(this.developmentStage, "developmentStage", visitor);
                this.accept(this.fractionDescription, "fractionDescription", visitor, FractionDescription.class);
                this.accept(this.organism, "organism", visitor);
                this.accept(this.partDescription, "partDescription", visitor, PartDescription.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubstanceSourceMaterial other = (SubstanceSourceMaterial)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.sourceMaterialClass, other.sourceMaterialClass) && Objects.equals(this.sourceMaterialType, other.sourceMaterialType) && Objects.equals(this.sourceMaterialState, other.sourceMaterialState) && Objects.equals(this.organismId, other.organismId) && Objects.equals(this.organismName, other.organismName) && Objects.equals(this.parentSubstanceId, other.parentSubstanceId) && Objects.equals(this.parentSubstanceName, other.parentSubstanceName) && Objects.equals(this.countryOfOrigin, other.countryOfOrigin) && Objects.equals(this.geographicalLocation, other.geographicalLocation) && Objects.equals(this.developmentStage, other.developmentStage) && Objects.equals(this.fractionDescription, other.fractionDescription) && Objects.equals(this.organism, other.organism) && Objects.equals(this.partDescription, other.partDescription);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.sourceMaterialClass, this.sourceMaterialType, this.sourceMaterialState, this.organismId, this.organismName, this.parentSubstanceId, this.parentSubstanceName, this.countryOfOrigin, this.geographicalLocation, this.developmentStage, this.fractionDescription, this.organism, this.partDescription);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class PartDescription
    extends BackboneElement {
        @Summary
        private final CodeableConcept part;
        @Summary
        private final CodeableConcept partLocation;

        private PartDescription(Builder builder) {
            super(builder);
            this.part = builder.part;
            this.partLocation = builder.partLocation;
        }

        public CodeableConcept getPart() {
            return this.part;
        }

        public CodeableConcept getPartLocation() {
            return this.partLocation;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.part != null || this.partLocation != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.part, "part", visitor);
                    this.accept(this.partLocation, "partLocation", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartDescription other = (PartDescription)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.part, other.part) && Objects.equals(this.partLocation, other.partLocation);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.part, this.partLocation);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept part;
            private CodeableConcept partLocation;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder part(CodeableConcept part) {
                this.part = part;
                return this;
            }

            public Builder partLocation(CodeableConcept partLocation) {
                this.partLocation = partLocation;
                return this;
            }

            @Override
            public PartDescription build() {
                PartDescription partDescription = new PartDescription(this);
                if (this.validating) {
                    this.validate(partDescription);
                }
                return partDescription;
            }

            protected void validate(PartDescription partDescription) {
                super.validate(partDescription);
                ValidationSupport.requireValueOrChildren(partDescription);
            }

            protected Builder from(PartDescription partDescription) {
                super.from(partDescription);
                this.part = partDescription.part;
                this.partLocation = partDescription.partLocation;
                return this;
            }
        }
    }

    public static class Organism
    extends BackboneElement {
        @Summary
        private final CodeableConcept family;
        @Summary
        private final CodeableConcept genus;
        @Summary
        private final CodeableConcept species;
        @Summary
        private final CodeableConcept intraspecificType;
        @Summary
        private final String intraspecificDescription;
        @Summary
        private final List<Author> author;
        @Summary
        private final Hybrid hybrid;
        @Summary
        private final OrganismGeneral organismGeneral;

        private Organism(Builder builder) {
            super(builder);
            this.family = builder.family;
            this.genus = builder.genus;
            this.species = builder.species;
            this.intraspecificType = builder.intraspecificType;
            this.intraspecificDescription = builder.intraspecificDescription;
            this.author = Collections.unmodifiableList(builder.author);
            this.hybrid = builder.hybrid;
            this.organismGeneral = builder.organismGeneral;
        }

        public CodeableConcept getFamily() {
            return this.family;
        }

        public CodeableConcept getGenus() {
            return this.genus;
        }

        public CodeableConcept getSpecies() {
            return this.species;
        }

        public CodeableConcept getIntraspecificType() {
            return this.intraspecificType;
        }

        public String getIntraspecificDescription() {
            return this.intraspecificDescription;
        }

        public List<Author> getAuthor() {
            return this.author;
        }

        public Hybrid getHybrid() {
            return this.hybrid;
        }

        public OrganismGeneral getOrganismGeneral() {
            return this.organismGeneral;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.family != null || this.genus != null || this.species != null || this.intraspecificType != null || this.intraspecificDescription != null || !this.author.isEmpty() || this.hybrid != null || this.organismGeneral != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.family, "family", visitor);
                    this.accept(this.genus, "genus", visitor);
                    this.accept(this.species, "species", visitor);
                    this.accept(this.intraspecificType, "intraspecificType", visitor);
                    this.accept(this.intraspecificDescription, "intraspecificDescription", visitor);
                    this.accept(this.author, "author", visitor, Author.class);
                    this.accept(this.hybrid, "hybrid", visitor);
                    this.accept(this.organismGeneral, "organismGeneral", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Organism other = (Organism)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.family, other.family) && Objects.equals(this.genus, other.genus) && Objects.equals(this.species, other.species) && Objects.equals(this.intraspecificType, other.intraspecificType) && Objects.equals(this.intraspecificDescription, other.intraspecificDescription) && Objects.equals(this.author, other.author) && Objects.equals(this.hybrid, other.hybrid) && Objects.equals(this.organismGeneral, other.organismGeneral);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.family, this.genus, this.species, this.intraspecificType, this.intraspecificDescription, this.author, this.hybrid, this.organismGeneral);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class OrganismGeneral
        extends BackboneElement {
            @Summary
            private final CodeableConcept kingdom;
            @Summary
            private final CodeableConcept phylum;
            @Summary
            private final CodeableConcept clazz;
            @Summary
            private final CodeableConcept order;

            private OrganismGeneral(Builder builder) {
                super(builder);
                this.kingdom = builder.kingdom;
                this.phylum = builder.phylum;
                this.clazz = builder.clazz;
                this.order = builder.order;
            }

            public CodeableConcept getKingdom() {
                return this.kingdom;
            }

            public CodeableConcept getPhylum() {
                return this.phylum;
            }

            public CodeableConcept getClazz() {
                return this.clazz;
            }

            public CodeableConcept getOrder() {
                return this.order;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.kingdom != null || this.phylum != null || this.clazz != null || this.order != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.kingdom, "kingdom", visitor);
                        this.accept(this.phylum, "phylum", visitor);
                        this.accept(this.clazz, "class", visitor);
                        this.accept(this.order, "order", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                OrganismGeneral other = (OrganismGeneral)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.kingdom, other.kingdom) && Objects.equals(this.phylum, other.phylum) && Objects.equals(this.clazz, other.clazz) && Objects.equals(this.order, other.order);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.kingdom, this.phylum, this.clazz, this.order);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept kingdom;
                private CodeableConcept phylum;
                private CodeableConcept clazz;
                private CodeableConcept order;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder kingdom(CodeableConcept kingdom) {
                    this.kingdom = kingdom;
                    return this;
                }

                public Builder phylum(CodeableConcept phylum) {
                    this.phylum = phylum;
                    return this;
                }

                public Builder clazz(CodeableConcept clazz) {
                    this.clazz = clazz;
                    return this;
                }

                public Builder order(CodeableConcept order) {
                    this.order = order;
                    return this;
                }

                @Override
                public OrganismGeneral build() {
                    OrganismGeneral organismGeneral = new OrganismGeneral(this);
                    if (this.validating) {
                        this.validate(organismGeneral);
                    }
                    return organismGeneral;
                }

                protected void validate(OrganismGeneral organismGeneral) {
                    super.validate(organismGeneral);
                    ValidationSupport.requireValueOrChildren(organismGeneral);
                }

                protected Builder from(OrganismGeneral organismGeneral) {
                    super.from(organismGeneral);
                    this.kingdom = organismGeneral.kingdom;
                    this.phylum = organismGeneral.phylum;
                    this.clazz = organismGeneral.clazz;
                    this.order = organismGeneral.order;
                    return this;
                }
            }
        }

        public static class Hybrid
        extends BackboneElement {
            @Summary
            private final String maternalOrganismId;
            @Summary
            private final String maternalOrganismName;
            @Summary
            private final String paternalOrganismId;
            @Summary
            private final String paternalOrganismName;
            @Summary
            private final CodeableConcept hybridType;

            private Hybrid(Builder builder) {
                super(builder);
                this.maternalOrganismId = builder.maternalOrganismId;
                this.maternalOrganismName = builder.maternalOrganismName;
                this.paternalOrganismId = builder.paternalOrganismId;
                this.paternalOrganismName = builder.paternalOrganismName;
                this.hybridType = builder.hybridType;
            }

            public String getMaternalOrganismId() {
                return this.maternalOrganismId;
            }

            public String getMaternalOrganismName() {
                return this.maternalOrganismName;
            }

            public String getPaternalOrganismId() {
                return this.paternalOrganismId;
            }

            public String getPaternalOrganismName() {
                return this.paternalOrganismName;
            }

            public CodeableConcept getHybridType() {
                return this.hybridType;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.maternalOrganismId != null || this.maternalOrganismName != null || this.paternalOrganismId != null || this.paternalOrganismName != null || this.hybridType != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.maternalOrganismId, "maternalOrganismId", visitor);
                        this.accept(this.maternalOrganismName, "maternalOrganismName", visitor);
                        this.accept(this.paternalOrganismId, "paternalOrganismId", visitor);
                        this.accept(this.paternalOrganismName, "paternalOrganismName", visitor);
                        this.accept(this.hybridType, "hybridType", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Hybrid other = (Hybrid)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.maternalOrganismId, other.maternalOrganismId) && Objects.equals(this.maternalOrganismName, other.maternalOrganismName) && Objects.equals(this.paternalOrganismId, other.paternalOrganismId) && Objects.equals(this.paternalOrganismName, other.paternalOrganismName) && Objects.equals(this.hybridType, other.hybridType);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.maternalOrganismId, this.maternalOrganismName, this.paternalOrganismId, this.paternalOrganismName, this.hybridType);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private String maternalOrganismId;
                private String maternalOrganismName;
                private String paternalOrganismId;
                private String paternalOrganismName;
                private CodeableConcept hybridType;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder maternalOrganismId(String maternalOrganismId) {
                    this.maternalOrganismId = maternalOrganismId;
                    return this;
                }

                public Builder maternalOrganismName(String maternalOrganismName) {
                    this.maternalOrganismName = maternalOrganismName;
                    return this;
                }

                public Builder paternalOrganismId(String paternalOrganismId) {
                    this.paternalOrganismId = paternalOrganismId;
                    return this;
                }

                public Builder paternalOrganismName(String paternalOrganismName) {
                    this.paternalOrganismName = paternalOrganismName;
                    return this;
                }

                public Builder hybridType(CodeableConcept hybridType) {
                    this.hybridType = hybridType;
                    return this;
                }

                @Override
                public Hybrid build() {
                    Hybrid hybrid = new Hybrid(this);
                    if (this.validating) {
                        this.validate(hybrid);
                    }
                    return hybrid;
                }

                protected void validate(Hybrid hybrid) {
                    super.validate(hybrid);
                    ValidationSupport.requireValueOrChildren(hybrid);
                }

                protected Builder from(Hybrid hybrid) {
                    super.from(hybrid);
                    this.maternalOrganismId = hybrid.maternalOrganismId;
                    this.maternalOrganismName = hybrid.maternalOrganismName;
                    this.paternalOrganismId = hybrid.paternalOrganismId;
                    this.paternalOrganismName = hybrid.paternalOrganismName;
                    this.hybridType = hybrid.hybridType;
                    return this;
                }
            }
        }

        public static class Author
        extends BackboneElement {
            @Summary
            private final CodeableConcept authorType;
            @Summary
            private final String authorDescription;

            private Author(Builder builder) {
                super(builder);
                this.authorType = builder.authorType;
                this.authorDescription = builder.authorDescription;
            }

            public CodeableConcept getAuthorType() {
                return this.authorType;
            }

            public String getAuthorDescription() {
                return this.authorDescription;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.authorType != null || this.authorDescription != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.authorType, "authorType", visitor);
                        this.accept(this.authorDescription, "authorDescription", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Author other = (Author)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.authorType, other.authorType) && Objects.equals(this.authorDescription, other.authorDescription);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.authorType, this.authorDescription);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private CodeableConcept authorType;
                private String authorDescription;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder authorType(CodeableConcept authorType) {
                    this.authorType = authorType;
                    return this;
                }

                public Builder authorDescription(String authorDescription) {
                    this.authorDescription = authorDescription;
                    return this;
                }

                @Override
                public Author build() {
                    Author author = new Author(this);
                    if (this.validating) {
                        this.validate(author);
                    }
                    return author;
                }

                protected void validate(Author author) {
                    super.validate(author);
                    ValidationSupport.requireValueOrChildren(author);
                }

                protected Builder from(Author author) {
                    super.from(author);
                    this.authorType = author.authorType;
                    this.authorDescription = author.authorDescription;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private CodeableConcept family;
            private CodeableConcept genus;
            private CodeableConcept species;
            private CodeableConcept intraspecificType;
            private String intraspecificDescription;
            private List<Author> author = new ArrayList<Author>();
            private Hybrid hybrid;
            private OrganismGeneral organismGeneral;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder family(CodeableConcept family) {
                this.family = family;
                return this;
            }

            public Builder genus(CodeableConcept genus) {
                this.genus = genus;
                return this;
            }

            public Builder species(CodeableConcept species) {
                this.species = species;
                return this;
            }

            public Builder intraspecificType(CodeableConcept intraspecificType) {
                this.intraspecificType = intraspecificType;
                return this;
            }

            public Builder intraspecificDescription(String intraspecificDescription) {
                this.intraspecificDescription = intraspecificDescription;
                return this;
            }

            public Builder author(Author ... author) {
                for (Author value : author) {
                    this.author.add(value);
                }
                return this;
            }

            public Builder author(Collection<Author> author) {
                this.author = new ArrayList<Author>(author);
                return this;
            }

            public Builder hybrid(Hybrid hybrid) {
                this.hybrid = hybrid;
                return this;
            }

            public Builder organismGeneral(OrganismGeneral organismGeneral) {
                this.organismGeneral = organismGeneral;
                return this;
            }

            @Override
            public Organism build() {
                Organism organism = new Organism(this);
                if (this.validating) {
                    this.validate(organism);
                }
                return organism;
            }

            protected void validate(Organism organism) {
                super.validate(organism);
                ValidationSupport.checkList(organism.author, "author", Author.class);
                ValidationSupport.requireValueOrChildren(organism);
            }

            protected Builder from(Organism organism) {
                super.from(organism);
                this.family = organism.family;
                this.genus = organism.genus;
                this.species = organism.species;
                this.intraspecificType = organism.intraspecificType;
                this.intraspecificDescription = organism.intraspecificDescription;
                this.author.addAll(organism.author);
                this.hybrid = organism.hybrid;
                this.organismGeneral = organism.organismGeneral;
                return this;
            }
        }
    }

    public static class FractionDescription
    extends BackboneElement {
        @Summary
        private final String fraction;
        @Summary
        private final CodeableConcept materialType;

        private FractionDescription(Builder builder) {
            super(builder);
            this.fraction = builder.fraction;
            this.materialType = builder.materialType;
        }

        public String getFraction() {
            return this.fraction;
        }

        public CodeableConcept getMaterialType() {
            return this.materialType;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.fraction != null || this.materialType != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.fraction, "fraction", visitor);
                    this.accept(this.materialType, "materialType", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FractionDescription other = (FractionDescription)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.fraction, other.fraction) && Objects.equals(this.materialType, other.materialType);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.fraction, this.materialType);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String fraction;
            private CodeableConcept materialType;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder fraction(String fraction) {
                this.fraction = fraction;
                return this;
            }

            public Builder materialType(CodeableConcept materialType) {
                this.materialType = materialType;
                return this;
            }

            @Override
            public FractionDescription build() {
                FractionDescription fractionDescription = new FractionDescription(this);
                if (this.validating) {
                    this.validate(fractionDescription);
                }
                return fractionDescription;
            }

            protected void validate(FractionDescription fractionDescription) {
                super.validate(fractionDescription);
                ValidationSupport.requireValueOrChildren(fractionDescription);
            }

            protected Builder from(FractionDescription fractionDescription) {
                super.from(fractionDescription);
                this.fraction = fractionDescription.fraction;
                this.materialType = fractionDescription.materialType;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private CodeableConcept sourceMaterialClass;
        private CodeableConcept sourceMaterialType;
        private CodeableConcept sourceMaterialState;
        private Identifier organismId;
        private String organismName;
        private List<Identifier> parentSubstanceId = new ArrayList<Identifier>();
        private List<String> parentSubstanceName = new ArrayList<String>();
        private List<CodeableConcept> countryOfOrigin = new ArrayList<CodeableConcept>();
        private List<String> geographicalLocation = new ArrayList<String>();
        private CodeableConcept developmentStage;
        private List<FractionDescription> fractionDescription = new ArrayList<FractionDescription>();
        private Organism organism;
        private List<PartDescription> partDescription = new ArrayList<PartDescription>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder sourceMaterialClass(CodeableConcept sourceMaterialClass) {
            this.sourceMaterialClass = sourceMaterialClass;
            return this;
        }

        public Builder sourceMaterialType(CodeableConcept sourceMaterialType) {
            this.sourceMaterialType = sourceMaterialType;
            return this;
        }

        public Builder sourceMaterialState(CodeableConcept sourceMaterialState) {
            this.sourceMaterialState = sourceMaterialState;
            return this;
        }

        public Builder organismId(Identifier organismId) {
            this.organismId = organismId;
            return this;
        }

        public Builder organismName(String organismName) {
            this.organismName = organismName;
            return this;
        }

        public Builder parentSubstanceId(Identifier ... parentSubstanceId) {
            for (Identifier value : parentSubstanceId) {
                this.parentSubstanceId.add(value);
            }
            return this;
        }

        public Builder parentSubstanceId(Collection<Identifier> parentSubstanceId) {
            this.parentSubstanceId = new ArrayList<Identifier>(parentSubstanceId);
            return this;
        }

        public Builder parentSubstanceName(String ... parentSubstanceName) {
            for (String value : parentSubstanceName) {
                this.parentSubstanceName.add(value);
            }
            return this;
        }

        public Builder parentSubstanceName(Collection<String> parentSubstanceName) {
            this.parentSubstanceName = new ArrayList<String>(parentSubstanceName);
            return this;
        }

        public Builder countryOfOrigin(CodeableConcept ... countryOfOrigin) {
            for (CodeableConcept value : countryOfOrigin) {
                this.countryOfOrigin.add(value);
            }
            return this;
        }

        public Builder countryOfOrigin(Collection<CodeableConcept> countryOfOrigin) {
            this.countryOfOrigin = new ArrayList<CodeableConcept>(countryOfOrigin);
            return this;
        }

        public Builder geographicalLocation(String ... geographicalLocation) {
            for (String value : geographicalLocation) {
                this.geographicalLocation.add(value);
            }
            return this;
        }

        public Builder geographicalLocation(Collection<String> geographicalLocation) {
            this.geographicalLocation = new ArrayList<String>(geographicalLocation);
            return this;
        }

        public Builder developmentStage(CodeableConcept developmentStage) {
            this.developmentStage = developmentStage;
            return this;
        }

        public Builder fractionDescription(FractionDescription ... fractionDescription) {
            for (FractionDescription value : fractionDescription) {
                this.fractionDescription.add(value);
            }
            return this;
        }

        public Builder fractionDescription(Collection<FractionDescription> fractionDescription) {
            this.fractionDescription = new ArrayList<FractionDescription>(fractionDescription);
            return this;
        }

        public Builder organism(Organism organism) {
            this.organism = organism;
            return this;
        }

        public Builder partDescription(PartDescription ... partDescription) {
            for (PartDescription value : partDescription) {
                this.partDescription.add(value);
            }
            return this;
        }

        public Builder partDescription(Collection<PartDescription> partDescription) {
            this.partDescription = new ArrayList<PartDescription>(partDescription);
            return this;
        }

        @Override
        public SubstanceSourceMaterial build() {
            SubstanceSourceMaterial substanceSourceMaterial = new SubstanceSourceMaterial(this);
            if (this.validating) {
                this.validate(substanceSourceMaterial);
            }
            return substanceSourceMaterial;
        }

        protected void validate(SubstanceSourceMaterial substanceSourceMaterial) {
            super.validate(substanceSourceMaterial);
            ValidationSupport.checkList(substanceSourceMaterial.parentSubstanceId, "parentSubstanceId", Identifier.class);
            ValidationSupport.checkList(substanceSourceMaterial.parentSubstanceName, "parentSubstanceName", String.class);
            ValidationSupport.checkList(substanceSourceMaterial.countryOfOrigin, "countryOfOrigin", CodeableConcept.class);
            ValidationSupport.checkList(substanceSourceMaterial.geographicalLocation, "geographicalLocation", String.class);
            ValidationSupport.checkList(substanceSourceMaterial.fractionDescription, "fractionDescription", FractionDescription.class);
            ValidationSupport.checkList(substanceSourceMaterial.partDescription, "partDescription", PartDescription.class);
        }

        protected Builder from(SubstanceSourceMaterial substanceSourceMaterial) {
            super.from(substanceSourceMaterial);
            this.sourceMaterialClass = substanceSourceMaterial.sourceMaterialClass;
            this.sourceMaterialType = substanceSourceMaterial.sourceMaterialType;
            this.sourceMaterialState = substanceSourceMaterial.sourceMaterialState;
            this.organismId = substanceSourceMaterial.organismId;
            this.organismName = substanceSourceMaterial.organismName;
            this.parentSubstanceId.addAll(substanceSourceMaterial.parentSubstanceId);
            this.parentSubstanceName.addAll(substanceSourceMaterial.parentSubstanceName);
            this.countryOfOrigin.addAll(substanceSourceMaterial.countryOfOrigin);
            this.geographicalLocation.addAll(substanceSourceMaterial.geographicalLocation);
            this.developmentStage = substanceSourceMaterial.developmentStage;
            this.fractionDescription.addAll(substanceSourceMaterial.fractionDescription);
            this.organism = substanceSourceMaterial.organism;
            this.partDescription.addAll(substanceSourceMaterial.partDescription);
            return this;
        }
    }
}

