/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.AssertionDirectionType;
import com.ibm.fhir.model.type.code.AssertionOperatorType;
import com.ibm.fhir.model.type.code.AssertionResponseTypes;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.FHIRDefinedType;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.type.code.TestScriptRequestMethodCode;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=2, status=StandardsStatus.Value.TRIAL_USE)
@Constraints(value={@Constraint(id="tst-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/TestScript"), @Constraint(id="tst-1", level="Rule", location="TestScript.setup.action", description="Setup action SHALL contain either an operation or assert but not both.", expression="operation.exists() xor assert.exists()", source="http://hl7.org/fhir/StructureDefinition/TestScript"), @Constraint(id="tst-2", level="Rule", location="TestScript.test.action", description="Test action SHALL contain either an operation or assert but not both.", expression="operation.exists() xor assert.exists()", source="http://hl7.org/fhir/StructureDefinition/TestScript"), @Constraint(id="tst-3", level="Rule", location="TestScript.variable", description="Variable can only contain one of expression, headerField or path.", expression="expression.empty() or headerField.empty() or path.empty()", source="http://hl7.org/fhir/StructureDefinition/TestScript"), @Constraint(id="tst-4", level="Rule", location="TestScript.metadata", description="TestScript metadata capability SHALL contain required or validated or both.", expression="capability.required.exists() or capability.validated.exists()", source="http://hl7.org/fhir/StructureDefinition/TestScript"), @Constraint(id="tst-5", level="Rule", location="TestScript.setup.action.assert", description="Only a single assertion SHALL be present within setup action assert element.", expression="extension.exists() or (contentType.count() + expression.count() + headerField.count() + minimumId.count() + navigationLinks.count() + path.count() + requestMethod.count() + resource.count() + responseCode.count() + response.count()  + validateProfileId.count() <=1)", source="http://hl7.org/fhir/StructureDefinition/TestScript"), @Constraint(id="tst-6", level="Rule", location="TestScript.test.action.assert", description="Only a single assertion SHALL be present within test action assert element.", expression="extension.exists() or (contentType.count() + expression.count() + headerField.count() + minimumId.count() + navigationLinks.count() + path.count() + requestMethod.count() + resource.count() + responseCode.count() + response.count() + validateProfileId.count() <=1)", source="http://hl7.org/fhir/StructureDefinition/TestScript"), @Constraint(id="tst-7", level="Rule", location="TestScript.setup.action.operation", description="Setup operation SHALL contain either sourceId or targetId or params or url.", expression="sourceId.exists() or (targetId.count() + url.count() + params.count() = 1) or (type.code in ('capabilities' |'search' | 'transaction' | 'history'))", source="http://hl7.org/fhir/StructureDefinition/TestScript"), @Constraint(id="tst-8", level="Rule", location="TestScript.test.action.operation", description="Test operation SHALL contain either sourceId or targetId or params or url.", expression="sourceId.exists() or (targetId.count() + url.count() + params.count() = 1) or (type.code in ('capabilities' | 'search' | 'transaction' | 'history'))", source="http://hl7.org/fhir/StructureDefinition/TestScript"), @Constraint(id="tst-9", level="Rule", location="TestScript.teardown.action.operation", description="Teardown operation SHALL contain either sourceId or targetId or params or url.", expression="sourceId.exists() or (targetId.count() + url.count() + params.count() = 1) or (type.code in ('capabilities' | 'search' | 'transaction' | 'history'))", source="http://hl7.org/fhir/StructureDefinition/TestScript"), @Constraint(id="tst-10", level="Rule", location="TestScript.setup.action.assert", description="Setup action assert SHALL contain either compareToSourceId and compareToSourceExpression, compareToSourceId and compareToSourcePath or neither.", expression="compareToSourceId.empty() xor (compareToSourceExpression.exists() or compareToSourcePath.exists())", source="http://hl7.org/fhir/StructureDefinition/TestScript"), @Constraint(id="tst-11", level="Rule", location="TestScript.test.action.assert", description="Test action assert SHALL contain either compareToSourceId and compareToSourceExpression, compareToSourceId and compareToSourcePath or neither.", expression="compareToSourceId.empty() xor (compareToSourceExpression.exists() or compareToSourcePath.exists())", source="http://hl7.org/fhir/StructureDefinition/TestScript"), @Constraint(id="tst-12", level="Rule", location="TestScript.setup.action.assert", description="Setup action assert response and responseCode SHALL be empty when direction equals request", expression="(response.empty() and responseCode.empty() and direction = 'request') or direction.empty() or direction = 'response'", source="http://hl7.org/fhir/StructureDefinition/TestScript"), @Constraint(id="tst-13", level="Rule", location="TestScript.test.action.assert", description="Test action assert response and response and responseCode SHALL be empty when direction equals request", expression="(response.empty() and responseCode.empty() and direction = 'request') or direction.empty() or direction = 'response'", source="http://hl7.org/fhir/StructureDefinition/TestScript"), @Constraint(id="testScript-14", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/TestScript", generated=true), @Constraint(id="testScript-15", level="Warning", location="origin.profile", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/testscript-profile-origin-types", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/testscript-profile-origin-types', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/TestScript", generated=true), @Constraint(id="testScript-16", level="Warning", location="destination.profile", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/testscript-profile-destination-types", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/testscript-profile-destination-types', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/TestScript", generated=true), @Constraint(id="testScript-17", level="Warning", location="setup.action.operation.type", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/testscript-operation-codes", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/testscript-operation-codes', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/TestScript", generated=true)})
public class TestScript
extends DomainResource {
    @Summary
    @Required
    private final Uri url;
    @Summary
    private final Identifier identifier;
    @Summary
    private final String version;
    @Summary
    @Required
    private final String name;
    @Summary
    private final String title;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    private final Markdown purpose;
    private final Markdown copyright;
    private final List<Origin> origin;
    private final List<Destination> destination;
    private final Metadata metadata;
    private final List<Fixture> fixture;
    private final List<Reference> profile;
    private final List<Variable> variable;
    private final Setup setup;
    private final List<Test> test;
    private final Teardown teardown;

    private TestScript(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = builder.identifier;
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.purpose = builder.purpose;
        this.copyright = builder.copyright;
        this.origin = Collections.unmodifiableList(builder.origin);
        this.destination = Collections.unmodifiableList(builder.destination);
        this.metadata = builder.metadata;
        this.fixture = Collections.unmodifiableList(builder.fixture);
        this.profile = Collections.unmodifiableList(builder.profile);
        this.variable = Collections.unmodifiableList(builder.variable);
        this.setup = builder.setup;
        this.test = Collections.unmodifiableList(builder.test);
        this.teardown = builder.teardown;
    }

    public Uri getUrl() {
        return this.url;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public List<Origin> getOrigin() {
        return this.origin;
    }

    public List<Destination> getDestination() {
        return this.destination;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public List<Fixture> getFixture() {
        return this.fixture;
    }

    public List<Reference> getProfile() {
        return this.profile;
    }

    public List<Variable> getVariable() {
        return this.variable;
    }

    public Setup getSetup() {
        return this.setup;
    }

    public List<Test> getTest() {
        return this.test;
    }

    public Teardown getTeardown() {
        return this.teardown;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || this.identifier != null || this.version != null || this.name != null || this.title != null || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.purpose != null || this.copyright != null || !this.origin.isEmpty() || !this.destination.isEmpty() || this.metadata != null || !this.fixture.isEmpty() || !this.profile.isEmpty() || !this.variable.isEmpty() || this.setup != null || !this.test.isEmpty() || this.teardown != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.origin, "origin", visitor, Origin.class);
                this.accept(this.destination, "destination", visitor, Destination.class);
                this.accept(this.metadata, "metadata", visitor);
                this.accept(this.fixture, "fixture", visitor, Fixture.class);
                this.accept(this.profile, "profile", visitor, Reference.class);
                this.accept(this.variable, "variable", visitor, Variable.class);
                this.accept(this.setup, "setup", visitor);
                this.accept(this.test, "test", visitor, Test.class);
                this.accept(this.teardown, "teardown", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestScript other = (TestScript)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.origin, other.origin) && Objects.equals(this.destination, other.destination) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.fixture, other.fixture) && Objects.equals(this.profile, other.profile) && Objects.equals(this.variable, other.variable) && Objects.equals(this.setup, other.setup) && Objects.equals(this.test, other.test) && Objects.equals(this.teardown, other.teardown);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.origin, this.destination, this.metadata, this.fixture, this.profile, this.variable, this.setup, this.test, this.teardown);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Teardown
    extends BackboneElement {
        @Required
        private final List<Action> action;

        private Teardown(Builder builder) {
            super(builder);
            this.action = Collections.unmodifiableList(builder.action);
        }

        public List<Action> getAction() {
            return this.action;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.action.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.action, "action", visitor, Action.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Teardown other = (Teardown)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.action, other.action);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.action);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Action
        extends BackboneElement {
            @Required
            private final Setup.Action.Operation operation;

            private Action(Builder builder) {
                super(builder);
                this.operation = builder.operation;
            }

            public Setup.Action.Operation getOperation() {
                return this.operation;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.operation != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.operation, "operation", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Action other = (Action)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.operation, other.operation);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.operation);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Setup.Action.Operation operation;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder operation(Setup.Action.Operation operation) {
                    this.operation = operation;
                    return this;
                }

                @Override
                public Action build() {
                    Action action = new Action(this);
                    if (this.validating) {
                        this.validate(action);
                    }
                    return action;
                }

                protected void validate(Action action) {
                    super.validate(action);
                    ValidationSupport.requireNonNull(action.operation, "operation");
                    ValidationSupport.requireValueOrChildren(action);
                }

                protected Builder from(Action action) {
                    super.from(action);
                    this.operation = action.operation;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Action> action = new ArrayList<Action>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder action(Action ... action) {
                for (Action value : action) {
                    this.action.add(value);
                }
                return this;
            }

            public Builder action(Collection<Action> action) {
                this.action = new ArrayList<Action>(action);
                return this;
            }

            @Override
            public Teardown build() {
                Teardown teardown = new Teardown(this);
                if (this.validating) {
                    this.validate(teardown);
                }
                return teardown;
            }

            protected void validate(Teardown teardown) {
                super.validate(teardown);
                ValidationSupport.checkNonEmptyList(teardown.action, "action", Action.class);
                ValidationSupport.requireValueOrChildren(teardown);
            }

            protected Builder from(Teardown teardown) {
                super.from(teardown);
                this.action.addAll(teardown.action);
                return this;
            }
        }
    }

    public static class Test
    extends BackboneElement {
        private final String name;
        private final String description;
        @Required
        private final List<Action> action;

        private Test(Builder builder) {
            super(builder);
            this.name = builder.name;
            this.description = builder.description;
            this.action = Collections.unmodifiableList(builder.action);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<Action> getAction() {
            return this.action;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.description != null || !this.action.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.action, "action", visitor, Action.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Test other = (Test)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.action, other.action);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.description, this.action);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Action
        extends BackboneElement {
            private final Setup.Action.Operation operation;
            private final Setup.Action.Assert _assert;

            private Action(Builder builder) {
                super(builder);
                this.operation = builder.operation;
                this._assert = builder._assert;
            }

            public Setup.Action.Operation getOperation() {
                return this.operation;
            }

            public Setup.Action.Assert getAssert() {
                return this._assert;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.operation != null || this._assert != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.operation, "operation", visitor);
                        this.accept(this._assert, "assert", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Action other = (Action)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.operation, other.operation) && Objects.equals(this._assert, other._assert);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.operation, this._assert);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Setup.Action.Operation operation;
                private Setup.Action.Assert _assert;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder operation(Setup.Action.Operation operation) {
                    this.operation = operation;
                    return this;
                }

                public Builder _assert(Setup.Action.Assert _assert) {
                    this._assert = _assert;
                    return this;
                }

                @Override
                public Action build() {
                    Action action = new Action(this);
                    if (this.validating) {
                        this.validate(action);
                    }
                    return action;
                }

                protected void validate(Action action) {
                    super.validate(action);
                    ValidationSupport.requireValueOrChildren(action);
                }

                protected Builder from(Action action) {
                    super.from(action);
                    this.operation = action.operation;
                    this._assert = action._assert;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String name;
            private String description;
            private List<Action> action = new ArrayList<Action>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder action(Action ... action) {
                for (Action value : action) {
                    this.action.add(value);
                }
                return this;
            }

            public Builder action(Collection<Action> action) {
                this.action = new ArrayList<Action>(action);
                return this;
            }

            @Override
            public Test build() {
                Test test = new Test(this);
                if (this.validating) {
                    this.validate(test);
                }
                return test;
            }

            protected void validate(Test test) {
                super.validate(test);
                ValidationSupport.checkNonEmptyList(test.action, "action", Action.class);
                ValidationSupport.requireValueOrChildren(test);
            }

            protected Builder from(Test test) {
                super.from(test);
                this.name = test.name;
                this.description = test.description;
                this.action.addAll(test.action);
                return this;
            }
        }
    }

    public static class Setup
    extends BackboneElement {
        @Required
        private final List<Action> action;

        private Setup(Builder builder) {
            super(builder);
            this.action = Collections.unmodifiableList(builder.action);
        }

        public List<Action> getAction() {
            return this.action;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.action.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.action, "action", visitor, Action.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Setup other = (Setup)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.action, other.action);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.action);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Action
        extends BackboneElement {
            private final Operation operation;
            private final Assert _assert;

            private Action(Builder builder) {
                super(builder);
                this.operation = builder.operation;
                this._assert = builder._assert;
            }

            public Operation getOperation() {
                return this.operation;
            }

            public Assert getAssert() {
                return this._assert;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.operation != null || this._assert != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.operation, "operation", visitor);
                        this.accept(this._assert, "assert", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Action other = (Action)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.operation, other.operation) && Objects.equals(this._assert, other._assert);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.operation, this._assert);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Assert
            extends BackboneElement {
                private final String label;
                private final String description;
                @Binding(bindingName="AssertionDirectionType", strength=BindingStrength.Value.REQUIRED, description="The type of direction to use for assertion.", valueSet="http://hl7.org/fhir/ValueSet/assert-direction-codes|4.0.1")
                private final AssertionDirectionType direction;
                private final String compareToSourceId;
                private final String compareToSourceExpression;
                private final String compareToSourcePath;
                @Binding(bindingName="MimeType", strength=BindingStrength.Value.REQUIRED, description="The mime type of an attachment. Any valid mime type is allowed.", valueSet="http://hl7.org/fhir/ValueSet/mimetypes|4.0.1")
                private final Code contentType;
                private final String expression;
                private final String headerField;
                private final String minimumId;
                private final Boolean navigationLinks;
                @Binding(bindingName="AssertionOperatorType", strength=BindingStrength.Value.REQUIRED, description="The type of operator to use for assertion.", valueSet="http://hl7.org/fhir/ValueSet/assert-operator-codes|4.0.1")
                private final AssertionOperatorType operator;
                private final String path;
                @Binding(bindingName="TestScriptRequestMethodCode", strength=BindingStrength.Value.REQUIRED, description="The allowable request method or HTTP operation codes.", valueSet="http://hl7.org/fhir/ValueSet/http-operations|4.0.1")
                private final TestScriptRequestMethodCode requestMethod;
                private final String requestURL;
                @Binding(bindingName="FHIRDefinedType", strength=BindingStrength.Value.REQUIRED, description="A list of all the concrete types defined in this version of the FHIR specification - Data Types and Resource Types.", valueSet="http://hl7.org/fhir/ValueSet/defined-types|4.0.1")
                private final FHIRDefinedType resource;
                @Binding(bindingName="AssertionResponseTypes", strength=BindingStrength.Value.REQUIRED, description="The type of response code to use for assertion.", valueSet="http://hl7.org/fhir/ValueSet/assert-response-code-types|4.0.1")
                private final AssertionResponseTypes response;
                private final String responseCode;
                private final Id sourceId;
                private final Id validateProfileId;
                private final String value;
                @Required
                private final Boolean warningOnly;

                private Assert(Builder builder) {
                    super(builder);
                    this.label = builder.label;
                    this.description = builder.description;
                    this.direction = builder.direction;
                    this.compareToSourceId = builder.compareToSourceId;
                    this.compareToSourceExpression = builder.compareToSourceExpression;
                    this.compareToSourcePath = builder.compareToSourcePath;
                    this.contentType = builder.contentType;
                    this.expression = builder.expression;
                    this.headerField = builder.headerField;
                    this.minimumId = builder.minimumId;
                    this.navigationLinks = builder.navigationLinks;
                    this.operator = builder.operator;
                    this.path = builder.path;
                    this.requestMethod = builder.requestMethod;
                    this.requestURL = builder.requestURL;
                    this.resource = builder.resource;
                    this.response = builder.response;
                    this.responseCode = builder.responseCode;
                    this.sourceId = builder.sourceId;
                    this.validateProfileId = builder.validateProfileId;
                    this.value = builder.value;
                    this.warningOnly = builder.warningOnly;
                }

                public String getLabel() {
                    return this.label;
                }

                public String getDescription() {
                    return this.description;
                }

                public AssertionDirectionType getDirection() {
                    return this.direction;
                }

                public String getCompareToSourceId() {
                    return this.compareToSourceId;
                }

                public String getCompareToSourceExpression() {
                    return this.compareToSourceExpression;
                }

                public String getCompareToSourcePath() {
                    return this.compareToSourcePath;
                }

                public Code getContentType() {
                    return this.contentType;
                }

                public String getExpression() {
                    return this.expression;
                }

                public String getHeaderField() {
                    return this.headerField;
                }

                public String getMinimumId() {
                    return this.minimumId;
                }

                public Boolean getNavigationLinks() {
                    return this.navigationLinks;
                }

                public AssertionOperatorType getOperator() {
                    return this.operator;
                }

                public String getPath() {
                    return this.path;
                }

                public TestScriptRequestMethodCode getRequestMethod() {
                    return this.requestMethod;
                }

                public String getRequestURL() {
                    return this.requestURL;
                }

                public FHIRDefinedType getResource() {
                    return this.resource;
                }

                public AssertionResponseTypes getResponse() {
                    return this.response;
                }

                public String getResponseCode() {
                    return this.responseCode;
                }

                public Id getSourceId() {
                    return this.sourceId;
                }

                public Id getValidateProfileId() {
                    return this.validateProfileId;
                }

                public String getValue() {
                    return this.value;
                }

                public Boolean getWarningOnly() {
                    return this.warningOnly;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.label != null || this.description != null || this.direction != null || this.compareToSourceId != null || this.compareToSourceExpression != null || this.compareToSourcePath != null || this.contentType != null || this.expression != null || this.headerField != null || this.minimumId != null || this.navigationLinks != null || this.operator != null || this.path != null || this.requestMethod != null || this.requestURL != null || this.resource != null || this.response != null || this.responseCode != null || this.sourceId != null || this.validateProfileId != null || this.value != null || this.warningOnly != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.label, "label", visitor);
                            this.accept(this.description, "description", visitor);
                            this.accept(this.direction, "direction", visitor);
                            this.accept(this.compareToSourceId, "compareToSourceId", visitor);
                            this.accept(this.compareToSourceExpression, "compareToSourceExpression", visitor);
                            this.accept(this.compareToSourcePath, "compareToSourcePath", visitor);
                            this.accept(this.contentType, "contentType", visitor);
                            this.accept(this.expression, "expression", visitor);
                            this.accept(this.headerField, "headerField", visitor);
                            this.accept(this.minimumId, "minimumId", visitor);
                            this.accept(this.navigationLinks, "navigationLinks", visitor);
                            this.accept(this.operator, "operator", visitor);
                            this.accept(this.path, "path", visitor);
                            this.accept(this.requestMethod, "requestMethod", visitor);
                            this.accept(this.requestURL, "requestURL", visitor);
                            this.accept(this.resource, "resource", visitor);
                            this.accept(this.response, "response", visitor);
                            this.accept(this.responseCode, "responseCode", visitor);
                            this.accept(this.sourceId, "sourceId", visitor);
                            this.accept(this.validateProfileId, "validateProfileId", visitor);
                            this.accept(this.value, "value", visitor);
                            this.accept(this.warningOnly, "warningOnly", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Assert other = (Assert)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.label, other.label) && Objects.equals(this.description, other.description) && Objects.equals(this.direction, other.direction) && Objects.equals(this.compareToSourceId, other.compareToSourceId) && Objects.equals(this.compareToSourceExpression, other.compareToSourceExpression) && Objects.equals(this.compareToSourcePath, other.compareToSourcePath) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.expression, other.expression) && Objects.equals(this.headerField, other.headerField) && Objects.equals(this.minimumId, other.minimumId) && Objects.equals(this.navigationLinks, other.navigationLinks) && Objects.equals(this.operator, other.operator) && Objects.equals(this.path, other.path) && Objects.equals(this.requestMethod, other.requestMethod) && Objects.equals(this.requestURL, other.requestURL) && Objects.equals(this.resource, other.resource) && Objects.equals(this.response, other.response) && Objects.equals(this.responseCode, other.responseCode) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.validateProfileId, other.validateProfileId) && Objects.equals(this.value, other.value) && Objects.equals(this.warningOnly, other.warningOnly);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.label, this.description, this.direction, this.compareToSourceId, this.compareToSourceExpression, this.compareToSourcePath, this.contentType, this.expression, this.headerField, this.minimumId, this.navigationLinks, this.operator, this.path, this.requestMethod, this.requestURL, this.resource, this.response, this.responseCode, this.sourceId, this.validateProfileId, this.value, this.warningOnly);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private String label;
                    private String description;
                    private AssertionDirectionType direction;
                    private String compareToSourceId;
                    private String compareToSourceExpression;
                    private String compareToSourcePath;
                    private Code contentType;
                    private String expression;
                    private String headerField;
                    private String minimumId;
                    private Boolean navigationLinks;
                    private AssertionOperatorType operator;
                    private String path;
                    private TestScriptRequestMethodCode requestMethod;
                    private String requestURL;
                    private FHIRDefinedType resource;
                    private AssertionResponseTypes response;
                    private String responseCode;
                    private Id sourceId;
                    private Id validateProfileId;
                    private String value;
                    private Boolean warningOnly;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder label(String label) {
                        this.label = label;
                        return this;
                    }

                    public Builder description(String description) {
                        this.description = description;
                        return this;
                    }

                    public Builder direction(AssertionDirectionType direction) {
                        this.direction = direction;
                        return this;
                    }

                    public Builder compareToSourceId(String compareToSourceId) {
                        this.compareToSourceId = compareToSourceId;
                        return this;
                    }

                    public Builder compareToSourceExpression(String compareToSourceExpression) {
                        this.compareToSourceExpression = compareToSourceExpression;
                        return this;
                    }

                    public Builder compareToSourcePath(String compareToSourcePath) {
                        this.compareToSourcePath = compareToSourcePath;
                        return this;
                    }

                    public Builder contentType(Code contentType) {
                        this.contentType = contentType;
                        return this;
                    }

                    public Builder expression(String expression) {
                        this.expression = expression;
                        return this;
                    }

                    public Builder headerField(String headerField) {
                        this.headerField = headerField;
                        return this;
                    }

                    public Builder minimumId(String minimumId) {
                        this.minimumId = minimumId;
                        return this;
                    }

                    public Builder navigationLinks(Boolean navigationLinks) {
                        this.navigationLinks = navigationLinks;
                        return this;
                    }

                    public Builder operator(AssertionOperatorType operator) {
                        this.operator = operator;
                        return this;
                    }

                    public Builder path(String path) {
                        this.path = path;
                        return this;
                    }

                    public Builder requestMethod(TestScriptRequestMethodCode requestMethod) {
                        this.requestMethod = requestMethod;
                        return this;
                    }

                    public Builder requestURL(String requestURL) {
                        this.requestURL = requestURL;
                        return this;
                    }

                    public Builder resource(FHIRDefinedType resource) {
                        this.resource = resource;
                        return this;
                    }

                    public Builder response(AssertionResponseTypes response) {
                        this.response = response;
                        return this;
                    }

                    public Builder responseCode(String responseCode) {
                        this.responseCode = responseCode;
                        return this;
                    }

                    public Builder sourceId(Id sourceId) {
                        this.sourceId = sourceId;
                        return this;
                    }

                    public Builder validateProfileId(Id validateProfileId) {
                        this.validateProfileId = validateProfileId;
                        return this;
                    }

                    public Builder value(String value) {
                        this.value = value;
                        return this;
                    }

                    public Builder warningOnly(Boolean warningOnly) {
                        this.warningOnly = warningOnly;
                        return this;
                    }

                    @Override
                    public Assert build() {
                        Assert _assert = new Assert(this);
                        if (this.validating) {
                            this.validate(_assert);
                        }
                        return _assert;
                    }

                    protected void validate(Assert _assert) {
                        super.validate(_assert);
                        ValidationSupport.requireNonNull(_assert.warningOnly, "warningOnly");
                        ValidationSupport.requireValueOrChildren(_assert);
                    }

                    protected Builder from(Assert _assert) {
                        super.from(_assert);
                        this.label = _assert.label;
                        this.description = _assert.description;
                        this.direction = _assert.direction;
                        this.compareToSourceId = _assert.compareToSourceId;
                        this.compareToSourceExpression = _assert.compareToSourceExpression;
                        this.compareToSourcePath = _assert.compareToSourcePath;
                        this.contentType = _assert.contentType;
                        this.expression = _assert.expression;
                        this.headerField = _assert.headerField;
                        this.minimumId = _assert.minimumId;
                        this.navigationLinks = _assert.navigationLinks;
                        this.operator = _assert.operator;
                        this.path = _assert.path;
                        this.requestMethod = _assert.requestMethod;
                        this.requestURL = _assert.requestURL;
                        this.resource = _assert.resource;
                        this.response = _assert.response;
                        this.responseCode = _assert.responseCode;
                        this.sourceId = _assert.sourceId;
                        this.validateProfileId = _assert.validateProfileId;
                        this.value = _assert.value;
                        this.warningOnly = _assert.warningOnly;
                        return this;
                    }
                }
            }

            public static class Operation
            extends BackboneElement {
                @Binding(bindingName="TestScriptOperationCode", strength=BindingStrength.Value.EXTENSIBLE, description="The allowable operation code types.", valueSet="http://hl7.org/fhir/ValueSet/testscript-operation-codes")
                private final Coding type;
                @Binding(bindingName="FHIRDefinedType", strength=BindingStrength.Value.REQUIRED, description="A list of all the concrete types defined in this version of the FHIR specification - Data Types and Resource Types.", valueSet="http://hl7.org/fhir/ValueSet/defined-types|4.0.1")
                private final FHIRDefinedType resource;
                private final String label;
                private final String description;
                @Binding(bindingName="MimeType", strength=BindingStrength.Value.REQUIRED, description="The mime type of an attachment. Any valid mime type is allowed.", valueSet="http://hl7.org/fhir/ValueSet/mimetypes|4.0.1")
                private final Code accept;
                @Binding(bindingName="MimeType", strength=BindingStrength.Value.REQUIRED, description="The mime type of an attachment. Any valid mime type is allowed.", valueSet="http://hl7.org/fhir/ValueSet/mimetypes|4.0.1")
                private final Code contentType;
                private final Integer destination;
                @Required
                private final Boolean encodeRequestUrl;
                @Binding(bindingName="TestScriptRequestMethodCode", strength=BindingStrength.Value.REQUIRED, description="The allowable request method or HTTP operation codes.", valueSet="http://hl7.org/fhir/ValueSet/http-operations|4.0.1")
                private final TestScriptRequestMethodCode method;
                private final Integer origin;
                private final String params;
                private final List<RequestHeader> requestHeader;
                private final Id requestId;
                private final Id responseId;
                private final Id sourceId;
                private final Id targetId;
                private final String url;

                private Operation(Builder builder) {
                    super(builder);
                    this.type = builder.type;
                    this.resource = builder.resource;
                    this.label = builder.label;
                    this.description = builder.description;
                    this.accept = builder.accept;
                    this.contentType = builder.contentType;
                    this.destination = builder.destination;
                    this.encodeRequestUrl = builder.encodeRequestUrl;
                    this.method = builder.method;
                    this.origin = builder.origin;
                    this.params = builder.params;
                    this.requestHeader = Collections.unmodifiableList(builder.requestHeader);
                    this.requestId = builder.requestId;
                    this.responseId = builder.responseId;
                    this.sourceId = builder.sourceId;
                    this.targetId = builder.targetId;
                    this.url = builder.url;
                }

                public Coding getType() {
                    return this.type;
                }

                public FHIRDefinedType getResource() {
                    return this.resource;
                }

                public String getLabel() {
                    return this.label;
                }

                public String getDescription() {
                    return this.description;
                }

                public Code getAccept() {
                    return this.accept;
                }

                public Code getContentType() {
                    return this.contentType;
                }

                public Integer getDestination() {
                    return this.destination;
                }

                public Boolean getEncodeRequestUrl() {
                    return this.encodeRequestUrl;
                }

                public TestScriptRequestMethodCode getMethod() {
                    return this.method;
                }

                public Integer getOrigin() {
                    return this.origin;
                }

                public String getParams() {
                    return this.params;
                }

                public List<RequestHeader> getRequestHeader() {
                    return this.requestHeader;
                }

                public Id getRequestId() {
                    return this.requestId;
                }

                public Id getResponseId() {
                    return this.responseId;
                }

                public Id getSourceId() {
                    return this.sourceId;
                }

                public Id getTargetId() {
                    return this.targetId;
                }

                public String getUrl() {
                    return this.url;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.type != null || this.resource != null || this.label != null || this.description != null || this.accept != null || this.contentType != null || this.destination != null || this.encodeRequestUrl != null || this.method != null || this.origin != null || this.params != null || !this.requestHeader.isEmpty() || this.requestId != null || this.responseId != null || this.sourceId != null || this.targetId != null || this.url != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.type, "type", visitor);
                            this.accept(this.resource, "resource", visitor);
                            this.accept(this.label, "label", visitor);
                            this.accept(this.description, "description", visitor);
                            this.accept(this.accept, "accept", visitor);
                            this.accept(this.contentType, "contentType", visitor);
                            this.accept(this.destination, "destination", visitor);
                            this.accept(this.encodeRequestUrl, "encodeRequestUrl", visitor);
                            this.accept(this.method, "method", visitor);
                            this.accept(this.origin, "origin", visitor);
                            this.accept(this.params, "params", visitor);
                            this.accept(this.requestHeader, "requestHeader", visitor, RequestHeader.class);
                            this.accept(this.requestId, "requestId", visitor);
                            this.accept(this.responseId, "responseId", visitor);
                            this.accept(this.sourceId, "sourceId", visitor);
                            this.accept(this.targetId, "targetId", visitor);
                            this.accept(this.url, "url", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Operation other = (Operation)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.type, other.type) && Objects.equals(this.resource, other.resource) && Objects.equals(this.label, other.label) && Objects.equals(this.description, other.description) && Objects.equals(this.accept, other.accept) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.destination, other.destination) && Objects.equals(this.encodeRequestUrl, other.encodeRequestUrl) && Objects.equals(this.method, other.method) && Objects.equals(this.origin, other.origin) && Objects.equals(this.params, other.params) && Objects.equals(this.requestHeader, other.requestHeader) && Objects.equals(this.requestId, other.requestId) && Objects.equals(this.responseId, other.responseId) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.url, other.url);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.type, this.resource, this.label, this.description, this.accept, this.contentType, this.destination, this.encodeRequestUrl, this.method, this.origin, this.params, this.requestHeader, this.requestId, this.responseId, this.sourceId, this.targetId, this.url);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class RequestHeader
                extends BackboneElement {
                    @Required
                    private final String field;
                    @Required
                    private final String value;

                    private RequestHeader(Builder builder) {
                        super(builder);
                        this.field = builder.field;
                        this.value = builder.value;
                    }

                    public String getField() {
                        return this.field;
                    }

                    public String getValue() {
                        return this.value;
                    }

                    @Override
                    public boolean hasChildren() {
                        return super.hasChildren() || this.field != null || this.value != null;
                    }

                    @Override
                    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                        if (visitor.preVisit(this)) {
                            visitor.visitStart(elementName, elementIndex, this);
                            if (visitor.visit(elementName, elementIndex, this)) {
                                this.accept(this.id, "id", visitor);
                                this.accept(this.extension, "extension", visitor, Extension.class);
                                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                                this.accept(this.field, "field", visitor);
                                this.accept(this.value, "value", visitor);
                            }
                            visitor.visitEnd(elementName, elementIndex, this);
                            visitor.postVisit(this);
                        }
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        RequestHeader other = (RequestHeader)obj;
                        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.field, other.field) && Objects.equals(this.value, other.value);
                    }

                    public int hashCode() {
                        int result = this.hashCode;
                        if (result == 0) {
                            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.field, this.value);
                        }
                        return result;
                    }

                    @Override
                    public Builder toBuilder() {
                        return new Builder().from(this);
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    public static class Builder
                    extends BackboneElement.Builder {
                        private String field;
                        private String value;

                        private Builder() {
                        }

                        @Override
                        public Builder id(java.lang.String id) {
                            return (Builder)super.id(id);
                        }

                        @Override
                        public Builder extension(Extension ... extension) {
                            return (Builder)super.extension(extension);
                        }

                        @Override
                        public Builder extension(Collection<Extension> extension) {
                            return (Builder)super.extension((Collection)extension);
                        }

                        @Override
                        public Builder modifierExtension(Extension ... modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        @Override
                        public Builder modifierExtension(Collection<Extension> modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        public Builder field(String field) {
                            this.field = field;
                            return this;
                        }

                        public Builder value(String value) {
                            this.value = value;
                            return this;
                        }

                        @Override
                        public RequestHeader build() {
                            RequestHeader requestHeader = new RequestHeader(this);
                            if (this.validating) {
                                this.validate(requestHeader);
                            }
                            return requestHeader;
                        }

                        protected void validate(RequestHeader requestHeader) {
                            super.validate(requestHeader);
                            ValidationSupport.requireNonNull(requestHeader.field, "field");
                            ValidationSupport.requireNonNull(requestHeader.value, "value");
                            ValidationSupport.requireValueOrChildren(requestHeader);
                        }

                        protected Builder from(RequestHeader requestHeader) {
                            super.from(requestHeader);
                            this.field = requestHeader.field;
                            this.value = requestHeader.value;
                            return this;
                        }
                    }
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Coding type;
                    private FHIRDefinedType resource;
                    private String label;
                    private String description;
                    private Code accept;
                    private Code contentType;
                    private Integer destination;
                    private Boolean encodeRequestUrl;
                    private TestScriptRequestMethodCode method;
                    private Integer origin;
                    private String params;
                    private List<RequestHeader> requestHeader = new ArrayList<RequestHeader>();
                    private Id requestId;
                    private Id responseId;
                    private Id sourceId;
                    private Id targetId;
                    private String url;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder type(Coding type) {
                        this.type = type;
                        return this;
                    }

                    public Builder resource(FHIRDefinedType resource) {
                        this.resource = resource;
                        return this;
                    }

                    public Builder label(String label) {
                        this.label = label;
                        return this;
                    }

                    public Builder description(String description) {
                        this.description = description;
                        return this;
                    }

                    public Builder accept(Code accept) {
                        this.accept = accept;
                        return this;
                    }

                    public Builder contentType(Code contentType) {
                        this.contentType = contentType;
                        return this;
                    }

                    public Builder destination(Integer destination) {
                        this.destination = destination;
                        return this;
                    }

                    public Builder encodeRequestUrl(Boolean encodeRequestUrl) {
                        this.encodeRequestUrl = encodeRequestUrl;
                        return this;
                    }

                    public Builder method(TestScriptRequestMethodCode method) {
                        this.method = method;
                        return this;
                    }

                    public Builder origin(Integer origin) {
                        this.origin = origin;
                        return this;
                    }

                    public Builder params(String params) {
                        this.params = params;
                        return this;
                    }

                    public Builder requestHeader(RequestHeader ... requestHeader) {
                        for (RequestHeader value : requestHeader) {
                            this.requestHeader.add(value);
                        }
                        return this;
                    }

                    public Builder requestHeader(Collection<RequestHeader> requestHeader) {
                        this.requestHeader = new ArrayList<RequestHeader>(requestHeader);
                        return this;
                    }

                    public Builder requestId(Id requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    public Builder responseId(Id responseId) {
                        this.responseId = responseId;
                        return this;
                    }

                    public Builder sourceId(Id sourceId) {
                        this.sourceId = sourceId;
                        return this;
                    }

                    public Builder targetId(Id targetId) {
                        this.targetId = targetId;
                        return this;
                    }

                    public Builder url(String url) {
                        this.url = url;
                        return this;
                    }

                    @Override
                    public Operation build() {
                        Operation operation = new Operation(this);
                        if (this.validating) {
                            this.validate(operation);
                        }
                        return operation;
                    }

                    protected void validate(Operation operation) {
                        super.validate(operation);
                        ValidationSupport.requireNonNull(operation.encodeRequestUrl, "encodeRequestUrl");
                        ValidationSupport.checkList(operation.requestHeader, "requestHeader", RequestHeader.class);
                        ValidationSupport.requireValueOrChildren(operation);
                    }

                    protected Builder from(Operation operation) {
                        super.from(operation);
                        this.type = operation.type;
                        this.resource = operation.resource;
                        this.label = operation.label;
                        this.description = operation.description;
                        this.accept = operation.accept;
                        this.contentType = operation.contentType;
                        this.destination = operation.destination;
                        this.encodeRequestUrl = operation.encodeRequestUrl;
                        this.method = operation.method;
                        this.origin = operation.origin;
                        this.params = operation.params;
                        this.requestHeader.addAll(operation.requestHeader);
                        this.requestId = operation.requestId;
                        this.responseId = operation.responseId;
                        this.sourceId = operation.sourceId;
                        this.targetId = operation.targetId;
                        this.url = operation.url;
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Operation operation;
                private Assert _assert;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder operation(Operation operation) {
                    this.operation = operation;
                    return this;
                }

                public Builder _assert(Assert _assert) {
                    this._assert = _assert;
                    return this;
                }

                @Override
                public Action build() {
                    Action action = new Action(this);
                    if (this.validating) {
                        this.validate(action);
                    }
                    return action;
                }

                protected void validate(Action action) {
                    super.validate(action);
                    ValidationSupport.requireValueOrChildren(action);
                }

                protected Builder from(Action action) {
                    super.from(action);
                    this.operation = action.operation;
                    this._assert = action._assert;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Action> action = new ArrayList<Action>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder action(Action ... action) {
                for (Action value : action) {
                    this.action.add(value);
                }
                return this;
            }

            public Builder action(Collection<Action> action) {
                this.action = new ArrayList<Action>(action);
                return this;
            }

            @Override
            public Setup build() {
                Setup setup = new Setup(this);
                if (this.validating) {
                    this.validate(setup);
                }
                return setup;
            }

            protected void validate(Setup setup) {
                super.validate(setup);
                ValidationSupport.checkNonEmptyList(setup.action, "action", Action.class);
                ValidationSupport.requireValueOrChildren(setup);
            }

            protected Builder from(Setup setup) {
                super.from(setup);
                this.action.addAll(setup.action);
                return this;
            }
        }
    }

    public static class Variable
    extends BackboneElement {
        @Required
        private final String name;
        private final String defaultValue;
        private final String description;
        private final String expression;
        private final String headerField;
        private final String hint;
        private final String path;
        private final Id sourceId;

        private Variable(Builder builder) {
            super(builder);
            this.name = builder.name;
            this.defaultValue = builder.defaultValue;
            this.description = builder.description;
            this.expression = builder.expression;
            this.headerField = builder.headerField;
            this.hint = builder.hint;
            this.path = builder.path;
            this.sourceId = builder.sourceId;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getHeaderField() {
            return this.headerField;
        }

        public String getHint() {
            return this.hint;
        }

        public String getPath() {
            return this.path;
        }

        public Id getSourceId() {
            return this.sourceId;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.name != null || this.defaultValue != null || this.description != null || this.expression != null || this.headerField != null || this.hint != null || this.path != null || this.sourceId != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.name, "name", visitor);
                    this.accept(this.defaultValue, "defaultValue", visitor);
                    this.accept(this.description, "description", visitor);
                    this.accept(this.expression, "expression", visitor);
                    this.accept(this.headerField, "headerField", visitor);
                    this.accept(this.hint, "hint", visitor);
                    this.accept(this.path, "path", visitor);
                    this.accept(this.sourceId, "sourceId", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Variable other = (Variable)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals(this.description, other.description) && Objects.equals(this.expression, other.expression) && Objects.equals(this.headerField, other.headerField) && Objects.equals(this.hint, other.hint) && Objects.equals(this.path, other.path) && Objects.equals(this.sourceId, other.sourceId);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.defaultValue, this.description, this.expression, this.headerField, this.hint, this.path, this.sourceId);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String name;
            private String defaultValue;
            private String description;
            private String expression;
            private String headerField;
            private String hint;
            private String path;
            private Id sourceId;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder defaultValue(String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder headerField(String headerField) {
                this.headerField = headerField;
                return this;
            }

            public Builder hint(String hint) {
                this.hint = hint;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder sourceId(Id sourceId) {
                this.sourceId = sourceId;
                return this;
            }

            @Override
            public Variable build() {
                Variable variable = new Variable(this);
                if (this.validating) {
                    this.validate(variable);
                }
                return variable;
            }

            protected void validate(Variable variable) {
                super.validate(variable);
                ValidationSupport.requireNonNull(variable.name, "name");
                ValidationSupport.requireValueOrChildren(variable);
            }

            protected Builder from(Variable variable) {
                super.from(variable);
                this.name = variable.name;
                this.defaultValue = variable.defaultValue;
                this.description = variable.description;
                this.expression = variable.expression;
                this.headerField = variable.headerField;
                this.hint = variable.hint;
                this.path = variable.path;
                this.sourceId = variable.sourceId;
                return this;
            }
        }
    }

    public static class Fixture
    extends BackboneElement {
        @Required
        private final Boolean autocreate;
        @Required
        private final Boolean autodelete;
        private final Reference resource;

        private Fixture(Builder builder) {
            super(builder);
            this.autocreate = builder.autocreate;
            this.autodelete = builder.autodelete;
            this.resource = builder.resource;
        }

        public Boolean getAutocreate() {
            return this.autocreate;
        }

        public Boolean getAutodelete() {
            return this.autodelete;
        }

        public Reference getResource() {
            return this.resource;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.autocreate != null || this.autodelete != null || this.resource != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.autocreate, "autocreate", visitor);
                    this.accept(this.autodelete, "autodelete", visitor);
                    this.accept(this.resource, "resource", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Fixture other = (Fixture)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.autocreate, other.autocreate) && Objects.equals(this.autodelete, other.autodelete) && Objects.equals(this.resource, other.resource);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.autocreate, this.autodelete, this.resource);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Boolean autocreate;
            private Boolean autodelete;
            private Reference resource;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder autocreate(Boolean autocreate) {
                this.autocreate = autocreate;
                return this;
            }

            public Builder autodelete(Boolean autodelete) {
                this.autodelete = autodelete;
                return this;
            }

            public Builder resource(Reference resource) {
                this.resource = resource;
                return this;
            }

            @Override
            public Fixture build() {
                Fixture fixture = new Fixture(this);
                if (this.validating) {
                    this.validate(fixture);
                }
                return fixture;
            }

            protected void validate(Fixture fixture) {
                super.validate(fixture);
                ValidationSupport.requireNonNull(fixture.autocreate, "autocreate");
                ValidationSupport.requireNonNull(fixture.autodelete, "autodelete");
                ValidationSupport.requireValueOrChildren(fixture);
            }

            protected Builder from(Fixture fixture) {
                super.from(fixture);
                this.autocreate = fixture.autocreate;
                this.autodelete = fixture.autodelete;
                this.resource = fixture.resource;
                return this;
            }
        }
    }

    public static class Metadata
    extends BackboneElement {
        private final List<Link> link;
        @Required
        private final List<Capability> capability;

        private Metadata(Builder builder) {
            super(builder);
            this.link = Collections.unmodifiableList(builder.link);
            this.capability = Collections.unmodifiableList(builder.capability);
        }

        public List<Link> getLink() {
            return this.link;
        }

        public List<Capability> getCapability() {
            return this.capability;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || !this.link.isEmpty() || !this.capability.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.link, "link", visitor, Link.class);
                    this.accept(this.capability, "capability", visitor, Capability.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Metadata other = (Metadata)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.link, other.link) && Objects.equals(this.capability, other.capability);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.link, this.capability);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Capability
        extends BackboneElement {
            @Required
            private final Boolean required;
            @Required
            private final Boolean validated;
            private final String description;
            private final List<Integer> origin;
            private final Integer destination;
            private final List<Uri> link;
            @Required
            private final Canonical capabilities;

            private Capability(Builder builder) {
                super(builder);
                this.required = builder.required;
                this.validated = builder.validated;
                this.description = builder.description;
                this.origin = Collections.unmodifiableList(builder.origin);
                this.destination = builder.destination;
                this.link = Collections.unmodifiableList(builder.link);
                this.capabilities = builder.capabilities;
            }

            public Boolean getRequired() {
                return this.required;
            }

            public Boolean getValidated() {
                return this.validated;
            }

            public String getDescription() {
                return this.description;
            }

            public List<Integer> getOrigin() {
                return this.origin;
            }

            public Integer getDestination() {
                return this.destination;
            }

            public List<Uri> getLink() {
                return this.link;
            }

            public Canonical getCapabilities() {
                return this.capabilities;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.required != null || this.validated != null || this.description != null || !this.origin.isEmpty() || this.destination != null || !this.link.isEmpty() || this.capabilities != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.required, "required", visitor);
                        this.accept(this.validated, "validated", visitor);
                        this.accept(this.description, "description", visitor);
                        this.accept(this.origin, "origin", visitor, Integer.class);
                        this.accept(this.destination, "destination", visitor);
                        this.accept(this.link, "link", visitor, Uri.class);
                        this.accept(this.capabilities, "capabilities", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Capability other = (Capability)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.required, other.required) && Objects.equals(this.validated, other.validated) && Objects.equals(this.description, other.description) && Objects.equals(this.origin, other.origin) && Objects.equals(this.destination, other.destination) && Objects.equals(this.link, other.link) && Objects.equals(this.capabilities, other.capabilities);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.required, this.validated, this.description, this.origin, this.destination, this.link, this.capabilities);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Boolean required;
                private Boolean validated;
                private String description;
                private List<Integer> origin = new ArrayList<Integer>();
                private Integer destination;
                private List<Uri> link = new ArrayList<Uri>();
                private Canonical capabilities;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder required(Boolean required) {
                    this.required = required;
                    return this;
                }

                public Builder validated(Boolean validated) {
                    this.validated = validated;
                    return this;
                }

                public Builder description(String description) {
                    this.description = description;
                    return this;
                }

                public Builder origin(Integer ... origin) {
                    for (Integer value : origin) {
                        this.origin.add(value);
                    }
                    return this;
                }

                public Builder origin(Collection<Integer> origin) {
                    this.origin = new ArrayList<Integer>(origin);
                    return this;
                }

                public Builder destination(Integer destination) {
                    this.destination = destination;
                    return this;
                }

                public Builder link(Uri ... link) {
                    for (Uri value : link) {
                        this.link.add(value);
                    }
                    return this;
                }

                public Builder link(Collection<Uri> link) {
                    this.link = new ArrayList<Uri>(link);
                    return this;
                }

                public Builder capabilities(Canonical capabilities) {
                    this.capabilities = capabilities;
                    return this;
                }

                @Override
                public Capability build() {
                    Capability capability = new Capability(this);
                    if (this.validating) {
                        this.validate(capability);
                    }
                    return capability;
                }

                protected void validate(Capability capability) {
                    super.validate(capability);
                    ValidationSupport.requireNonNull(capability.required, "required");
                    ValidationSupport.requireNonNull(capability.validated, "validated");
                    ValidationSupport.checkList(capability.origin, "origin", Integer.class);
                    ValidationSupport.checkList(capability.link, "link", Uri.class);
                    ValidationSupport.requireNonNull(capability.capabilities, "capabilities");
                    ValidationSupport.requireValueOrChildren(capability);
                }

                protected Builder from(Capability capability) {
                    super.from(capability);
                    this.required = capability.required;
                    this.validated = capability.validated;
                    this.description = capability.description;
                    this.origin.addAll(capability.origin);
                    this.destination = capability.destination;
                    this.link.addAll(capability.link);
                    this.capabilities = capability.capabilities;
                    return this;
                }
            }
        }

        public static class Link
        extends BackboneElement {
            @Required
            private final Uri url;
            private final String description;

            private Link(Builder builder) {
                super(builder);
                this.url = builder.url;
                this.description = builder.description;
            }

            public Uri getUrl() {
                return this.url;
            }

            public String getDescription() {
                return this.description;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.url != null || this.description != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.url, "url", visitor);
                        this.accept(this.description, "description", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Link other = (Link)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.description, other.description);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.url, this.description);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Uri url;
                private String description;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder url(Uri url) {
                    this.url = url;
                    return this;
                }

                public Builder description(String description) {
                    this.description = description;
                    return this;
                }

                @Override
                public Link build() {
                    Link link = new Link(this);
                    if (this.validating) {
                        this.validate(link);
                    }
                    return link;
                }

                protected void validate(Link link) {
                    super.validate(link);
                    ValidationSupport.requireNonNull(link.url, "url");
                    ValidationSupport.requireValueOrChildren(link);
                }

                protected Builder from(Link link) {
                    super.from(link);
                    this.url = link.url;
                    this.description = link.description;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private List<Link> link = new ArrayList<Link>();
            private List<Capability> capability = new ArrayList<Capability>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder link(Link ... link) {
                for (Link value : link) {
                    this.link.add(value);
                }
                return this;
            }

            public Builder link(Collection<Link> link) {
                this.link = new ArrayList<Link>(link);
                return this;
            }

            public Builder capability(Capability ... capability) {
                for (Capability value : capability) {
                    this.capability.add(value);
                }
                return this;
            }

            public Builder capability(Collection<Capability> capability) {
                this.capability = new ArrayList<Capability>(capability);
                return this;
            }

            @Override
            public Metadata build() {
                Metadata metadata = new Metadata(this);
                if (this.validating) {
                    this.validate(metadata);
                }
                return metadata;
            }

            protected void validate(Metadata metadata) {
                super.validate(metadata);
                ValidationSupport.checkList(metadata.link, "link", Link.class);
                ValidationSupport.checkNonEmptyList(metadata.capability, "capability", Capability.class);
                ValidationSupport.requireValueOrChildren(metadata);
            }

            protected Builder from(Metadata metadata) {
                super.from(metadata);
                this.link.addAll(metadata.link);
                this.capability.addAll(metadata.capability);
                return this;
            }
        }
    }

    public static class Destination
    extends BackboneElement {
        @Required
        private final Integer index;
        @Binding(bindingName="TestScriptProfileDestinationType", strength=BindingStrength.Value.EXTENSIBLE, description="The type of destination profile the test system supports.", valueSet="http://hl7.org/fhir/ValueSet/testscript-profile-destination-types")
        @Required
        private final Coding profile;

        private Destination(Builder builder) {
            super(builder);
            this.index = builder.index;
            this.profile = builder.profile;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Coding getProfile() {
            return this.profile;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.index != null || this.profile != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.index, "index", visitor);
                    this.accept(this.profile, "profile", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Destination other = (Destination)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.index, other.index) && Objects.equals(this.profile, other.profile);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.index, this.profile);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Integer index;
            private Coding profile;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder index(Integer index) {
                this.index = index;
                return this;
            }

            public Builder profile(Coding profile) {
                this.profile = profile;
                return this;
            }

            @Override
            public Destination build() {
                Destination destination = new Destination(this);
                if (this.validating) {
                    this.validate(destination);
                }
                return destination;
            }

            protected void validate(Destination destination) {
                super.validate(destination);
                ValidationSupport.requireNonNull(destination.index, "index");
                ValidationSupport.requireNonNull(destination.profile, "profile");
                ValidationSupport.requireValueOrChildren(destination);
            }

            protected Builder from(Destination destination) {
                super.from(destination);
                this.index = destination.index;
                this.profile = destination.profile;
                return this;
            }
        }
    }

    public static class Origin
    extends BackboneElement {
        @Required
        private final Integer index;
        @Binding(bindingName="TestScriptProfileOriginType", strength=BindingStrength.Value.EXTENSIBLE, description="The type of origin profile the test system supports.", valueSet="http://hl7.org/fhir/ValueSet/testscript-profile-origin-types")
        @Required
        private final Coding profile;

        private Origin(Builder builder) {
            super(builder);
            this.index = builder.index;
            this.profile = builder.profile;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Coding getProfile() {
            return this.profile;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.index != null || this.profile != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.index, "index", visitor);
                    this.accept(this.profile, "profile", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Origin other = (Origin)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.index, other.index) && Objects.equals(this.profile, other.profile);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.index, this.profile);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Integer index;
            private Coding profile;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder index(Integer index) {
                this.index = index;
                return this;
            }

            public Builder profile(Coding profile) {
                this.profile = profile;
                return this;
            }

            @Override
            public Origin build() {
                Origin origin = new Origin(this);
                if (this.validating) {
                    this.validate(origin);
                }
                return origin;
            }

            protected void validate(Origin origin) {
                super.validate(origin);
                ValidationSupport.requireNonNull(origin.index, "index");
                ValidationSupport.requireNonNull(origin.profile, "profile");
                ValidationSupport.requireValueOrChildren(origin);
            }

            protected Builder from(Origin origin) {
                super.from(origin);
                this.index = origin.index;
                this.profile = origin.profile;
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private Identifier identifier;
        private String version;
        private String name;
        private String title;
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Markdown purpose;
        private Markdown copyright;
        private List<Origin> origin = new ArrayList<Origin>();
        private List<Destination> destination = new ArrayList<Destination>();
        private Metadata metadata;
        private List<Fixture> fixture = new ArrayList<Fixture>();
        private List<Reference> profile = new ArrayList<Reference>();
        private List<Variable> variable = new ArrayList<Variable>();
        private Setup setup;
        private List<Test> test = new ArrayList<Test>();
        private Teardown teardown;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder origin(Origin ... origin) {
            for (Origin value : origin) {
                this.origin.add(value);
            }
            return this;
        }

        public Builder origin(Collection<Origin> origin) {
            this.origin = new ArrayList<Origin>(origin);
            return this;
        }

        public Builder destination(Destination ... destination) {
            for (Destination value : destination) {
                this.destination.add(value);
            }
            return this;
        }

        public Builder destination(Collection<Destination> destination) {
            this.destination = new ArrayList<Destination>(destination);
            return this;
        }

        public Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder fixture(Fixture ... fixture) {
            for (Fixture value : fixture) {
                this.fixture.add(value);
            }
            return this;
        }

        public Builder fixture(Collection<Fixture> fixture) {
            this.fixture = new ArrayList<Fixture>(fixture);
            return this;
        }

        public Builder profile(Reference ... profile) {
            for (Reference value : profile) {
                this.profile.add(value);
            }
            return this;
        }

        public Builder profile(Collection<Reference> profile) {
            this.profile = new ArrayList<Reference>(profile);
            return this;
        }

        public Builder variable(Variable ... variable) {
            for (Variable value : variable) {
                this.variable.add(value);
            }
            return this;
        }

        public Builder variable(Collection<Variable> variable) {
            this.variable = new ArrayList<Variable>(variable);
            return this;
        }

        public Builder setup(Setup setup) {
            this.setup = setup;
            return this;
        }

        public Builder test(Test ... test) {
            for (Test value : test) {
                this.test.add(value);
            }
            return this;
        }

        public Builder test(Collection<Test> test) {
            this.test = new ArrayList<Test>(test);
            return this;
        }

        public Builder teardown(Teardown teardown) {
            this.teardown = teardown;
            return this;
        }

        @Override
        public TestScript build() {
            TestScript testScript = new TestScript(this);
            if (this.validating) {
                this.validate(testScript);
            }
            return testScript;
        }

        protected void validate(TestScript testScript) {
            super.validate(testScript);
            ValidationSupport.requireNonNull(testScript.url, "url");
            ValidationSupport.requireNonNull(testScript.name, "name");
            ValidationSupport.requireNonNull(testScript.status, "status");
            ValidationSupport.checkList(testScript.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(testScript.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(testScript.jurisdiction, "jurisdiction", CodeableConcept.class);
            ValidationSupport.checkList(testScript.origin, "origin", Origin.class);
            ValidationSupport.checkList(testScript.destination, "destination", Destination.class);
            ValidationSupport.checkList(testScript.fixture, "fixture", Fixture.class);
            ValidationSupport.checkList(testScript.profile, "profile", Reference.class);
            ValidationSupport.checkList(testScript.variable, "variable", Variable.class);
            ValidationSupport.checkList(testScript.test, "test", Test.class);
        }

        protected Builder from(TestScript testScript) {
            super.from(testScript);
            this.url = testScript.url;
            this.identifier = testScript.identifier;
            this.version = testScript.version;
            this.name = testScript.name;
            this.title = testScript.title;
            this.status = testScript.status;
            this.experimental = testScript.experimental;
            this.date = testScript.date;
            this.publisher = testScript.publisher;
            this.contact.addAll(testScript.contact);
            this.description = testScript.description;
            this.useContext.addAll(testScript.useContext);
            this.jurisdiction.addAll(testScript.jurisdiction);
            this.purpose = testScript.purpose;
            this.copyright = testScript.copyright;
            this.origin.addAll(testScript.origin);
            this.destination.addAll(testScript.destination);
            this.metadata = testScript.metadata;
            this.fixture.addAll(testScript.fixture);
            this.profile.addAll(testScript.profile);
            this.variable.addAll(testScript.variable);
            this.setup = testScript.setup;
            this.test.addAll(testScript.test);
            this.teardown = testScript.teardown;
            return this;
        }
    }
}

